# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkActivationMetadata(object):
    """
    Metadata about the bulk activation operation.  The bulk activation operation is atomic and binary.  If the processing of any of the attributes in the bulk
    activation request results in a processing or validation error, then none of the attributes in the request are activated.  The bulk activation request succeeds
    only when all the attributes in the bulk activation request are processed and they get a successful attributeStatus back.
    """

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "SUCCESS"
    OPERATION_STATUS_SUCCESS = "SUCCESS"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "EMPTY_ATTRIBUTE_LIST"
    OPERATION_STATUS_EMPTY_ATTRIBUTE_LIST = "EMPTY_ATTRIBUTE_LIST"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED"
    OPERATION_STATUS_NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED = "NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "STRING_ATTRIBUTE_LIMIT_EXCEEDED"
    OPERATION_STATUS_STRING_ATTRIBUTE_LIMIT_EXCEEDED = "STRING_ATTRIBUTE_LIMIT_EXCEEDED"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "INSUFFICIENT_STRING_SPACE"
    OPERATION_STATUS_INSUFFICIENT_STRING_SPACE = "INSUFFICIENT_STRING_SPACE"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "INSUFFICIENT_NUMERIC_SPACE"
    OPERATION_STATUS_INSUFFICIENT_NUMERIC_SPACE = "INSUFFICIENT_NUMERIC_SPACE"

    #: A constant which can be used with the operation_status property of a BulkActivationMetadata.
    #: This constant has a value of "INVALID_BULK_REQUEST"
    OPERATION_STATUS_INVALID_BULK_REQUEST = "INVALID_BULK_REQUEST"

    #: A constant which can be used with the operation_type property of a BulkActivationMetadata.
    #: This constant has a value of "ACTIVATE"
    OPERATION_TYPE_ACTIVATE = "ACTIVATE"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkActivationMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_status:
            The value to assign to the operation_status property of this BulkActivationMetadata.
            Allowed values for this property are: "SUCCESS", "EMPTY_ATTRIBUTE_LIST", "NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED", "STRING_ATTRIBUTE_LIMIT_EXCEEDED", "INSUFFICIENT_STRING_SPACE", "INSUFFICIENT_NUMERIC_SPACE", "INVALID_BULK_REQUEST", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_status: str

        :param operation_type:
            The value to assign to the operation_type property of this BulkActivationMetadata.
            Allowed values for this property are: "ACTIVATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param string_attributes_activated:
            The value to assign to the string_attributes_activated property of this BulkActivationMetadata.
        :type string_attributes_activated: int

        :param numeric_attributes_activated:
            The value to assign to the numeric_attributes_activated property of this BulkActivationMetadata.
        :type numeric_attributes_activated: int

        :param synthetic_string_attributes_activated:
            The value to assign to the synthetic_string_attributes_activated property of this BulkActivationMetadata.
        :type synthetic_string_attributes_activated: int

        :param synthetic_numeric_attributes_activated:
            The value to assign to the synthetic_numeric_attributes_activated property of this BulkActivationMetadata.
        :type synthetic_numeric_attributes_activated: int

        :param available_string_attributes:
            The value to assign to the available_string_attributes property of this BulkActivationMetadata.
        :type available_string_attributes: int

        :param available_numeric_attributes:
            The value to assign to the available_numeric_attributes property of this BulkActivationMetadata.
        :type available_numeric_attributes: int

        :param available_synthetic_string_attributes:
            The value to assign to the available_synthetic_string_attributes property of this BulkActivationMetadata.
        :type available_synthetic_string_attributes: int

        :param available_synthetic_numeric_attributes:
            The value to assign to the available_synthetic_numeric_attributes property of this BulkActivationMetadata.
        :type available_synthetic_numeric_attributes: int

        """
        self.swagger_types = {
            'operation_status': 'str',
            'operation_type': 'str',
            'string_attributes_activated': 'int',
            'numeric_attributes_activated': 'int',
            'synthetic_string_attributes_activated': 'int',
            'synthetic_numeric_attributes_activated': 'int',
            'available_string_attributes': 'int',
            'available_numeric_attributes': 'int',
            'available_synthetic_string_attributes': 'int',
            'available_synthetic_numeric_attributes': 'int'
        }
        self.attribute_map = {
            'operation_status': 'operationStatus',
            'operation_type': 'operationType',
            'string_attributes_activated': 'stringAttributesActivated',
            'numeric_attributes_activated': 'numericAttributesActivated',
            'synthetic_string_attributes_activated': 'syntheticStringAttributesActivated',
            'synthetic_numeric_attributes_activated': 'syntheticNumericAttributesActivated',
            'available_string_attributes': 'availableStringAttributes',
            'available_numeric_attributes': 'availableNumericAttributes',
            'available_synthetic_string_attributes': 'availableSyntheticStringAttributes',
            'available_synthetic_numeric_attributes': 'availableSyntheticNumericAttributes'
        }
        self._operation_status = None
        self._operation_type = None
        self._string_attributes_activated = None
        self._numeric_attributes_activated = None
        self._synthetic_string_attributes_activated = None
        self._synthetic_numeric_attributes_activated = None
        self._available_string_attributes = None
        self._available_numeric_attributes = None
        self._available_synthetic_string_attributes = None
        self._available_synthetic_numeric_attributes = None

    @property
    def operation_status(self):
        """
        **[Required]** Gets the operation_status of this BulkActivationMetadata.
        Operation status of the bulk activation operation.  The bulk  activation operation could have either a success or an error status as defined below.
        The following is a success status for the bulk activation operation.
        SUCCESS - The bulk activation operation has succeeded and all the attributes in the bulk activation request have been activated by this operation or activated earlier.
        The following are error statuses for the bulk activation operation.  Note that none of the attributes (string or numeric) in the bulk request have been activated by this bulk
        activation operation if any of the below statuses.
        EMPTY_ATTRIBUTE_LIST - The bulk activation request object was empty and did not contain any attributes to be activated.
        NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED - The number of numeric attributes in the bulk request exceeded the maximum limit (100) of numeric attributes that could be activated in the APM Domain.
        STRING_ATTRIBUTE_LIMIT_EXCEEDED - The number of string attributes in the bulk request exceeded the maximum limit (700) of string attributes that could be activated in the APM Domain.
        INSUFFICIENT_STRING_SPACE - There are not enough free slots available in the APM Domain to activate the string attributes present in the bulk request.
        INSUFFICIENT_NUMERIC_SPACE - There are not enough free slots available in the APM Domain to activate the numeric attributes present in the bulk request.
        INVALID_BULK_REQUEST - The bulk request contains invalid attribute(s), or attribute(s) that resulted in a validation error, or an attribute that resulted
        in a processing error.

        Allowed values for this property are: "SUCCESS", "EMPTY_ATTRIBUTE_LIST", "NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED", "STRING_ATTRIBUTE_LIMIT_EXCEEDED", "INSUFFICIENT_STRING_SPACE", "INSUFFICIENT_NUMERIC_SPACE", "INVALID_BULK_REQUEST", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_status of this BulkActivationMetadata.
        :rtype: str
        """
        return self._operation_status

    @operation_status.setter
    def operation_status(self, operation_status):
        """
        Sets the operation_status of this BulkActivationMetadata.
        Operation status of the bulk activation operation.  The bulk  activation operation could have either a success or an error status as defined below.
        The following is a success status for the bulk activation operation.
        SUCCESS - The bulk activation operation has succeeded and all the attributes in the bulk activation request have been activated by this operation or activated earlier.
        The following are error statuses for the bulk activation operation.  Note that none of the attributes (string or numeric) in the bulk request have been activated by this bulk
        activation operation if any of the below statuses.
        EMPTY_ATTRIBUTE_LIST - The bulk activation request object was empty and did not contain any attributes to be activated.
        NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED - The number of numeric attributes in the bulk request exceeded the maximum limit (100) of numeric attributes that could be activated in the APM Domain.
        STRING_ATTRIBUTE_LIMIT_EXCEEDED - The number of string attributes in the bulk request exceeded the maximum limit (700) of string attributes that could be activated in the APM Domain.
        INSUFFICIENT_STRING_SPACE - There are not enough free slots available in the APM Domain to activate the string attributes present in the bulk request.
        INSUFFICIENT_NUMERIC_SPACE - There are not enough free slots available in the APM Domain to activate the numeric attributes present in the bulk request.
        INVALID_BULK_REQUEST - The bulk request contains invalid attribute(s), or attribute(s) that resulted in a validation error, or an attribute that resulted
        in a processing error.


        :param operation_status: The operation_status of this BulkActivationMetadata.
        :type: str
        """
        allowed_values = ["SUCCESS", "EMPTY_ATTRIBUTE_LIST", "NUMERIC_ATTRIBUTE_LIMIT_EXCEEDED", "STRING_ATTRIBUTE_LIMIT_EXCEEDED", "INSUFFICIENT_STRING_SPACE", "INSUFFICIENT_NUMERIC_SPACE", "INVALID_BULK_REQUEST"]
        if not value_allowed_none_or_none_sentinel(operation_status, allowed_values):
            operation_status = 'UNKNOWN_ENUM_VALUE'
        self._operation_status = operation_status

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this BulkActivationMetadata.
        Type of operation.

        Allowed values for this property are: "ACTIVATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this BulkActivationMetadata.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this BulkActivationMetadata.
        Type of operation.


        :param operation_type: The operation_type of this BulkActivationMetadata.
        :type: str
        """
        allowed_values = ["ACTIVATE"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def string_attributes_activated(self):
        """
        Gets the string_attributes_activated of this BulkActivationMetadata.
        Total number of string attributes in TRACES namespace that were activated.


        :return: The string_attributes_activated of this BulkActivationMetadata.
        :rtype: int
        """
        return self._string_attributes_activated

    @string_attributes_activated.setter
    def string_attributes_activated(self, string_attributes_activated):
        """
        Sets the string_attributes_activated of this BulkActivationMetadata.
        Total number of string attributes in TRACES namespace that were activated.


        :param string_attributes_activated: The string_attributes_activated of this BulkActivationMetadata.
        :type: int
        """
        self._string_attributes_activated = string_attributes_activated

    @property
    def numeric_attributes_activated(self):
        """
        Gets the numeric_attributes_activated of this BulkActivationMetadata.
        Total number of numeric attributes in TRACES namespace that were activated.


        :return: The numeric_attributes_activated of this BulkActivationMetadata.
        :rtype: int
        """
        return self._numeric_attributes_activated

    @numeric_attributes_activated.setter
    def numeric_attributes_activated(self, numeric_attributes_activated):
        """
        Sets the numeric_attributes_activated of this BulkActivationMetadata.
        Total number of numeric attributes in TRACES namespace that were activated.


        :param numeric_attributes_activated: The numeric_attributes_activated of this BulkActivationMetadata.
        :type: int
        """
        self._numeric_attributes_activated = numeric_attributes_activated

    @property
    def synthetic_string_attributes_activated(self):
        """
        Gets the synthetic_string_attributes_activated of this BulkActivationMetadata.
        Total number of string attributes in SYNTHETIC namespace that were activated.


        :return: The synthetic_string_attributes_activated of this BulkActivationMetadata.
        :rtype: int
        """
        return self._synthetic_string_attributes_activated

    @synthetic_string_attributes_activated.setter
    def synthetic_string_attributes_activated(self, synthetic_string_attributes_activated):
        """
        Sets the synthetic_string_attributes_activated of this BulkActivationMetadata.
        Total number of string attributes in SYNTHETIC namespace that were activated.


        :param synthetic_string_attributes_activated: The synthetic_string_attributes_activated of this BulkActivationMetadata.
        :type: int
        """
        self._synthetic_string_attributes_activated = synthetic_string_attributes_activated

    @property
    def synthetic_numeric_attributes_activated(self):
        """
        Gets the synthetic_numeric_attributes_activated of this BulkActivationMetadata.
        Total number of numeric attributes in SYNTHETIC namespace that were activated.


        :return: The synthetic_numeric_attributes_activated of this BulkActivationMetadata.
        :rtype: int
        """
        return self._synthetic_numeric_attributes_activated

    @synthetic_numeric_attributes_activated.setter
    def synthetic_numeric_attributes_activated(self, synthetic_numeric_attributes_activated):
        """
        Sets the synthetic_numeric_attributes_activated of this BulkActivationMetadata.
        Total number of numeric attributes in SYNTHETIC namespace that were activated.


        :param synthetic_numeric_attributes_activated: The synthetic_numeric_attributes_activated of this BulkActivationMetadata.
        :type: int
        """
        self._synthetic_numeric_attributes_activated = synthetic_numeric_attributes_activated

    @property
    def available_string_attributes(self):
        """
        Gets the available_string_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate string attributes in the TRACES namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free slots available for activation of additional string attributes in the TRACES namespace in the APM Domain.


        :return: The available_string_attributes of this BulkActivationMetadata.
        :rtype: int
        """
        return self._available_string_attributes

    @available_string_attributes.setter
    def available_string_attributes(self, available_string_attributes):
        """
        Sets the available_string_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate string attributes in the TRACES namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free slots available for activation of additional string attributes in the TRACES namespace in the APM Domain.


        :param available_string_attributes: The available_string_attributes of this BulkActivationMetadata.
        :type: int
        """
        self._available_string_attributes = available_string_attributes

    @property
    def available_numeric_attributes(self):
        """
        Gets the available_numeric_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate numeric attributes in the TRACES namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free slots available for activation of additional numeric attributes in the TRACES namespace in the APM Domain.


        :return: The available_numeric_attributes of this BulkActivationMetadata.
        :rtype: int
        """
        return self._available_numeric_attributes

    @available_numeric_attributes.setter
    def available_numeric_attributes(self, available_numeric_attributes):
        """
        Sets the available_numeric_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate numeric attributes in the TRACES namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free slots available for activation of additional numeric attributes in the TRACES namespace in the APM Domain.


        :param available_numeric_attributes: The available_numeric_attributes of this BulkActivationMetadata.
        :type: int
        """
        self._available_numeric_attributes = available_numeric_attributes

    @property
    def available_synthetic_string_attributes(self):
        """
        Gets the available_synthetic_string_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate string attributes in the SYNTHETIC namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free synthetic slots available for activation of additional string attributes in the SYNTHETIC namespace in the APM Domain.


        :return: The available_synthetic_string_attributes of this BulkActivationMetadata.
        :rtype: int
        """
        return self._available_synthetic_string_attributes

    @available_synthetic_string_attributes.setter
    def available_synthetic_string_attributes(self, available_synthetic_string_attributes):
        """
        Sets the available_synthetic_string_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate string attributes in the SYNTHETIC namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free synthetic slots available for activation of additional string attributes in the SYNTHETIC namespace in the APM Domain.


        :param available_synthetic_string_attributes: The available_synthetic_string_attributes of this BulkActivationMetadata.
        :type: int
        """
        self._available_synthetic_string_attributes = available_synthetic_string_attributes

    @property
    def available_synthetic_numeric_attributes(self):
        """
        Gets the available_synthetic_numeric_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate numeric attributes in the SYNTHETIC namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free synthetic slots available for activation of additional numeric attributes in the SYNTHETIC namespace in the APM Domain.


        :return: The available_synthetic_numeric_attributes of this BulkActivationMetadata.
        :rtype: int
        """
        return self._available_synthetic_numeric_attributes

    @available_synthetic_numeric_attributes.setter
    def available_synthetic_numeric_attributes(self, available_synthetic_numeric_attributes):
        """
        Sets the available_synthetic_numeric_attributes of this BulkActivationMetadata.
        Total number of free slots available to activate numeric attributes in the SYNTHETIC namespace in the APM Domain.  Note that if a bulk request has succeeded, this
        number reflects the total number of free synthetic slots available for activation of additional numeric attributes in the SYNTHETIC namespace in the APM Domain.


        :param available_synthetic_numeric_attributes: The available_synthetic_numeric_attributes of this BulkActivationMetadata.
        :type: int
        """
        self._available_synthetic_numeric_attributes = available_synthetic_numeric_attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
