# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdateAttributeStatus(object):
    """
    Response of a bulk update attribute operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdateAttributeStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_statuses:
            The value to assign to the attribute_statuses property of this BulkUpdateAttributeStatus.
        :type attribute_statuses: list[oci.apm_traces.models.AttributeUpdateResponse]

        :param bulk_update_attribute_metadata:
            The value to assign to the bulk_update_attribute_metadata property of this BulkUpdateAttributeStatus.
        :type bulk_update_attribute_metadata: oci.apm_traces.models.BulkUpdateAttributeMetadata

        """
        self.swagger_types = {
            'attribute_statuses': 'list[AttributeUpdateResponse]',
            'bulk_update_attribute_metadata': 'BulkUpdateAttributeMetadata'
        }
        self.attribute_map = {
            'attribute_statuses': 'attributeStatuses',
            'bulk_update_attribute_metadata': 'bulkUpdateAttributeMetadata'
        }
        self._attribute_statuses = None
        self._bulk_update_attribute_metadata = None

    @property
    def attribute_statuses(self):
        """
        **[Required]** Gets the attribute_statuses of this BulkUpdateAttributeStatus.
        We preserve the order of the attribute items from the bulk update attribute request in this collection.  The ith object in this collection represents the
        bulk update attribute operation status of the ith object in the BulkUpdateAttributeDetails object in the Bulk update attribute request.  If the
        bulk update attribute operation results in a processing error or a validation error, the operationStatus property in the  BulkUpdateAttributeMetadata object will
        contain the appropriate bulk error status for the bulk operation.


        :return: The attribute_statuses of this BulkUpdateAttributeStatus.
        :rtype: list[oci.apm_traces.models.AttributeUpdateResponse]
        """
        return self._attribute_statuses

    @attribute_statuses.setter
    def attribute_statuses(self, attribute_statuses):
        """
        Sets the attribute_statuses of this BulkUpdateAttributeStatus.
        We preserve the order of the attribute items from the bulk update attribute request in this collection.  The ith object in this collection represents the
        bulk update attribute operation status of the ith object in the BulkUpdateAttributeDetails object in the Bulk update attribute request.  If the
        bulk update attribute operation results in a processing error or a validation error, the operationStatus property in the  BulkUpdateAttributeMetadata object will
        contain the appropriate bulk error status for the bulk operation.


        :param attribute_statuses: The attribute_statuses of this BulkUpdateAttributeStatus.
        :type: list[oci.apm_traces.models.AttributeUpdateResponse]
        """
        self._attribute_statuses = attribute_statuses

    @property
    def bulk_update_attribute_metadata(self):
        """
        **[Required]** Gets the bulk_update_attribute_metadata of this BulkUpdateAttributeStatus.

        :return: The bulk_update_attribute_metadata of this BulkUpdateAttributeStatus.
        :rtype: oci.apm_traces.models.BulkUpdateAttributeMetadata
        """
        return self._bulk_update_attribute_metadata

    @bulk_update_attribute_metadata.setter
    def bulk_update_attribute_metadata(self, bulk_update_attribute_metadata):
        """
        Sets the bulk_update_attribute_metadata of this BulkUpdateAttributeStatus.

        :param bulk_update_attribute_metadata: The bulk_update_attribute_metadata of this BulkUpdateAttributeStatus.
        :type: oci.apm_traces.models.BulkUpdateAttributeMetadata
        """
        self._bulk_update_attribute_metadata = bulk_update_attribute_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
