# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181001

from .metric_base import MetricBase
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomMetric(MetricBase):
    """
    Metric details for triggering an autoscaling action based on a custom MQL query.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomMetric object with values from keyword arguments. The default value of the :py:attr:`~oci.autoscaling.models.CustomMetric.metric_source` attribute
        of this class is ``CUSTOM_QUERY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pending_duration:
            The value to assign to the pending_duration property of this CustomMetric.
        :type pending_duration: str

        :param metric_source:
            The value to assign to the metric_source property of this CustomMetric.
            Allowed values for this property are: "COMPUTE_AGENT", "CUSTOM_QUERY"
        :type metric_source: str

        :param query:
            The value to assign to the query property of this CustomMetric.
        :type query: str

        :param namespace:
            The value to assign to the namespace property of this CustomMetric.
        :type namespace: str

        :param resource_group:
            The value to assign to the resource_group property of this CustomMetric.
        :type resource_group: str

        :param metric_compartment_id:
            The value to assign to the metric_compartment_id property of this CustomMetric.
        :type metric_compartment_id: str

        """
        self.swagger_types = {
            'pending_duration': 'str',
            'metric_source': 'str',
            'query': 'str',
            'namespace': 'str',
            'resource_group': 'str',
            'metric_compartment_id': 'str'
        }
        self.attribute_map = {
            'pending_duration': 'pendingDuration',
            'metric_source': 'metricSource',
            'query': 'query',
            'namespace': 'namespace',
            'resource_group': 'resourceGroup',
            'metric_compartment_id': 'metricCompartmentId'
        }
        self._pending_duration = None
        self._metric_source = None
        self._query = None
        self._namespace = None
        self._resource_group = None
        self._metric_compartment_id = None
        self._metric_source = 'CUSTOM_QUERY'

    @property
    def query(self):
        """
        **[Required]** Gets the query of this CustomMetric.
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of
        the Monitoring service interprets results for each returned time series as Boolean values,
        where zero represents false and a non-zero value represents true. A true value means that the trigger
        rule condition has been met. The query must specify a metric, statistic, interval, and trigger
        rule (threshold or absence). Supported values for interval: `1m`-`60m` (also `1h`). You can optionally
        specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`.

        Example of threshold alarm:

          -----

            CpuUtilization[1m]{availabilityDomain=\"cumS:PHX-AD-1\"}.groupBy(availabilityDomain).percentile(0.9) > 85

          -----


        :return: The query of this CustomMetric.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this CustomMetric.
        The Monitoring Query Language (MQL) expression to evaluate for the alarm. The Alarms feature of
        the Monitoring service interprets results for each returned time series as Boolean values,
        where zero represents false and a non-zero value represents true. A true value means that the trigger
        rule condition has been met. The query must specify a metric, statistic, interval, and trigger
        rule (threshold or absence). Supported values for interval: `1m`-`60m` (also `1h`). You can optionally
        specify dimensions and grouping functions. Supported grouping functions: `grouping()`, `groupBy()`.

        Example of threshold alarm:

          -----

            CpuUtilization[1m]{availabilityDomain=\"cumS:PHX-AD-1\"}.groupBy(availabilityDomain).percentile(0.9) > 85

          -----


        :param query: The query of this CustomMetric.
        :type: str
        """
        self._query = query

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this CustomMetric.
        The namespace for the query.


        :return: The namespace of this CustomMetric.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CustomMetric.
        The namespace for the query.


        :param namespace: The namespace of this CustomMetric.
        :type: str
        """
        self._namespace = namespace

    @property
    def resource_group(self):
        """
        Gets the resource_group of this CustomMetric.
        The resource group for the query.


        :return: The resource_group of this CustomMetric.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this CustomMetric.
        The resource group for the query.


        :param resource_group: The resource_group of this CustomMetric.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def metric_compartment_id(self):
        """
        **[Required]** Gets the metric_compartment_id of this CustomMetric.
        The OCID of the compartment containing the metrics.


        :return: The metric_compartment_id of this CustomMetric.
        :rtype: str
        """
        return self._metric_compartment_id

    @metric_compartment_id.setter
    def metric_compartment_id(self, metric_compartment_id):
        """
        Sets the metric_compartment_id of this CustomMetric.
        The OCID of the compartment containing the metrics.


        :param metric_compartment_id: The metric_compartment_id of this CustomMetric.
        :type: str
        """
        self._metric_compartment_id = metric_compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
