# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOccmDemandSignalItemDetails(object):
    """
    Details about different fields used to update the demand signal item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOccmDemandSignalItemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this UpdateOccmDemandSignalItemDetails.
        :type region: str

        :param availability_domain:
            The value to assign to the availability_domain property of this UpdateOccmDemandSignalItemDetails.
        :type availability_domain: str

        :param target_compartment_id:
            The value to assign to the target_compartment_id property of this UpdateOccmDemandSignalItemDetails.
        :type target_compartment_id: str

        :param demand_quantity:
            The value to assign to the demand_quantity property of this UpdateOccmDemandSignalItemDetails.
        :type demand_quantity: int

        :param time_needed_before:
            The value to assign to the time_needed_before property of this UpdateOccmDemandSignalItemDetails.
        :type time_needed_before: datetime

        :param resource_properties:
            The value to assign to the resource_properties property of this UpdateOccmDemandSignalItemDetails.
        :type resource_properties: dict(str, str)

        :param notes:
            The value to assign to the notes property of this UpdateOccmDemandSignalItemDetails.
        :type notes: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOccmDemandSignalItemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOccmDemandSignalItemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'region': 'str',
            'availability_domain': 'str',
            'target_compartment_id': 'str',
            'demand_quantity': 'int',
            'time_needed_before': 'datetime',
            'resource_properties': 'dict(str, str)',
            'notes': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'region': 'region',
            'availability_domain': 'availabilityDomain',
            'target_compartment_id': 'targetCompartmentId',
            'demand_quantity': 'demandQuantity',
            'time_needed_before': 'timeNeededBefore',
            'resource_properties': 'resourceProperties',
            'notes': 'notes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._region = None
        self._availability_domain = None
        self._target_compartment_id = None
        self._demand_quantity = None
        self._time_needed_before = None
        self._resource_properties = None
        self._notes = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def region(self):
        """
        Gets the region of this UpdateOccmDemandSignalItemDetails.
        The region for which you want to request the resource for.


        :return: The region of this UpdateOccmDemandSignalItemDetails.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this UpdateOccmDemandSignalItemDetails.
        The region for which you want to request the resource for.


        :param region: The region of this UpdateOccmDemandSignalItemDetails.
        :type: str
        """
        self._region = region

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this UpdateOccmDemandSignalItemDetails.
        The name of the availability domain for which you want to request the OCI resource.


        :return: The availability_domain of this UpdateOccmDemandSignalItemDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this UpdateOccmDemandSignalItemDetails.
        The name of the availability domain for which you want to request the OCI resource.


        :param availability_domain: The availability_domain of this UpdateOccmDemandSignalItemDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def target_compartment_id(self):
        """
        Gets the target_compartment_id of this UpdateOccmDemandSignalItemDetails.
        The OCID of the tenancy for which you want to request the OCI resource for.


        :return: The target_compartment_id of this UpdateOccmDemandSignalItemDetails.
        :rtype: str
        """
        return self._target_compartment_id

    @target_compartment_id.setter
    def target_compartment_id(self, target_compartment_id):
        """
        Sets the target_compartment_id of this UpdateOccmDemandSignalItemDetails.
        The OCID of the tenancy for which you want to request the OCI resource for.


        :param target_compartment_id: The target_compartment_id of this UpdateOccmDemandSignalItemDetails.
        :type: str
        """
        self._target_compartment_id = target_compartment_id

    @property
    def demand_quantity(self):
        """
        Gets the demand_quantity of this UpdateOccmDemandSignalItemDetails.
        The quantity of the resource that you want to demand from OCI.


        :return: The demand_quantity of this UpdateOccmDemandSignalItemDetails.
        :rtype: int
        """
        return self._demand_quantity

    @demand_quantity.setter
    def demand_quantity(self, demand_quantity):
        """
        Sets the demand_quantity of this UpdateOccmDemandSignalItemDetails.
        The quantity of the resource that you want to demand from OCI.


        :param demand_quantity: The demand_quantity of this UpdateOccmDemandSignalItemDetails.
        :type: int
        """
        self._demand_quantity = demand_quantity

    @property
    def time_needed_before(self):
        """
        Gets the time_needed_before of this UpdateOccmDemandSignalItemDetails.
        the date before which you would ideally like the OCI resource to be delivered to you.


        :return: The time_needed_before of this UpdateOccmDemandSignalItemDetails.
        :rtype: datetime
        """
        return self._time_needed_before

    @time_needed_before.setter
    def time_needed_before(self, time_needed_before):
        """
        Sets the time_needed_before of this UpdateOccmDemandSignalItemDetails.
        the date before which you would ideally like the OCI resource to be delivered to you.


        :param time_needed_before: The time_needed_before of this UpdateOccmDemandSignalItemDetails.
        :type: datetime
        """
        self._time_needed_before = time_needed_before

    @property
    def resource_properties(self):
        """
        Gets the resource_properties of this UpdateOccmDemandSignalItemDetails.
        A map of various properties associated with the OCI resource. This parameter will act as a replace parameter i.e the existing resource properties will be overridden by this update.


        :return: The resource_properties of this UpdateOccmDemandSignalItemDetails.
        :rtype: dict(str, str)
        """
        return self._resource_properties

    @resource_properties.setter
    def resource_properties(self, resource_properties):
        """
        Sets the resource_properties of this UpdateOccmDemandSignalItemDetails.
        A map of various properties associated with the OCI resource. This parameter will act as a replace parameter i.e the existing resource properties will be overridden by this update.


        :param resource_properties: The resource_properties of this UpdateOccmDemandSignalItemDetails.
        :type: dict(str, str)
        """
        self._resource_properties = resource_properties

    @property
    def notes(self):
        """
        Gets the notes of this UpdateOccmDemandSignalItemDetails.
        This field will serve as notes section for you. You can use this section to convey a message to OCI regarding your resource request.

        NOTE: The previous value gets overwritten with the new one for this once updated.


        :return: The notes of this UpdateOccmDemandSignalItemDetails.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this UpdateOccmDemandSignalItemDetails.
        This field will serve as notes section for you. You can use this section to convey a message to OCI regarding your resource request.

        NOTE: The previous value gets overwritten with the new one for this once updated.


        :param notes: The notes of this UpdateOccmDemandSignalItemDetails.
        :type: str
        """
        self._notes = notes

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOccmDemandSignalItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateOccmDemandSignalItemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOccmDemandSignalItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateOccmDemandSignalItemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOccmDemandSignalItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateOccmDemandSignalItemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOccmDemandSignalItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateOccmDemandSignalItemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
