# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SupportedCloudRegionSummary(object):
    """
    Summary of the supported cloud region.
    """

    #: A constant which can be used with the asset_source_type property of a SupportedCloudRegionSummary.
    #: This constant has a value of "VMWARE"
    ASSET_SOURCE_TYPE_VMWARE = "VMWARE"

    #: A constant which can be used with the asset_source_type property of a SupportedCloudRegionSummary.
    #: This constant has a value of "AWS"
    ASSET_SOURCE_TYPE_AWS = "AWS"

    #: A constant which can be used with the lifecycle_state property of a SupportedCloudRegionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SupportedCloudRegionSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new SupportedCloudRegionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param asset_source_type:
            The value to assign to the asset_source_type property of this SupportedCloudRegionSummary.
            Allowed values for this property are: "VMWARE", "AWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type asset_source_type: str

        :param name:
            The value to assign to the name property of this SupportedCloudRegionSummary.
        :type name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SupportedCloudRegionSummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SupportedCloudRegionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SupportedCloudRegionSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'asset_source_type': 'str',
            'name': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'asset_source_type': 'assetSourceType',
            'name': 'name',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._asset_source_type = None
        self._name = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def asset_source_type(self):
        """
        **[Required]** Gets the asset_source_type of this SupportedCloudRegionSummary.
        The asset source type associated with the supported cloud region.

        Allowed values for this property are: "VMWARE", "AWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The asset_source_type of this SupportedCloudRegionSummary.
        :rtype: str
        """
        return self._asset_source_type

    @asset_source_type.setter
    def asset_source_type(self, asset_source_type):
        """
        Sets the asset_source_type of this SupportedCloudRegionSummary.
        The asset source type associated with the supported cloud region.


        :param asset_source_type: The asset_source_type of this SupportedCloudRegionSummary.
        :type: str
        """
        allowed_values = ["VMWARE", "AWS"]
        if not value_allowed_none_or_none_sentinel(asset_source_type, allowed_values):
            asset_source_type = 'UNKNOWN_ENUM_VALUE'
        self._asset_source_type = asset_source_type

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SupportedCloudRegionSummary.
        The supported cloud region name.


        :return: The name of this SupportedCloudRegionSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SupportedCloudRegionSummary.
        The supported cloud region name.


        :param name: The name of this SupportedCloudRegionSummary.
        :type: str
        """
        self._name = name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SupportedCloudRegionSummary.
        The current state of the supported cloud region.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SupportedCloudRegionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SupportedCloudRegionSummary.
        The current state of the supported cloud region.


        :param lifecycle_state: The lifecycle_state of this SupportedCloudRegionSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this SupportedCloudRegionSummary.
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no
        predefined name, type, or namespace/scope. For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SupportedCloudRegionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SupportedCloudRegionSummary.
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no
        predefined name, type, or namespace/scope. For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SupportedCloudRegionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this SupportedCloudRegionSummary.
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SupportedCloudRegionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SupportedCloudRegionSummary.
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SupportedCloudRegionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
