# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeHostSummary(object):
    """
    Summary information for a compute host.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeHostSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this ComputeHostSummary.
        :type availability_domain: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ComputeHostSummary.
        :type compartment_id: str

        :param id:
            The value to assign to the id property of this ComputeHostSummary.
        :type id: str

        :param fault_domain:
            The value to assign to the fault_domain property of this ComputeHostSummary.
        :type fault_domain: str

        :param hpc_island_id:
            The value to assign to the hpc_island_id property of this ComputeHostSummary.
        :type hpc_island_id: str

        :param compute_host_group_id:
            The value to assign to the compute_host_group_id property of this ComputeHostSummary.
        :type compute_host_group_id: str

        :param recycle_details:
            The value to assign to the recycle_details property of this ComputeHostSummary.
        :type recycle_details: oci.core.models.RecycleDetails

        :param network_block_id:
            The value to assign to the network_block_id property of this ComputeHostSummary.
        :type network_block_id: str

        :param local_block_id:
            The value to assign to the local_block_id property of this ComputeHostSummary.
        :type local_block_id: str

        :param gpu_memory_fabric_id:
            The value to assign to the gpu_memory_fabric_id property of this ComputeHostSummary.
        :type gpu_memory_fabric_id: str

        :param instance_id:
            The value to assign to the instance_id property of this ComputeHostSummary.
        :type instance_id: str

        :param shape:
            The value to assign to the shape property of this ComputeHostSummary.
        :type shape: str

        :param health:
            The value to assign to the health property of this ComputeHostSummary.
        :type health: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeHostSummary.
        :type lifecycle_state: str

        :param capacity_reservation_id:
            The value to assign to the capacity_reservation_id property of this ComputeHostSummary.
        :type capacity_reservation_id: str

        :param has_impacted_components:
            The value to assign to the has_impacted_components property of this ComputeHostSummary.
        :type has_impacted_components: bool

        :param time_created:
            The value to assign to the time_created property of this ComputeHostSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ComputeHostSummary.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this ComputeHostSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this ComputeHostSummary.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ComputeHostSummary.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'compartment_id': 'str',
            'id': 'str',
            'fault_domain': 'str',
            'hpc_island_id': 'str',
            'compute_host_group_id': 'str',
            'recycle_details': 'RecycleDetails',
            'network_block_id': 'str',
            'local_block_id': 'str',
            'gpu_memory_fabric_id': 'str',
            'instance_id': 'str',
            'shape': 'str',
            'health': 'str',
            'lifecycle_state': 'str',
            'capacity_reservation_id': 'str',
            'has_impacted_components': 'bool',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'compartment_id': 'compartmentId',
            'id': 'id',
            'fault_domain': 'faultDomain',
            'hpc_island_id': 'hpcIslandId',
            'compute_host_group_id': 'computeHostGroupId',
            'recycle_details': 'recycleDetails',
            'network_block_id': 'networkBlockId',
            'local_block_id': 'localBlockId',
            'gpu_memory_fabric_id': 'gpuMemoryFabricId',
            'instance_id': 'instanceId',
            'shape': 'shape',
            'health': 'health',
            'lifecycle_state': 'lifecycleState',
            'capacity_reservation_id': 'capacityReservationId',
            'has_impacted_components': 'hasImpactedComponents',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags'
        }
        self._availability_domain = None
        self._compartment_id = None
        self._id = None
        self._fault_domain = None
        self._hpc_island_id = None
        self._compute_host_group_id = None
        self._recycle_details = None
        self._network_block_id = None
        self._local_block_id = None
        self._gpu_memory_fabric_id = None
        self._instance_id = None
        self._shape = None
        self._health = None
        self._lifecycle_state = None
        self._capacity_reservation_id = None
        self._has_impacted_components = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this ComputeHostSummary.
        The availability domain of the compute host.

        Example: `Uocm:US-CHICAGO-1-AD-2`


        :return: The availability_domain of this ComputeHostSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ComputeHostSummary.
        The availability domain of the compute host.

        Example: `Uocm:US-CHICAGO-1-AD-2`


        :param availability_domain: The availability_domain of this ComputeHostSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ComputeHostSummary.
        The `OCID`__ for the compartment. This should always be the root
        compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ComputeHostSummary.
        The `OCID`__ for the compartment. This should always be the root
        compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ComputeHostSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComputeHostSummary.
        The `OCID`__ for the Customer-unique host

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ComputeHostSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeHostSummary.
        The `OCID`__ for the Customer-unique host

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ComputeHostSummary.
        :type: str
        """
        self._id = id

    @property
    def fault_domain(self):
        """
        **[Required]** Gets the fault_domain of this ComputeHostSummary.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        This field is the Fault domain of the host


        :return: The fault_domain of this ComputeHostSummary.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this ComputeHostSummary.
        A fault domain is a grouping of hardware and infrastructure within an availability domain.
        Each availability domain contains three fault domains. Fault domains let you distribute your
        instances so that they are not on the same physical hardware within a single availability domain.
        A hardware failure or Compute hardware maintenance that affects one fault domain does not affect
        instances in other fault domains.

        This field is the Fault domain of the host


        :param fault_domain: The fault_domain of this ComputeHostSummary.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def hpc_island_id(self):
        """
        Gets the hpc_island_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique HPC Island

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The hpc_island_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._hpc_island_id

    @hpc_island_id.setter
    def hpc_island_id(self, hpc_island_id):
        """
        Sets the hpc_island_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique HPC Island

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param hpc_island_id: The hpc_island_id of this ComputeHostSummary.
        :type: str
        """
        self._hpc_island_id = hpc_island_id

    @property
    def compute_host_group_id(self):
        """
        Gets the compute_host_group_id of this ComputeHostSummary.
        The `OCID`__ for the Customer-unique host group

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_host_group_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._compute_host_group_id

    @compute_host_group_id.setter
    def compute_host_group_id(self, compute_host_group_id):
        """
        Sets the compute_host_group_id of this ComputeHostSummary.
        The `OCID`__ for the Customer-unique host group

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_host_group_id: The compute_host_group_id of this ComputeHostSummary.
        :type: str
        """
        self._compute_host_group_id = compute_host_group_id

    @property
    def recycle_details(self):
        """
        Gets the recycle_details of this ComputeHostSummary.

        :return: The recycle_details of this ComputeHostSummary.
        :rtype: oci.core.models.RecycleDetails
        """
        return self._recycle_details

    @recycle_details.setter
    def recycle_details(self, recycle_details):
        """
        Sets the recycle_details of this ComputeHostSummary.

        :param recycle_details: The recycle_details of this ComputeHostSummary.
        :type: oci.core.models.RecycleDetails
        """
        self._recycle_details = recycle_details

    @property
    def network_block_id(self):
        """
        Gets the network_block_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique Network Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The network_block_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._network_block_id

    @network_block_id.setter
    def network_block_id(self, network_block_id):
        """
        Sets the network_block_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique Network Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param network_block_id: The network_block_id of this ComputeHostSummary.
        :type: str
        """
        self._network_block_id = network_block_id

    @property
    def local_block_id(self):
        """
        Gets the local_block_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique Local Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The local_block_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._local_block_id

    @local_block_id.setter
    def local_block_id(self, local_block_id):
        """
        Sets the local_block_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique Local Block

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param local_block_id: The local_block_id of this ComputeHostSummary.
        :type: str
        """
        self._local_block_id = local_block_id

    @property
    def gpu_memory_fabric_id(self):
        """
        Gets the gpu_memory_fabric_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique GPU Memory Fabric

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The gpu_memory_fabric_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._gpu_memory_fabric_id

    @gpu_memory_fabric_id.setter
    def gpu_memory_fabric_id(self, gpu_memory_fabric_id):
        """
        Sets the gpu_memory_fabric_id of this ComputeHostSummary.
        The `OCID`__ for Customer-unique GPU Memory Fabric

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param gpu_memory_fabric_id: The gpu_memory_fabric_id of this ComputeHostSummary.
        :type: str
        """
        self._gpu_memory_fabric_id = gpu_memory_fabric_id

    @property
    def instance_id(self):
        """
        Gets the instance_id of this ComputeHostSummary.
        The public `OCID`__ for the Virtual Machine or Bare Metal instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The instance_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ComputeHostSummary.
        The public `OCID`__ for the Virtual Machine or Bare Metal instance

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param instance_id: The instance_id of this ComputeHostSummary.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ComputeHostSummary.
        The shape of host


        :return: The shape of this ComputeHostSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ComputeHostSummary.
        The shape of host


        :param shape: The shape of this ComputeHostSummary.
        :type: str
        """
        self._shape = shape

    @property
    def health(self):
        """
        **[Required]** Gets the health of this ComputeHostSummary.
        The heathy state of the host


        :return: The health of this ComputeHostSummary.
        :rtype: str
        """
        return self._health

    @health.setter
    def health(self, health):
        """
        Sets the health of this ComputeHostSummary.
        The heathy state of the host


        :param health: The health of this ComputeHostSummary.
        :type: str
        """
        self._health = health

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ComputeHostSummary.
        The lifecycle state of the host


        :return: The lifecycle_state of this ComputeHostSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeHostSummary.
        The lifecycle state of the host


        :param lifecycle_state: The lifecycle_state of this ComputeHostSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def capacity_reservation_id(self):
        """
        Gets the capacity_reservation_id of this ComputeHostSummary.
        The `OCID`__ for the Capacity Reserver that is currently on host

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The capacity_reservation_id of this ComputeHostSummary.
        :rtype: str
        """
        return self._capacity_reservation_id

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, capacity_reservation_id):
        """
        Sets the capacity_reservation_id of this ComputeHostSummary.
        The `OCID`__ for the Capacity Reserver that is currently on host

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param capacity_reservation_id: The capacity_reservation_id of this ComputeHostSummary.
        :type: str
        """
        self._capacity_reservation_id = capacity_reservation_id

    @property
    def has_impacted_components(self):
        """
        **[Required]** Gets the has_impacted_components of this ComputeHostSummary.
        While listing a host the user will know if they have an impacted component or not.
        The user will have to issue a get host to see details.


        :return: The has_impacted_components of this ComputeHostSummary.
        :rtype: bool
        """
        return self._has_impacted_components

    @has_impacted_components.setter
    def has_impacted_components(self, has_impacted_components):
        """
        Sets the has_impacted_components of this ComputeHostSummary.
        While listing a host the user will know if they have an impacted component or not.
        The user will have to issue a get host to see details.


        :param has_impacted_components: The has_impacted_components of this ComputeHostSummary.
        :type: bool
        """
        self._has_impacted_components = has_impacted_components

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ComputeHostSummary.
        The date and time that the compute host record was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools
        .ietf.org/html/rfc3339


        :return: The time_created of this ComputeHostSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeHostSummary.
        The date and time that the compute host record was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools
        .ietf.org/html/rfc3339


        :param time_created: The time_created of this ComputeHostSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ComputeHostSummary.
        The date and time that the compute host record was updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ComputeHostSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ComputeHostSummary.
        The date and time that the compute host record was updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ComputeHostSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ComputeHostSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ComputeHostSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ComputeHostSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ComputeHostSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this ComputeHostSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this ComputeHostSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ComputeHostSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this ComputeHostSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ComputeHostSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ComputeHostSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ComputeHostSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ComputeHostSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
