# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190325


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LineageObject(object):
    """
    Object describing an individual element of object lineage.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LineageObject object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param object_key:
            The value to assign to the object_key property of this LineageObject.
        :type object_key: str

        :param display_name:
            The value to assign to the display_name property of this LineageObject.
        :type display_name: str

        :param description:
            The value to assign to the description property of this LineageObject.
        :type description: str

        :param is_intra_lineage_available:
            The value to assign to the is_intra_lineage_available property of this LineageObject.
        :type is_intra_lineage_available: bool

        :param parent_key:
            The value to assign to the parent_key property of this LineageObject.
        :type parent_key: str

        :param parent_path:
            The value to assign to the parent_path property of this LineageObject.
        :type parent_path: str

        :param time_created:
            The value to assign to the time_created property of this LineageObject.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this LineageObject.
        :type time_updated: datetime

        :param type_name:
            The value to assign to the type_name property of this LineageObject.
        :type type_name: str

        :param type_key:
            The value to assign to the type_key property of this LineageObject.
        :type type_key: str

        :param properties:
            The value to assign to the properties property of this LineageObject.
        :type properties: dict(str, dict(str, str))

        """
        self.swagger_types = {
            'object_key': 'str',
            'display_name': 'str',
            'description': 'str',
            'is_intra_lineage_available': 'bool',
            'parent_key': 'str',
            'parent_path': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'type_name': 'str',
            'type_key': 'str',
            'properties': 'dict(str, dict(str, str))'
        }
        self.attribute_map = {
            'object_key': 'objectKey',
            'display_name': 'displayName',
            'description': 'description',
            'is_intra_lineage_available': 'isIntraLineageAvailable',
            'parent_key': 'parentKey',
            'parent_path': 'parentPath',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'type_name': 'typeName',
            'type_key': 'typeKey',
            'properties': 'properties'
        }
        self._object_key = None
        self._display_name = None
        self._description = None
        self._is_intra_lineage_available = None
        self._parent_key = None
        self._parent_path = None
        self._time_created = None
        self._time_updated = None
        self._type_name = None
        self._type_key = None
        self._properties = None

    @property
    def object_key(self):
        """
        Gets the object_key of this LineageObject.
        Key of the object, such as an entity, about which this lineage applies.


        :return: The object_key of this LineageObject.
        :rtype: str
        """
        return self._object_key

    @object_key.setter
    def object_key(self, object_key):
        """
        Sets the object_key of this LineageObject.
        Key of the object, such as an entity, about which this lineage applies.


        :param object_key: The object_key of this LineageObject.
        :type: str
        """
        self._object_key = object_key

    @property
    def display_name(self):
        """
        Gets the display_name of this LineageObject.
        Display name of the object.


        :return: The display_name of this LineageObject.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this LineageObject.
        Display name of the object.


        :param display_name: The display_name of this LineageObject.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this LineageObject.
        Detailed description of the object.


        :return: The description of this LineageObject.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LineageObject.
        Detailed description of the object.


        :param description: The description of this LineageObject.
        :type: str
        """
        self._description = description

    @property
    def is_intra_lineage_available(self):
        """
        Gets the is_intra_lineage_available of this LineageObject.
        Indicates if intra-lineage is available for this given object. If yes, drill-down can be requested for
        this object.


        :return: The is_intra_lineage_available of this LineageObject.
        :rtype: bool
        """
        return self._is_intra_lineage_available

    @is_intra_lineage_available.setter
    def is_intra_lineage_available(self, is_intra_lineage_available):
        """
        Sets the is_intra_lineage_available of this LineageObject.
        Indicates if intra-lineage is available for this given object. If yes, drill-down can be requested for
        this object.


        :param is_intra_lineage_available: The is_intra_lineage_available of this LineageObject.
        :type: bool
        """
        self._is_intra_lineage_available = is_intra_lineage_available

    @property
    def parent_key(self):
        """
        Gets the parent_key of this LineageObject.
        Key of the parent object for this object.


        :return: The parent_key of this LineageObject.
        :rtype: str
        """
        return self._parent_key

    @parent_key.setter
    def parent_key(self, parent_key):
        """
        Sets the parent_key of this LineageObject.
        Key of the parent object for this object.


        :param parent_key: The parent_key of this LineageObject.
        :type: str
        """
        self._parent_key = parent_key

    @property
    def parent_path(self):
        """
        Gets the parent_path of this LineageObject.
        Full path of the parent object.


        :return: The parent_path of this LineageObject.
        :rtype: str
        """
        return self._parent_path

    @parent_path.setter
    def parent_path(self, parent_path):
        """
        Sets the parent_path of this LineageObject.
        Full path of the parent object.


        :param parent_path: The parent_path of this LineageObject.
        :type: str
        """
        self._parent_path = parent_path

    @property
    def time_created(self):
        """
        Gets the time_created of this LineageObject.
        The time that this object was created. An `RFC3339`__ formatted datetime string.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this LineageObject.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this LineageObject.
        The time that this object was created. An `RFC3339`__ formatted datetime string.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this LineageObject.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this LineageObject.
        The time that this object was updated. An `RFC3339`__ formatted datetime string.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this LineageObject.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this LineageObject.
        The time that this object was updated. An `RFC3339`__ formatted datetime string.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this LineageObject.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def type_name(self):
        """
        Gets the type_name of this LineageObject.
        Type name of the object. Type keys can be found via the '/types' endpoint.


        :return: The type_name of this LineageObject.
        :rtype: str
        """
        return self._type_name

    @type_name.setter
    def type_name(self, type_name):
        """
        Sets the type_name of this LineageObject.
        Type name of the object. Type keys can be found via the '/types' endpoint.


        :param type_name: The type_name of this LineageObject.
        :type: str
        """
        self._type_name = type_name

    @property
    def type_key(self):
        """
        Gets the type_key of this LineageObject.
        Type key of the object. Type keys can be found via the '/types' endpoint.


        :return: The type_key of this LineageObject.
        :rtype: str
        """
        return self._type_key

    @type_key.setter
    def type_key(self, type_key):
        """
        Sets the type_key of this LineageObject.
        Type key of the object. Type keys can be found via the '/types' endpoint.


        :param type_key: The type_key of this LineageObject.
        :type: str
        """
        self._type_key = type_key

    @property
    def properties(self):
        """
        Gets the properties of this LineageObject.
        A map of maps that contains the properties which are specific to the entity type. Each entity type
        definition defines it's set of required and optional properties. The map keys are category names and the
        values are maps of property name to property value. Every property is contained inside of a category. Most
        data entities have required properties within the \"default\" category.
        Example: `{\"properties\": { \"default\": { \"key1\": \"value1\"}}}`


        :return: The properties of this LineageObject.
        :rtype: dict(str, dict(str, str))
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this LineageObject.
        A map of maps that contains the properties which are specific to the entity type. Each entity type
        definition defines it's set of required and optional properties. The map keys are category names and the
        values are maps of property name to property value. Every property is contained inside of a category. Most
        data entities have required properties within the \"default\" category.
        Example: `{\"properties\": { \"default\": { \"key1\": \"value1\"}}}`


        :param properties: The properties of this LineageObject.
        :type: dict(str, dict(str, str))
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
