# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class State(object):
    """
    State stored in All States Map of Composite State
    """

    def __init__(self, **kwargs):
        """
        Initializes a new State object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this State.
        :type name: str

        :param parameter_value:
            The value to assign to the parameter_value property of this State.
        :type parameter_value: oci.data_integration.models.ParameterValue

        :param time_value:
            The value to assign to the time_value property of this State.
        :type time_value: datetime

        """
        self.swagger_types = {
            'name': 'str',
            'parameter_value': 'ParameterValue',
            'time_value': 'datetime'
        }
        self.attribute_map = {
            'name': 'name',
            'parameter_value': 'parameterValue',
            'time_value': 'timeValue'
        }
        self._name = None
        self._parameter_value = None
        self._time_value = None

    @property
    def name(self):
        """
        Gets the name of this State.
        A simple name for the State.


        :return: The name of this State.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this State.
        A simple name for the State.


        :param name: The name of this State.
        :type: str
        """
        self._name = name

    @property
    def parameter_value(self):
        """
        Gets the parameter_value of this State.

        :return: The parameter_value of this State.
        :rtype: oci.data_integration.models.ParameterValue
        """
        return self._parameter_value

    @parameter_value.setter
    def parameter_value(self, parameter_value):
        """
        Sets the parameter_value of this State.

        :param parameter_value: The parameter_value of this State.
        :type: oci.data_integration.models.ParameterValue
        """
        self._parameter_value = parameter_value

    @property
    def time_value(self):
        """
        Gets the time_value of this State.
        To store a date value for the State we use dateValue attribute.


        :return: The time_value of this State.
        :rtype: datetime
        """
        return self._time_value

    @time_value.setter
    def time_value(self, time_value):
        """
        Sets the time_value of this State.
        To store a date value for the State we use dateValue attribute.


        :param time_value: The time_value of this State.
        :type: datetime
        """
        self._time_value = time_value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
