# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RoleGrantPathSummary(object):
    """
    The summary of user role grant paths.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RoleGrantPathSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this RoleGrantPathSummary.
        :type key: str

        :param grantee:
            The value to assign to the grantee property of this RoleGrantPathSummary.
        :type grantee: str

        :param granted_role:
            The value to assign to the granted_role property of this RoleGrantPathSummary.
        :type granted_role: str

        :param depth_level:
            The value to assign to the depth_level property of this RoleGrantPathSummary.
        :type depth_level: int

        """
        self.swagger_types = {
            'key': 'str',
            'grantee': 'str',
            'granted_role': 'str',
            'depth_level': 'int'
        }
        self.attribute_map = {
            'key': 'key',
            'grantee': 'grantee',
            'granted_role': 'grantedRole',
            'depth_level': 'depthLevel'
        }
        self._key = None
        self._grantee = None
        self._granted_role = None
        self._depth_level = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this RoleGrantPathSummary.
        The unique key of a role grant.


        :return: The key of this RoleGrantPathSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this RoleGrantPathSummary.
        The unique key of a role grant.


        :param key: The key of this RoleGrantPathSummary.
        :type: str
        """
        self._key = key

    @property
    def grantee(self):
        """
        Gets the grantee of this RoleGrantPathSummary.
        Grantee is the user who can access the table.


        :return: The grantee of this RoleGrantPathSummary.
        :rtype: str
        """
        return self._grantee

    @grantee.setter
    def grantee(self, grantee):
        """
        Sets the grantee of this RoleGrantPathSummary.
        Grantee is the user who can access the table.


        :param grantee: The grantee of this RoleGrantPathSummary.
        :type: str
        """
        self._grantee = grantee

    @property
    def granted_role(self):
        """
        Gets the granted_role of this RoleGrantPathSummary.
        The name of the role.


        :return: The granted_role of this RoleGrantPathSummary.
        :rtype: str
        """
        return self._granted_role

    @granted_role.setter
    def granted_role(self, granted_role):
        """
        Sets the granted_role of this RoleGrantPathSummary.
        The name of the role.


        :param granted_role: The granted_role of this RoleGrantPathSummary.
        :type: str
        """
        self._granted_role = granted_role

    @property
    def depth_level(self):
        """
        Gets the depth_level of this RoleGrantPathSummary.
        The grant depth level of the indirect grant.
        An indirectly granted role/privilege is granted to the user through another role.
        The depth level indicates how deep a privilege is within the grant hierarchy.


        :return: The depth_level of this RoleGrantPathSummary.
        :rtype: int
        """
        return self._depth_level

    @depth_level.setter
    def depth_level(self, depth_level):
        """
        Sets the depth_level of this RoleGrantPathSummary.
        The grant depth level of the indirect grant.
        An indirectly granted role/privilege is granted to the user through another role.
        The depth level indicates how deep a privilege is within the grant hierarchy.


        :param depth_level: The depth_level of this RoleGrantPathSummary.
        :type: int
        """
        self._depth_level = depth_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
