# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateAssociationAnalyticsDimensions(object):
    """
    The scope of template association analytics data.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateAssociationAnalyticsDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param template_assessment_id:
            The value to assign to the template_assessment_id property of this TemplateAssociationAnalyticsDimensions.
        :type template_assessment_id: str

        :param template_baseline_assessment_id:
            The value to assign to the template_baseline_assessment_id property of this TemplateAssociationAnalyticsDimensions.
        :type template_baseline_assessment_id: str

        :param target_database_group_id:
            The value to assign to the target_database_group_id property of this TemplateAssociationAnalyticsDimensions.
        :type target_database_group_id: str

        :param target_id:
            The value to assign to the target_id property of this TemplateAssociationAnalyticsDimensions.
        :type target_id: str

        """
        self.swagger_types = {
            'template_assessment_id': 'str',
            'template_baseline_assessment_id': 'str',
            'target_database_group_id': 'str',
            'target_id': 'str'
        }
        self.attribute_map = {
            'template_assessment_id': 'templateAssessmentId',
            'template_baseline_assessment_id': 'templateBaselineAssessmentId',
            'target_database_group_id': 'targetDatabaseGroupId',
            'target_id': 'targetId'
        }
        self._template_assessment_id = None
        self._template_baseline_assessment_id = None
        self._target_database_group_id = None
        self._target_id = None

    @property
    def template_assessment_id(self):
        """
        Gets the template_assessment_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE.


        :return: The template_assessment_id of this TemplateAssociationAnalyticsDimensions.
        :rtype: str
        """
        return self._template_assessment_id

    @template_assessment_id.setter
    def template_assessment_id(self, template_assessment_id):
        """
        Sets the template_assessment_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE.


        :param template_assessment_id: The template_assessment_id of this TemplateAssociationAnalyticsDimensions.
        :type: str
        """
        self._template_assessment_id = template_assessment_id

    @property
    def template_baseline_assessment_id(self):
        """
        Gets the template_baseline_assessment_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE_BASELINE.


        :return: The template_baseline_assessment_id of this TemplateAssociationAnalyticsDimensions.
        :rtype: str
        """
        return self._template_baseline_assessment_id

    @template_baseline_assessment_id.setter
    def template_baseline_assessment_id(self, template_baseline_assessment_id):
        """
        Sets the template_baseline_assessment_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the security assessment of type TEMPLATE_BASELINE.


        :param template_baseline_assessment_id: The template_baseline_assessment_id of this TemplateAssociationAnalyticsDimensions.
        :type: str
        """
        self._template_baseline_assessment_id = template_baseline_assessment_id

    @property
    def target_database_group_id(self):
        """
        Gets the target_database_group_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the target database group that the group assessment is created for.
        This field will be in the response if the template was applied on a target group.


        :return: The target_database_group_id of this TemplateAssociationAnalyticsDimensions.
        :rtype: str
        """
        return self._target_database_group_id

    @target_database_group_id.setter
    def target_database_group_id(self, target_database_group_id):
        """
        Sets the target_database_group_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the target database group that the group assessment is created for.
        This field will be in the response if the template was applied on a target group.


        :param target_database_group_id: The target_database_group_id of this TemplateAssociationAnalyticsDimensions.
        :type: str
        """
        self._target_database_group_id = target_database_group_id

    @property
    def target_id(self):
        """
        Gets the target_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the target database.
        If the template was applied on a target group, this field will be the OCID of the target members of the target group.
        If the template was applied on an individual target, this field will contain that targetId.


        :return: The target_id of this TemplateAssociationAnalyticsDimensions.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this TemplateAssociationAnalyticsDimensions.
        The OCID of the target database.
        If the template was applied on a target group, this field will be the OCID of the target members of the target group.
        If the template was applied on an individual target, this field will contain that targetId.


        :param target_id: The target_id of this TemplateAssociationAnalyticsDimensions.
        :type: str
        """
        self._target_id = target_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
