# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBaseModelGroupDetails(object):
    """
    The base create model group details.
    """

    #: A constant which can be used with the create_type property of a CreateBaseModelGroupDetails.
    #: This constant has a value of "CREATE"
    CREATE_TYPE_CREATE = "CREATE"

    #: A constant which can be used with the create_type property of a CreateBaseModelGroupDetails.
    #: This constant has a value of "CLONE"
    CREATE_TYPE_CLONE = "CLONE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBaseModelGroupDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.CloneModelGroupDetails`
        * :class:`~oci.data_science.models.CreateModelGroupDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param create_type:
            The value to assign to the create_type property of this CreateBaseModelGroupDetails.
            Allowed values for this property are: "CREATE", "CLONE"
        :type create_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBaseModelGroupDetails.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this CreateBaseModelGroupDetails.
        :type project_id: str

        """
        self.swagger_types = {
            'create_type': 'str',
            'compartment_id': 'str',
            'project_id': 'str'
        }
        self.attribute_map = {
            'create_type': 'createType',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId'
        }
        self._create_type = None
        self._compartment_id = None
        self._project_id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['createType']

        if type == 'CLONE':
            return 'CloneModelGroupDetails'

        if type == 'CREATE':
            return 'CreateModelGroupDetails'
        else:
            return 'CreateBaseModelGroupDetails'

    @property
    def create_type(self):
        """
        **[Required]** Gets the create_type of this CreateBaseModelGroupDetails.
        The type of the model group create operation.

        Allowed values for this property are: "CREATE", "CLONE"


        :return: The create_type of this CreateBaseModelGroupDetails.
        :rtype: str
        """
        return self._create_type

    @create_type.setter
    def create_type(self, create_type):
        """
        Sets the create_type of this CreateBaseModelGroupDetails.
        The type of the model group create operation.


        :param create_type: The create_type of this CreateBaseModelGroupDetails.
        :type: str
        """
        allowed_values = ["CREATE", "CLONE"]
        if not value_allowed_none_or_none_sentinel(create_type, allowed_values):
            raise ValueError(
                f"Invalid value for `create_type`, must be None or one of {allowed_values}"
            )
        self._create_type = create_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBaseModelGroupDetails.
        The `OCID`__ of the compartment to create the modelGroup in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBaseModelGroupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBaseModelGroupDetails.
        The `OCID`__ of the compartment to create the modelGroup in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBaseModelGroupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this CreateBaseModelGroupDetails.
        The `OCID`__ of the project to associate with the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this CreateBaseModelGroupDetails.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this CreateBaseModelGroupDetails.
        The `OCID`__ of the project to associate with the modelGroup.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this CreateBaseModelGroupDetails.
        :type: str
        """
        self._project_id = project_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
