# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .auth_configuration import AuthConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdcsAuthConfiguration(AuthConfiguration):
    """
    Configuration of IDCS AuthN/Z for online prediction
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdcsAuthConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.IdcsAuthConfiguration.type` attribute
        of this class is ``IDCS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this IdcsAuthConfiguration.
            Allowed values for this property are: "IDCS", "IAM", "IDCS_CUSTOM_SERVICE"
        :type type: str

        :param domain_id:
            The value to assign to the domain_id property of this IdcsAuthConfiguration.
        :type domain_id: str

        :param application_name:
            The value to assign to the application_name property of this IdcsAuthConfiguration.
        :type application_name: str

        """
        self.swagger_types = {
            'type': 'str',
            'domain_id': 'str',
            'application_name': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'domain_id': 'domainId',
            'application_name': 'applicationName'
        }
        self._type = None
        self._domain_id = None
        self._application_name = None
        self._type = 'IDCS'

    @property
    def domain_id(self):
        """
        **[Required]** Gets the domain_id of this IdcsAuthConfiguration.
        Identity Domain OCID


        :return: The domain_id of this IdcsAuthConfiguration.
        :rtype: str
        """
        return self._domain_id

    @domain_id.setter
    def domain_id(self, domain_id):
        """
        Sets the domain_id of this IdcsAuthConfiguration.
        Identity Domain OCID


        :param domain_id: The domain_id of this IdcsAuthConfiguration.
        :type: str
        """
        self._domain_id = domain_id

    @property
    def application_name(self):
        """
        Gets the application_name of this IdcsAuthConfiguration.
        Name of the IDCS application


        :return: The application_name of this IdcsAuthConfiguration.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """
        Sets the application_name of this IdcsAuthConfiguration.
        Name of the IDCS application


        :param application_name: The application_name of this IdcsAuthConfiguration.
        :type: str
        """
        self._application_name = application_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
