# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TriggerMlApplicationInstanceViewFlowDetails(object):
    """
    Payload for trigger request endpoint
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TriggerMlApplicationInstanceViewFlowDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param trigger_name:
            The value to assign to the trigger_name property of this TriggerMlApplicationInstanceViewFlowDetails.
        :type trigger_name: str

        :param parameters:
            The value to assign to the parameters property of this TriggerMlApplicationInstanceViewFlowDetails.
        :type parameters: list[oci.data_science.models.TriggerParameter]

        """
        self.swagger_types = {
            'trigger_name': 'str',
            'parameters': 'list[TriggerParameter]'
        }
        self.attribute_map = {
            'trigger_name': 'triggerName',
            'parameters': 'parameters'
        }
        self._trigger_name = None
        self._parameters = None

    @property
    def trigger_name(self):
        """
        **[Required]** Gets the trigger_name of this TriggerMlApplicationInstanceViewFlowDetails.
        Name of trigger


        :return: The trigger_name of this TriggerMlApplicationInstanceViewFlowDetails.
        :rtype: str
        """
        return self._trigger_name

    @trigger_name.setter
    def trigger_name(self, trigger_name):
        """
        Sets the trigger_name of this TriggerMlApplicationInstanceViewFlowDetails.
        Name of trigger


        :param trigger_name: The trigger_name of this TriggerMlApplicationInstanceViewFlowDetails.
        :type: str
        """
        self._trigger_name = trigger_name

    @property
    def parameters(self):
        """
        Gets the parameters of this TriggerMlApplicationInstanceViewFlowDetails.
        Parameters provided for given trigger invocation (they must match predefined schema)


        :return: The parameters of this TriggerMlApplicationInstanceViewFlowDetails.
        :rtype: list[oci.data_science.models.TriggerParameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this TriggerMlApplicationInstanceViewFlowDetails.
        Parameters provided for given trigger invocation (they must match predefined schema)


        :param parameters: The parameters of this TriggerMlApplicationInstanceViewFlowDetails.
        :type: list[oci.data_science.models.TriggerParameter]
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
