# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateExadbVmClusterDetails(object):
    """
    Details for updating the Exadata VM cluster on Exascale Infrastructure. Applies to Exadata Database Service on Exascale Infrastructure only.
    """

    #: A constant which can be used with the license_model property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the update_action property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "ROLLING_APPLY"
    UPDATE_ACTION_ROLLING_APPLY = "ROLLING_APPLY"

    #: A constant which can be used with the update_action property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "NON_ROLLING_APPLY"
    UPDATE_ACTION_NON_ROLLING_APPLY = "NON_ROLLING_APPLY"

    #: A constant which can be used with the update_action property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "PRECHECK"
    UPDATE_ACTION_PRECHECK = "PRECHECK"

    #: A constant which can be used with the update_action property of a UpdateExadbVmClusterDetails.
    #: This constant has a value of "ROLLBACK"
    UPDATE_ACTION_ROLLBACK = "ROLLBACK"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateExadbVmClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateExadbVmClusterDetails.
        :type display_name: str

        :param total_e_cpu_count:
            The value to assign to the total_e_cpu_count property of this UpdateExadbVmClusterDetails.
        :type total_e_cpu_count: int

        :param enabled_e_cpu_count:
            The value to assign to the enabled_e_cpu_count property of this UpdateExadbVmClusterDetails.
        :type enabled_e_cpu_count: int

        :param vm_file_system_storage:
            The value to assign to the vm_file_system_storage property of this UpdateExadbVmClusterDetails.
        :type vm_file_system_storage: oci.database.models.ExadbVmClusterStorageDetails

        :param node_count:
            The value to assign to the node_count property of this UpdateExadbVmClusterDetails.
        :type node_count: int

        :param license_model:
            The value to assign to the license_model property of this UpdateExadbVmClusterDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param ssh_public_keys:
            The value to assign to the ssh_public_keys property of this UpdateExadbVmClusterDetails.
        :type ssh_public_keys: list[str]

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateExadbVmClusterDetails.
        :type nsg_ids: list[str]

        :param backup_network_nsg_ids:
            The value to assign to the backup_network_nsg_ids property of this UpdateExadbVmClusterDetails.
        :type backup_network_nsg_ids: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateExadbVmClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateExadbVmClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this UpdateExadbVmClusterDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param data_collection_options:
            The value to assign to the data_collection_options property of this UpdateExadbVmClusterDetails.
        :type data_collection_options: oci.database.models.DataCollectionOptions

        :param system_version:
            The value to assign to the system_version property of this UpdateExadbVmClusterDetails.
        :type system_version: str

        :param grid_image_id:
            The value to assign to the grid_image_id property of this UpdateExadbVmClusterDetails.
        :type grid_image_id: str

        :param update_action:
            The value to assign to the update_action property of this UpdateExadbVmClusterDetails.
            Allowed values for this property are: "ROLLING_APPLY", "NON_ROLLING_APPLY", "PRECHECK", "ROLLBACK"
        :type update_action: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'total_e_cpu_count': 'int',
            'enabled_e_cpu_count': 'int',
            'vm_file_system_storage': 'ExadbVmClusterStorageDetails',
            'node_count': 'int',
            'license_model': 'str',
            'ssh_public_keys': 'list[str]',
            'nsg_ids': 'list[str]',
            'backup_network_nsg_ids': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))',
            'data_collection_options': 'DataCollectionOptions',
            'system_version': 'str',
            'grid_image_id': 'str',
            'update_action': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'total_e_cpu_count': 'totalECpuCount',
            'enabled_e_cpu_count': 'enabledECpuCount',
            'vm_file_system_storage': 'vmFileSystemStorage',
            'node_count': 'nodeCount',
            'license_model': 'licenseModel',
            'ssh_public_keys': 'sshPublicKeys',
            'nsg_ids': 'nsgIds',
            'backup_network_nsg_ids': 'backupNetworkNsgIds',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'security_attributes': 'securityAttributes',
            'data_collection_options': 'dataCollectionOptions',
            'system_version': 'systemVersion',
            'grid_image_id': 'gridImageId',
            'update_action': 'updateAction'
        }
        self._display_name = None
        self._total_e_cpu_count = None
        self._enabled_e_cpu_count = None
        self._vm_file_system_storage = None
        self._node_count = None
        self._license_model = None
        self._ssh_public_keys = None
        self._nsg_ids = None
        self._backup_network_nsg_ids = None
        self._freeform_tags = None
        self._defined_tags = None
        self._security_attributes = None
        self._data_collection_options = None
        self._system_version = None
        self._grid_image_id = None
        self._update_action = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateExadbVmClusterDetails.
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.


        :return: The display_name of this UpdateExadbVmClusterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateExadbVmClusterDetails.
        The user-friendly name for the Exadata VM cluster on Exascale Infrastructure. The name does not need to be unique.


        :param display_name: The display_name of this UpdateExadbVmClusterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def total_e_cpu_count(self):
        """
        Gets the total_e_cpu_count of this UpdateExadbVmClusterDetails.
        The number of Total ECPUs for an Exadata VM cluster on Exascale Infrastructure.


        :return: The total_e_cpu_count of this UpdateExadbVmClusterDetails.
        :rtype: int
        """
        return self._total_e_cpu_count

    @total_e_cpu_count.setter
    def total_e_cpu_count(self, total_e_cpu_count):
        """
        Sets the total_e_cpu_count of this UpdateExadbVmClusterDetails.
        The number of Total ECPUs for an Exadata VM cluster on Exascale Infrastructure.


        :param total_e_cpu_count: The total_e_cpu_count of this UpdateExadbVmClusterDetails.
        :type: int
        """
        self._total_e_cpu_count = total_e_cpu_count

    @property
    def enabled_e_cpu_count(self):
        """
        Gets the enabled_e_cpu_count of this UpdateExadbVmClusterDetails.
        The number of ECPUs to enable for an Exadata VM cluster on Exascale Infrastructure.


        :return: The enabled_e_cpu_count of this UpdateExadbVmClusterDetails.
        :rtype: int
        """
        return self._enabled_e_cpu_count

    @enabled_e_cpu_count.setter
    def enabled_e_cpu_count(self, enabled_e_cpu_count):
        """
        Sets the enabled_e_cpu_count of this UpdateExadbVmClusterDetails.
        The number of ECPUs to enable for an Exadata VM cluster on Exascale Infrastructure.


        :param enabled_e_cpu_count: The enabled_e_cpu_count of this UpdateExadbVmClusterDetails.
        :type: int
        """
        self._enabled_e_cpu_count = enabled_e_cpu_count

    @property
    def vm_file_system_storage(self):
        """
        Gets the vm_file_system_storage of this UpdateExadbVmClusterDetails.

        :return: The vm_file_system_storage of this UpdateExadbVmClusterDetails.
        :rtype: oci.database.models.ExadbVmClusterStorageDetails
        """
        return self._vm_file_system_storage

    @vm_file_system_storage.setter
    def vm_file_system_storage(self, vm_file_system_storage):
        """
        Sets the vm_file_system_storage of this UpdateExadbVmClusterDetails.

        :param vm_file_system_storage: The vm_file_system_storage of this UpdateExadbVmClusterDetails.
        :type: oci.database.models.ExadbVmClusterStorageDetails
        """
        self._vm_file_system_storage = vm_file_system_storage

    @property
    def node_count(self):
        """
        Gets the node_count of this UpdateExadbVmClusterDetails.
        The number of nodes to be added in the Exadata VM cluster on Exascale Infrastructure.


        :return: The node_count of this UpdateExadbVmClusterDetails.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this UpdateExadbVmClusterDetails.
        The number of nodes to be added in the Exadata VM cluster on Exascale Infrastructure.


        :param node_count: The node_count of this UpdateExadbVmClusterDetails.
        :type: int
        """
        self._node_count = node_count

    @property
    def license_model(self):
        """
        Gets the license_model of this UpdateExadbVmClusterDetails.
        The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The default is BRING_YOUR_OWN_LICENSE.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this UpdateExadbVmClusterDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this UpdateExadbVmClusterDetails.
        The Oracle license model that applies to the Exadata VM cluster on Exascale Infrastructure. The default is BRING_YOUR_OWN_LICENSE.


        :param license_model: The license_model of this UpdateExadbVmClusterDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def ssh_public_keys(self):
        """
        Gets the ssh_public_keys of this UpdateExadbVmClusterDetails.
        The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster on Exascale Infrastructure.


        :return: The ssh_public_keys of this UpdateExadbVmClusterDetails.
        :rtype: list[str]
        """
        return self._ssh_public_keys

    @ssh_public_keys.setter
    def ssh_public_keys(self, ssh_public_keys):
        """
        Sets the ssh_public_keys of this UpdateExadbVmClusterDetails.
        The public key portion of one or more key pairs used for SSH access to the Exadata VM cluster on Exascale Infrastructure.


        :param ssh_public_keys: The ssh_public_keys of this UpdateExadbVmClusterDetails.
        :type: list[str]
        """
        self._ssh_public_keys = ssh_public_keys

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateExadbVmClusterDetails.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this UpdateExadbVmClusterDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateExadbVmClusterDetails.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this UpdateExadbVmClusterDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def backup_network_nsg_ids(self):
        """
        Gets the backup_network_nsg_ids of this UpdateExadbVmClusterDetails.
        A list of the `OCIDs`__ of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see `Security Rules`__. Applicable only to Exadata systems.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The backup_network_nsg_ids of this UpdateExadbVmClusterDetails.
        :rtype: list[str]
        """
        return self._backup_network_nsg_ids

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, backup_network_nsg_ids):
        """
        Sets the backup_network_nsg_ids of this UpdateExadbVmClusterDetails.
        A list of the `OCIDs`__ of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see `Security Rules`__. Applicable only to Exadata systems.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param backup_network_nsg_ids: The backup_network_nsg_ids of this UpdateExadbVmClusterDetails.
        :type: list[str]
        """
        self._backup_network_nsg_ids = backup_network_nsg_ids

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateExadbVmClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateExadbVmClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateExadbVmClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateExadbVmClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateExadbVmClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateExadbVmClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateExadbVmClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateExadbVmClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this UpdateExadbVmClusterDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this UpdateExadbVmClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this UpdateExadbVmClusterDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this UpdateExadbVmClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def data_collection_options(self):
        """
        Gets the data_collection_options of this UpdateExadbVmClusterDetails.

        :return: The data_collection_options of this UpdateExadbVmClusterDetails.
        :rtype: oci.database.models.DataCollectionOptions
        """
        return self._data_collection_options

    @data_collection_options.setter
    def data_collection_options(self, data_collection_options):
        """
        Sets the data_collection_options of this UpdateExadbVmClusterDetails.

        :param data_collection_options: The data_collection_options of this UpdateExadbVmClusterDetails.
        :type: oci.database.models.DataCollectionOptions
        """
        self._data_collection_options = data_collection_options

    @property
    def system_version(self):
        """
        Gets the system_version of this UpdateExadbVmClusterDetails.
        Operating system version of the image.


        :return: The system_version of this UpdateExadbVmClusterDetails.
        :rtype: str
        """
        return self._system_version

    @system_version.setter
    def system_version(self, system_version):
        """
        Sets the system_version of this UpdateExadbVmClusterDetails.
        Operating system version of the image.


        :param system_version: The system_version of this UpdateExadbVmClusterDetails.
        :type: str
        """
        self._system_version = system_version

    @property
    def grid_image_id(self):
        """
        Gets the grid_image_id of this UpdateExadbVmClusterDetails.
        Grid Setup will be done using this grid image id.

        The grid image ID can be obtained using the API /20160918/giVersions/{majorVersion}/minorVersions?compartmentId=<compartmentId>&shapeFamily=EXADB_XS&availabilityDomain=<AD name>.
        The list of supported major versions can be obtained using the API /20160918/giVersions?compartmentId=<compartmentId>&shape=ExaDbXS&availabilityDomain=<AD name>


        :return: The grid_image_id of this UpdateExadbVmClusterDetails.
        :rtype: str
        """
        return self._grid_image_id

    @grid_image_id.setter
    def grid_image_id(self, grid_image_id):
        """
        Sets the grid_image_id of this UpdateExadbVmClusterDetails.
        Grid Setup will be done using this grid image id.

        The grid image ID can be obtained using the API /20160918/giVersions/{majorVersion}/minorVersions?compartmentId=<compartmentId>&shapeFamily=EXADB_XS&availabilityDomain=<AD name>.
        The list of supported major versions can be obtained using the API /20160918/giVersions?compartmentId=<compartmentId>&shape=ExaDbXS&availabilityDomain=<AD name>


        :param grid_image_id: The grid_image_id of this UpdateExadbVmClusterDetails.
        :type: str
        """
        self._grid_image_id = grid_image_id

    @property
    def update_action(self):
        """
        Gets the update_action of this UpdateExadbVmClusterDetails.
        The update action.

        Allowed values for this property are: "ROLLING_APPLY", "NON_ROLLING_APPLY", "PRECHECK", "ROLLBACK"


        :return: The update_action of this UpdateExadbVmClusterDetails.
        :rtype: str
        """
        return self._update_action

    @update_action.setter
    def update_action(self, update_action):
        """
        Sets the update_action of this UpdateExadbVmClusterDetails.
        The update action.


        :param update_action: The update_action of this UpdateExadbVmClusterDetails.
        :type: str
        """
        allowed_values = ["ROLLING_APPLY", "NON_ROLLING_APPLY", "PRECHECK", "ROLLBACK"]
        if not value_allowed_none_or_none_sentinel(update_action, allowed_values):
            raise ValueError(
                f"Invalid value for `update_action`, must be None or one of {allowed_values}"
            )
        self._update_action = update_action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
