# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCloudDbSystemDetails(object):
    """
    The details required to create a cloud DB system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCloudDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateCloudDbSystemDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCloudDbSystemDetails.
        :type compartment_id: str

        :param db_system_discovery_id:
            The value to assign to the db_system_discovery_id property of this CreateCloudDbSystemDetails.
        :type db_system_discovery_id: str

        :param database_management_config:
            The value to assign to the database_management_config property of this CreateCloudDbSystemDetails.
        :type database_management_config: oci.database_management.models.CloudDbSystemDatabaseManagementConfigDetails

        :param stack_monitoring_config:
            The value to assign to the stack_monitoring_config property of this CreateCloudDbSystemDetails.
        :type stack_monitoring_config: oci.database_management.models.CloudDbSystemStackMonitoringConfigDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCloudDbSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCloudDbSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'db_system_discovery_id': 'str',
            'database_management_config': 'CloudDbSystemDatabaseManagementConfigDetails',
            'stack_monitoring_config': 'CloudDbSystemStackMonitoringConfigDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'db_system_discovery_id': 'dbSystemDiscoveryId',
            'database_management_config': 'databaseManagementConfig',
            'stack_monitoring_config': 'stackMonitoringConfig',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._db_system_discovery_id = None
        self._database_management_config = None
        self._stack_monitoring_config = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCloudDbSystemDetails.
        The user-friendly name for the DB system. The name does not have to be unique.


        :return: The display_name of this CreateCloudDbSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCloudDbSystemDetails.
        The user-friendly name for the DB system. The name does not have to be unique.


        :param display_name: The display_name of this CreateCloudDbSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCloudDbSystemDetails.
        The `OCID`__ of the compartment in which the cloud DB system resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateCloudDbSystemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCloudDbSystemDetails.
        The `OCID`__ of the compartment in which the cloud DB system resides.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateCloudDbSystemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_system_discovery_id(self):
        """
        **[Required]** Gets the db_system_discovery_id of this CreateCloudDbSystemDetails.
        The `OCID`__ of the DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_system_discovery_id of this CreateCloudDbSystemDetails.
        :rtype: str
        """
        return self._db_system_discovery_id

    @db_system_discovery_id.setter
    def db_system_discovery_id(self, db_system_discovery_id):
        """
        Sets the db_system_discovery_id of this CreateCloudDbSystemDetails.
        The `OCID`__ of the DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_system_discovery_id: The db_system_discovery_id of this CreateCloudDbSystemDetails.
        :type: str
        """
        self._db_system_discovery_id = db_system_discovery_id

    @property
    def database_management_config(self):
        """
        Gets the database_management_config of this CreateCloudDbSystemDetails.

        :return: The database_management_config of this CreateCloudDbSystemDetails.
        :rtype: oci.database_management.models.CloudDbSystemDatabaseManagementConfigDetails
        """
        return self._database_management_config

    @database_management_config.setter
    def database_management_config(self, database_management_config):
        """
        Sets the database_management_config of this CreateCloudDbSystemDetails.

        :param database_management_config: The database_management_config of this CreateCloudDbSystemDetails.
        :type: oci.database_management.models.CloudDbSystemDatabaseManagementConfigDetails
        """
        self._database_management_config = database_management_config

    @property
    def stack_monitoring_config(self):
        """
        Gets the stack_monitoring_config of this CreateCloudDbSystemDetails.

        :return: The stack_monitoring_config of this CreateCloudDbSystemDetails.
        :rtype: oci.database_management.models.CloudDbSystemStackMonitoringConfigDetails
        """
        return self._stack_monitoring_config

    @stack_monitoring_config.setter
    def stack_monitoring_config(self, stack_monitoring_config):
        """
        Sets the stack_monitoring_config of this CreateCloudDbSystemDetails.

        :param stack_monitoring_config: The stack_monitoring_config of this CreateCloudDbSystemDetails.
        :type: oci.database_management.models.CloudDbSystemStackMonitoringConfigDetails
        """
        self._stack_monitoring_config = stack_monitoring_config

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCloudDbSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateCloudDbSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCloudDbSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateCloudDbSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCloudDbSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateCloudDbSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCloudDbSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateCloudDbSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
