# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlChannelApplyError(object):
    """
    MySQL server replication channel name and error from its apply operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlChannelApplyError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param channel_name:
            The value to assign to the channel_name property of this MySqlChannelApplyError.
        :type channel_name: str

        :param apply_error:
            The value to assign to the apply_error property of this MySqlChannelApplyError.
        :type apply_error: oci.database_management.models.MySqlApplyError

        """
        self.swagger_types = {
            'channel_name': 'str',
            'apply_error': 'MySqlApplyError'
        }
        self.attribute_map = {
            'channel_name': 'channelName',
            'apply_error': 'applyError'
        }
        self._channel_name = None
        self._apply_error = None

    @property
    def channel_name(self):
        """
        Gets the channel_name of this MySqlChannelApplyError.
        The name of the replication channel.


        :return: The channel_name of this MySqlChannelApplyError.
        :rtype: str
        """
        return self._channel_name

    @channel_name.setter
    def channel_name(self, channel_name):
        """
        Sets the channel_name of this MySqlChannelApplyError.
        The name of the replication channel.


        :param channel_name: The channel_name of this MySqlChannelApplyError.
        :type: str
        """
        self._channel_name = channel_name

    @property
    def apply_error(self):
        """
        **[Required]** Gets the apply_error of this MySqlChannelApplyError.

        :return: The apply_error of this MySqlChannelApplyError.
        :rtype: oci.database_management.models.MySqlApplyError
        """
        return self._apply_error

    @apply_error.setter
    def apply_error(self, apply_error):
        """
        Sets the apply_error of this MySqlChannelApplyError.

        :param apply_error: The apply_error of this MySqlChannelApplyError.
        :type: oci.database_management.models.MySqlApplyError
        """
        self._apply_error = apply_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
