# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DblmVulnerability(object):
    """
    A Dblm Vulnerability is a description of a Dblm Vulnerability.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DblmVulnerability.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new DblmVulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this DblmVulnerability.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this DblmVulnerability.
        :type resources: list[oci.dblm.models.ResourceInfo]

        :param message:
            The value to assign to the message property of this DblmVulnerability.
        :type message: str

        :param time_enabled:
            The value to assign to the time_enabled property of this DblmVulnerability.
        :type time_enabled: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DblmVulnerability.
            Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param resources_summary:
            The value to assign to the resources_summary property of this DblmVulnerability.
        :type resources_summary: object

        :param vulnerabilities_summary:
            The value to assign to the vulnerabilities_summary property of this DblmVulnerability.
        :type vulnerabilities_summary: object

        :param patch_recommendations_summary:
            The value to assign to the patch_recommendations_summary property of this DblmVulnerability.
        :type patch_recommendations_summary: object

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DblmVulnerability.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this DblmVulnerability.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'resources': 'list[ResourceInfo]',
            'message': 'str',
            'time_enabled': 'datetime',
            'lifecycle_state': 'str',
            'resources_summary': 'object',
            'vulnerabilities_summary': 'object',
            'patch_recommendations_summary': 'object',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'message': 'message',
            'time_enabled': 'timeEnabled',
            'lifecycle_state': 'lifecycleState',
            'resources_summary': 'resourcesSummary',
            'vulnerabilities_summary': 'vulnerabilitiesSummary',
            'patch_recommendations_summary': 'patchRecommendationsSummary',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._compartment_id = None
        self._resources = None
        self._message = None
        self._time_enabled = None
        self._lifecycle_state = None
        self._resources_summary = None
        self._vulnerabilities_summary = None
        self._patch_recommendations_summary = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DblmVulnerability.
        Compartment Identifier.


        :return: The compartment_id of this DblmVulnerability.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DblmVulnerability.
        Compartment Identifier.


        :param compartment_id: The compartment_id of this DblmVulnerability.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        Gets the resources of this DblmVulnerability.
        Resources objects.


        :return: The resources of this DblmVulnerability.
        :rtype: list[oci.dblm.models.ResourceInfo]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this DblmVulnerability.
        Resources objects.


        :param resources: The resources of this DblmVulnerability.
        :type: list[oci.dblm.models.ResourceInfo]
        """
        self._resources = resources

    @property
    def message(self):
        """
        Gets the message of this DblmVulnerability.
        A message describing the status of the feature's state.


        :return: The message of this DblmVulnerability.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this DblmVulnerability.
        A message describing the status of the feature's state.


        :param message: The message of this DblmVulnerability.
        :type: str
        """
        self._message = message

    @property
    def time_enabled(self):
        """
        Gets the time_enabled of this DblmVulnerability.
        The time the the Vulnerability was enabled. An RFC3339 formatted datetime string.


        :return: The time_enabled of this DblmVulnerability.
        :rtype: datetime
        """
        return self._time_enabled

    @time_enabled.setter
    def time_enabled(self, time_enabled):
        """
        Sets the time_enabled of this DblmVulnerability.
        The time the the Vulnerability was enabled. An RFC3339 formatted datetime string.


        :param time_enabled: The time_enabled of this DblmVulnerability.
        :type: datetime
        """
        self._time_enabled = time_enabled

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DblmVulnerability.
        The current state of the feature.

        Allowed values for this property are: "CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DblmVulnerability.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DblmVulnerability.
        The current state of the feature.


        :param lifecycle_state: The lifecycle_state of this DblmVulnerability.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def resources_summary(self):
        """
        Gets the resources_summary of this DblmVulnerability.
        Summary of dblm registered and unregistered resources.


        :return: The resources_summary of this DblmVulnerability.
        :rtype: object
        """
        return self._resources_summary

    @resources_summary.setter
    def resources_summary(self, resources_summary):
        """
        Sets the resources_summary of this DblmVulnerability.
        Summary of dblm registered and unregistered resources.


        :param resources_summary: The resources_summary of this DblmVulnerability.
        :type: object
        """
        self._resources_summary = resources_summary

    @property
    def vulnerabilities_summary(self):
        """
        Gets the vulnerabilities_summary of this DblmVulnerability.
        Summary of vulnerabilities found in registered resources grouped by severity.


        :return: The vulnerabilities_summary of this DblmVulnerability.
        :rtype: object
        """
        return self._vulnerabilities_summary

    @vulnerabilities_summary.setter
    def vulnerabilities_summary(self, vulnerabilities_summary):
        """
        Sets the vulnerabilities_summary of this DblmVulnerability.
        Summary of vulnerabilities found in registered resources grouped by severity.


        :param vulnerabilities_summary: The vulnerabilities_summary of this DblmVulnerability.
        :type: object
        """
        self._vulnerabilities_summary = vulnerabilities_summary

    @property
    def patch_recommendations_summary(self):
        """
        Gets the patch_recommendations_summary of this DblmVulnerability.
        Summary of the patch recommendations for databases.


        :return: The patch_recommendations_summary of this DblmVulnerability.
        :rtype: object
        """
        return self._patch_recommendations_summary

    @patch_recommendations_summary.setter
    def patch_recommendations_summary(self, patch_recommendations_summary):
        """
        Sets the patch_recommendations_summary of this DblmVulnerability.
        Summary of the patch recommendations for databases.


        :param patch_recommendations_summary: The patch_recommendations_summary of this DblmVulnerability.
        :type: object
        """
        self._patch_recommendations_summary = patch_recommendations_summary

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DblmVulnerability.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DblmVulnerability.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DblmVulnerability.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DblmVulnerability.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DblmVulnerability.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DblmVulnerability.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DblmVulnerability.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DblmVulnerability.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
