# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestAuthorSummary(object):
    """
    Object containing summary of PR author.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestAuthorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param principal_details:
            The value to assign to the principal_details property of this PullRequestAuthorSummary.
        :type principal_details: oci.devops.models.PrincipalDetails

        """
        self.swagger_types = {
            'principal_details': 'PrincipalDetails'
        }
        self.attribute_map = {
            'principal_details': 'principalDetails'
        }
        self._principal_details = None

    @property
    def principal_details(self):
        """
        **[Required]** Gets the principal_details of this PullRequestAuthorSummary.

        :return: The principal_details of this PullRequestAuthorSummary.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._principal_details

    @principal_details.setter
    def principal_details(self, principal_details):
        """
        Sets the principal_details of this PullRequestAuthorSummary.

        :param principal_details: The principal_details of this PullRequestAuthorSummary.
        :type: oci.devops.models.PrincipalDetails
        """
        self._principal_details = principal_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
