# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePullRequestDetails(object):
    """
    The information to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePullRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdatePullRequestDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdatePullRequestDetails.
        :type description: str

        :param destination_branch:
            The value to assign to the destination_branch property of this UpdatePullRequestDetails.
        :type destination_branch: str

        :param reviewers:
            The value to assign to the reviewers property of this UpdatePullRequestDetails.
        :type reviewers: list[oci.devops.models.UpdateReviewerDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdatePullRequestDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdatePullRequestDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'destination_branch': 'str',
            'reviewers': 'list[UpdateReviewerDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'destination_branch': 'destinationBranch',
            'reviewers': 'reviewers',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._destination_branch = None
        self._reviewers = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdatePullRequestDetails.
        Pull Request title


        :return: The display_name of this UpdatePullRequestDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdatePullRequestDetails.
        Pull Request title


        :param display_name: The display_name of this UpdatePullRequestDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdatePullRequestDetails.
        Details of the pull request. Avoid entering confidential information.


        :return: The description of this UpdatePullRequestDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdatePullRequestDetails.
        Details of the pull request. Avoid entering confidential information.


        :param description: The description of this UpdatePullRequestDetails.
        :type: str
        """
        self._description = description

    @property
    def destination_branch(self):
        """
        Gets the destination_branch of this UpdatePullRequestDetails.
        The destination branch against which the changes are to be reviewed. Example: \"main\"


        :return: The destination_branch of this UpdatePullRequestDetails.
        :rtype: str
        """
        return self._destination_branch

    @destination_branch.setter
    def destination_branch(self, destination_branch):
        """
        Sets the destination_branch of this UpdatePullRequestDetails.
        The destination branch against which the changes are to be reviewed. Example: \"main\"


        :param destination_branch: The destination_branch of this UpdatePullRequestDetails.
        :type: str
        """
        self._destination_branch = destination_branch

    @property
    def reviewers(self):
        """
        Gets the reviewers of this UpdatePullRequestDetails.
        Reviewers for this Review.


        :return: The reviewers of this UpdatePullRequestDetails.
        :rtype: list[oci.devops.models.UpdateReviewerDetails]
        """
        return self._reviewers

    @reviewers.setter
    def reviewers(self, reviewers):
        """
        Sets the reviewers of this UpdatePullRequestDetails.
        Reviewers for this Review.


        :param reviewers: The reviewers of this UpdatePullRequestDetails.
        :type: list[oci.devops.models.UpdateReviewerDetails]
        """
        self._reviewers = reviewers

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdatePullRequestDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdatePullRequestDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdatePullRequestDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdatePullRequestDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdatePullRequestDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdatePullRequestDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdatePullRequestDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdatePullRequestDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
