# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .update_dr_protection_group_member_details import UpdateDrProtectionGroupMemberDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDrProtectionGroupMemberVolumeGroupDetails(UpdateDrProtectionGroupMemberDetails):
    """
    Update properties for a volume group member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDrProtectionGroupMemberVolumeGroupDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.disaster_recovery.models.UpdateDrProtectionGroupMemberVolumeGroupDetails.member_type` attribute
        of this class is ``VOLUME_GROUP`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_id:
            The value to assign to the member_id property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type member_id: str

        :param member_type:
            The value to assign to the member_type property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
            Allowed values for this property are: "COMPUTE_INSTANCE", "COMPUTE_INSTANCE_MOVABLE", "COMPUTE_INSTANCE_NON_MOVABLE", "VOLUME_GROUP", "DATABASE", "AUTONOMOUS_DATABASE", "AUTONOMOUS_CONTAINER_DATABASE", "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", "FILE_SYSTEM", "OKE_CLUSTER", "OBJECT_STORAGE_BUCKET", "MYSQL_DB_SYSTEM"
        :type member_type: str

        :param destination_backup_policy_id:
            The value to assign to the destination_backup_policy_id property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type destination_backup_policy_id: str

        :param source_volume_to_destination_encryption_key_mappings:
            The value to assign to the source_volume_to_destination_encryption_key_mappings property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type source_volume_to_destination_encryption_key_mappings: list[oci.disaster_recovery.models.UpdateSourceVolumeToDestinationEncryptionKeyMappingDetails]

        :param common_destination_key:
            The value to assign to the common_destination_key property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type common_destination_key: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails

        :param destination_compartment_id:
            The value to assign to the destination_compartment_id property of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type destination_compartment_id: str

        """
        self.swagger_types = {
            'member_id': 'str',
            'member_type': 'str',
            'destination_backup_policy_id': 'str',
            'source_volume_to_destination_encryption_key_mappings': 'list[UpdateSourceVolumeToDestinationEncryptionKeyMappingDetails]',
            'common_destination_key': 'UpdateVaultAndEncryptionKeyDetails',
            'destination_compartment_id': 'str'
        }
        self.attribute_map = {
            'member_id': 'memberId',
            'member_type': 'memberType',
            'destination_backup_policy_id': 'destinationBackupPolicyId',
            'source_volume_to_destination_encryption_key_mappings': 'sourceVolumeToDestinationEncryptionKeyMappings',
            'common_destination_key': 'commonDestinationKey',
            'destination_compartment_id': 'destinationCompartmentId'
        }
        self._member_id = None
        self._member_type = None
        self._destination_backup_policy_id = None
        self._source_volume_to_destination_encryption_key_mappings = None
        self._common_destination_key = None
        self._destination_compartment_id = None
        self._member_type = 'VOLUME_GROUP'

    @property
    def destination_backup_policy_id(self):
        """
        Gets the destination_backup_policy_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        The OCID of the backup policy to use in the destination region. This policy will be used to create backups for this volume group after it moves the destination region.

        Example: `ocid1.volumebackuppolicy.oc1..uniqueID`


        :return: The destination_backup_policy_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :rtype: str
        """
        return self._destination_backup_policy_id

    @destination_backup_policy_id.setter
    def destination_backup_policy_id(self, destination_backup_policy_id):
        """
        Sets the destination_backup_policy_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        The OCID of the backup policy to use in the destination region. This policy will be used to create backups for this volume group after it moves the destination region.

        Example: `ocid1.volumebackuppolicy.oc1..uniqueID`


        :param destination_backup_policy_id: The destination_backup_policy_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type: str
        """
        self._destination_backup_policy_id = destination_backup_policy_id

    @property
    def source_volume_to_destination_encryption_key_mappings(self):
        """
        Gets the source_volume_to_destination_encryption_key_mappings of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        A list of mappings between source volume IDs in the volume group and customer-managed encryption keys in the
        destination region which will be used to encrypt the volume after it moves to the destination region.

        If you add the entry for source volumes and its corresponding vault and encryption keys here, you can not use
        'commonDestinationKey' for encrypting all volumes with common encryption key. Similarly, if you specify common
        vault and encryption key using 'commonDestinationKey', you cannot specify vaults and encryption keys individually
        for each volume using 'sourceVolumeToDestinationEncryptionKeyMappings'.

        An entry for each volume in volume group should be added in this list. The encryption key will not be updated
        for the volumes that are part of volume group but missing in this list.


        :return: The source_volume_to_destination_encryption_key_mappings of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :rtype: list[oci.disaster_recovery.models.UpdateSourceVolumeToDestinationEncryptionKeyMappingDetails]
        """
        return self._source_volume_to_destination_encryption_key_mappings

    @source_volume_to_destination_encryption_key_mappings.setter
    def source_volume_to_destination_encryption_key_mappings(self, source_volume_to_destination_encryption_key_mappings):
        """
        Sets the source_volume_to_destination_encryption_key_mappings of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        A list of mappings between source volume IDs in the volume group and customer-managed encryption keys in the
        destination region which will be used to encrypt the volume after it moves to the destination region.

        If you add the entry for source volumes and its corresponding vault and encryption keys here, you can not use
        'commonDestinationKey' for encrypting all volumes with common encryption key. Similarly, if you specify common
        vault and encryption key using 'commonDestinationKey', you cannot specify vaults and encryption keys individually
        for each volume using 'sourceVolumeToDestinationEncryptionKeyMappings'.

        An entry for each volume in volume group should be added in this list. The encryption key will not be updated
        for the volumes that are part of volume group but missing in this list.


        :param source_volume_to_destination_encryption_key_mappings: The source_volume_to_destination_encryption_key_mappings of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type: list[oci.disaster_recovery.models.UpdateSourceVolumeToDestinationEncryptionKeyMappingDetails]
        """
        self._source_volume_to_destination_encryption_key_mappings = source_volume_to_destination_encryption_key_mappings

    @property
    def common_destination_key(self):
        """
        Gets the common_destination_key of this UpdateDrProtectionGroupMemberVolumeGroupDetails.

        :return: The common_destination_key of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :rtype: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails
        """
        return self._common_destination_key

    @common_destination_key.setter
    def common_destination_key(self, common_destination_key):
        """
        Sets the common_destination_key of this UpdateDrProtectionGroupMemberVolumeGroupDetails.

        :param common_destination_key: The common_destination_key of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type: oci.disaster_recovery.models.UpdateVaultAndEncryptionKeyDetails
        """
        self._common_destination_key = common_destination_key

    @property
    def destination_compartment_id(self):
        """
        Gets the destination_compartment_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        The OCID of a compartment in the destination region in which the volume group should be launched.

        Example: `ocid1.compartment.oc1..uniqueID`


        :return: The destination_compartment_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :rtype: str
        """
        return self._destination_compartment_id

    @destination_compartment_id.setter
    def destination_compartment_id(self, destination_compartment_id):
        """
        Sets the destination_compartment_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        The OCID of a compartment in the destination region in which the volume group should be launched.

        Example: `ocid1.compartment.oc1..uniqueID`


        :param destination_compartment_id: The destination_compartment_id of this UpdateDrProtectionGroupMemberVolumeGroupDetails.
        :type: str
        """
        self._destination_compartment_id = destination_compartment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
