# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint(object):
    """
    The details of distributed autonomous database associated with the private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :type id: str

        :param db_deployment_type:
            The value to assign to the db_deployment_type property of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :type db_deployment_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'db_deployment_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'db_deployment_type': 'dbDeploymentType'
        }
        self._id = None
        self._db_deployment_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        The `OCID`__ of the distributed database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        The `OCID`__ of the distributed database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :type: str
        """
        self._id = id

    @property
    def db_deployment_type(self):
        """
        **[Required]** Gets the db_deployment_type of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        The dbDeploymentType associated with the distributed autonomous database.


        :return: The db_deployment_type of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :rtype: str
        """
        return self._db_deployment_type

    @db_deployment_type.setter
    def db_deployment_type(self, db_deployment_type):
        """
        Sets the db_deployment_type of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        The dbDeploymentType associated with the distributed autonomous database.


        :param db_deployment_type: The db_deployment_type of this DistributedAutonomousDatabaseAssociatedWithPrivateEndpoint.
        :type: str
        """
        self._db_deployment_type = db_deployment_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
