# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedAutonomousDatabaseSummary(object):
    """
    Globally distributed autonomous database.
    """

    #: A constant which can be used with the db_deployment_type property of a DistributedAutonomousDatabaseSummary.
    #: This constant has a value of "ADB_D"
    DB_DEPLOYMENT_TYPE_ADB_D = "ADB_D"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedAutonomousDatabaseSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DistributedAutonomousDatabaseSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DistributedAutonomousDatabaseSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DistributedAutonomousDatabaseSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this DistributedAutonomousDatabaseSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DistributedAutonomousDatabaseSummary.
        :type time_updated: datetime

        :param database_version:
            The value to assign to the database_version property of this DistributedAutonomousDatabaseSummary.
        :type database_version: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DistributedAutonomousDatabaseSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DistributedAutonomousDatabaseSummary.
        :type lifecycle_details: str

        :param connection_strings:
            The value to assign to the connection_strings property of this DistributedAutonomousDatabaseSummary.
        :type connection_strings: oci.distributed_database.models.DistributedAutonomousDatabaseConnectionString

        :param prefix:
            The value to assign to the prefix property of this DistributedAutonomousDatabaseSummary.
        :type prefix: str

        :param private_endpoint_ids:
            The value to assign to the private_endpoint_ids property of this DistributedAutonomousDatabaseSummary.
        :type private_endpoint_ids: list[str]

        :param sharding_method:
            The value to assign to the sharding_method property of this DistributedAutonomousDatabaseSummary.
        :type sharding_method: str

        :param db_workload:
            The value to assign to the db_workload property of this DistributedAutonomousDatabaseSummary.
        :type db_workload: str

        :param character_set:
            The value to assign to the character_set property of this DistributedAutonomousDatabaseSummary.
        :type character_set: str

        :param ncharacter_set:
            The value to assign to the ncharacter_set property of this DistributedAutonomousDatabaseSummary.
        :type ncharacter_set: str

        :param chunks:
            The value to assign to the chunks property of this DistributedAutonomousDatabaseSummary.
        :type chunks: int

        :param listener_port:
            The value to assign to the listener_port property of this DistributedAutonomousDatabaseSummary.
        :type listener_port: int

        :param listener_port_tls:
            The value to assign to the listener_port_tls property of this DistributedAutonomousDatabaseSummary.
        :type listener_port_tls: int

        :param ons_port_local:
            The value to assign to the ons_port_local property of this DistributedAutonomousDatabaseSummary.
        :type ons_port_local: int

        :param ons_port_remote:
            The value to assign to the ons_port_remote property of this DistributedAutonomousDatabaseSummary.
        :type ons_port_remote: int

        :param replication_method:
            The value to assign to the replication_method property of this DistributedAutonomousDatabaseSummary.
        :type replication_method: str

        :param replication_factor:
            The value to assign to the replication_factor property of this DistributedAutonomousDatabaseSummary.
        :type replication_factor: int

        :param replication_unit:
            The value to assign to the replication_unit property of this DistributedAutonomousDatabaseSummary.
        :type replication_unit: int

        :param db_deployment_type:
            The value to assign to the db_deployment_type property of this DistributedAutonomousDatabaseSummary.
            Allowed values for this property are: "ADB_D", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_deployment_type: str

        :param metadata:
            The value to assign to the metadata property of this DistributedAutonomousDatabaseSummary.
        :type metadata: oci.distributed_database.models.DistributedAutonomousDbMetadata

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DistributedAutonomousDatabaseSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DistributedAutonomousDatabaseSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DistributedAutonomousDatabaseSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'database_version': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'connection_strings': 'DistributedAutonomousDatabaseConnectionString',
            'prefix': 'str',
            'private_endpoint_ids': 'list[str]',
            'sharding_method': 'str',
            'db_workload': 'str',
            'character_set': 'str',
            'ncharacter_set': 'str',
            'chunks': 'int',
            'listener_port': 'int',
            'listener_port_tls': 'int',
            'ons_port_local': 'int',
            'ons_port_remote': 'int',
            'replication_method': 'str',
            'replication_factor': 'int',
            'replication_unit': 'int',
            'db_deployment_type': 'str',
            'metadata': 'DistributedAutonomousDbMetadata',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'database_version': 'databaseVersion',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'connection_strings': 'connectionStrings',
            'prefix': 'prefix',
            'private_endpoint_ids': 'privateEndpointIds',
            'sharding_method': 'shardingMethod',
            'db_workload': 'dbWorkload',
            'character_set': 'characterSet',
            'ncharacter_set': 'ncharacterSet',
            'chunks': 'chunks',
            'listener_port': 'listenerPort',
            'listener_port_tls': 'listenerPortTls',
            'ons_port_local': 'onsPortLocal',
            'ons_port_remote': 'onsPortRemote',
            'replication_method': 'replicationMethod',
            'replication_factor': 'replicationFactor',
            'replication_unit': 'replicationUnit',
            'db_deployment_type': 'dbDeploymentType',
            'metadata': 'metadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._database_version = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._connection_strings = None
        self._prefix = None
        self._private_endpoint_ids = None
        self._sharding_method = None
        self._db_workload = None
        self._character_set = None
        self._ncharacter_set = None
        self._chunks = None
        self._listener_port = None
        self._listener_port_tls = None
        self._ons_port_local = None
        self._ons_port_remote = None
        self._replication_method = None
        self._replication_factor = None
        self._replication_unit = None
        self._db_deployment_type = None
        self._metadata = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DistributedAutonomousDatabaseSummary.
        The `OCID`__ of the Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DistributedAutonomousDatabaseSummary.
        The `OCID`__ of the Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DistributedAutonomousDatabaseSummary.
        The `OCID`__ of the Globally distributed autonomous database compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DistributedAutonomousDatabaseSummary.
        The `OCID`__ of the Globally distributed autonomous database compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DistributedAutonomousDatabaseSummary.
        The display name of the Globally distributed autonomous database.


        :return: The display_name of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DistributedAutonomousDatabaseSummary.
        The display name of the Globally distributed autonomous database.


        :param display_name: The display_name of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DistributedAutonomousDatabaseSummary.
        The time the Globally distributed autonomous database was created. An RFC3339 formatted datetime string


        :return: The time_created of this DistributedAutonomousDatabaseSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DistributedAutonomousDatabaseSummary.
        The time the Globally distributed autonomous database was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this DistributedAutonomousDatabaseSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DistributedAutonomousDatabaseSummary.
        The time the Globally distributed autonomous database was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this DistributedAutonomousDatabaseSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DistributedAutonomousDatabaseSummary.
        The time the Globally distributed autonomous database was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this DistributedAutonomousDatabaseSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def database_version(self):
        """
        **[Required]** Gets the database_version of this DistributedAutonomousDatabaseSummary.
        Oracle Database version for the shards and catalog used in Globally distributed autonomous database.


        :return: The database_version of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this DistributedAutonomousDatabaseSummary.
        Oracle Database version for the shards and catalog used in Globally distributed autonomous database.


        :param database_version: The database_version of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._database_version = database_version

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DistributedAutonomousDatabaseSummary.
        Lifecycle state of sharded database.


        :return: The lifecycle_state of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DistributedAutonomousDatabaseSummary.
        Lifecycle state of sharded database.


        :param lifecycle_state: The lifecycle_state of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this DistributedAutonomousDatabaseSummary.
        The lifecycleDetails for the Globally distributed autonomous database.


        :return: The lifecycle_details of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DistributedAutonomousDatabaseSummary.
        The lifecycleDetails for the Globally distributed autonomous database.


        :param lifecycle_details: The lifecycle_details of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def connection_strings(self):
        """
        Gets the connection_strings of this DistributedAutonomousDatabaseSummary.

        :return: The connection_strings of this DistributedAutonomousDatabaseSummary.
        :rtype: oci.distributed_database.models.DistributedAutonomousDatabaseConnectionString
        """
        return self._connection_strings

    @connection_strings.setter
    def connection_strings(self, connection_strings):
        """
        Sets the connection_strings of this DistributedAutonomousDatabaseSummary.

        :param connection_strings: The connection_strings of this DistributedAutonomousDatabaseSummary.
        :type: oci.distributed_database.models.DistributedAutonomousDatabaseConnectionString
        """
        self._connection_strings = connection_strings

    @property
    def prefix(self):
        """
        **[Required]** Gets the prefix of this DistributedAutonomousDatabaseSummary.
        Unique name prefix for the Globally distributed autonomous databases. Only alpha-numeric values are allowed. First character
        has to be a letter followed by any combination of letter and number.


        :return: The prefix of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this DistributedAutonomousDatabaseSummary.
        Unique name prefix for the Globally distributed autonomous databases. Only alpha-numeric values are allowed. First character
        has to be a letter followed by any combination of letter and number.


        :param prefix: The prefix of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._prefix = prefix

    @property
    def private_endpoint_ids(self):
        """
        **[Required]** Gets the private_endpoint_ids of this DistributedAutonomousDatabaseSummary.
        The collection of `OCID`__ of the private endpoint associated with Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The private_endpoint_ids of this DistributedAutonomousDatabaseSummary.
        :rtype: list[str]
        """
        return self._private_endpoint_ids

    @private_endpoint_ids.setter
    def private_endpoint_ids(self, private_endpoint_ids):
        """
        Sets the private_endpoint_ids of this DistributedAutonomousDatabaseSummary.
        The collection of `OCID`__ of the private endpoint associated with Globally distributed autonomous database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param private_endpoint_ids: The private_endpoint_ids of this DistributedAutonomousDatabaseSummary.
        :type: list[str]
        """
        self._private_endpoint_ids = private_endpoint_ids

    @property
    def sharding_method(self):
        """
        **[Required]** Gets the sharding_method of this DistributedAutonomousDatabaseSummary.
        Sharding Methods for the Globally distributed autonomous database.


        :return: The sharding_method of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._sharding_method

    @sharding_method.setter
    def sharding_method(self, sharding_method):
        """
        Sets the sharding_method of this DistributedAutonomousDatabaseSummary.
        Sharding Methods for the Globally distributed autonomous database.


        :param sharding_method: The sharding_method of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._sharding_method = sharding_method

    @property
    def db_workload(self):
        """
        **[Required]** Gets the db_workload of this DistributedAutonomousDatabaseSummary.
        The workload type for the database.


        :return: The db_workload of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this DistributedAutonomousDatabaseSummary.
        The workload type for the database.


        :param db_workload: The db_workload of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._db_workload = db_workload

    @property
    def character_set(self):
        """
        **[Required]** Gets the character_set of this DistributedAutonomousDatabaseSummary.
        The character set for the database.


        :return: The character_set of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._character_set

    @character_set.setter
    def character_set(self, character_set):
        """
        Sets the character_set of this DistributedAutonomousDatabaseSummary.
        The character set for the database.


        :param character_set: The character_set of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._character_set = character_set

    @property
    def ncharacter_set(self):
        """
        **[Required]** Gets the ncharacter_set of this DistributedAutonomousDatabaseSummary.
        The national character set for the database.


        :return: The ncharacter_set of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._ncharacter_set

    @ncharacter_set.setter
    def ncharacter_set(self, ncharacter_set):
        """
        Sets the ncharacter_set of this DistributedAutonomousDatabaseSummary.
        The national character set for the database.


        :param ncharacter_set: The ncharacter_set of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._ncharacter_set = ncharacter_set

    @property
    def chunks(self):
        """
        Gets the chunks of this DistributedAutonomousDatabaseSummary.
        The default number of unique chunks in a shardspace. The value of chunks must be
        greater than 2 times the size of the largest shardgroup in any shardspace.


        :return: The chunks of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._chunks

    @chunks.setter
    def chunks(self, chunks):
        """
        Sets the chunks of this DistributedAutonomousDatabaseSummary.
        The default number of unique chunks in a shardspace. The value of chunks must be
        greater than 2 times the size of the largest shardgroup in any shardspace.


        :param chunks: The chunks of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._chunks = chunks

    @property
    def listener_port(self):
        """
        **[Required]** Gets the listener_port of this DistributedAutonomousDatabaseSummary.
        The listener port number for the Globally distributed autonomous database.


        :return: The listener_port of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """
        Sets the listener_port of this DistributedAutonomousDatabaseSummary.
        The listener port number for the Globally distributed autonomous database.


        :param listener_port: The listener_port of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._listener_port = listener_port

    @property
    def listener_port_tls(self):
        """
        Gets the listener_port_tls of this DistributedAutonomousDatabaseSummary.
        The TLS listener port number for the Globally distributed autonomous database.


        :return: The listener_port_tls of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._listener_port_tls

    @listener_port_tls.setter
    def listener_port_tls(self, listener_port_tls):
        """
        Sets the listener_port_tls of this DistributedAutonomousDatabaseSummary.
        The TLS listener port number for the Globally distributed autonomous database.


        :param listener_port_tls: The listener_port_tls of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._listener_port_tls = listener_port_tls

    @property
    def ons_port_local(self):
        """
        **[Required]** Gets the ons_port_local of this DistributedAutonomousDatabaseSummary.
        Ons local port number for the Globally distributed autonomous database.


        :return: The ons_port_local of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._ons_port_local

    @ons_port_local.setter
    def ons_port_local(self, ons_port_local):
        """
        Sets the ons_port_local of this DistributedAutonomousDatabaseSummary.
        Ons local port number for the Globally distributed autonomous database.


        :param ons_port_local: The ons_port_local of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._ons_port_local = ons_port_local

    @property
    def ons_port_remote(self):
        """
        **[Required]** Gets the ons_port_remote of this DistributedAutonomousDatabaseSummary.
        Ons remote port number for the Globally distributed autonomous database.


        :return: The ons_port_remote of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._ons_port_remote

    @ons_port_remote.setter
    def ons_port_remote(self, ons_port_remote):
        """
        Sets the ons_port_remote of this DistributedAutonomousDatabaseSummary.
        Ons remote port number for the Globally distributed autonomous database.


        :param ons_port_remote: The ons_port_remote of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._ons_port_remote = ons_port_remote

    @property
    def replication_method(self):
        """
        Gets the replication_method of this DistributedAutonomousDatabaseSummary.
        The Replication method for Globally distributed autonomous database. Use RAFT for Raft replication, and DG for
        DataGuard. If replicationMethod is not provided, it defaults to DG.


        :return: The replication_method of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._replication_method

    @replication_method.setter
    def replication_method(self, replication_method):
        """
        Sets the replication_method of this DistributedAutonomousDatabaseSummary.
        The Replication method for Globally distributed autonomous database. Use RAFT for Raft replication, and DG for
        DataGuard. If replicationMethod is not provided, it defaults to DG.


        :param replication_method: The replication_method of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        self._replication_method = replication_method

    @property
    def replication_factor(self):
        """
        Gets the replication_factor of this DistributedAutonomousDatabaseSummary.
        The Replication factor for RAFT replication based Globally distributed autonomous database. Currently supported values are 3, 5 and 7.


        :return: The replication_factor of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._replication_factor

    @replication_factor.setter
    def replication_factor(self, replication_factor):
        """
        Sets the replication_factor of this DistributedAutonomousDatabaseSummary.
        The Replication factor for RAFT replication based Globally distributed autonomous database. Currently supported values are 3, 5 and 7.


        :param replication_factor: The replication_factor of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._replication_factor = replication_factor

    @property
    def replication_unit(self):
        """
        Gets the replication_unit of this DistributedAutonomousDatabaseSummary.
        For RAFT replication based Globally distributed autonomous database, the value should be atleast twice the number of shards.


        :return: The replication_unit of this DistributedAutonomousDatabaseSummary.
        :rtype: int
        """
        return self._replication_unit

    @replication_unit.setter
    def replication_unit(self, replication_unit):
        """
        Sets the replication_unit of this DistributedAutonomousDatabaseSummary.
        For RAFT replication based Globally distributed autonomous database, the value should be atleast twice the number of shards.


        :param replication_unit: The replication_unit of this DistributedAutonomousDatabaseSummary.
        :type: int
        """
        self._replication_unit = replication_unit

    @property
    def db_deployment_type(self):
        """
        **[Required]** Gets the db_deployment_type of this DistributedAutonomousDatabaseSummary.
        The distributed autonomous database deployment type.

        Allowed values for this property are: "ADB_D", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_deployment_type of this DistributedAutonomousDatabaseSummary.
        :rtype: str
        """
        return self._db_deployment_type

    @db_deployment_type.setter
    def db_deployment_type(self, db_deployment_type):
        """
        Sets the db_deployment_type of this DistributedAutonomousDatabaseSummary.
        The distributed autonomous database deployment type.


        :param db_deployment_type: The db_deployment_type of this DistributedAutonomousDatabaseSummary.
        :type: str
        """
        allowed_values = ["ADB_D"]
        if not value_allowed_none_or_none_sentinel(db_deployment_type, allowed_values):
            db_deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._db_deployment_type = db_deployment_type

    @property
    def metadata(self):
        """
        Gets the metadata of this DistributedAutonomousDatabaseSummary.

        :return: The metadata of this DistributedAutonomousDatabaseSummary.
        :rtype: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this DistributedAutonomousDatabaseSummary.

        :param metadata: The metadata of this DistributedAutonomousDatabaseSummary.
        :type: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        self._metadata = metadata

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DistributedAutonomousDatabaseSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DistributedAutonomousDatabaseSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DistributedAutonomousDatabaseSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DistributedAutonomousDatabaseSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DistributedAutonomousDatabaseSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DistributedAutonomousDatabaseSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DistributedAutonomousDatabaseSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DistributedAutonomousDatabaseSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DistributedAutonomousDatabaseSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DistributedAutonomousDatabaseSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DistributedAutonomousDatabaseSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DistributedAutonomousDatabaseSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
