# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20171215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateQuotaRuleDetails(object):
    """
    Details for updating a quota rule in the file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateQuotaRuleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateQuotaRuleDetails.
        :type display_name: str

        :param quota_limit_in_gigabytes:
            The value to assign to the quota_limit_in_gigabytes property of this UpdateQuotaRuleDetails.
        :type quota_limit_in_gigabytes: int

        """
        self.swagger_types = {
            'display_name': 'str',
            'quota_limit_in_gigabytes': 'int'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'quota_limit_in_gigabytes': 'quotaLimitInGigabytes'
        }
        self._display_name = None
        self._quota_limit_in_gigabytes = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateQuotaRuleDetails.
        A user-friendly name that the quota rule will be renamed to. It does not have to be unique.
        Avoid entering confidential information.
        Example: `UserXYZ's quota`


        :return: The display_name of this UpdateQuotaRuleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateQuotaRuleDetails.
        A user-friendly name that the quota rule will be renamed to. It does not have to be unique.
        Avoid entering confidential information.
        Example: `UserXYZ's quota`


        :param display_name: The display_name of this UpdateQuotaRuleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def quota_limit_in_gigabytes(self):
        """
        Gets the quota_limit_in_gigabytes of this UpdateQuotaRuleDetails.
        An updated value of the quota rule in gigabytes.


        :return: The quota_limit_in_gigabytes of this UpdateQuotaRuleDetails.
        :rtype: int
        """
        return self._quota_limit_in_gigabytes

    @quota_limit_in_gigabytes.setter
    def quota_limit_in_gigabytes(self, quota_limit_in_gigabytes):
        """
        Sets the quota_limit_in_gigabytes of this UpdateQuotaRuleDetails.
        An updated value of the quota rule in gigabytes.


        :param quota_limit_in_gigabytes: The quota_limit_in_gigabytes of this UpdateQuotaRuleDetails.
        :type: int
        """
        self._quota_limit_in_gigabytes = quota_limit_in_gigabytes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
