# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogResultPayload(object):
    """
    Catalog result payload.
    """

    #: A constant which can be used with the config_result_type property of a CatalogResultPayload.
    #: This constant has a value of "PAR_RESULT_CONFIG"
    CONFIG_RESULT_TYPE_PAR_RESULT_CONFIG = "PAR_RESULT_CONFIG"

    #: A constant which can be used with the config_result_type property of a CatalogResultPayload.
    #: This constant has a value of "TEMPLATE_RESULT_CONFIG"
    CONFIG_RESULT_TYPE_TEMPLATE_RESULT_CONFIG = "TEMPLATE_RESULT_CONFIG"

    #: A constant which can be used with the config_result_type property of a CatalogResultPayload.
    #: This constant has a value of "GIT_RESULT_CONFIG"
    CONFIG_RESULT_TYPE_GIT_RESULT_CONFIG = "GIT_RESULT_CONFIG"

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogResultPayload object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.CatalogGitResultConfig`
        * :class:`~oci.fleet_apps_management.models.CatalogTemplateResultConfig`
        * :class:`~oci.fleet_apps_management.models.CatalogParResultConfig`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_result_type:
            The value to assign to the config_result_type property of this CatalogResultPayload.
            Allowed values for this property are: "PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_result_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogResultPayload.
        :type working_directory: str

        """
        self.swagger_types = {
            'config_result_type': 'str',
            'working_directory': 'str'
        }
        self.attribute_map = {
            'config_result_type': 'configResultType',
            'working_directory': 'workingDirectory'
        }
        self._config_result_type = None
        self._working_directory = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['configResultType']

        if type == 'GIT_RESULT_CONFIG':
            return 'CatalogGitResultConfig'

        if type == 'TEMPLATE_RESULT_CONFIG':
            return 'CatalogTemplateResultConfig'

        if type == 'PAR_RESULT_CONFIG':
            return 'CatalogParResultConfig'
        else:
            return 'CatalogResultPayload'

    @property
    def config_result_type(self):
        """
        **[Required]** Gets the config_result_type of this CatalogResultPayload.
        config result type.

        Allowed values for this property are: "PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The config_result_type of this CatalogResultPayload.
        :rtype: str
        """
        return self._config_result_type

    @config_result_type.setter
    def config_result_type(self, config_result_type):
        """
        Sets the config_result_type of this CatalogResultPayload.
        config result type.


        :param config_result_type: The config_result_type of this CatalogResultPayload.
        :type: str
        """
        allowed_values = ["PAR_RESULT_CONFIG", "TEMPLATE_RESULT_CONFIG", "GIT_RESULT_CONFIG"]
        if not value_allowed_none_or_none_sentinel(config_result_type, allowed_values):
            config_result_type = 'UNKNOWN_ENUM_VALUE'
        self._config_result_type = config_result_type

    @property
    def working_directory(self):
        """
        Gets the working_directory of this CatalogResultPayload.
        working directory


        :return: The working_directory of this CatalogResultPayload.
        :rtype: str
        """
        return self._working_directory

    @working_directory.setter
    def working_directory(self, working_directory):
        """
        Sets the working_directory of this CatalogResultPayload.
        working directory


        :param working_directory: The working_directory of this CatalogResultPayload.
        :type: str
        """
        self._working_directory = working_directory

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
