# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFleetResourceDetails(object):
    """
    The information about the resource to be added to the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFleetResourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this CreateFleetResourceDetails.
        :type resource_id: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this CreateFleetResourceDetails.
        :type tenancy_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFleetResourceDetails.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this CreateFleetResourceDetails.
        :type resource_region: str

        :param resource_type:
            The value to assign to the resource_type property of this CreateFleetResourceDetails.
        :type resource_type: str

        """
        self.swagger_types = {
            'resource_id': 'str',
            'tenancy_id': 'str',
            'compartment_id': 'str',
            'resource_region': 'str',
            'resource_type': 'str'
        }
        self.attribute_map = {
            'resource_id': 'resourceId',
            'tenancy_id': 'tenancyId',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'resource_type': 'resourceType'
        }
        self._resource_id = None
        self._tenancy_id = None
        self._compartment_id = None
        self._resource_region = None
        self._resource_type = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this CreateFleetResourceDetails.
        The OCID of the resource.


        :return: The resource_id of this CreateFleetResourceDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this CreateFleetResourceDetails.
        The OCID of the resource.


        :param resource_id: The resource_id of this CreateFleetResourceDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def tenancy_id(self):
        """
        **[Required]** Gets the tenancy_id of this CreateFleetResourceDetails.
        OCID of the tenancy to which the resource belongs to.


        :return: The tenancy_id of this CreateFleetResourceDetails.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this CreateFleetResourceDetails.
        OCID of the tenancy to which the resource belongs to.


        :param tenancy_id: The tenancy_id of this CreateFleetResourceDetails.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFleetResourceDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this CreateFleetResourceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFleetResourceDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this CreateFleetResourceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this CreateFleetResourceDetails.
        Associated region


        :return: The resource_region of this CreateFleetResourceDetails.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this CreateFleetResourceDetails.
        Associated region


        :param resource_region: The resource_region of this CreateFleetResourceDetails.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def resource_type(self):
        """
        Gets the resource_type of this CreateFleetResourceDetails.
        Type of the Resource.


        :return: The resource_type of this CreateFleetResourceDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this CreateFleetResourceDetails.
        Type of the Resource.


        :param resource_type: The resource_type of this CreateFleetResourceDetails.
        :type: str
        """
        self._resource_type = resource_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
