# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .config_category_details import ConfigCategoryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProductStackConfigCategoryDetails(ConfigCategoryDetails):
    """
    ProductStack Config Category Details.
    Defines suite or stack of products on which applications hosted by the resources are built and need to be managed.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ProductStackConfigCategoryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.ProductStackConfigCategoryDetails.config_category` attribute
        of this class is ``PRODUCT_STACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_category:
            The value to assign to the config_category property of this ProductStackConfigCategoryDetails.
            Allowed values for this property are: "PRODUCT", "PRODUCT_STACK", "ENVIRONMENT", "PATCH_TYPE", "CREDENTIAL", "SELF_HOSTED_INSTANCE", "LIFECYCLE_OPERATION"
        :type config_category: str

        :param products:
            The value to assign to the products property of this ProductStackConfigCategoryDetails.
        :type products: list[oci.fleet_apps_management.models.ConfigAssociationDetails]

        :param sub_category_details:
            The value to assign to the sub_category_details property of this ProductStackConfigCategoryDetails.
        :type sub_category_details: oci.fleet_apps_management.models.ProductStackSubCategoryDetails

        """
        self.swagger_types = {
            'config_category': 'str',
            'products': 'list[ConfigAssociationDetails]',
            'sub_category_details': 'ProductStackSubCategoryDetails'
        }
        self.attribute_map = {
            'config_category': 'configCategory',
            'products': 'products',
            'sub_category_details': 'subCategoryDetails'
        }
        self._config_category = None
        self._products = None
        self._sub_category_details = None
        self._config_category = 'PRODUCT_STACK'

    @property
    def products(self):
        """
        **[Required]** Gets the products of this ProductStackConfigCategoryDetails.
        Products that belong to the stack.
        For example, Oracle WebLogic and Java for the Oracle Fusion Middleware product stack.


        :return: The products of this ProductStackConfigCategoryDetails.
        :rtype: list[oci.fleet_apps_management.models.ConfigAssociationDetails]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this ProductStackConfigCategoryDetails.
        Products that belong to the stack.
        For example, Oracle WebLogic and Java for the Oracle Fusion Middleware product stack.


        :param products: The products of this ProductStackConfigCategoryDetails.
        :type: list[oci.fleet_apps_management.models.ConfigAssociationDetails]
        """
        self._products = products

    @property
    def sub_category_details(self):
        """
        Gets the sub_category_details of this ProductStackConfigCategoryDetails.

        :return: The sub_category_details of this ProductStackConfigCategoryDetails.
        :rtype: oci.fleet_apps_management.models.ProductStackSubCategoryDetails
        """
        return self._sub_category_details

    @sub_category_details.setter
    def sub_category_details(self, sub_category_details):
        """
        Sets the sub_category_details of this ProductStackConfigCategoryDetails.

        :param sub_category_details: The sub_category_details of this ProductStackConfigCategoryDetails.
        :type: oci.fleet_apps_management.models.ProductStackSubCategoryDetails
        """
        self._sub_category_details = sub_category_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
