# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFsuCycleDetails(object):
    """
    Exadata Fleet Update Cycle resource creation details.
    """

    #: A constant which can be used with the type property of a CreateFsuCycleDetails.
    #: This constant has a value of "PATCH"
    TYPE_PATCH = "PATCH"

    #: A constant which can be used with the type property of a CreateFsuCycleDetails.
    #: This constant has a value of "UPGRADE"
    TYPE_UPGRADE = "UPGRADE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFsuCycleDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.CreatePatchFsuCycle`
        * :class:`~oci.fleet_software_update.models.CreateUpgradeFsuCycle`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateFsuCycleDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFsuCycleDetails.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this CreateFsuCycleDetails.
            Allowed values for this property are: "PATCH", "UPGRADE"
        :type type: str

        :param fsu_collection_id:
            The value to assign to the fsu_collection_id property of this CreateFsuCycleDetails.
        :type fsu_collection_id: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this CreateFsuCycleDetails.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this CreateFsuCycleDetails.
        :type batching_strategy: oci.fleet_software_update.models.CreateBatchingStrategyDetails

        :param stage_action_schedule:
            The value to assign to the stage_action_schedule property of this CreateFsuCycleDetails.
        :type stage_action_schedule: oci.fleet_software_update.models.CreateScheduleDetails

        :param apply_action_schedule:
            The value to assign to the apply_action_schedule property of this CreateFsuCycleDetails.
        :type apply_action_schedule: oci.fleet_software_update.models.CreateScheduleDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this CreateFsuCycleDetails.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFsuCycleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFsuCycleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'fsu_collection_id': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'CreateBatchingStrategyDetails',
            'stage_action_schedule': 'CreateScheduleDetails',
            'apply_action_schedule': 'CreateScheduleDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'fsu_collection_id': 'fsuCollectionId',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'stage_action_schedule': 'stageActionSchedule',
            'apply_action_schedule': 'applyActionSchedule',
            'diagnostics_collection': 'diagnosticsCollection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._type = None
        self._fsu_collection_id = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._stage_action_schedule = None
        self._apply_action_schedule = None
        self._diagnostics_collection = None
        self._freeform_tags = None
        self._defined_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'PATCH':
            return 'CreatePatchFsuCycle'

        if type == 'UPGRADE':
            return 'CreateUpgradeFsuCycle'
        else:
            return 'CreateFsuCycleDetails'

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFsuCycleDetails.
        Exadata Fleet Update Cycle display name.


        :return: The display_name of this CreateFsuCycleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFsuCycleDetails.
        Exadata Fleet Update Cycle display name.


        :param display_name: The display_name of this CreateFsuCycleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFsuCycleDetails.
        Compartment Identifier.


        :return: The compartment_id of this CreateFsuCycleDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFsuCycleDetails.
        Compartment Identifier.


        :param compartment_id: The compartment_id of this CreateFsuCycleDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateFsuCycleDetails.
        Type of Exadata Fleet Update Cycle.

        Allowed values for this property are: "PATCH", "UPGRADE"


        :return: The type of this CreateFsuCycleDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateFsuCycleDetails.
        Type of Exadata Fleet Update Cycle.


        :param type: The type of this CreateFsuCycleDetails.
        :type: str
        """
        allowed_values = ["PATCH", "UPGRADE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def fsu_collection_id(self):
        """
        **[Required]** Gets the fsu_collection_id of this CreateFsuCycleDetails.
        OCID identifier for the Collection ID the Exadata Fleet Update Cycle will be assigned to.


        :return: The fsu_collection_id of this CreateFsuCycleDetails.
        :rtype: str
        """
        return self._fsu_collection_id

    @fsu_collection_id.setter
    def fsu_collection_id(self, fsu_collection_id):
        """
        Sets the fsu_collection_id of this CreateFsuCycleDetails.
        OCID identifier for the Collection ID the Exadata Fleet Update Cycle will be assigned to.


        :param fsu_collection_id: The fsu_collection_id of this CreateFsuCycleDetails.
        :type: str
        """
        self._fsu_collection_id = fsu_collection_id

    @property
    def goal_version_details(self):
        """
        **[Required]** Gets the goal_version_details of this CreateFsuCycleDetails.

        :return: The goal_version_details of this CreateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.FsuGoalVersionDetails
        """
        return self._goal_version_details

    @goal_version_details.setter
    def goal_version_details(self, goal_version_details):
        """
        Sets the goal_version_details of this CreateFsuCycleDetails.

        :param goal_version_details: The goal_version_details of this CreateFsuCycleDetails.
        :type: oci.fleet_software_update.models.FsuGoalVersionDetails
        """
        self._goal_version_details = goal_version_details

    @property
    def batching_strategy(self):
        """
        Gets the batching_strategy of this CreateFsuCycleDetails.

        :return: The batching_strategy of this CreateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.CreateBatchingStrategyDetails
        """
        return self._batching_strategy

    @batching_strategy.setter
    def batching_strategy(self, batching_strategy):
        """
        Sets the batching_strategy of this CreateFsuCycleDetails.

        :param batching_strategy: The batching_strategy of this CreateFsuCycleDetails.
        :type: oci.fleet_software_update.models.CreateBatchingStrategyDetails
        """
        self._batching_strategy = batching_strategy

    @property
    def stage_action_schedule(self):
        """
        Gets the stage_action_schedule of this CreateFsuCycleDetails.

        :return: The stage_action_schedule of this CreateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.CreateScheduleDetails
        """
        return self._stage_action_schedule

    @stage_action_schedule.setter
    def stage_action_schedule(self, stage_action_schedule):
        """
        Sets the stage_action_schedule of this CreateFsuCycleDetails.

        :param stage_action_schedule: The stage_action_schedule of this CreateFsuCycleDetails.
        :type: oci.fleet_software_update.models.CreateScheduleDetails
        """
        self._stage_action_schedule = stage_action_schedule

    @property
    def apply_action_schedule(self):
        """
        Gets the apply_action_schedule of this CreateFsuCycleDetails.

        :return: The apply_action_schedule of this CreateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.CreateScheduleDetails
        """
        return self._apply_action_schedule

    @apply_action_schedule.setter
    def apply_action_schedule(self, apply_action_schedule):
        """
        Sets the apply_action_schedule of this CreateFsuCycleDetails.

        :param apply_action_schedule: The apply_action_schedule of this CreateFsuCycleDetails.
        :type: oci.fleet_software_update.models.CreateScheduleDetails
        """
        self._apply_action_schedule = apply_action_schedule

    @property
    def diagnostics_collection(self):
        """
        Gets the diagnostics_collection of this CreateFsuCycleDetails.

        :return: The diagnostics_collection of this CreateFsuCycleDetails.
        :rtype: oci.fleet_software_update.models.DiagnosticsCollectionDetails
        """
        return self._diagnostics_collection

    @diagnostics_collection.setter
    def diagnostics_collection(self, diagnostics_collection):
        """
        Sets the diagnostics_collection of this CreateFsuCycleDetails.

        :param diagnostics_collection: The diagnostics_collection of this CreateFsuCycleDetails.
        :type: oci.fleet_software_update.models.DiagnosticsCollectionDetails
        """
        self._diagnostics_collection = diagnostics_collection

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFsuCycleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateFsuCycleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFsuCycleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateFsuCycleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFsuCycleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateFsuCycleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFsuCycleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateFsuCycleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
