# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .upgrade_details import UpgradeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpgradeDbCollectionDetails(UpgradeDetails):
    """
    Details of supported upgrade options for DB collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpgradeDbCollectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.UpgradeDbCollectionDetails.collection_type` attribute
        of this class is ``DB`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collection_type:
            The value to assign to the collection_type property of this UpgradeDbCollectionDetails.
            Allowed values for this property are: "DB", "GI"
        :type collection_type: str

        :param is_time_zone_upgrade:
            The value to assign to the is_time_zone_upgrade property of this UpgradeDbCollectionDetails.
        :type is_time_zone_upgrade: bool

        :param is_recompile_invalid_objects:
            The value to assign to the is_recompile_invalid_objects property of this UpgradeDbCollectionDetails.
        :type is_recompile_invalid_objects: bool

        :param max_drain_timeout_in_seconds:
            The value to assign to the max_drain_timeout_in_seconds property of this UpgradeDbCollectionDetails.
        :type max_drain_timeout_in_seconds: int

        """
        self.swagger_types = {
            'collection_type': 'str',
            'is_time_zone_upgrade': 'bool',
            'is_recompile_invalid_objects': 'bool',
            'max_drain_timeout_in_seconds': 'int'
        }
        self.attribute_map = {
            'collection_type': 'collectionType',
            'is_time_zone_upgrade': 'isTimeZoneUpgrade',
            'is_recompile_invalid_objects': 'isRecompileInvalidObjects',
            'max_drain_timeout_in_seconds': 'maxDrainTimeoutInSeconds'
        }
        self._collection_type = None
        self._is_time_zone_upgrade = None
        self._is_recompile_invalid_objects = None
        self._max_drain_timeout_in_seconds = None
        self._collection_type = 'DB'

    @property
    def is_time_zone_upgrade(self):
        """
        Gets the is_time_zone_upgrade of this UpgradeDbCollectionDetails.
        Enables or disables time zone upgrade.


        :return: The is_time_zone_upgrade of this UpgradeDbCollectionDetails.
        :rtype: bool
        """
        return self._is_time_zone_upgrade

    @is_time_zone_upgrade.setter
    def is_time_zone_upgrade(self, is_time_zone_upgrade):
        """
        Sets the is_time_zone_upgrade of this UpgradeDbCollectionDetails.
        Enables or disables time zone upgrade.


        :param is_time_zone_upgrade: The is_time_zone_upgrade of this UpgradeDbCollectionDetails.
        :type: bool
        """
        self._is_time_zone_upgrade = is_time_zone_upgrade

    @property
    def is_recompile_invalid_objects(self):
        """
        Gets the is_recompile_invalid_objects of this UpgradeDbCollectionDetails.
        Enables or disables the recompilation of invalid objects.


        :return: The is_recompile_invalid_objects of this UpgradeDbCollectionDetails.
        :rtype: bool
        """
        return self._is_recompile_invalid_objects

    @is_recompile_invalid_objects.setter
    def is_recompile_invalid_objects(self, is_recompile_invalid_objects):
        """
        Sets the is_recompile_invalid_objects of this UpgradeDbCollectionDetails.
        Enables or disables the recompilation of invalid objects.


        :param is_recompile_invalid_objects: The is_recompile_invalid_objects of this UpgradeDbCollectionDetails.
        :type: bool
        """
        self._is_recompile_invalid_objects = is_recompile_invalid_objects

    @property
    def max_drain_timeout_in_seconds(self):
        """
        Gets the max_drain_timeout_in_seconds of this UpgradeDbCollectionDetails.
        Service drain timeout specified in seconds.


        :return: The max_drain_timeout_in_seconds of this UpgradeDbCollectionDetails.
        :rtype: int
        """
        return self._max_drain_timeout_in_seconds

    @max_drain_timeout_in_seconds.setter
    def max_drain_timeout_in_seconds(self, max_drain_timeout_in_seconds):
        """
        Sets the max_drain_timeout_in_seconds of this UpgradeDbCollectionDetails.
        Service drain timeout specified in seconds.


        :param max_drain_timeout_in_seconds: The max_drain_timeout_in_seconds of this UpgradeDbCollectionDetails.
        :type: int
        """
        self._max_drain_timeout_in_seconds = max_drain_timeout_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
