# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpgradeDetails(object):
    """
    Details of supported upgrade options for DB or GI collection.
    """

    #: A constant which can be used with the collection_type property of a UpgradeDetails.
    #: This constant has a value of "DB"
    COLLECTION_TYPE_DB = "DB"

    #: A constant which can be used with the collection_type property of a UpgradeDetails.
    #: This constant has a value of "GI"
    COLLECTION_TYPE_GI = "GI"

    def __init__(self, **kwargs):
        """
        Initializes a new UpgradeDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_software_update.models.UpgradeDbCollectionDetails`
        * :class:`~oci.fleet_software_update.models.UpgradeGiCollectionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collection_type:
            The value to assign to the collection_type property of this UpgradeDetails.
            Allowed values for this property are: "DB", "GI", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type collection_type: str

        """
        self.swagger_types = {
            'collection_type': 'str'
        }
        self.attribute_map = {
            'collection_type': 'collectionType'
        }
        self._collection_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['collectionType']

        if type == 'DB':
            return 'UpgradeDbCollectionDetails'

        if type == 'GI':
            return 'UpgradeGiCollectionDetails'
        else:
            return 'UpgradeDetails'

    @property
    def collection_type(self):
        """
        **[Required]** Gets the collection_type of this UpgradeDetails.
        Type of Exadata Fleet Update collection being upgraded.

        Allowed values for this property are: "DB", "GI", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The collection_type of this UpgradeDetails.
        :rtype: str
        """
        return self._collection_type

    @collection_type.setter
    def collection_type(self, collection_type):
        """
        Sets the collection_type of this UpgradeDetails.
        Type of Exadata Fleet Update collection being upgraded.


        :param collection_type: The collection_type of this UpgradeDetails.
        :type: str
        """
        allowed_values = ["DB", "GI"]
        if not value_allowed_none_or_none_sentinel(collection_type, allowed_values):
            collection_type = 'UNKNOWN_ENUM_VALUE'
        self._collection_type = collection_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
