# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateModelDetails(object):
    """
    The data to create a custom model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateModelDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateModelDetails.
        :type compartment_id: str

        :param vendor:
            The value to assign to the vendor property of this CreateModelDetails.
        :type vendor: str

        :param version:
            The value to assign to the version property of this CreateModelDetails.
        :type version: str

        :param description:
            The value to assign to the description property of this CreateModelDetails.
        :type description: str

        :param base_model_id:
            The value to assign to the base_model_id property of this CreateModelDetails.
        :type base_model_id: str

        :param fine_tune_details:
            The value to assign to the fine_tune_details property of this CreateModelDetails.
        :type fine_tune_details: oci.generative_ai.models.FineTuneDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateModelDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateModelDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'vendor': 'str',
            'version': 'str',
            'description': 'str',
            'base_model_id': 'str',
            'fine_tune_details': 'FineTuneDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'vendor': 'vendor',
            'version': 'version',
            'description': 'description',
            'base_model_id': 'baseModelId',
            'fine_tune_details': 'fineTuneDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._vendor = None
        self._version = None
        self._description = None
        self._base_model_id = None
        self._fine_tune_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateModelDetails.
        A user-friendly name.


        :return: The display_name of this CreateModelDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateModelDetails.
        A user-friendly name.


        :param display_name: The display_name of this CreateModelDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateModelDetails.
        The compartment OCID for fine-tuned models. For pretrained models, this value is null.


        :return: The compartment_id of this CreateModelDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateModelDetails.
        The compartment OCID for fine-tuned models. For pretrained models, this value is null.


        :param compartment_id: The compartment_id of this CreateModelDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vendor(self):
        """
        Gets the vendor of this CreateModelDetails.
        The provider of the model.


        :return: The vendor of this CreateModelDetails.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this CreateModelDetails.
        The provider of the model.


        :param vendor: The vendor of this CreateModelDetails.
        :type: str
        """
        self._vendor = vendor

    @property
    def version(self):
        """
        Gets the version of this CreateModelDetails.
        The version of the model.


        :return: The version of this CreateModelDetails.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this CreateModelDetails.
        The version of the model.


        :param version: The version of this CreateModelDetails.
        :type: str
        """
        self._version = version

    @property
    def description(self):
        """
        Gets the description of this CreateModelDetails.
        An optional description of the model.


        :return: The description of this CreateModelDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateModelDetails.
        An optional description of the model.


        :param description: The description of this CreateModelDetails.
        :type: str
        """
        self._description = description

    @property
    def base_model_id(self):
        """
        **[Required]** Gets the base_model_id of this CreateModelDetails.
        The OCID of the base model that's used for fine-tuning.


        :return: The base_model_id of this CreateModelDetails.
        :rtype: str
        """
        return self._base_model_id

    @base_model_id.setter
    def base_model_id(self, base_model_id):
        """
        Sets the base_model_id of this CreateModelDetails.
        The OCID of the base model that's used for fine-tuning.


        :param base_model_id: The base_model_id of this CreateModelDetails.
        :type: str
        """
        self._base_model_id = base_model_id

    @property
    def fine_tune_details(self):
        """
        **[Required]** Gets the fine_tune_details of this CreateModelDetails.

        :return: The fine_tune_details of this CreateModelDetails.
        :rtype: oci.generative_ai.models.FineTuneDetails
        """
        return self._fine_tune_details

    @fine_tune_details.setter
    def fine_tune_details(self, fine_tune_details):
        """
        Sets the fine_tune_details of this CreateModelDetails.

        :param fine_tune_details: The fine_tune_details of this CreateModelDetails.
        :type: oci.generative_ai.models.FineTuneDetails
        """
        self._fine_tune_details = fine_tune_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateModelDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateModelDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateModelDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateModelDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
