# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentEndpoint(object):
    """
    The endpoint to access a deployed agent.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AgentEndpoint.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AgentEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AgentEndpoint.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this AgentEndpoint.
        :type display_name: str

        :param description:
            The value to assign to the description property of this AgentEndpoint.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AgentEndpoint.
        :type compartment_id: str

        :param agent_id:
            The value to assign to the agent_id property of this AgentEndpoint.
        :type agent_id: str

        :param content_moderation_config:
            The value to assign to the content_moderation_config property of this AgentEndpoint.
        :type content_moderation_config: oci.generative_ai_agent.models.ContentModerationConfig

        :param guardrail_config:
            The value to assign to the guardrail_config property of this AgentEndpoint.
        :type guardrail_config: oci.generative_ai_agent.models.GuardrailConfig

        :param metadata:
            The value to assign to the metadata property of this AgentEndpoint.
        :type metadata: dict(str, str)

        :param human_input_config:
            The value to assign to the human_input_config property of this AgentEndpoint.
        :type human_input_config: oci.generative_ai_agent.models.HumanInputConfig

        :param output_config:
            The value to assign to the output_config property of this AgentEndpoint.
        :type output_config: oci.generative_ai_agent.models.OutputConfig

        :param should_enable_trace:
            The value to assign to the should_enable_trace property of this AgentEndpoint.
        :type should_enable_trace: bool

        :param should_enable_citation:
            The value to assign to the should_enable_citation property of this AgentEndpoint.
        :type should_enable_citation: bool

        :param should_enable_session:
            The value to assign to the should_enable_session property of this AgentEndpoint.
        :type should_enable_session: bool

        :param should_enable_multi_language:
            The value to assign to the should_enable_multi_language property of this AgentEndpoint.
        :type should_enable_multi_language: bool

        :param session_config:
            The value to assign to the session_config property of this AgentEndpoint.
        :type session_config: oci.generative_ai_agent.models.SessionConfig

        :param time_created:
            The value to assign to the time_created property of this AgentEndpoint.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AgentEndpoint.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AgentEndpoint.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AgentEndpoint.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AgentEndpoint.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AgentEndpoint.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AgentEndpoint.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'agent_id': 'str',
            'content_moderation_config': 'ContentModerationConfig',
            'guardrail_config': 'GuardrailConfig',
            'metadata': 'dict(str, str)',
            'human_input_config': 'HumanInputConfig',
            'output_config': 'OutputConfig',
            'should_enable_trace': 'bool',
            'should_enable_citation': 'bool',
            'should_enable_session': 'bool',
            'should_enable_multi_language': 'bool',
            'session_config': 'SessionConfig',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'agent_id': 'agentId',
            'content_moderation_config': 'contentModerationConfig',
            'guardrail_config': 'guardrailConfig',
            'metadata': 'metadata',
            'human_input_config': 'humanInputConfig',
            'output_config': 'outputConfig',
            'should_enable_trace': 'shouldEnableTrace',
            'should_enable_citation': 'shouldEnableCitation',
            'should_enable_session': 'shouldEnableSession',
            'should_enable_multi_language': 'shouldEnableMultiLanguage',
            'session_config': 'sessionConfig',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._agent_id = None
        self._content_moderation_config = None
        self._guardrail_config = None
        self._metadata = None
        self._human_input_config = None
        self._output_config = None
        self._should_enable_trace = None
        self._should_enable_citation = None
        self._should_enable_session = None
        self._should_enable_multi_language = None
        self._session_config = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AgentEndpoint.
        The `OCID`__ of the endpoint.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this AgentEndpoint.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AgentEndpoint.
        The `OCID`__ of the endpoint.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this AgentEndpoint.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this AgentEndpoint.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this AgentEndpoint.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AgentEndpoint.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this AgentEndpoint.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this AgentEndpoint.
        An optional description of the endpoint.


        :return: The description of this AgentEndpoint.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AgentEndpoint.
        An optional description of the endpoint.


        :param description: The description of this AgentEndpoint.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AgentEndpoint.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AgentEndpoint.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AgentEndpoint.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AgentEndpoint.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this AgentEndpoint.
        The OCID of the agent that this endpoint is associated with.


        :return: The agent_id of this AgentEndpoint.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this AgentEndpoint.
        The OCID of the agent that this endpoint is associated with.


        :param agent_id: The agent_id of this AgentEndpoint.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def content_moderation_config(self):
        """
        Gets the content_moderation_config of this AgentEndpoint.

        :return: The content_moderation_config of this AgentEndpoint.
        :rtype: oci.generative_ai_agent.models.ContentModerationConfig
        """
        return self._content_moderation_config

    @content_moderation_config.setter
    def content_moderation_config(self, content_moderation_config):
        """
        Sets the content_moderation_config of this AgentEndpoint.

        :param content_moderation_config: The content_moderation_config of this AgentEndpoint.
        :type: oci.generative_ai_agent.models.ContentModerationConfig
        """
        self._content_moderation_config = content_moderation_config

    @property
    def guardrail_config(self):
        """
        Gets the guardrail_config of this AgentEndpoint.

        :return: The guardrail_config of this AgentEndpoint.
        :rtype: oci.generative_ai_agent.models.GuardrailConfig
        """
        return self._guardrail_config

    @guardrail_config.setter
    def guardrail_config(self, guardrail_config):
        """
        Sets the guardrail_config of this AgentEndpoint.

        :param guardrail_config: The guardrail_config of this AgentEndpoint.
        :type: oci.generative_ai_agent.models.GuardrailConfig
        """
        self._guardrail_config = guardrail_config

    @property
    def metadata(self):
        """
        Gets the metadata of this AgentEndpoint.
        Key-value pairs to allow additional configurations.


        :return: The metadata of this AgentEndpoint.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this AgentEndpoint.
        Key-value pairs to allow additional configurations.


        :param metadata: The metadata of this AgentEndpoint.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def human_input_config(self):
        """
        Gets the human_input_config of this AgentEndpoint.

        :return: The human_input_config of this AgentEndpoint.
        :rtype: oci.generative_ai_agent.models.HumanInputConfig
        """
        return self._human_input_config

    @human_input_config.setter
    def human_input_config(self, human_input_config):
        """
        Sets the human_input_config of this AgentEndpoint.

        :param human_input_config: The human_input_config of this AgentEndpoint.
        :type: oci.generative_ai_agent.models.HumanInputConfig
        """
        self._human_input_config = human_input_config

    @property
    def output_config(self):
        """
        Gets the output_config of this AgentEndpoint.

        :return: The output_config of this AgentEndpoint.
        :rtype: oci.generative_ai_agent.models.OutputConfig
        """
        return self._output_config

    @output_config.setter
    def output_config(self, output_config):
        """
        Sets the output_config of this AgentEndpoint.

        :param output_config: The output_config of this AgentEndpoint.
        :type: oci.generative_ai_agent.models.OutputConfig
        """
        self._output_config = output_config

    @property
    def should_enable_trace(self):
        """
        Gets the should_enable_trace of this AgentEndpoint.
        Whether to show traces in the chat result.


        :return: The should_enable_trace of this AgentEndpoint.
        :rtype: bool
        """
        return self._should_enable_trace

    @should_enable_trace.setter
    def should_enable_trace(self, should_enable_trace):
        """
        Sets the should_enable_trace of this AgentEndpoint.
        Whether to show traces in the chat result.


        :param should_enable_trace: The should_enable_trace of this AgentEndpoint.
        :type: bool
        """
        self._should_enable_trace = should_enable_trace

    @property
    def should_enable_citation(self):
        """
        Gets the should_enable_citation of this AgentEndpoint.
        Whether to show citations in the chat result.


        :return: The should_enable_citation of this AgentEndpoint.
        :rtype: bool
        """
        return self._should_enable_citation

    @should_enable_citation.setter
    def should_enable_citation(self, should_enable_citation):
        """
        Sets the should_enable_citation of this AgentEndpoint.
        Whether to show citations in the chat result.


        :param should_enable_citation: The should_enable_citation of this AgentEndpoint.
        :type: bool
        """
        self._should_enable_citation = should_enable_citation

    @property
    def should_enable_session(self):
        """
        Gets the should_enable_session of this AgentEndpoint.
        Whether or not to enable Session-based chat.


        :return: The should_enable_session of this AgentEndpoint.
        :rtype: bool
        """
        return self._should_enable_session

    @should_enable_session.setter
    def should_enable_session(self, should_enable_session):
        """
        Sets the should_enable_session of this AgentEndpoint.
        Whether or not to enable Session-based chat.


        :param should_enable_session: The should_enable_session of this AgentEndpoint.
        :type: bool
        """
        self._should_enable_session = should_enable_session

    @property
    def should_enable_multi_language(self):
        """
        Gets the should_enable_multi_language of this AgentEndpoint.
        Whether to enable multi-language for chat.


        :return: The should_enable_multi_language of this AgentEndpoint.
        :rtype: bool
        """
        return self._should_enable_multi_language

    @should_enable_multi_language.setter
    def should_enable_multi_language(self, should_enable_multi_language):
        """
        Sets the should_enable_multi_language of this AgentEndpoint.
        Whether to enable multi-language for chat.


        :param should_enable_multi_language: The should_enable_multi_language of this AgentEndpoint.
        :type: bool
        """
        self._should_enable_multi_language = should_enable_multi_language

    @property
    def session_config(self):
        """
        Gets the session_config of this AgentEndpoint.

        :return: The session_config of this AgentEndpoint.
        :rtype: oci.generative_ai_agent.models.SessionConfig
        """
        return self._session_config

    @session_config.setter
    def session_config(self, session_config):
        """
        Sets the session_config of this AgentEndpoint.

        :param session_config: The session_config of this AgentEndpoint.
        :type: oci.generative_ai_agent.models.SessionConfig
        """
        self._session_config = session_config

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AgentEndpoint.
        The date and time the AgentEndpoint was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this AgentEndpoint.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AgentEndpoint.
        The date and time the AgentEndpoint was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this AgentEndpoint.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this AgentEndpoint.
        The date and time the endpoint was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this AgentEndpoint.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AgentEndpoint.
        The date and time the endpoint was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this AgentEndpoint.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AgentEndpoint.
        The current state of the endpoint.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AgentEndpoint.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AgentEndpoint.
        The current state of the endpoint.


        :param lifecycle_state: The lifecycle_state of this AgentEndpoint.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AgentEndpoint.
        A message that describes the current state of the endpoint in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this AgentEndpoint.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AgentEndpoint.
        A message that describes the current state of the endpoint in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this AgentEndpoint.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AgentEndpoint.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AgentEndpoint.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AgentEndpoint.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AgentEndpoint.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AgentEndpoint.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AgentEndpoint.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AgentEndpoint.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AgentEndpoint.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AgentEndpoint.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this AgentEndpoint.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AgentEndpoint.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this AgentEndpoint.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
