# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .index_config import IndexConfig
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultIndexConfig(IndexConfig):
    """
    The default index is service managed vector store on behalf of the customer.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultIndexConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent.models.DefaultIndexConfig.index_config_type` attribute
        of this class is ``DEFAULT_INDEX_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param index_config_type:
            The value to assign to the index_config_type property of this DefaultIndexConfig.
            Allowed values for this property are: "DEFAULT_INDEX_CONFIG", "OCI_OPEN_SEARCH_INDEX_CONFIG", "OCI_DATABASE_CONFIG"
        :type index_config_type: str

        :param should_enable_hybrid_search:
            The value to assign to the should_enable_hybrid_search property of this DefaultIndexConfig.
        :type should_enable_hybrid_search: bool

        """
        self.swagger_types = {
            'index_config_type': 'str',
            'should_enable_hybrid_search': 'bool'
        }
        self.attribute_map = {
            'index_config_type': 'indexConfigType',
            'should_enable_hybrid_search': 'shouldEnableHybridSearch'
        }
        self._index_config_type = None
        self._should_enable_hybrid_search = None
        self._index_config_type = 'DEFAULT_INDEX_CONFIG'

    @property
    def should_enable_hybrid_search(self):
        """
        Gets the should_enable_hybrid_search of this DefaultIndexConfig.
        Whether to enable Hybrid search in service managed OpenSearch.


        :return: The should_enable_hybrid_search of this DefaultIndexConfig.
        :rtype: bool
        """
        return self._should_enable_hybrid_search

    @should_enable_hybrid_search.setter
    def should_enable_hybrid_search(self, should_enable_hybrid_search):
        """
        Sets the should_enable_hybrid_search of this DefaultIndexConfig.
        Whether to enable Hybrid search in service managed OpenSearch.


        :param should_enable_hybrid_search: The should_enable_hybrid_search of this DefaultIndexConfig.
        :type: bool
        """
        self._should_enable_hybrid_search = should_enable_hybrid_search

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
