# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DocumentRank(object):
    """
    An object that contains a relevance score, an index and the text for a document.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DocumentRank object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param index:
            The value to assign to the index property of this DocumentRank.
        :type index: int

        :param relevance_score:
            The value to assign to the relevance_score property of this DocumentRank.
        :type relevance_score: float

        :param document:
            The value to assign to the document property of this DocumentRank.
        :type document: oci.generative_ai_inference.models.Document

        """
        self.swagger_types = {
            'index': 'int',
            'relevance_score': 'float',
            'document': 'Document'
        }
        self.attribute_map = {
            'index': 'index',
            'relevance_score': 'relevanceScore',
            'document': 'document'
        }
        self._index = None
        self._relevance_score = None
        self._document = None

    @property
    def index(self):
        """
        Gets the index of this DocumentRank.
        Index of the document in documents array.


        :return: The index of this DocumentRank.
        :rtype: int
        """
        return self._index

    @index.setter
    def index(self, index):
        """
        Sets the index of this DocumentRank.
        Index of the document in documents array.


        :param index: The index of this DocumentRank.
        :type: int
        """
        self._index = index

    @property
    def relevance_score(self):
        """
        Gets the relevance_score of this DocumentRank.
        The relevance score for the document at that index.


        :return: The relevance_score of this DocumentRank.
        :rtype: float
        """
        return self._relevance_score

    @relevance_score.setter
    def relevance_score(self, relevance_score):
        """
        Sets the relevance_score of this DocumentRank.
        The relevance score for the document at that index.


        :param relevance_score: The relevance_score of this DocumentRank.
        :type: float
        """
        self._relevance_score = relevance_score

    @property
    def document(self):
        """
        Gets the document of this DocumentRank.

        :return: The document of this DocumentRank.
        :rtype: oci.generative_ai_inference.models.Document
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this DocumentRank.

        :param document: The document of this DocumentRank.
        :type: oci.generative_ai_inference.models.Document
        """
        self._document = document

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
