# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .iceberg_storage import IcebergStorage
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GoogleCloudStorageIcebergStorage(IcebergStorage):
    """
    Represents a Google Cloud Storage storage used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GoogleCloudStorageIcebergStorage object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.GoogleCloudStorageIcebergStorage.storage_type` attribute
        of this class is ``GOOGLE_CLOUD_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this GoogleCloudStorageIcebergStorage.
            Allowed values for this property are: "AMAZON_S3", "GOOGLE_CLOUD_STORAGE", "AZURE_DATA_LAKE_STORAGE"
        :type storage_type: str

        :param bucket:
            The value to assign to the bucket property of this GoogleCloudStorageIcebergStorage.
        :type bucket: str

        :param project_id:
            The value to assign to the project_id property of this GoogleCloudStorageIcebergStorage.
        :type project_id: str

        :param service_account_key_file_secret_id:
            The value to assign to the service_account_key_file_secret_id property of this GoogleCloudStorageIcebergStorage.
        :type service_account_key_file_secret_id: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'bucket': 'str',
            'project_id': 'str',
            'service_account_key_file_secret_id': 'str'
        }
        self.attribute_map = {
            'storage_type': 'storageType',
            'bucket': 'bucket',
            'project_id': 'projectId',
            'service_account_key_file_secret_id': 'serviceAccountKeyFileSecretId'
        }
        self._storage_type = None
        self._bucket = None
        self._project_id = None
        self._service_account_key_file_secret_id = None
        self._storage_type = 'GOOGLE_CLOUD_STORAGE'

    @property
    def bucket(self):
        """
        **[Required]** Gets the bucket of this GoogleCloudStorageIcebergStorage.
        Google Cloud Storage bucket where Iceberg stores metadata and data files.


        :return: The bucket of this GoogleCloudStorageIcebergStorage.
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this GoogleCloudStorageIcebergStorage.
        Google Cloud Storage bucket where Iceberg stores metadata and data files.


        :param bucket: The bucket of this GoogleCloudStorageIcebergStorage.
        :type: str
        """
        self._bucket = bucket

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this GoogleCloudStorageIcebergStorage.
        The Google Cloud Project where the bucket exists.


        :return: The project_id of this GoogleCloudStorageIcebergStorage.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this GoogleCloudStorageIcebergStorage.
        The Google Cloud Project where the bucket exists.


        :param project_id: The project_id of this GoogleCloudStorageIcebergStorage.
        :type: str
        """
        self._project_id = project_id

    @property
    def service_account_key_file_secret_id(self):
        """
        **[Required]** Gets the service_account_key_file_secret_id of this GoogleCloudStorageIcebergStorage.
        The `OCID`__ of the Secret where the content of the service account key file is stored,
        which contains the credentials required to use Google Cloud Storage.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The service_account_key_file_secret_id of this GoogleCloudStorageIcebergStorage.
        :rtype: str
        """
        return self._service_account_key_file_secret_id

    @service_account_key_file_secret_id.setter
    def service_account_key_file_secret_id(self, service_account_key_file_secret_id):
        """
        Sets the service_account_key_file_secret_id of this GoogleCloudStorageIcebergStorage.
        The `OCID`__ of the Secret where the content of the service account key file is stored,
        which contains the credentials required to use Google Cloud Storage.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param service_account_key_file_secret_id: The service_account_key_file_secret_id of this GoogleCloudStorageIcebergStorage.
        :type: str
        """
        self._service_account_key_file_secret_id = service_account_key_file_secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
