# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciConsoleSignOnPolicyConsentConsentSignedBy(object):
    """
    User or App that signs the consent.

    **SCIM++ Properties:**
    - idcsSearchable: true
    - multiValued: false
    - mutability: immutable
    - required: true
    - returned: default
    - type: complex
    - uniqueness: none
    """

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentConsentSignedBy.
    #: This constant has a value of "User"
    TYPE_USER = "User"

    #: A constant which can be used with the type property of a OciConsoleSignOnPolicyConsentConsentSignedBy.
    #: This constant has a value of "App"
    TYPE_APP = "App"

    def __init__(self, **kwargs):
        """
        Initializes a new OciConsoleSignOnPolicyConsentConsentSignedBy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type value: str

        :param ocid:
            The value to assign to the ocid property of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type ocid: str

        :param display_name:
            The value to assign to the display_name property of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type display_name: str

        :param type:
            The value to assign to the type property of this OciConsoleSignOnPolicyConsentConsentSignedBy.
            Allowed values for this property are: "User", "App", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'value': 'str',
            'ocid': 'str',
            'display_name': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'value': 'value',
            'ocid': 'ocid',
            'display_name': 'displayName',
            'type': 'type'
        }
        self._value = None
        self._ocid = None
        self._display_name = None
        self._type = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Id of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :return: The value of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Id of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param value: The value of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type: str
        """
        self._value = value

    @property
    def ocid(self):
        """
        **[Required]** Gets the ocid of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        OCID of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :return: The ocid of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        OCID of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param ocid: The ocid of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type: str
        """
        self._ocid = ocid

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Name of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :return: The display_name of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Name of the User or App that signed consent.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param display_name: The display_name of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Type of principal that signed consent: User or App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string

        Allowed values for this property are: "User", "App", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        Type of principal that signed consent: User or App.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: default
         - type: string


        :param type: The type of this OciConsoleSignOnPolicyConsentConsentSignedBy.
        :type: str
        """
        allowed_values = ["User", "App"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
