# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RestoreOciConsolePolicy(object):
    """
    Schema to restoring OCI Console Policy to Factory Defaults.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a RestoreOciConsolePolicy.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a RestoreOciConsolePolicy.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a RestoreOciConsolePolicy.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    def __init__(self, **kwargs):
        """
        Initializes a new RestoreOciConsolePolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RestoreOciConsolePolicy.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this RestoreOciConsolePolicy.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this RestoreOciConsolePolicy.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this RestoreOciConsolePolicy.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this RestoreOciConsolePolicy.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this RestoreOciConsolePolicy.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this RestoreOciConsolePolicy.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this RestoreOciConsolePolicy.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this RestoreOciConsolePolicy.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this RestoreOciConsolePolicy.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this RestoreOciConsolePolicy.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this RestoreOciConsolePolicy.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this RestoreOciConsolePolicy.
        :type tenancy_ocid: str

        :param consent:
            The value to assign to the consent property of this RestoreOciConsolePolicy.
        :type consent: bool

        :param reason:
            The value to assign to the reason property of this RestoreOciConsolePolicy.
        :type reason: str

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'consent': 'bool',
            'reason': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'consent': 'consent',
            'reason': 'reason'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._consent = None
        self._reason = None

    @property
    def id(self):
        """
        Gets the id of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: always
        - type: string
        - uniqueness: global
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.


        :return: The id of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: always
        - type: string
        - uniqueness: global
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.


        :param id: The id of this RestoreOciConsolePolicy.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: true
        - idcsSearchable: true
        - multiValued: false
        - mutability: immutable
        - required: false
        - returned: default
        - type: string
        - uniqueness: global
        Unique OCI identifier for the SCIM Resource.


        :return: The ocid of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: true
        - idcsSearchable: true
        - multiValued: false
        - mutability: immutable
        - required: false
        - returned: default
        - type: string
        - uniqueness: global
        Unique OCI identifier for the SCIM Resource.


        :param ocid: The ocid of this RestoreOciConsolePolicy.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: true
        - mutability: readWrite
        - required: true
        - returned: default
        - type: string
        - uniqueness: none
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.


        :return: The schemas of this RestoreOciConsolePolicy.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: true
        - mutability: readWrite
        - required: true
        - returned: default
        - type: string
        - uniqueness: none
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.


        :param schemas: The schemas of this RestoreOciConsolePolicy.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this RestoreOciConsolePolicy.

        :return: The meta of this RestoreOciConsolePolicy.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this RestoreOciConsolePolicy.

        :param meta: The meta of this RestoreOciConsolePolicy.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this RestoreOciConsolePolicy.

        :return: The idcs_created_by of this RestoreOciConsolePolicy.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this RestoreOciConsolePolicy.

        :param idcs_created_by: The idcs_created_by of this RestoreOciConsolePolicy.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this RestoreOciConsolePolicy.

        :return: The idcs_last_modified_by of this RestoreOciConsolePolicy.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this RestoreOciConsolePolicy.

        :param idcs_last_modified_by: The idcs_last_modified_by of this RestoreOciConsolePolicy.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: true
        - mutability: readOnly
        - required: false
        - returned: request
        - type: string
        - uniqueness: none
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this RestoreOciConsolePolicy.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: true
        - mutability: readOnly
        - required: false
        - returned: request
        - type: string
        - uniqueness: none
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.


        :param idcs_prevented_operations: The idcs_prevented_operations of this RestoreOciConsolePolicy.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsCompositeKey: [key, value]
        - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]]
        - idcsSearchable: true
        - multiValued: true
        - mutability: readWrite
        - required: false
        - returned: request
        - type: complex
        - uniqueness: none
        A list of tags on this resource.


        :return: The tags of this RestoreOciConsolePolicy.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsCompositeKey: [key, value]
        - idcsCsvAttributeNameMappings: [[columnHeaderName:Tag Key, mapsTo:tags.key], [columnHeaderName:Tag Value, mapsTo:tags.value]]
        - idcsSearchable: true
        - multiValued: true
        - mutability: readWrite
        - required: false
        - returned: request
        - type: complex
        - uniqueness: none
        A list of tags on this resource.


        :param tags: The tags of this RestoreOciConsolePolicy.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.


        :return: The delete_in_progress of this RestoreOciConsolePolicy.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: boolean
        - uniqueness: none
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.


        :param delete_in_progress: The delete_in_progress of this RestoreOciConsolePolicy.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: request
        - type: string
        - uniqueness: none
        The release number when the resource was upgraded.


        :return: The idcs_last_upgraded_in_release of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: request
        - type: string
        - uniqueness: none
        The release number when the resource was upgraded.


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this RestoreOciConsolePolicy.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Domain Id (ocid) in which the resource lives.


        :return: The domain_ocid of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Domain Id (ocid) in which the resource lives.


        :param domain_ocid: The domain_ocid of this RestoreOciConsolePolicy.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Compartment Id (ocid) in which the resource lives.


        :return: The compartment_ocid of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Compartment Id (ocid) in which the resource lives.


        :param compartment_ocid: The compartment_ocid of this RestoreOciConsolePolicy.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Tenant Id (ocid) in which the resource lives.


        :return: The tenancy_ocid of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - caseExact: false
        - idcsSearchable: false
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: string
        - uniqueness: none
        OCI Tenant Id (ocid) in which the resource lives.


        :param tenancy_ocid: The tenancy_ocid of this RestoreOciConsolePolicy.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def consent(self):
        """
        **[Required]** Gets the consent of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: false
        - required: true
        - mutability: writeOnly
        - returned: default
        - type: boolean
        Consent to be provided for restoring the Oci Console SignOn Policy to Factory Defaults. Defaults to false


        :return: The consent of this RestoreOciConsolePolicy.
        :rtype: bool
        """
        return self._consent

    @consent.setter
    def consent(self, consent):
        """
        Sets the consent of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: false
        - required: true
        - mutability: writeOnly
        - returned: default
        - type: boolean
        Consent to be provided for restoring the Oci Console SignOn Policy to Factory Defaults. Defaults to false


        :param consent: The consent of this RestoreOciConsolePolicy.
        :type: bool
        """
        self._consent = consent

    @property
    def reason(self):
        """
        **[Required]** Gets the reason of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: false
        - mutability: writeOnly
        - required: true
        - returned: default
        - type: string
        Detailed reason when domain admin opts to restore the Oci Console SignOn Policy to Factory Defaults


        :return: The reason of this RestoreOciConsolePolicy.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """
        Sets the reason of this RestoreOciConsolePolicy.
        **SCIM++ Properties:**
        - idcsSearchable: false
        - multiValued: false
        - mutability: writeOnly
        - required: true
        - returned: default
        - type: string
        Detailed reason when domain admin opts to restore the Oci Console SignOn Policy to Factory Defaults


        :param reason: The reason of this RestoreOciConsolePolicy.
        :type: str
        """
        self._reason = reason

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
