# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogAnalyticsMetadata(object):
    """
    Entity metadata information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogAnalyticsMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this LogAnalyticsMetadata.
        :type name: str

        :param value:
            The value to assign to the value property of this LogAnalyticsMetadata.
        :type value: str

        :param type:
            The value to assign to the type property of this LogAnalyticsMetadata.
        :type type: str

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'type': 'type'
        }
        self._name = None
        self._value = None
        self._type = None

    @property
    def name(self):
        """
        Gets the name of this LogAnalyticsMetadata.
        The metadata name.


        :return: The name of this LogAnalyticsMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LogAnalyticsMetadata.
        The metadata name.


        :param name: The name of this LogAnalyticsMetadata.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this LogAnalyticsMetadata.
        The metadata value.


        :return: The value of this LogAnalyticsMetadata.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this LogAnalyticsMetadata.
        The metadata value.


        :param value: The value of this LogAnalyticsMetadata.
        :type: str
        """
        self._value = value

    @property
    def type(self):
        """
        Gets the type of this LogAnalyticsMetadata.
        The metadata type.


        :return: The type of this LogAnalyticsMetadata.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this LogAnalyticsMetadata.
        The metadata type.


        :param type: The type of this LogAnalyticsMetadata.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
