# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601

from .log_analytics_endpoint import LogAnalyticsEndpoint
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogListTypeEndpoint(LogAnalyticsEndpoint):
    """
    The LOG_LIST type endpoint configuration. The list of logs is first fetched using the listEndpoint configuration,
    and then the logs are subsequently fetched using the logEndpoints, which reference the list endpoint response.
    For time based incremental collection, specify the START_TIME macro with the desired time format,
    example: {START_TIME:yyMMddHHmmssZ}.
    For offset based incremental collection, specify the START_OFFSET macro with offset identifier in the API response,
    example: {START_OFFSET:$.offset}
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogListTypeEndpoint object with values from keyword arguments. The default value of the :py:attr:`~oci.log_analytics.models.LogListTypeEndpoint.endpoint_type` attribute
        of this class is ``LOG_LIST`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_type:
            The value to assign to the endpoint_type property of this LogListTypeEndpoint.
            Allowed values for this property are: "LOG_LIST", "LOG"
        :type endpoint_type: str

        :param list_endpoint:
            The value to assign to the list_endpoint property of this LogListTypeEndpoint.
        :type list_endpoint: oci.log_analytics.models.LogListEndpoint

        :param log_endpoints:
            The value to assign to the log_endpoints property of this LogListTypeEndpoint.
        :type log_endpoints: list[oci.log_analytics.models.LogEndpoint]

        """
        self.swagger_types = {
            'endpoint_type': 'str',
            'list_endpoint': 'LogListEndpoint',
            'log_endpoints': 'list[LogEndpoint]'
        }
        self.attribute_map = {
            'endpoint_type': 'endpointType',
            'list_endpoint': 'listEndpoint',
            'log_endpoints': 'logEndpoints'
        }
        self._endpoint_type = None
        self._list_endpoint = None
        self._log_endpoints = None
        self._endpoint_type = 'LOG_LIST'

    @property
    def list_endpoint(self):
        """
        **[Required]** Gets the list_endpoint of this LogListTypeEndpoint.

        :return: The list_endpoint of this LogListTypeEndpoint.
        :rtype: oci.log_analytics.models.LogListEndpoint
        """
        return self._list_endpoint

    @list_endpoint.setter
    def list_endpoint(self, list_endpoint):
        """
        Sets the list_endpoint of this LogListTypeEndpoint.

        :param list_endpoint: The list_endpoint of this LogListTypeEndpoint.
        :type: oci.log_analytics.models.LogListEndpoint
        """
        self._list_endpoint = list_endpoint

    @property
    def log_endpoints(self):
        """
        **[Required]** Gets the log_endpoints of this LogListTypeEndpoint.
        Log endpoints, which reference the listEndpoint response, to fetch log data.


        :return: The log_endpoints of this LogListTypeEndpoint.
        :rtype: list[oci.log_analytics.models.LogEndpoint]
        """
        return self._log_endpoints

    @log_endpoints.setter
    def log_endpoints(self, log_endpoints):
        """
        Sets the log_endpoints of this LogListTypeEndpoint.
        Log endpoints, which reference the listEndpoint response, to fetch log data.


        :param log_endpoints: The log_endpoints of this LogListTypeEndpoint.
        :type: list[oci.log_analytics.models.LogEndpoint]
        """
        self._log_endpoints = log_endpoints

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
