# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomerInstanceReportRecord(object):
    """
    The model for instance report item
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomerInstanceReportRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param publisher_id:
            The value to assign to the publisher_id property of this CustomerInstanceReportRecord.
        :type publisher_id: str

        :param listing_name:
            The value to assign to the listing_name property of this CustomerInstanceReportRecord.
        :type listing_name: str

        :param listing_id:
            The value to assign to the listing_id property of this CustomerInstanceReportRecord.
        :type listing_id: str

        :param listing_version_id:
            The value to assign to the listing_version_id property of this CustomerInstanceReportRecord.
        :type listing_version_id: str

        :param package_version:
            The value to assign to the package_version property of this CustomerInstanceReportRecord.
        :type package_version: str

        :param package_version_id:
            The value to assign to the package_version_id property of this CustomerInstanceReportRecord.
        :type package_version_id: str

        :param status:
            The value to assign to the status property of this CustomerInstanceReportRecord.
        :type status: str

        :param instance_id:
            The value to assign to the instance_id property of this CustomerInstanceReportRecord.
        :type instance_id: str

        :param time_instance_creation:
            The value to assign to the time_instance_creation property of this CustomerInstanceReportRecord.
        :type time_instance_creation: datetime

        :param time_instance_termination:
            The value to assign to the time_instance_termination property of this CustomerInstanceReportRecord.
        :type time_instance_termination: datetime

        :param region:
            The value to assign to the region property of this CustomerInstanceReportRecord.
        :type region: str

        :param realm:
            The value to assign to the realm property of this CustomerInstanceReportRecord.
        :type realm: str

        :param shape:
            The value to assign to the shape property of this CustomerInstanceReportRecord.
        :type shape: str

        :param oci_tenancy:
            The value to assign to the oci_tenancy property of this CustomerInstanceReportRecord.
        :type oci_tenancy: str

        :param tenant_admin_name:
            The value to assign to the tenant_admin_name property of this CustomerInstanceReportRecord.
        :type tenant_admin_name: str

        :param tenant_admin_email:
            The value to assign to the tenant_admin_email property of this CustomerInstanceReportRecord.
        :type tenant_admin_email: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CustomerInstanceReportRecord.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CustomerInstanceReportRecord.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CustomerInstanceReportRecord.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'publisher_id': 'str',
            'listing_name': 'str',
            'listing_id': 'str',
            'listing_version_id': 'str',
            'package_version': 'str',
            'package_version_id': 'str',
            'status': 'str',
            'instance_id': 'str',
            'time_instance_creation': 'datetime',
            'time_instance_termination': 'datetime',
            'region': 'str',
            'realm': 'str',
            'shape': 'str',
            'oci_tenancy': 'str',
            'tenant_admin_name': 'str',
            'tenant_admin_email': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'publisher_id': 'publisherId',
            'listing_name': 'listingName',
            'listing_id': 'listingId',
            'listing_version_id': 'listingVersionId',
            'package_version': 'packageVersion',
            'package_version_id': 'packageVersionId',
            'status': 'status',
            'instance_id': 'instanceId',
            'time_instance_creation': 'timeInstanceCreation',
            'time_instance_termination': 'timeInstanceTermination',
            'region': 'region',
            'realm': 'realm',
            'shape': 'shape',
            'oci_tenancy': 'ociTenancy',
            'tenant_admin_name': 'tenantAdminName',
            'tenant_admin_email': 'tenantAdminEmail',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._publisher_id = None
        self._listing_name = None
        self._listing_id = None
        self._listing_version_id = None
        self._package_version = None
        self._package_version_id = None
        self._status = None
        self._instance_id = None
        self._time_instance_creation = None
        self._time_instance_termination = None
        self._region = None
        self._realm = None
        self._shape = None
        self._oci_tenancy = None
        self._tenant_admin_name = None
        self._tenant_admin_email = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def publisher_id(self):
        """
        Gets the publisher_id of this CustomerInstanceReportRecord.
        publisher OCID


        :return: The publisher_id of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._publisher_id

    @publisher_id.setter
    def publisher_id(self, publisher_id):
        """
        Sets the publisher_id of this CustomerInstanceReportRecord.
        publisher OCID


        :param publisher_id: The publisher_id of this CustomerInstanceReportRecord.
        :type: str
        """
        self._publisher_id = publisher_id

    @property
    def listing_name(self):
        """
        Gets the listing_name of this CustomerInstanceReportRecord.
        Name of the listing


        :return: The listing_name of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._listing_name

    @listing_name.setter
    def listing_name(self, listing_name):
        """
        Sets the listing_name of this CustomerInstanceReportRecord.
        Name of the listing


        :param listing_name: The listing_name of this CustomerInstanceReportRecord.
        :type: str
        """
        self._listing_name = listing_name

    @property
    def listing_id(self):
        """
        Gets the listing_id of this CustomerInstanceReportRecord.
        Listing ID


        :return: The listing_id of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this CustomerInstanceReportRecord.
        Listing ID


        :param listing_id: The listing_id of this CustomerInstanceReportRecord.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_version_id(self):
        """
        Gets the listing_version_id of this CustomerInstanceReportRecord.
        Listing version ID


        :return: The listing_version_id of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._listing_version_id

    @listing_version_id.setter
    def listing_version_id(self, listing_version_id):
        """
        Sets the listing_version_id of this CustomerInstanceReportRecord.
        Listing version ID


        :param listing_version_id: The listing_version_id of this CustomerInstanceReportRecord.
        :type: str
        """
        self._listing_version_id = listing_version_id

    @property
    def package_version(self):
        """
        Gets the package_version of this CustomerInstanceReportRecord.
        The version for the package


        :return: The package_version of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._package_version

    @package_version.setter
    def package_version(self, package_version):
        """
        Sets the package_version of this CustomerInstanceReportRecord.
        The version for the package


        :param package_version: The package_version of this CustomerInstanceReportRecord.
        :type: str
        """
        self._package_version = package_version

    @property
    def package_version_id(self):
        """
        Gets the package_version_id of this CustomerInstanceReportRecord.
        Package version ID


        :return: The package_version_id of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._package_version_id

    @package_version_id.setter
    def package_version_id(self, package_version_id):
        """
        Sets the package_version_id of this CustomerInstanceReportRecord.
        Package version ID


        :param package_version_id: The package_version_id of this CustomerInstanceReportRecord.
        :type: str
        """
        self._package_version_id = package_version_id

    @property
    def status(self):
        """
        Gets the status of this CustomerInstanceReportRecord.
        Instance status


        :return: The status of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CustomerInstanceReportRecord.
        Instance status


        :param status: The status of this CustomerInstanceReportRecord.
        :type: str
        """
        self._status = status

    @property
    def instance_id(self):
        """
        Gets the instance_id of this CustomerInstanceReportRecord.
        Instance OCID


        :return: The instance_id of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this CustomerInstanceReportRecord.
        Instance OCID


        :param instance_id: The instance_id of this CustomerInstanceReportRecord.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def time_instance_creation(self):
        """
        Gets the time_instance_creation of this CustomerInstanceReportRecord.
        The date and time that instance was created, expressed in `RFC 3339`__
        timestamp format.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_instance_creation of this CustomerInstanceReportRecord.
        :rtype: datetime
        """
        return self._time_instance_creation

    @time_instance_creation.setter
    def time_instance_creation(self, time_instance_creation):
        """
        Sets the time_instance_creation of this CustomerInstanceReportRecord.
        The date and time that instance was created, expressed in `RFC 3339`__
        timestamp format.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_instance_creation: The time_instance_creation of this CustomerInstanceReportRecord.
        :type: datetime
        """
        self._time_instance_creation = time_instance_creation

    @property
    def time_instance_termination(self):
        """
        Gets the time_instance_termination of this CustomerInstanceReportRecord.
        The date and time that instance was terminated, expressed in `RFC 3339`__
        timestamp format.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_instance_termination of this CustomerInstanceReportRecord.
        :rtype: datetime
        """
        return self._time_instance_termination

    @time_instance_termination.setter
    def time_instance_termination(self, time_instance_termination):
        """
        Sets the time_instance_termination of this CustomerInstanceReportRecord.
        The date and time that instance was terminated, expressed in `RFC 3339`__
        timestamp format.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_instance_termination: The time_instance_termination of this CustomerInstanceReportRecord.
        :type: datetime
        """
        self._time_instance_termination = time_instance_termination

    @property
    def region(self):
        """
        Gets the region of this CustomerInstanceReportRecord.
        The region of the instance


        :return: The region of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this CustomerInstanceReportRecord.
        The region of the instance


        :param region: The region of this CustomerInstanceReportRecord.
        :type: str
        """
        self._region = region

    @property
    def realm(self):
        """
        Gets the realm of this CustomerInstanceReportRecord.
        The realm of the instance


        :return: The realm of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._realm

    @realm.setter
    def realm(self, realm):
        """
        Sets the realm of this CustomerInstanceReportRecord.
        The realm of the instance


        :param realm: The realm of this CustomerInstanceReportRecord.
        :type: str
        """
        self._realm = realm

    @property
    def shape(self):
        """
        Gets the shape of this CustomerInstanceReportRecord.
        The shape of the instance


        :return: The shape of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CustomerInstanceReportRecord.
        The shape of the instance


        :param shape: The shape of this CustomerInstanceReportRecord.
        :type: str
        """
        self._shape = shape

    @property
    def oci_tenancy(self):
        """
        Gets the oci_tenancy of this CustomerInstanceReportRecord.
        The tenancy of the instance


        :return: The oci_tenancy of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._oci_tenancy

    @oci_tenancy.setter
    def oci_tenancy(self, oci_tenancy):
        """
        Sets the oci_tenancy of this CustomerInstanceReportRecord.
        The tenancy of the instance


        :param oci_tenancy: The oci_tenancy of this CustomerInstanceReportRecord.
        :type: str
        """
        self._oci_tenancy = oci_tenancy

    @property
    def tenant_admin_name(self):
        """
        Gets the tenant_admin_name of this CustomerInstanceReportRecord.
        The name of the tenant adminstrator


        :return: The tenant_admin_name of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._tenant_admin_name

    @tenant_admin_name.setter
    def tenant_admin_name(self, tenant_admin_name):
        """
        Sets the tenant_admin_name of this CustomerInstanceReportRecord.
        The name of the tenant adminstrator


        :param tenant_admin_name: The tenant_admin_name of this CustomerInstanceReportRecord.
        :type: str
        """
        self._tenant_admin_name = tenant_admin_name

    @property
    def tenant_admin_email(self):
        """
        Gets the tenant_admin_email of this CustomerInstanceReportRecord.
        The email of the tenant adminstrator


        :return: The tenant_admin_email of this CustomerInstanceReportRecord.
        :rtype: str
        """
        return self._tenant_admin_email

    @tenant_admin_email.setter
    def tenant_admin_email(self, tenant_admin_email):
        """
        Sets the tenant_admin_email of this CustomerInstanceReportRecord.
        The email of the tenant adminstrator


        :param tenant_admin_email: The tenant_admin_email of this CustomerInstanceReportRecord.
        :type: str
        """
        self._tenant_admin_email = tenant_admin_email

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CustomerInstanceReportRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CustomerInstanceReportRecord.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CustomerInstanceReportRecord.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CustomerInstanceReportRecord.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CustomerInstanceReportRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CustomerInstanceReportRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CustomerInstanceReportRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CustomerInstanceReportRecord.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CustomerInstanceReportRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CustomerInstanceReportRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CustomerInstanceReportRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CustomerInstanceReportRecord.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
