# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciNetworkSubnet(object):
    """
    Oracle Cloud Infrastructure network subnet object.
    """

    #: A constant which can be used with the type property of a OciNetworkSubnet.
    #: This constant has a value of "CLIENT"
    TYPE_CLIENT = "CLIENT"

    #: A constant which can be used with the type property of a OciNetworkSubnet.
    #: This constant has a value of "BACKUP"
    TYPE_BACKUP = "BACKUP"

    def __init__(self, **kwargs):
        """
        Initializes a new OciNetworkSubnet object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this OciNetworkSubnet.
            Allowed values for this property are: "CLIENT", "BACKUP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param subnet_id:
            The value to assign to the subnet_id property of this OciNetworkSubnet.
        :type subnet_id: str

        :param label:
            The value to assign to the label property of this OciNetworkSubnet.
        :type label: str

        """
        self.swagger_types = {
            'type': 'str',
            'subnet_id': 'str',
            'label': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'subnet_id': 'subnetId',
            'label': 'label'
        }
        self._type = None
        self._subnet_id = None
        self._label = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this OciNetworkSubnet.
        Defines if the subnet is the primary or backup for the network

        Allowed values for this property are: "CLIENT", "BACKUP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this OciNetworkSubnet.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this OciNetworkSubnet.
        Defines if the subnet is the primary or backup for the network


        :param type: The type of this OciNetworkSubnet.
        :type: str
        """
        allowed_values = ["CLIENT", "BACKUP"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this OciNetworkSubnet.
        OCID for existing the subnet. CSP can not set this property.


        :return: The subnet_id of this OciNetworkSubnet.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this OciNetworkSubnet.
        OCID for existing the subnet. CSP can not set this property.


        :param subnet_id: The subnet_id of this OciNetworkSubnet.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def label(self):
        """
        Gets the label of this OciNetworkSubnet.
        Subnet label. CSP can set this property


        :return: The label of this OciNetworkSubnet.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this OciNetworkSubnet.
        Subnet label. CSP can set this property


        :param label: The label of this OciNetworkSubnet.
        :type: str
        """
        self._label = label

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
