# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501

from .tunnel_inspection_rule import TunnelInspectionRule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VxlanInspectionRule(TunnelInspectionRule):
    """
    Vxlan Tunnel Inspection Rule used on the firewall policy rules.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VxlanInspectionRule object with values from keyword arguments. The default value of the :py:attr:`~oci.network_firewall.models.VxlanInspectionRule.protocol` attribute
        of this class is ``VXLAN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this VxlanInspectionRule.
        :type name: str

        :param protocol:
            The value to assign to the protocol property of this VxlanInspectionRule.
            Allowed values for this property are: "VXLAN"
        :type protocol: str

        :param action:
            The value to assign to the action property of this VxlanInspectionRule.
            Allowed values for this property are: "INSPECT", "INSPECT_AND_CAPTURE_LOG"
        :type action: str

        :param priority_order:
            The value to assign to the priority_order property of this VxlanInspectionRule.
        :type priority_order: int

        :param position:
            The value to assign to the position property of this VxlanInspectionRule.
        :type position: oci.network_firewall.models.RulePosition

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this VxlanInspectionRule.
        :type parent_resource_id: str

        :param condition:
            The value to assign to the condition property of this VxlanInspectionRule.
        :type condition: oci.network_firewall.models.VxlanInspectionRuleMatchCriteria

        :param profile:
            The value to assign to the profile property of this VxlanInspectionRule.
        :type profile: oci.network_firewall.models.VxlanInspectionRuleProfile

        """
        self.swagger_types = {
            'name': 'str',
            'protocol': 'str',
            'action': 'str',
            'priority_order': 'int',
            'position': 'RulePosition',
            'parent_resource_id': 'str',
            'condition': 'VxlanInspectionRuleMatchCriteria',
            'profile': 'VxlanInspectionRuleProfile'
        }
        self.attribute_map = {
            'name': 'name',
            'protocol': 'protocol',
            'action': 'action',
            'priority_order': 'priorityOrder',
            'position': 'position',
            'parent_resource_id': 'parentResourceId',
            'condition': 'condition',
            'profile': 'profile'
        }
        self._name = None
        self._protocol = None
        self._action = None
        self._priority_order = None
        self._position = None
        self._parent_resource_id = None
        self._condition = None
        self._profile = None
        self._protocol = 'VXLAN'

    @property
    def condition(self):
        """
        **[Required]** Gets the condition of this VxlanInspectionRule.

        :return: The condition of this VxlanInspectionRule.
        :rtype: oci.network_firewall.models.VxlanInspectionRuleMatchCriteria
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """
        Sets the condition of this VxlanInspectionRule.

        :param condition: The condition of this VxlanInspectionRule.
        :type: oci.network_firewall.models.VxlanInspectionRuleMatchCriteria
        """
        self._condition = condition

    @property
    def profile(self):
        """
        **[Required]** Gets the profile of this VxlanInspectionRule.

        :return: The profile of this VxlanInspectionRule.
        :rtype: oci.network_firewall.models.VxlanInspectionRuleProfile
        """
        return self._profile

    @profile.setter
    def profile(self, profile):
        """
        Sets the profile of this VxlanInspectionRule.

        :param profile: The profile of this VxlanInspectionRule.
        :type: oci.network_firewall.models.VxlanInspectionRuleProfile
        """
        self._profile = profile

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
