# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TableCollection(object):
    """
    Results of ListTables.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TableCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param items:
            The value to assign to the items property of this TableCollection.
        :type items: list[oci.nosql.models.TableSummary]

        :param max_auto_reclaimable_tables:
            The value to assign to the max_auto_reclaimable_tables property of this TableCollection.
        :type max_auto_reclaimable_tables: int

        :param auto_reclaimable_tables:
            The value to assign to the auto_reclaimable_tables property of this TableCollection.
        :type auto_reclaimable_tables: int

        :param on_demand_capacity_tables:
            The value to assign to the on_demand_capacity_tables property of this TableCollection.
        :type on_demand_capacity_tables: int

        :param max_on_demand_capacity_tables:
            The value to assign to the max_on_demand_capacity_tables property of this TableCollection.
        :type max_on_demand_capacity_tables: int

        :param available_replication_regions:
            The value to assign to the available_replication_regions property of this TableCollection.
        :type available_replication_regions: list[str]

        """
        self.swagger_types = {
            'items': 'list[TableSummary]',
            'max_auto_reclaimable_tables': 'int',
            'auto_reclaimable_tables': 'int',
            'on_demand_capacity_tables': 'int',
            'max_on_demand_capacity_tables': 'int',
            'available_replication_regions': 'list[str]'
        }
        self.attribute_map = {
            'items': 'items',
            'max_auto_reclaimable_tables': 'maxAutoReclaimableTables',
            'auto_reclaimable_tables': 'autoReclaimableTables',
            'on_demand_capacity_tables': 'onDemandCapacityTables',
            'max_on_demand_capacity_tables': 'maxOnDemandCapacityTables',
            'available_replication_regions': 'availableReplicationRegions'
        }
        self._items = None
        self._max_auto_reclaimable_tables = None
        self._auto_reclaimable_tables = None
        self._on_demand_capacity_tables = None
        self._max_on_demand_capacity_tables = None
        self._available_replication_regions = None

    @property
    def items(self):
        """
        Gets the items of this TableCollection.
        A page of TableSummary objects.


        :return: The items of this TableCollection.
        :rtype: list[oci.nosql.models.TableSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this TableCollection.
        A page of TableSummary objects.


        :param items: The items of this TableCollection.
        :type: list[oci.nosql.models.TableSummary]
        """
        self._items = items

    @property
    def max_auto_reclaimable_tables(self):
        """
        Gets the max_auto_reclaimable_tables of this TableCollection.
        The maximum number of reclaimable tables allowed in the tenancy.


        :return: The max_auto_reclaimable_tables of this TableCollection.
        :rtype: int
        """
        return self._max_auto_reclaimable_tables

    @max_auto_reclaimable_tables.setter
    def max_auto_reclaimable_tables(self, max_auto_reclaimable_tables):
        """
        Sets the max_auto_reclaimable_tables of this TableCollection.
        The maximum number of reclaimable tables allowed in the tenancy.


        :param max_auto_reclaimable_tables: The max_auto_reclaimable_tables of this TableCollection.
        :type: int
        """
        self._max_auto_reclaimable_tables = max_auto_reclaimable_tables

    @property
    def auto_reclaimable_tables(self):
        """
        Gets the auto_reclaimable_tables of this TableCollection.
        The current number of reclaimable tables in the tenancy.


        :return: The auto_reclaimable_tables of this TableCollection.
        :rtype: int
        """
        return self._auto_reclaimable_tables

    @auto_reclaimable_tables.setter
    def auto_reclaimable_tables(self, auto_reclaimable_tables):
        """
        Sets the auto_reclaimable_tables of this TableCollection.
        The current number of reclaimable tables in the tenancy.


        :param auto_reclaimable_tables: The auto_reclaimable_tables of this TableCollection.
        :type: int
        """
        self._auto_reclaimable_tables = auto_reclaimable_tables

    @property
    def on_demand_capacity_tables(self):
        """
        Gets the on_demand_capacity_tables of this TableCollection.
        The current number of on demand capacity tables in the tenancy.


        :return: The on_demand_capacity_tables of this TableCollection.
        :rtype: int
        """
        return self._on_demand_capacity_tables

    @on_demand_capacity_tables.setter
    def on_demand_capacity_tables(self, on_demand_capacity_tables):
        """
        Sets the on_demand_capacity_tables of this TableCollection.
        The current number of on demand capacity tables in the tenancy.


        :param on_demand_capacity_tables: The on_demand_capacity_tables of this TableCollection.
        :type: int
        """
        self._on_demand_capacity_tables = on_demand_capacity_tables

    @property
    def max_on_demand_capacity_tables(self):
        """
        Gets the max_on_demand_capacity_tables of this TableCollection.
        The maximum number of on demand capacity tables allowed in the tenancy.


        :return: The max_on_demand_capacity_tables of this TableCollection.
        :rtype: int
        """
        return self._max_on_demand_capacity_tables

    @max_on_demand_capacity_tables.setter
    def max_on_demand_capacity_tables(self, max_on_demand_capacity_tables):
        """
        Sets the max_on_demand_capacity_tables of this TableCollection.
        The maximum number of on demand capacity tables allowed in the tenancy.


        :param max_on_demand_capacity_tables: The max_on_demand_capacity_tables of this TableCollection.
        :type: int
        """
        self._max_on_demand_capacity_tables = max_on_demand_capacity_tables

    @property
    def available_replication_regions(self):
        """
        Gets the available_replication_regions of this TableCollection.
        An array of regions that are available for replication.


        :return: The available_replication_regions of this TableCollection.
        :rtype: list[str]
        """
        return self._available_replication_regions

    @available_replication_regions.setter
    def available_replication_regions(self, available_replication_regions):
        """
        Sets the available_replication_regions of this TableCollection.
        An array of regions that are available for replication.


        :param available_replication_regions: The available_replication_regions of this TableCollection.
        :type: list[str]
        """
        self._available_replication_regions = available_replication_regions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
