# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateClusterSpecsDetails(object):
    """
    update cluster specs in Kiev.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateClusterSpecsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_id:
            The value to assign to the cluster_id property of this UpdateClusterSpecsDetails.
        :type cluster_id: str

        :param master_node_host_ocpu_count:
            The value to assign to the master_node_host_ocpu_count property of this UpdateClusterSpecsDetails.
        :type master_node_host_ocpu_count: int

        :param master_node_host_memory_gb:
            The value to assign to the master_node_host_memory_gb property of this UpdateClusterSpecsDetails.
        :type master_node_host_memory_gb: int

        :param master_node_host_shape:
            The value to assign to the master_node_host_shape property of this UpdateClusterSpecsDetails.
        :type master_node_host_shape: str

        :param data_node_host_ocpu_count:
            The value to assign to the data_node_host_ocpu_count property of this UpdateClusterSpecsDetails.
        :type data_node_host_ocpu_count: int

        :param data_node_host_memory_gb:
            The value to assign to the data_node_host_memory_gb property of this UpdateClusterSpecsDetails.
        :type data_node_host_memory_gb: int

        :param data_node_host_shape:
            The value to assign to the data_node_host_shape property of this UpdateClusterSpecsDetails.
        :type data_node_host_shape: str

        :param search_node_host_shape:
            The value to assign to the search_node_host_shape property of this UpdateClusterSpecsDetails.
        :type search_node_host_shape: str

        :param search_node_host_ocpu_count:
            The value to assign to the search_node_host_ocpu_count property of this UpdateClusterSpecsDetails.
        :type search_node_host_ocpu_count: int

        :param search_node_host_memory_gb:
            The value to assign to the search_node_host_memory_gb property of this UpdateClusterSpecsDetails.
        :type search_node_host_memory_gb: int

        :param software_version:
            The value to assign to the software_version property of this UpdateClusterSpecsDetails.
        :type software_version: str

        :param dashboard_software_version:
            The value to assign to the dashboard_software_version property of this UpdateClusterSpecsDetails.
        :type dashboard_software_version: str

        :param opendashboard_node_host_shape:
            The value to assign to the opendashboard_node_host_shape property of this UpdateClusterSpecsDetails.
        :type opendashboard_node_host_shape: str

        :param cluster_private_endpoint:
            The value to assign to the cluster_private_endpoint property of this UpdateClusterSpecsDetails.
        :type cluster_private_endpoint: str

        """
        self.swagger_types = {
            'cluster_id': 'str',
            'master_node_host_ocpu_count': 'int',
            'master_node_host_memory_gb': 'int',
            'master_node_host_shape': 'str',
            'data_node_host_ocpu_count': 'int',
            'data_node_host_memory_gb': 'int',
            'data_node_host_shape': 'str',
            'search_node_host_shape': 'str',
            'search_node_host_ocpu_count': 'int',
            'search_node_host_memory_gb': 'int',
            'software_version': 'str',
            'dashboard_software_version': 'str',
            'opendashboard_node_host_shape': 'str',
            'cluster_private_endpoint': 'str'
        }
        self.attribute_map = {
            'cluster_id': 'clusterId',
            'master_node_host_ocpu_count': 'masterNodeHostOcpuCount',
            'master_node_host_memory_gb': 'masterNodeHostMemoryGB',
            'master_node_host_shape': 'masterNodeHostShape',
            'data_node_host_ocpu_count': 'dataNodeHostOcpuCount',
            'data_node_host_memory_gb': 'dataNodeHostMemoryGB',
            'data_node_host_shape': 'dataNodeHostShape',
            'search_node_host_shape': 'searchNodeHostShape',
            'search_node_host_ocpu_count': 'searchNodeHostOcpuCount',
            'search_node_host_memory_gb': 'searchNodeHostMemoryGB',
            'software_version': 'softwareVersion',
            'dashboard_software_version': 'dashboardSoftwareVersion',
            'opendashboard_node_host_shape': 'opendashboardNodeHostShape',
            'cluster_private_endpoint': 'clusterPrivateEndpoint'
        }
        self._cluster_id = None
        self._master_node_host_ocpu_count = None
        self._master_node_host_memory_gb = None
        self._master_node_host_shape = None
        self._data_node_host_ocpu_count = None
        self._data_node_host_memory_gb = None
        self._data_node_host_shape = None
        self._search_node_host_shape = None
        self._search_node_host_ocpu_count = None
        self._search_node_host_memory_gb = None
        self._software_version = None
        self._dashboard_software_version = None
        self._opendashboard_node_host_shape = None
        self._cluster_private_endpoint = None

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this UpdateClusterSpecsDetails.
        OCID of the Opensearch Cluster.


        :return: The cluster_id of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this UpdateClusterSpecsDetails.
        OCID of the Opensearch Cluster.


        :param cluster_id: The cluster_id of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def master_node_host_ocpu_count(self):
        """
        Gets the master_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        Updated value of OCPU's configured for master nodes of the cluster.


        :return: The master_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._master_node_host_ocpu_count

    @master_node_host_ocpu_count.setter
    def master_node_host_ocpu_count(self, master_node_host_ocpu_count):
        """
        Sets the master_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        Updated value of OCPU's configured for master nodes of the cluster.


        :param master_node_host_ocpu_count: The master_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._master_node_host_ocpu_count = master_node_host_ocpu_count

    @property
    def master_node_host_memory_gb(self):
        """
        Gets the master_node_host_memory_gb of this UpdateClusterSpecsDetails.
        Updated value of memory for master nodes in the cluster (in GB).


        :return: The master_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._master_node_host_memory_gb

    @master_node_host_memory_gb.setter
    def master_node_host_memory_gb(self, master_node_host_memory_gb):
        """
        Sets the master_node_host_memory_gb of this UpdateClusterSpecsDetails.
        Updated value of memory for master nodes in the cluster (in GB).


        :param master_node_host_memory_gb: The master_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._master_node_host_memory_gb = master_node_host_memory_gb

    @property
    def master_node_host_shape(self):
        """
        Gets the master_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's master nodes.


        :return: The master_node_host_shape of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._master_node_host_shape

    @master_node_host_shape.setter
    def master_node_host_shape(self, master_node_host_shape):
        """
        Sets the master_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's master nodes.


        :param master_node_host_shape: The master_node_host_shape of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._master_node_host_shape = master_node_host_shape

    @property
    def data_node_host_ocpu_count(self):
        """
        Gets the data_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        Updated value of OCPU's configured for data nodes of the cluster.


        :return: The data_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._data_node_host_ocpu_count

    @data_node_host_ocpu_count.setter
    def data_node_host_ocpu_count(self, data_node_host_ocpu_count):
        """
        Sets the data_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        Updated value of OCPU's configured for data nodes of the cluster.


        :param data_node_host_ocpu_count: The data_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._data_node_host_ocpu_count = data_node_host_ocpu_count

    @property
    def data_node_host_memory_gb(self):
        """
        Gets the data_node_host_memory_gb of this UpdateClusterSpecsDetails.
        Updated value of memory for data nodes in the cluster (in GB).


        :return: The data_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._data_node_host_memory_gb

    @data_node_host_memory_gb.setter
    def data_node_host_memory_gb(self, data_node_host_memory_gb):
        """
        Sets the data_node_host_memory_gb of this UpdateClusterSpecsDetails.
        Updated value of memory for data nodes in the cluster (in GB).


        :param data_node_host_memory_gb: The data_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._data_node_host_memory_gb = data_node_host_memory_gb

    @property
    def data_node_host_shape(self):
        """
        Gets the data_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's data nodes.


        :return: The data_node_host_shape of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._data_node_host_shape

    @data_node_host_shape.setter
    def data_node_host_shape(self, data_node_host_shape):
        """
        Sets the data_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's data nodes.


        :param data_node_host_shape: The data_node_host_shape of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._data_node_host_shape = data_node_host_shape

    @property
    def search_node_host_shape(self):
        """
        Gets the search_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's search nodes.


        :return: The search_node_host_shape of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._search_node_host_shape

    @search_node_host_shape.setter
    def search_node_host_shape(self, search_node_host_shape):
        """
        Sets the search_node_host_shape of this UpdateClusterSpecsDetails.
        The node shape for the cluster's search nodes.


        :param search_node_host_shape: The search_node_host_shape of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._search_node_host_shape = search_node_host_shape

    @property
    def search_node_host_ocpu_count(self):
        """
        Gets the search_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        The number of OCPUs configured for the cluster's search nodes.


        :return: The search_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._search_node_host_ocpu_count

    @search_node_host_ocpu_count.setter
    def search_node_host_ocpu_count(self, search_node_host_ocpu_count):
        """
        Sets the search_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        The number of OCPUs configured for the cluster's search nodes.


        :param search_node_host_ocpu_count: The search_node_host_ocpu_count of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._search_node_host_ocpu_count = search_node_host_ocpu_count

    @property
    def search_node_host_memory_gb(self):
        """
        Gets the search_node_host_memory_gb of this UpdateClusterSpecsDetails.
        The amount of memory in GB, for the cluster's search nodes.


        :return: The search_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :rtype: int
        """
        return self._search_node_host_memory_gb

    @search_node_host_memory_gb.setter
    def search_node_host_memory_gb(self, search_node_host_memory_gb):
        """
        Sets the search_node_host_memory_gb of this UpdateClusterSpecsDetails.
        The amount of memory in GB, for the cluster's search nodes.


        :param search_node_host_memory_gb: The search_node_host_memory_gb of this UpdateClusterSpecsDetails.
        :type: int
        """
        self._search_node_host_memory_gb = search_node_host_memory_gb

    @property
    def software_version(self):
        """
        Gets the software_version of this UpdateClusterSpecsDetails.
        Updated version of the software the cluster is currently running.


        :return: The software_version of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this UpdateClusterSpecsDetails.
        Updated version of the software the cluster is currently running.


        :param software_version: The software_version of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._software_version = software_version

    @property
    def dashboard_software_version(self):
        """
        Gets the dashboard_software_version of this UpdateClusterSpecsDetails.
        Updated version of the dashboard software the cluster is currently running.


        :return: The dashboard_software_version of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._dashboard_software_version

    @dashboard_software_version.setter
    def dashboard_software_version(self, dashboard_software_version):
        """
        Sets the dashboard_software_version of this UpdateClusterSpecsDetails.
        Updated version of the dashboard software the cluster is currently running.


        :param dashboard_software_version: The dashboard_software_version of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._dashboard_software_version = dashboard_software_version

    @property
    def opendashboard_node_host_shape(self):
        """
        Gets the opendashboard_node_host_shape of this UpdateClusterSpecsDetails.
        The shape node for the cluster's OpenSearch Dashboard nodes.


        :return: The opendashboard_node_host_shape of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._opendashboard_node_host_shape

    @opendashboard_node_host_shape.setter
    def opendashboard_node_host_shape(self, opendashboard_node_host_shape):
        """
        Sets the opendashboard_node_host_shape of this UpdateClusterSpecsDetails.
        The shape node for the cluster's OpenSearch Dashboard nodes.


        :param opendashboard_node_host_shape: The opendashboard_node_host_shape of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._opendashboard_node_host_shape = opendashboard_node_host_shape

    @property
    def cluster_private_endpoint(self):
        """
        Gets the cluster_private_endpoint of this UpdateClusterSpecsDetails.
        Updated Private endpoint of cluster.


        :return: The cluster_private_endpoint of this UpdateClusterSpecsDetails.
        :rtype: str
        """
        return self._cluster_private_endpoint

    @cluster_private_endpoint.setter
    def cluster_private_endpoint(self, cluster_private_endpoint):
        """
        Sets the cluster_private_endpoint of this UpdateClusterSpecsDetails.
        Updated Private endpoint of cluster.


        :param cluster_private_endpoint: The cluster_private_endpoint of this UpdateClusterSpecsDetails.
        :type: str
        """
        self._cluster_private_endpoint = cluster_private_endpoint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
