# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .database_configuration_summary import DatabaseConfigurationSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MdsMysqlDatabaseConfigurationSummary(DatabaseConfigurationSummary):
    """
    Configuration Summary of a MDS MYSQL database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MdsMysqlDatabaseConfigurationSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.MdsMysqlDatabaseConfigurationSummary.entity_source` attribute
        of this class is ``MDS_MYSQL_DATABASE_SYSTEM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_insight_id:
            The value to assign to the database_insight_id property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_insight_id: str

        :param entity_source:
            The value to assign to the entity_source property of this MdsMysqlDatabaseConfigurationSummary.
            Allowed values for this property are: "AUTONOMOUS_DATABASE", "EM_MANAGED_EXTERNAL_DATABASE", "MACS_MANAGED_EXTERNAL_DATABASE", "PE_COMANAGED_DATABASE", "MDS_MYSQL_DATABASE_SYSTEM", "EXTERNAL_MYSQL_DATABASE_SYSTEM", "MACS_MANAGED_CLOUD_DATABASE", "MACS_MANAGED_AUTONOMOUS_DATABASE"
        :type entity_source: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MdsMysqlDatabaseConfigurationSummary.
        :type compartment_id: str

        :param database_name:
            The value to assign to the database_name property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_name: str

        :param database_display_name:
            The value to assign to the database_display_name property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_display_name: str

        :param database_type:
            The value to assign to the database_type property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_type: str

        :param database_version:
            The value to assign to the database_version property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_version: str

        :param cdb_name:
            The value to assign to the cdb_name property of this MdsMysqlDatabaseConfigurationSummary.
        :type cdb_name: str

        :param defined_tags:
            The value to assign to the defined_tags property of this MdsMysqlDatabaseConfigurationSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MdsMysqlDatabaseConfigurationSummary.
        :type freeform_tags: dict(str, str)

        :param processor_count:
            The value to assign to the processor_count property of this MdsMysqlDatabaseConfigurationSummary.
        :type processor_count: int

        :param database_id:
            The value to assign to the database_id property of this MdsMysqlDatabaseConfigurationSummary.
        :type database_id: str

        :param is_heat_wave_cluster_attached:
            The value to assign to the is_heat_wave_cluster_attached property of this MdsMysqlDatabaseConfigurationSummary.
        :type is_heat_wave_cluster_attached: bool

        :param is_highly_available:
            The value to assign to the is_highly_available property of this MdsMysqlDatabaseConfigurationSummary.
        :type is_highly_available: bool

        :param shape_name:
            The value to assign to the shape_name property of this MdsMysqlDatabaseConfigurationSummary.
        :type shape_name: str

        """
        self.swagger_types = {
            'database_insight_id': 'str',
            'entity_source': 'str',
            'compartment_id': 'str',
            'database_name': 'str',
            'database_display_name': 'str',
            'database_type': 'str',
            'database_version': 'str',
            'cdb_name': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'processor_count': 'int',
            'database_id': 'str',
            'is_heat_wave_cluster_attached': 'bool',
            'is_highly_available': 'bool',
            'shape_name': 'str'
        }
        self.attribute_map = {
            'database_insight_id': 'databaseInsightId',
            'entity_source': 'entitySource',
            'compartment_id': 'compartmentId',
            'database_name': 'databaseName',
            'database_display_name': 'databaseDisplayName',
            'database_type': 'databaseType',
            'database_version': 'databaseVersion',
            'cdb_name': 'cdbName',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'processor_count': 'processorCount',
            'database_id': 'databaseId',
            'is_heat_wave_cluster_attached': 'isHeatWaveClusterAttached',
            'is_highly_available': 'isHighlyAvailable',
            'shape_name': 'shapeName'
        }
        self._database_insight_id = None
        self._entity_source = None
        self._compartment_id = None
        self._database_name = None
        self._database_display_name = None
        self._database_type = None
        self._database_version = None
        self._cdb_name = None
        self._defined_tags = None
        self._freeform_tags = None
        self._processor_count = None
        self._database_id = None
        self._is_heat_wave_cluster_attached = None
        self._is_highly_available = None
        self._shape_name = None
        self._entity_source = 'MDS_MYSQL_DATABASE_SYSTEM'

    @property
    def database_id(self):
        """
        **[Required]** Gets the database_id of this MdsMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The database_id of this MdsMysqlDatabaseConfigurationSummary.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this MdsMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param database_id: The database_id of this MdsMysqlDatabaseConfigurationSummary.
        :type: str
        """
        self._database_id = database_id

    @property
    def is_heat_wave_cluster_attached(self):
        """
        **[Required]** Gets the is_heat_wave_cluster_attached of this MdsMysqlDatabaseConfigurationSummary.
        Specifies if MYSQL DB System has heatwave cluster attached.


        :return: The is_heat_wave_cluster_attached of this MdsMysqlDatabaseConfigurationSummary.
        :rtype: bool
        """
        return self._is_heat_wave_cluster_attached

    @is_heat_wave_cluster_attached.setter
    def is_heat_wave_cluster_attached(self, is_heat_wave_cluster_attached):
        """
        Sets the is_heat_wave_cluster_attached of this MdsMysqlDatabaseConfigurationSummary.
        Specifies if MYSQL DB System has heatwave cluster attached.


        :param is_heat_wave_cluster_attached: The is_heat_wave_cluster_attached of this MdsMysqlDatabaseConfigurationSummary.
        :type: bool
        """
        self._is_heat_wave_cluster_attached = is_heat_wave_cluster_attached

    @property
    def is_highly_available(self):
        """
        **[Required]** Gets the is_highly_available of this MdsMysqlDatabaseConfigurationSummary.
        Specifies if MYSQL DB System is highly available.


        :return: The is_highly_available of this MdsMysqlDatabaseConfigurationSummary.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this MdsMysqlDatabaseConfigurationSummary.
        Specifies if MYSQL DB System is highly available.


        :param is_highly_available: The is_highly_available of this MdsMysqlDatabaseConfigurationSummary.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this MdsMysqlDatabaseConfigurationSummary.
        The shape of the primary instances of MYSQL DB system. The shape determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM shapes.


        :return: The shape_name of this MdsMysqlDatabaseConfigurationSummary.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this MdsMysqlDatabaseConfigurationSummary.
        The shape of the primary instances of MYSQL DB system. The shape determines resources allocated to a DB System - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM shapes.


        :param shape_name: The shape_name of this MdsMysqlDatabaseConfigurationSummary.
        :type: str
        """
        self._shape_name = shape_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
