# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExploitAttemptEventData(object):
    """
    Information about the exploit attempt event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExploitAttemptEventData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content:
            The value to assign to the content property of this ExploitAttemptEventData.
        :type content: oci.os_management_hub.models.ExploitAttemptEventContent

        :param count:
            The value to assign to the count property of this ExploitAttemptEventData.
        :type count: int

        :param additional_details:
            The value to assign to the additional_details property of this ExploitAttemptEventData.
        :type additional_details: oci.os_management_hub.models.ExploitAttemptAdditionalDetails

        """
        self.swagger_types = {
            'content': 'ExploitAttemptEventContent',
            'count': 'int',
            'additional_details': 'ExploitAttemptAdditionalDetails'
        }
        self.attribute_map = {
            'content': 'content',
            'count': 'count',
            'additional_details': 'additionalDetails'
        }
        self._content = None
        self._count = None
        self._additional_details = None

    @property
    def content(self):
        """
        Gets the content of this ExploitAttemptEventData.

        :return: The content of this ExploitAttemptEventData.
        :rtype: oci.os_management_hub.models.ExploitAttemptEventContent
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this ExploitAttemptEventData.

        :param content: The content of this ExploitAttemptEventData.
        :type: oci.os_management_hub.models.ExploitAttemptEventContent
        """
        self._content = content

    @property
    def count(self):
        """
        **[Required]** Gets the count of this ExploitAttemptEventData.
        Number of times the event has occurred.


        :return: The count of this ExploitAttemptEventData.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this ExploitAttemptEventData.
        Number of times the event has occurred.


        :param count: The count of this ExploitAttemptEventData.
        :type: int
        """
        self._count = count

    @property
    def additional_details(self):
        """
        Gets the additional_details of this ExploitAttemptEventData.

        :return: The additional_details of this ExploitAttemptEventData.
        :rtype: oci.os_management_hub.models.ExploitAttemptAdditionalDetails
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this ExploitAttemptEventData.

        :param additional_details: The additional_details of this ExploitAttemptEventData.
        :type: oci.os_management_hub.models.ExploitAttemptAdditionalDetails
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
