# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefinedMonitoringTemplateSummary(object):
    """
    Summary information about defined Monitoring Template for specified resourceType.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefinedMonitoringTemplateSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DefinedMonitoringTemplateSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DefinedMonitoringTemplateSummary.
        :type display_name: str

        :param namespace:
            The value to assign to the namespace property of this DefinedMonitoringTemplateSummary.
        :type namespace: str

        :param composite_type:
            The value to assign to the composite_type property of this DefinedMonitoringTemplateSummary.
        :type composite_type: str

        :param resource_type:
            The value to assign to the resource_type property of this DefinedMonitoringTemplateSummary.
        :type resource_type: str

        :param defined_alarm_conditions:
            The value to assign to the defined_alarm_conditions property of this DefinedMonitoringTemplateSummary.
        :type defined_alarm_conditions: list[oci.stack_monitoring.models.DefinedAlarmCondition]

        :param time_created:
            The value to assign to the time_created property of this DefinedMonitoringTemplateSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DefinedMonitoringTemplateSummary.
        :type time_updated: datetime

        :param system_tags:
            The value to assign to the system_tags property of this DefinedMonitoringTemplateSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'namespace': 'str',
            'composite_type': 'str',
            'resource_type': 'str',
            'defined_alarm_conditions': 'list[DefinedAlarmCondition]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'namespace': 'namespace',
            'composite_type': 'compositeType',
            'resource_type': 'resourceType',
            'defined_alarm_conditions': 'definedAlarmConditions',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._namespace = None
        self._composite_type = None
        self._resource_type = None
        self._defined_alarm_conditions = None
        self._time_created = None
        self._time_updated = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DefinedMonitoringTemplateSummary.
        The `OCID`__ of the definedMonitoringTemplate.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DefinedMonitoringTemplateSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DefinedMonitoringTemplateSummary.
        The `OCID`__ of the definedMonitoringTemplate.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DefinedMonitoringTemplateSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DefinedMonitoringTemplateSummary.
        The name of the definedMonitoringTemplate.


        :return: The display_name of this DefinedMonitoringTemplateSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DefinedMonitoringTemplateSummary.
        The name of the definedMonitoringTemplate.


        :param display_name: The display_name of this DefinedMonitoringTemplateSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this DefinedMonitoringTemplateSummary.
        The stack monitoring service or application emitting the metric that is evaluated by the alarm.


        :return: The namespace of this DefinedMonitoringTemplateSummary.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this DefinedMonitoringTemplateSummary.
        The stack monitoring service or application emitting the metric that is evaluated by the alarm.


        :param namespace: The namespace of this DefinedMonitoringTemplateSummary.
        :type: str
        """
        self._namespace = namespace

    @property
    def composite_type(self):
        """
        Gets the composite_type of this DefinedMonitoringTemplateSummary.
        Type of composite resource type OCID like EBS/PEOPLE_SOFT.


        :return: The composite_type of this DefinedMonitoringTemplateSummary.
        :rtype: str
        """
        return self._composite_type

    @composite_type.setter
    def composite_type(self, composite_type):
        """
        Sets the composite_type of this DefinedMonitoringTemplateSummary.
        Type of composite resource type OCID like EBS/PEOPLE_SOFT.


        :param composite_type: The composite_type of this DefinedMonitoringTemplateSummary.
        :type: str
        """
        self._composite_type = composite_type

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this DefinedMonitoringTemplateSummary.
        The resource types OCID.


        :return: The resource_type of this DefinedMonitoringTemplateSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this DefinedMonitoringTemplateSummary.
        The resource types OCID.


        :param resource_type: The resource_type of this DefinedMonitoringTemplateSummary.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def defined_alarm_conditions(self):
        """
        **[Required]** Gets the defined_alarm_conditions of this DefinedMonitoringTemplateSummary.
        Defined Monitoring template alarm conditions


        :return: The defined_alarm_conditions of this DefinedMonitoringTemplateSummary.
        :rtype: list[oci.stack_monitoring.models.DefinedAlarmCondition]
        """
        return self._defined_alarm_conditions

    @defined_alarm_conditions.setter
    def defined_alarm_conditions(self, defined_alarm_conditions):
        """
        Sets the defined_alarm_conditions of this DefinedMonitoringTemplateSummary.
        Defined Monitoring template alarm conditions


        :param defined_alarm_conditions: The defined_alarm_conditions of this DefinedMonitoringTemplateSummary.
        :type: list[oci.stack_monitoring.models.DefinedAlarmCondition]
        """
        self._defined_alarm_conditions = defined_alarm_conditions

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DefinedMonitoringTemplateSummary.
        The date and time the monitoringTemplate was created. Format defined by RFC3339.


        :return: The time_created of this DefinedMonitoringTemplateSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DefinedMonitoringTemplateSummary.
        The date and time the monitoringTemplate was created. Format defined by RFC3339.


        :param time_created: The time_created of this DefinedMonitoringTemplateSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DefinedMonitoringTemplateSummary.
        The date and time the monitoringTemplate was updated. Format defined by RFC3339.


        :return: The time_updated of this DefinedMonitoringTemplateSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DefinedMonitoringTemplateSummary.
        The date and time the monitoringTemplate was updated. Format defined by RFC3339.


        :param time_updated: The time_updated of this DefinedMonitoringTemplateSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DefinedMonitoringTemplateSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DefinedMonitoringTemplateSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DefinedMonitoringTemplateSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DefinedMonitoringTemplateSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
