# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlDetails(object):
    """
    Details of Sql content which needs to execute to collect Metric Extension data
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param script_file_name:
            The value to assign to the script_file_name property of this SqlDetails.
        :type script_file_name: str

        :param content:
            The value to assign to the content property of this SqlDetails.
        :type content: str

        """
        self.swagger_types = {
            'script_file_name': 'str',
            'content': 'str'
        }
        self.attribute_map = {
            'script_file_name': 'scriptFileName',
            'content': 'content'
        }
        self._script_file_name = None
        self._content = None

    @property
    def script_file_name(self):
        """
        Gets the script_file_name of this SqlDetails.
        If a script needs to be executed, then provide file name of the script


        :return: The script_file_name of this SqlDetails.
        :rtype: str
        """
        return self._script_file_name

    @script_file_name.setter
    def script_file_name(self, script_file_name):
        """
        Sets the script_file_name of this SqlDetails.
        If a script needs to be executed, then provide file name of the script


        :param script_file_name: The script_file_name of this SqlDetails.
        :type: str
        """
        self._script_file_name = script_file_name

    @property
    def content(self):
        """
        **[Required]** Gets the content of this SqlDetails.
        Sql statement or script file content as base64 encoded string


        :return: The content of this SqlDetails.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this SqlDetails.
        Sql statement or script file content as base64 encoded string


        :param content: The content of this SqlDetails.
        :type: str
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
