# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMetricExtensionDetails(object):
    """
    The information about updating a metric extension resource
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMetricExtensionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateMetricExtensionDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateMetricExtensionDetails.
        :type description: str

        :param collection_recurrences:
            The value to assign to the collection_recurrences property of this UpdateMetricExtensionDetails.
        :type collection_recurrences: str

        :param metric_list:
            The value to assign to the metric_list property of this UpdateMetricExtensionDetails.
        :type metric_list: list[oci.stack_monitoring.models.Metric]

        :param query_properties:
            The value to assign to the query_properties property of this UpdateMetricExtensionDetails.
        :type query_properties: oci.stack_monitoring.models.MetricExtensionUpdateQueryProperties

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'collection_recurrences': 'str',
            'metric_list': 'list[Metric]',
            'query_properties': 'MetricExtensionUpdateQueryProperties'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'collection_recurrences': 'collectionRecurrences',
            'metric_list': 'metricList',
            'query_properties': 'queryProperties'
        }
        self._display_name = None
        self._description = None
        self._collection_recurrences = None
        self._metric_list = None
        self._query_properties = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateMetricExtensionDetails.
        Metric Extension resource display name.


        :return: The display_name of this UpdateMetricExtensionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateMetricExtensionDetails.
        Metric Extension resource display name.


        :param display_name: The display_name of this UpdateMetricExtensionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateMetricExtensionDetails.
        Description of the metric extension.


        :return: The description of this UpdateMetricExtensionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateMetricExtensionDetails.
        Description of the metric extension.


        :param description: The description of this UpdateMetricExtensionDetails.
        :type: str
        """
        self._description = description

    @property
    def collection_recurrences(self):
        """
        Gets the collection_recurrences of this UpdateMetricExtensionDetails.
        Schedule of metric extension should use RFC 5545 format -> recur-rule-part = \"FREQ\";\"INTERVAL\" where FREQ rule part identifies the type of recurrence rule. Valid values are \"MINUTELY\",\"HOURLY\",\"DAILY\" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1


        :return: The collection_recurrences of this UpdateMetricExtensionDetails.
        :rtype: str
        """
        return self._collection_recurrences

    @collection_recurrences.setter
    def collection_recurrences(self, collection_recurrences):
        """
        Sets the collection_recurrences of this UpdateMetricExtensionDetails.
        Schedule of metric extension should use RFC 5545 format -> recur-rule-part = \"FREQ\";\"INTERVAL\" where FREQ rule part identifies the type of recurrence rule. Valid values are \"MINUTELY\",\"HOURLY\",\"DAILY\" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1


        :param collection_recurrences: The collection_recurrences of this UpdateMetricExtensionDetails.
        :type: str
        """
        self._collection_recurrences = collection_recurrences

    @property
    def metric_list(self):
        """
        Gets the metric_list of this UpdateMetricExtensionDetails.
        List of metrics which are part of this metric extension


        :return: The metric_list of this UpdateMetricExtensionDetails.
        :rtype: list[oci.stack_monitoring.models.Metric]
        """
        return self._metric_list

    @metric_list.setter
    def metric_list(self, metric_list):
        """
        Sets the metric_list of this UpdateMetricExtensionDetails.
        List of metrics which are part of this metric extension


        :param metric_list: The metric_list of this UpdateMetricExtensionDetails.
        :type: list[oci.stack_monitoring.models.Metric]
        """
        self._metric_list = metric_list

    @property
    def query_properties(self):
        """
        Gets the query_properties of this UpdateMetricExtensionDetails.

        :return: The query_properties of this UpdateMetricExtensionDetails.
        :rtype: oci.stack_monitoring.models.MetricExtensionUpdateQueryProperties
        """
        return self._query_properties

    @query_properties.setter
    def query_properties(self, query_properties):
        """
        Sets the query_properties of this UpdateMetricExtensionDetails.

        :param query_properties: The query_properties of this UpdateMetricExtensionDetails.
        :type: oci.stack_monitoring.models.MetricExtensionUpdateQueryProperties
        """
        self._query_properties = query_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
