const e=["```mysql\ndeclare @@clone_autotune_concurrency boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables dynamic spawning of threads for remote cloning operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_autotune_concurrency)]."],t=["```mysql\ndeclare @@clone_buffer_size integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `4194304`, min: `1048576`, max: `268435456`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the size of the intermediate buffer on the donor MySQL server instance [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_buffer_size)]."],n=["```mysql\ndeclare @@clone_ddl_timeout integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `300`, min: `0`, max: `2592000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The number of seconds that a cloning operation waits for backup lock [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_ddl_timeout)]."],s=["```mysql\ndeclare @@clone_enable_compression boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables compression of data at the network layer during cloning [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_enable_compression)]."],o=["```mysql\ndeclare @@clone_max_concurrency integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `16`, min: `1`, max: `128`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of concurrent threads used to perform cloning operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_max_concurrency)]."],a=["```mysql\ndeclare @@clone_max_data_bandwidth integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `0`, min: `0`, max: `1048576`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum data transfer rate in MiB per second for a remote cloning operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_max_data_bandwidth)]."],i=["```mysql\ndeclare @@clone_max_network_bandwidth integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `0`, min: `0`, max: `1048576`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum network transfer rate in MiB per second for a remote cloning operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_max_network_bandwidth)]."],r=["```mysql\ndeclare @@clone_ssl_ca filename\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the path to the certificate authority (CA) file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_ssl_ca)]."],m=["```mysql\ndeclare @@clone_ssl_cert filename\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the path to the public key certificate file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_ssl_cert)]."],l=["```mysql\ndeclare @@clone_ssl_key filename\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the path to the private key file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_ssl_key)]."],d=["```mysql\ndeclare @@clone_valid_donor_list string\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines donor host addresses for remote cloning operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_clone_valid_donor_list)]."],c=["```mysql\ndeclare @@group_replication_group_name string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The name of the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_group_name)]."],_=["```mysql\ndeclare @@group_replication_start_on_boot boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the server should start Group Replication or not during server start [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_start_on_boot)]."],p=["```mysql\ndeclare @@group_replication_local_address string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The local address in host:port formatted string [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_local_address)]."],h=["```mysql\ndeclare @@group_replication_member_weight integer\n```","_**System Variable**_ (⊕ 5.7.20)\n\ndefault: `50`, min: `0`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Chance of this member being elected as primary [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_member_weight)]."],y=["```mysql\ndeclare @@group_replication_member_expel_timeout integer\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `0`, min: `0`, max: `3600`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The time between a suspected failure of a group member and it being expelled from the group, causing a group membership reconfiguration [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_member_expel_timeout)]."],v=["```mysql\ndeclare @@group_replication_group_seeds string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A list of peer addresses, comma separated list such as host1:port1,host2:port2 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_group_seeds)]."],u=["```mysql\ndeclare @@group_replication_force_members string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A comma separated list of peer addresses, such as host1:port1,host2:port2 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_force_members)]."],b=["```mysql\ndeclare @@group_replication_bootstrap_group boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Configure this server to bootstrap the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_bootstrap_group)]."],f=["```mysql\ndeclare @@group_replication_clone_threshold integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `9223372036854775807`, min: `1`, max: `9223372036854775807`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The transaction number gap between the donor and recipient above which a remote cloning operation is used for state transfer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_clone_threshold)]."],q=["```mysql\ndeclare @@group_replication_poll_spin_loops integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `0`, min: `0`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times the group communication thread waits [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_poll_spin_loops)]."],g=["```mysql\ndeclare @@group_replication_recovery_compression_algorithm set\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `uncompressed`, valid values:\n\n- `zlib`\n- `zstd`\n- `uncompressed`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permitted compression algorithms for outgoing recovery connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_compression_algorithm)]."],S=["```mysql\ndeclare @@group_replication_recovery_get_public_key boolean\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to accept preference about fetching public key from master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_get_public_key)]."],z=["```mysql\ndeclare @@group_replication_recovery_public_key_path filename\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","To accept public key information [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_public_key_path)]."],V=["```mysql\ndeclare @@group_replication_recovery_retry_count integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `10`, min: `0`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that a joining member tries to connect to the available donors before giving up [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_retry_count)]."],T=["```mysql\ndeclare @@group_replication_recovery_reconnect_interval integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `60`, min: `0`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The sleep time, in seconds, between reconnection attempts when no donor was found in the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_reconnect_interval)]."],E=["```mysql\ndeclare @@group_replication_recovery_use_ssl boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether Group Replication recovery connection should use SSL [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_use_ssl)]."],A=["```mysql\ndeclare @@group_replication_recovery_ssl_ca string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains list of trusted SSL Certificate Authorities [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_ca)]."],R=["```mysql\ndeclare @@group_replication_recovery_ssl_capath string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains trusted SSL Certificate Authority certificate files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_capath)]."],x=["```mysql\ndeclare @@group_replication_recovery_ssl_cert string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of SSL certificate file to use for establishing encrypted connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_cert)]."],w=["```mysql\ndeclare @@group_replication_recovery_ssl_key string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of SSL key file to use for establishing encrypted connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_key)]."],N=["```mysql\ndeclare @@group_replication_recovery_ssl_cipher string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible ciphers for SSL encryption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_cipher)]."],C=["```mysql\ndeclare @@group_replication_recovery_ssl_crl filename\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains certificate revocation lists [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_crl)]."],k=["```mysql\ndeclare @@group_replication_recovery_ssl_crlpath dirname\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains certificate revocation-list files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_crlpath)]."],O=["```mysql\ndeclare @@group_replication_recovery_ssl_verify_server_cert boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Make the recovery process check the server's Common Name value in the donor sent certificate [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_ssl_verify_server_cert)]."],I=["```mysql\ndeclare @@group_replication_recovery_tls_version string\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndefault: `TLSv1,TLSv1.1,TLSv1.2,TLSv1.3`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permitted TLS protocols for connection encryption as the client (joining member) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_tls_version)]."],L=["```mysql\ndeclare @@group_replication_recovery_tls_ciphersuites string\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permitted ciphersuites when TLSv1.3 is used for connection encryption with this instance as the client (joining member) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_tls_ciphersuites)]."],D=["```mysql\ndeclare @@group_replication_recovery_complete_at enumeration\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `TRANSACTIONS_APPLIED`, valid values:\n\n- `TRANSACTIONS_CERTIFIED`\n- `TRANSACTIONS_APPLIED`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Recovery policies when handling cached transactions after state transfer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_complete_at)]."],M=["```mysql\ndeclare @@group_replication_recovery_zstd_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `3`, min: `1`, max: `22`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compression level for recovery connections that use zstd compression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_recovery_zstd_compression_level)]."],F=["```mysql\ndeclare @@group_replication_communication_debug_options string\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `GCS_DEBUG_NONE`, valid values:\n\n- `GCS_DEBUG_NONE`\n- `GCS_DEBUG_BASIC`\n- `GCS_DEBUG_TRACE`\n- `XCOM_DEBUG_BASIC`\n- `XCOM_DEBUG_TRACE`\n- `GCS_DEBUG_ALL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The level of debugging messages for Group Replication components [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_communication_debug_options)]."],P=["```mysql\ndeclare @@group_replication_components_stop_timeout integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `31536000`, min: `2`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Timeout, in seconds, that the plugin waits for each of the components when shutting down [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_components_stop_timeout)]."],B=["```mysql\ndeclare @@group_replication_consistency enumeration\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `EVENTUAL`, valid values:\n\n- `EVENTUAL`\n- `BEFORE_ON_PRIMARY_FAILOVER`\n- `BEFORE`\n- `AFTER`\n- `BEFORE_AND_AFTER`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The type of transaction consistency guarantee which the group provides [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_consistency)]."],U=["```mysql\ndeclare @@group_replication_allow_local_lower_version_join boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allow the current server to join the group even if it has a lower plugin version than the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_allow_local_lower_version_join)]."],H=["```mysql\ndeclare @@group_replication_allow_local_disjoint_gtids_join boolean\n```","_**System Variable**_ (⊕ 5.7.17, ⊘ 5.7.21, ⊗ 8.0.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allow the current server to join the group even if it has transactions not present in the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_allow_local_disjoint_gtids_join)]."],W=["```mysql\ndeclare @@group_replication_auto_increment_increment integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `7`, min: `1`, max: `65535`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Determines the interval between successive column values for transactions that execute on this server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_auto_increment_increment)]."],Q=["```mysql\ndeclare @@group_replication_compression_threshold integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `1000000`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The value in bytes above which (LZ4) compression is enforced; when set to zero, deactivates compression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_compression_threshold)]."],j=["```mysql\ndeclare @@group_replication_gtid_assignment_block_size integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `1000000`, min: `1`, max: `9223372036854775807`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of consecutive GTIDs that are reserved for each member; each member consumes its blocks and reserves more when needed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_gtid_assignment_block_size)]."],G=["```mysql\ndeclare @@group_replication_ssl_mode enumeration\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `DISABLED`, valid values:\n\n- `DISABLED`\n- `REQUIRED`\n- `VERIFY_CA`\n- `VERIFY_IDENTITY`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Desired security state of connection between Group Replication members [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_ssl_mode)]."],X=["```mysql\ndeclare @@group_replication_single_primary_mode boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Instructs the group to use a single server for the read/write workload [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_single_primary_mode)]."],Y=["```mysql\ndeclare @@group_replication_transaction_size_limit integer\n```","_**System Variable**_ (⊕ 5.7.19)\n\ndefault: `150000000`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the maximum size of transaction in bytes which the group accepts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_transaction_size_limit)]."],K=["```mysql\ndeclare @@group_replication_unreachable_majority_timeout integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `0`, min: `0`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How long to wait for network partitions that result in a minority to leave the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_unreachable_majority_timeout)]."],Z=["```mysql\ndeclare @@group_replication_enforce_update_everywhere_checks boolean\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable strict consistency checks for multi-master update everywhere [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_enforce_update_everywhere_checks)]."],$=["```mysql\ndeclare @@group_replication_exit_state_action enumeration\n```","_**System Variable**_ (⊕ 8.0.12)\n\ndefault: `READ_ONLY`, valid values:\n\n- `ABORT_SERVER`\n- `OFFLINE_MODE`\n- `READ_ONLY`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How the instance behaves when it leaves the group involuntarily [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_exit_state_action)]."],J=["```mysql\ndeclare @@group_replication_flow_control_mode enumeration\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `QUOTA`, valid values:\n\n- `DISABLED`\n- `QUOTA`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the mode used for flow control [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_mode)]."],ee=["```mysql\ndeclare @@group_replication_flow_control_certifier_threshold integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `25000`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the number of waiting transactions in the certifier queue that trigger flow control [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_certifier_threshold)]."],te=["```mysql\ndeclare @@group_replication_flow_control_applier_threshold integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `25000`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of waiting transactions in the applier queue that trigger flow control [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_applier_threshold)]."],ne=["```mysql\ndeclare @@group_replication_flow_control_hold_percent integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `10`, min: `0`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines what percentage of the group quota remains unused [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_hold_percent)]."],se=["```mysql\ndeclare @@group_replication_flow_control_max_commit_quota integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `0`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the maximum flow control quota of the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_max_commit_quota)]."],oe=["```mysql\ndeclare @@group_replication_flow_control_member_quota_percent integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `0`, min: `0`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the percentage of the quota that a member should assume is available for itself when calculating the quotas [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_member_quota_percent)]."],ae=["```mysql\ndeclare @@group_replication_flow_control_min_quota integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `0`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls the lowest flow control quota that can be assigned to a member [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_min_quota)]."],ie=["```mysql\ndeclare @@group_replication_flow_control_min_recovery_quota integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `0`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls the lowest quota that can be assigned to a member because of another recovering member in the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_min_recovery_quota)]."],re=["```mysql\ndeclare @@group_replication_flow_control_period integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `1`, min: `1`, max: `60`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines how many seconds to wait between flow control iterations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_period)]."],me=["```mysql\ndeclare @@group_replication_flow_control_release_percent integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `50`, min: `0`, max: `1000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines how the group quota should be released when flow control no longer needs to throttle the writer members [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_flow_control_release_percent)]."],le=["```mysql\ndeclare @@group_replication_ip_whitelist string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `AUTOMATIC`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The list of hosts permitted to connect to the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_ip_whitelist)]."],de=["```mysql\ndeclare @@group_replication_communication_max_message_size integer\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `10485760`, min: `0`, max: `1073741824`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum message size for Group Replication communications, larger messages are fragmented [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_communication_max_message_size)]."],ce=["```mysql\ndeclare @@group_replication_message_cache_size integer\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `1073741824 (1 GB)`, min: `1073741824 (1 GB)`, max: `18446744073709551615 (16 EiB)`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum memory for the message cache in the group communication engine (XCom) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_message_cache_size)]."],_e=["```mysql\ndeclare @@group_replication_autorejoin_tries integer\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `0`, min: `0`, max: `2016`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of tries that a member makes to automatically rejoin the group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_autorejoin_tries)]."],pe=["```mysql\ndeclare @@group_replication_tls_source enumeration\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `mysql_main`, valid values:\n\n- `mysql_main`\n- `mysql_admin`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Source of TLS material for Group Replication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_replication_tls_source)]."],he=["```mysql\ndeclare @@group_replication_primary_member string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Shows the primary member's UUID when the group is operating in single-primary mode. If the group is operating in multi-primary mode, shows an empty string [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_group_replication_primary_member)]."],ye=["```mysql\ndeclare @@mysqlx enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ON`, valid values:\n\n- `ON`\n- `OFF`\n- `FORCE`\n- `FORCE_PLUS_PERMANENT`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether X Plugin is initialized [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_mysqlx)]."],ve=["```mysql\ndeclare @@mysqlx_bind_address string\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `*`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The network address X Plugin uses for connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_bind_address)]."],ue=["```mysql\ndeclare @@mysqlx_compression_algorithms set\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndefault: `deflate_stream,lz4_message,zstd_stream`, valid values:\n\n- `deflate_stream`\n- `lz4_message`\n- `zstd_stream`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compression algorithms permitted for X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_compression_algorithms)]."],be=["```mysql\ndeclare @@mysqlx_connect_timeout integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `30`, min: `1`, max: `1000000000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permitted waiting time in seconds for a connection to set up a session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_connect_timeout)]."],fe=["```mysql\ndeclare @@mysqlx_deflate_default_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `3`, min: `1`, max: `9`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default compression level for the Deflate algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_deflate_default_compression_level)]."],qe=["```mysql\ndeclare @@mysqlx_deflate_max_client_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `5`, min: `1`, max: `9`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permitted compression level for the Deflate algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_deflate_max_client_compression_level)]."],ge=["```mysql\ndeclare @@mysqlx_document_id_unique_prefix integer\n```","_**System Variable**_\n\ndefault: `0`, min: `0`, max: `65535`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use a custom prefix for document IDs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_document_id_unique_prefix)]."],Se=["```mysql\ndeclare @@mysqlx_enable_hello_notice boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls messages sent to classic MySQL protocol clients that try to connect over X Protocol [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_enable_hello_notice)]."],ze=["```mysql\ndeclare @@mysqlx_idle_worker_thread_timeout integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `60`, min: `0`, max: `3600`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Time in seconds after which idle worker threads are terminated [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_idle_worker_thread_timeout)]."],Ve=["```mysql\ndeclare @@mysqlx_interactive_timeout integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `28800`, min: `1`, max: `2147483`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for interactive clients to timeout [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_interactive_timeout)]."],Te=["```mysql\ndeclare @@mysqlx_lz4_default_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `2`, min: `0`, max: `16`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default compression level for the LZ4 algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_lz4_default_compression_level)]."],Ee=["```mysql\ndeclare @@mysqlx_lz4_max_client_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `8`, min: `0`, max: `16`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permitted compression level for the LZ4 algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_lz4_max_client_compression_level)]."],Ae=["```mysql\ndeclare @@mysqlx_max_allowed_packet integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `67108864`, min: `512`, max: `1073741824`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum size of network packets that can be received by X Plugin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_max_allowed_packet)]."],Re=["```mysql\ndeclare @@mysqlx_max_connections integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `100`, min: `1`, max: `65535`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum number of concurrent client connections X Plugin can accept [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_max_connections)]."],xe=["```mysql\ndeclare @@mysqlx_min_worker_threads integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `2`, min: `1`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Minimum number of worker threads used for handling client requests [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_min_worker_threads)]."],we=["```mysql\ndeclare @@mysqlx_port integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `33060`, min: `1`, max: `65535`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Port number on which X Plugin accepts TCP/IP connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_port)]."],Ne=["```mysql\ndeclare @@mysqlx_port_open_timeout integer\n```","_**System Variable**_ (⊕ 5.7.17)\n\ndefault: `0`, min: `0`, max: `120`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Time which the X Plugin waits when accepting connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_port_open_timeout)]."],Ce=["```mysql\ndeclare @@mysqlx_read_timeout integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `28800`, min: `30`, max: `2147483`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for blocking read operations to complete [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_read_timeout)]."],ke=["```mysql\ndeclare @@mysqlx_socket string\n```","_**System Variable**_ (⊕ 5.7.15)\n\ndefault: `/tmp/mysqlx.sock`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to the socket where X Plugin listens for connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_socket)]."],Oe=["```mysql\ndeclare @@mysqlx_ssl_ca filename\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains list of trusted SSL Certificate Authorities [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_ca)]."],Ie=["```mysql\ndeclare @@mysqlx_ssl_capath dirname\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains trusted SSL Certificate Authority certificate files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_capath)]."],Le=["```mysql\ndeclare @@mysqlx_ssl_cert filename\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 certificate [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_cert)]."],De=["```mysql\ndeclare @@mysqlx_ssl_cipher string\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible ciphers for connection encryption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_cipher)]."],Me=["```mysql\ndeclare @@mysqlx_ssl_crl filename\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains certificate revocation lists [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_crl)]."],Fe=["```mysql\ndeclare @@mysqlx_ssl_crlpath dirname\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains certificate revocation list files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_crlpath)]."],Pe=["```mysql\ndeclare @@mysqlx_ssl_key filename\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_ssl_key)]."],Be=["```mysql\ndeclare @@mysqlx_wait_timeout integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `28800`, min: `1`, max: `2147483`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for activity on a connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_wait_timeout)]."],Ue=["```mysql\ndeclare @@mysqlx_write_timeout integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `60`, min: `1`, max: `2147483`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for blocking write operations to complete [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_write_timeout)]."],He=["```mysql\ndeclare @@mysqlx_zstd_default_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `3`, min: `-131072`, max: `22`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default compression level for the zstd algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_zstd_default_compression_level)]."],We=["```mysql\ndeclare @@mysqlx_zstd_max_client_compression_level integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `11`, min: `-131072`, max: `22`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permitted compression level for the zstd algorithm on X Protocol connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysqlx_zstd_max_client_compression_level)]."],Qe=["```mysql\ndeclare @@Mysqlx_aborted_clients integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of clients that were disconnected because of an input or output timeout [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_aborted_clients)]."],je=["```mysql\ndeclare @@Mysqlx_address string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The network address X Plugin is bound to [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_address)]."],Ge=["```mysql\ndeclare @@Mysqlx_bytes_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes sent through the network, after compression if applicable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_sent)]."],Xe=["```mysql\ndeclare @@Mysqlx_bytes_received integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes received through the network, after compression if applicable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_received)]."],Ye=["```mysql\ndeclare @@Mysqlx_bytes_sent_compressed_payload integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes sent as compressed message payloads, measured after compression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_sent_compressed_payload)]."],Ke=["```mysql\ndeclare @@Mysqlx_bytes_sent_uncompressed_frame integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes sent as compressed message payloads, measured before compression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_sent_uncompressed_frame)]."],Ze=["```mysql\ndeclare @@Mysqlx_bytes_received_compressed_payload integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes received as compressed message payloads, measured before decompression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_received_compressed_payload)]."],$e=["```mysql\ndeclare @@Mysqlx_bytes_received_uncompressed_frame integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes received as compressed message payloads, measured after decompression [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_bytes_received_uncompressed_frame)]."],Je=["```mysql\ndeclare @@Mysqlx_compression_algorithm string\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The compression algorithm in use for the X Protocol connection for this session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_compression_algorithm)]."],et=["```mysql\ndeclare @@Mysqlx_compression_level string\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The compression level in use for the X Protocol connection for this session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_compression_level)]."],tt=["```mysql\ndeclare @@Mysqlx_socket string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The socket which X Plugin is listening on [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_socket)]."],nt=["```mysql\ndeclare @@Mysqlx_stmt_execute_sql integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of StmtExecute requests received for the SQL namespace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_execute_sql)]."],st=["```mysql\ndeclare @@Mysqlx_stmt_execute_xplugin integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of StmtExecute requests received for the X Plugin namespace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_execute_xplugin)]."],ot=["```mysql\ndeclare @@Mysqlx_stmt_create_collection integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of create collection statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_create_collection)]."],at=["```mysql\ndeclare @@Mysqlx_stmt_create_collection_index integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of create collection index statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_create_collection_index)]."],it=["```mysql\ndeclare @@Mysqlx_stmt_drop_collection integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of drop collection statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_drop_collection)]."],rt=["```mysql\ndeclare @@Mysqlx_stmt_drop_collection_index integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of drop collection index statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_drop_collection_index)]."],mt=["```mysql\ndeclare @@Mysqlx_stmt_ensure_collection string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of executed ensure collection admin commands; incremented on reception of Mysqlx.Sql.StmtExecute with the admin command [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_ensure_collection)]."],lt=["```mysql\ndeclare @@Mysqlx_stmt_execute_mysqlx integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Incremented on reception of each StmtExecute message with namespace set to mysqlx [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_execute_mysqlx)]."],dt=["```mysql\ndeclare @@Mysqlx_stmt_get_collection_options integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of the number of get collection options statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_get_collection_options)]."],ct=["```mysql\ndeclare @@Mysqlx_stmt_modify_collection_options integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of the number of modify collection options statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_modify_collection_options)]."],_t=["```mysql\ndeclare @@Mysqlx_stmt_list_objects integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of list object statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_list_objects)]."],pt=["```mysql\ndeclare @@Mysqlx_stmt_enable_notices integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of enable notice statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_enable_notices)]."],ht=["```mysql\ndeclare @@Mysqlx_stmt_disable_notices integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of disable notice statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_disable_notices)]."],yt=["```mysql\ndeclare @@Mysqlx_stmt_list_notices integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of list notice statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_list_notices)]."],vt=["```mysql\ndeclare @@Mysqlx_stmt_list_clients integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of list client statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_list_clients)]."],ut=["```mysql\ndeclare @@Mysqlx_stmt_kill_client integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of kill client statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_kill_client)]."],bt=["```mysql\ndeclare @@Mysqlx_stmt_ping integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of ping statements received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_stmt_ping)]."],ft=["```mysql\ndeclare @@Mysqlx_crud_insert integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of insert requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_insert)]."],qt=["```mysql\ndeclare @@Mysqlx_crud_update integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of update requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_update)]."],gt=["```mysql\ndeclare @@Mysqlx_crud_create_view integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of create view requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_create_view)]."],St=["```mysql\ndeclare @@Mysqlx_crud_drop_view integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of drop view requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_drop_view)]."],zt=["```mysql\ndeclare @@Mysqlx_crud_modify_view integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of modify view requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_modify_view)]."],Vt=["```mysql\ndeclare @@Mysqlx_crud_delete integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of delete requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_delete)]."],Tt=["```mysql\ndeclare @@Mysqlx_crud_find integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of find requests received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_crud_find)]."],Et=["```mysql\ndeclare @@Mysqlx_errors_unknown_message_type integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of unknown message types that have been received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_errors_unknown_message_type)]."],At=["```mysql\ndeclare @@Mysqlx_expect_open integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of expectation blocks opened [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_expect_open)]."],Rt=["```mysql\ndeclare @@Mysqlx_expect_close integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of expectation blocks closed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_expect_close)]."],xt=["```mysql\ndeclare @@Mysqlx_rows_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows sent back to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_rows_sent)]."],wt=["```mysql\ndeclare @@Mysqlx_notice_warning_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of warning notices sent back to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_notice_warning_sent)]."],Nt=["```mysql\ndeclare @@Mysqlx_notice_global_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of global notifications sent back to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_notice_global_sent)]."],Ct=["```mysql\ndeclare @@Mysqlx_notice_other_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of other types of notices sent back to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_notice_other_sent)]."],kt=["```mysql\ndeclare @@Mysqlx_notified_by_group_replication integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of Group Replication notifications sent to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_notified_by_group_replication)]."],Ot=["```mysql\ndeclare @@Mysqlx_prep_deallocate integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of prepared-statement-deallocate messages received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_prep_deallocate)]."],It=["```mysql\ndeclare @@Mysqlx_prep_execute integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of prepared-statement-execute messages received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_prep_execute)]."],Lt=["```mysql\ndeclare @@Mysqlx_prep_prepare integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","integer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_prep_prepare)]."],Dt=["```mysql\ndeclare @@Mysqlx_port string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The port which X Plugin is listening on [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_port)]."],Mt=["```mysql\ndeclare @@Mysqlx_ssl_cipher integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current SSL cipher (empty for non-SSL connections) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_cipher)]."],Ft=["```mysql\ndeclare @@Mysqlx_ssl_cipher_list integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A list of possible SSL ciphers (empty for non-SSL connections) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_cipher_list)]."],Pt=["```mysql\ndeclare @@Mysqlx_ssl_verify_depth integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The certificate verification depth for SSL connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_verify_depth)]."],Bt=["```mysql\ndeclare @@Mysqlx_ssl_verify_mode integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The certificate verification mode for SSL connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_verify_mode)]."],Ut=["```mysql\ndeclare @@Mysqlx_ssl_version integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The name of the protocol used for the SSL connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_version)]."],Ht=["```mysql\ndeclare @@Mysqlx_sessions integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sessions that have been opened [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions)]."],Wt=["```mysql\ndeclare @@Mysqlx_sessions_closed integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sessions that have been closed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions_closed)]."],Qt=["```mysql\ndeclare @@Mysqlx_sessions_fatal_error integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sessions that have closed with a fatal error [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions_fatal_error)]."],jt=["```mysql\ndeclare @@Mysqlx_init_error integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of errors during initialisation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_init_error)]."],Gt=["```mysql\ndeclare @@Mysqlx_sessions_accepted integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of session attempts which have been accepted [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions_accepted)]."],Xt=["```mysql\ndeclare @@Mysqlx_sessions_rejected integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of session attempts which have been rejected [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions_rejected)]."],Yt=["```mysql\ndeclare @@Mysqlx_sessions_killed integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sessions which have been killed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_sessions_killed)]."],Kt=["```mysql\ndeclare @@Mysqlx_connections_closed integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections which have been closed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_connections_closed)]."],Zt=["```mysql\ndeclare @@Mysqlx_connections_accepted integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections which have been accepted [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_connections_accepted)]."],$t=["```mysql\ndeclare @@Mysqlx_connections_rejected integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections which have been rejected [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_connections_rejected)]."],Jt=["```mysql\ndeclare @@Mysqlx_connection_accept_errors integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections which have caused accept errors [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_connection_accept_errors)]."],en=["```mysql\ndeclare @@Mysqlx_connection_errors integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections which have been closed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_connection_errors)]."],tn=["```mysql\ndeclare @@Mysqlx_cursor_close integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of cursor-close messages received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_cursor_close)]."],nn=["```mysql\ndeclare @@Mysqlx_cursor_fetch integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of cursor-fetch messages received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_cursor_fetch)]."],sn=["```mysql\ndeclare @@Mysqlx_cursor_open integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of cursor-open messages received [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_cursor_open)]."],on=["```mysql\ndeclare @@Mysqlx_worker_threads integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of worker threads available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_worker_threads)]."],an=["```mysql\ndeclare @@Mysqlx_worker_threads_active integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of worker threads currently used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_worker_threads_active)]."],rn=["```mysql\ndeclare @@Mysqlx_ssl_active integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether SSL is active [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_active)]."],mn=["```mysql\ndeclare @@Mysqlx_ssl_ctx_verify_depth integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The certificate verification depth limit currently set in ctx [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_ctx_verify_depth)]."],ln=["```mysql\ndeclare @@Mysqlx_ssl_ctx_verify_mode integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The certificate verification mode currently set in ctx [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_ctx_verify_mode)]."],dn=["```mysql\ndeclare @@Mysqlx_ssl_finished_accepts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of successful SSL connections to the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_finished_accepts)]."],cn=["```mysql\ndeclare @@Mysqlx_ssl_accepts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of accepted SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_accepts)]."],_n=["```mysql\ndeclare @@Mysqlx_ssl_server_not_after integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The last date for which the SSL certificate is valid [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_server_not_after)]."],pn=["```mysql\ndeclare @@Mysqlx_ssl_server_not_before integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The first date for which the SSL certificate is valid [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_server_not_before)]."],hn=["```mysql\ndeclare @@Mysqlx_ssl_accept_renegotiates integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of negotiates needed to establish the connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_ssl_accept_renegotiates)]."],yn=["```mysql\ndeclare @@Mysqlx_errors_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","number of errors that were sent to clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Mysqlx_errors_sent)]."],vn=["```mysql\ndeclare @@Aborted_clients integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections aborted because the client died without closing the connection properly [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Aborted_clients)]."],un=["```mysql\ndeclare @@Aborted_connects integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of failed attempts to connect to MySQL server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Aborted_connects)]."],bn=["```mysql\ndeclare @@Acl_cache_items_count integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of cached privilege objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Acl_cache_items_count)]."],fn=["```mysql\ndeclare @@activate_all_roles_on_login boolean\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to activate all user roles at connect time [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_activate_all_roles_on_login)]."],qn=["```mysql\ndeclare @@admin_address string\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","IP address to bind to for connections on administrative interface [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_address)]."],gn=["```mysql\ndeclare @@admin_port integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `33062`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","TCP/IP number to use for connections on administrative interface [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_port)]."],Sn=["```mysql\ndeclare @@admin_ssl_ca filename\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains list of trusted SSL Certificate Authorities [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_ca)]."],zn=["```mysql\ndeclare @@admin_ssl_capath dirname\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains trusted SSL Certificate Authority certificate files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_capath)]."],Vn=["```mysql\ndeclare @@admin_ssl_cert filename\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 certificate [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_cert)]."],Tn=["```mysql\ndeclare @@admin_ssl_cipher string\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible ciphers for connection encryption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_cipher)]."],En=["```mysql\ndeclare @@admin_ssl_crl filename\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains certificate revocation lists [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_crl)]."],An=["```mysql\ndeclare @@admin_ssl_crlpath dirname\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains certificate revocation list files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_crlpath)]."],Rn=["```mysql\ndeclare @@admin_ssl_key filename\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_ssl_key)]."],xn=["```mysql\ndeclare @@admin_tls_ciphersuites string\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible TLSv1.3 ciphersuites for encrypted connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_tls_ciphersuites)]."],wn=["```mysql\ndeclare @@admin_tls_version string\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndefault: `TLSv1,TLSv1.1,TLSv1.2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible TLS protocols for encrypted connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_admin_tls_version)]."],Nn=["```mysql\ndeclare @@ansi \n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use ANSI SQL syntax instead of MySQL syntax [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_ansi)]."],Cn=["```mysql\ndeclare @@audit_log_buffer_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The size of the audit log buffer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_buffer_size)]."],kn=["```mysql\ndeclare @@audit_log_compression enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NONE`, valid values:\n\n- `NONE`\n- `GZIP`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit log file compression method [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_compression)]."],On=["```mysql\ndeclare @@audit_log_connection_policy enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ALL`, valid values:\n\n- `ALL`\n- `ERRORS`\n- `NONE`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit logging policy for connection-related events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_connection_policy)]."],In=["```mysql\ndeclare @@audit_log_current_session boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `depends on filtering policy`\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to audit current session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_current_session)]."],Ln=["```mysql\ndeclare @@Audit_log_current_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit log file current size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_current_size)]."],Dn=["```mysql\ndeclare @@Audit_log_event_max_drop_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of largest dropped audited event [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_event_max_drop_size)]."],Mn=["```mysql\ndeclare @@Audit_log_events integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of handled audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_events)]."],Fn=["```mysql\ndeclare @@Audit_log_events_filtered integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of filtered audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_events_filtered)]."],Pn=["```mysql\ndeclare @@Audit_log_events_lost integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of dropped audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_events_lost)]."],Bn=["```mysql\ndeclare @@Audit_log_events_written integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of written audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_events_written)]."],Un=["```mysql\ndeclare @@audit_log_encryption enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NONE`, valid values:\n\n- `NONE`\n- `AES`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit log file encryption method [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_encryption)]."],Hn=["```mysql\ndeclare @@audit_log_exclude_accounts string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Accounts not to audit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_exclude_accounts)]."],Wn=["```mysql\ndeclare @@audit_log_file filename\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `audit.log`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The name of the audit log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_file)]."],Qn=["```mysql\ndeclare @@audit_log_filter_id integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","ID of current audit log filter [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_filter_id)]."],jn=["```mysql\ndeclare @@audit_log_flush boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Close and reopen the audit log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_flush)]."],Gn=["```mysql\ndeclare @@audit_log_format enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NEW`, valid values:\n\n- `OLD`\n- `NEW`\n- `JSON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The audit log file format [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_format)]."],Xn=["```mysql\ndeclare @@audit_log_include_accounts string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Accounts to audit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_include_accounts)]."],Yn=["```mysql\ndeclare @@audit_log_password_history_keep_days integer\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `0`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of days to keep archived audit log encryption passwords [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_password_history_keep_days)]."],Kn=["```mysql\ndeclare @@audit_log_policy enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ALL`, valid values:\n\n- `ALL`\n- `LOGINS`\n- `QUERIES`\n- `NONE`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit logging policy [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_policy)]."],Zn=["```mysql\ndeclare @@audit_log_read_buffer_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `32768`, min: `32768`, max: `4194304`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit log file read buffer size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_read_buffer_size)]."],$n=["```mysql\ndeclare @@audit_log_rotate_on_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Close and reopen the audit log file at a certain size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_rotate_on_size)]."],Jn=["```mysql\ndeclare @@audit_log_statement_policy enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ALL`, valid values:\n\n- `ALL`\n- `ERRORS`\n- `NONE`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Audit logging policy for statement-related events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_statement_policy)]."],es=["```mysql\ndeclare @@audit_log_strategy enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ASYNCHRONOUS`, valid values:\n\n- `ASYNCHRONOUS`\n- `PERFORMANCE`\n- `SEMISYNCHRONOUS`\n- `SYNCHRONOUS`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The audit logging strategy [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_audit_log_strategy)]."],ts=["```mysql\ndeclare @@Audit_log_total_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Combined size of written audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_total_size)]."],ns=["```mysql\ndeclare @@Audit_log_write_waits integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of write-delayed audited events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Audit_log_write_waits)]."],ss=["```mysql\ndeclare @@authentication_ldap_sasl_auth_method_name string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `SCRAM-SHA-1`, valid values:\n\n- `SCRAM-SHA-1`\n- `GSSAPI`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Authentication method name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_auth_method_name)]."],os=["```mysql\ndeclare @@authentication_ldap_sasl_bind_base_dn string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server base distinguished name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_bind_base_dn)]."],as=["```mysql\ndeclare @@authentication_ldap_sasl_bind_root_dn string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server root distinguished name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_bind_root_dn)]."],is=["```mysql\ndeclare @@authentication_ldap_sasl_bind_root_pwd string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server root bind password [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_bind_root_pwd)]."],rs=["```mysql\ndeclare @@authentication_ldap_sasl_ca_path string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server certificate authority file name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_ca_path)]."],ms=["```mysql\ndeclare @@authentication_ldap_sasl_group_search_attr string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `cn`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server group search attribute [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_group_search_attr)]."],ls=["```mysql\ndeclare @@authentication_ldap_sasl_group_search_filter string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `(|(&(objectClass=posixGroup)(memberUid=%s))(&(objectClass=group)(member=%s)))`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP custom group search filter [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_group_search_filter)]."],ds=["```mysql\ndeclare @@authentication_ldap_sasl_init_pool_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `10`, min: `0`, max: `32767`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server initial connection pool size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_init_pool_size)]."],cs=["```mysql\ndeclare @@authentication_ldap_sasl_log_status integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1`, min: `1`, max: `6`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server log level [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_log_status)]."],_s=["```mysql\ndeclare @@authentication_ldap_sasl_max_pool_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1000`, min: `0`, max: `32767`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server maximum connection pool size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_max_pool_size)]."],ps=["```mysql\ndeclare @@authentication_ldap_sasl_referral boolean\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable LDAP search referral [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_referral)]."],hs=["```mysql\ndeclare @@authentication_ldap_sasl_server_host string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server host name or IP address [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_server_host)]."],ys=["```mysql\ndeclare @@authentication_ldap_sasl_server_port integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `389`, min: `1`, max: `32376`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server port number [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_server_port)]."],vs=["```mysql\ndeclare @@Authentication_ldap_sasl_supported_methods string\n```","_**System Variable**_ (⊕ 8.0.21)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Supported authentication methods for SASL LDAP authentication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Authentication_ldap_sasl_supported_methods)]."],us=["```mysql\ndeclare @@authentication_ldap_sasl_tls boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use encrypted connections to LDAP server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_tls)]."],bs=["```mysql\ndeclare @@authentication_ldap_sasl_user_search_attr string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `uid`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server user search attribute [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_sasl_user_search_attr)]."],fs=["```mysql\ndeclare @@authentication_ldap_simple_auth_method_name string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `SIMPLE`, valid values:\n\n- `SIMPLE`\n- `AD-FOREST`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Authentication method name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_auth_method_name)]."],qs=["```mysql\ndeclare @@authentication_ldap_simple_bind_base_dn string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server base distinguished name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_bind_base_dn)]."],gs=["```mysql\ndeclare @@authentication_ldap_simple_bind_root_dn string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server root distinguished name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_bind_root_dn)]."],Ss=["```mysql\ndeclare @@authentication_ldap_simple_bind_root_pwd string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server root bind password [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_bind_root_pwd)]."],zs=["```mysql\ndeclare @@authentication_ldap_simple_ca_path string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server certificate authority file name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_ca_path)]."],Vs=["```mysql\ndeclare @@authentication_ldap_simple_group_search_attr string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `cn`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server group search attribute [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_group_search_attr)]."],Ts=["```mysql\ndeclare @@authentication_ldap_simple_group_search_filter string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `(|(&(objectClass=posixGroup)(memberUid=%s))(&(objectClass=group)(member=%s)))`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP custom group search filter [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_group_search_filter)]."],Es=["```mysql\ndeclare @@authentication_ldap_simple_init_pool_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `10`, min: `0`, max: `32767`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server initial connection pool size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_init_pool_size)]."],As=["```mysql\ndeclare @@authentication_ldap_simple_log_status integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1`, min: `1`, max: `6`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server log level [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_log_status)]."],Rs=["```mysql\ndeclare @@authentication_ldap_simple_max_pool_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1000`, min: `0`, max: `32767`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server maximum connection pool size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_max_pool_size)]."],xs=["```mysql\ndeclare @@authentication_ldap_simple_referral boolean\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable LDAP search referral [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_referral)]."],ws=["```mysql\ndeclare @@authentication_ldap_simple_server_host string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server host name or IP address [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_server_host)]."],Ns=["```mysql\ndeclare @@authentication_ldap_simple_server_port integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `389`, min: `1`, max: `32376`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server port number [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_server_port)]."],Cs=["```mysql\ndeclare @@authentication_ldap_simple_tls boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use encrypted connections to LDAP server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_tls)]."],ks=["```mysql\ndeclare @@authentication_ldap_simple_user_search_attr string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `uid`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","LDAP server user search attribute [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_ldap_simple_user_search_attr)]."],Os=["```mysql\ndeclare @@authentication_windows_log_level integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `2`, min: `0`, max: `4`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Windows authentication plugin logging level [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_windows_log_level)]."],Is=["```mysql\ndeclare @@authentication_windows_use_principal_name boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use Windows authentication plugin principal name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_authentication_windows_use_principal_name)]."],Ls=["```mysql\ndeclare @@auto_generate_certs boolean\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to autogenerate SSL key and certificate files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_auto_generate_certs)]."],Ds=["```mysql\ndeclare @@auto_increment_increment integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndefault: `1`, min: `1`, max: `65535`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","AUTO_INCREMENT columns are incremented by this value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_auto_increment_increment)]."],Ms=["```mysql\ndeclare @@auto_increment_offset integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndefault: `1`, min: `1`, max: `65535`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Offset added to AUTO_INCREMENT columns [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_auto_increment_offset)]."],Fs=["```mysql\ndeclare @@autocommit boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the autocommit mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_autocommit)]."],Ps=["```mysql\ndeclare @@automatic_sp_privileges boolean\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Creating and dropping stored procedures alters ACLs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_automatic_sp_privileges)]."],Bs=["```mysql\ndeclare @@avoid_temporal_upgrade boolean\n```","_**System Variable**_ (⊕ 5.7.6, ⊘ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether ALTER TABLE should upgrade pre-5.6.4 temporal columns [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_avoid_temporal_upgrade)]."],Us=["```mysql\ndeclare @@back_log integer\n```","_**System Variable**_\n\ndefault: `-1`, min: `1`, max: `65535`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of outstanding connection requests MySQL can have [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_back_log)]."],Hs=["```mysql\ndeclare @@backup_elevation boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable BACKUP DATABASE privilege elevation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_elevation)]."],Ws=["```mysql\ndeclare @@backup_history_log boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable MySQL Backup history log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_history_log)]."],Qs=["```mysql\ndeclare @@backup_history_log_file filename\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `backup_history.log`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of the MySQL Backup history log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_history_log_file)]."],js=["```mysql\ndeclare @@backup_progress_log boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable MySQL Backup progress log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_progress_log)]."],Gs=["```mysql\ndeclare @@backup_progress_log_file filename\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `backup_progress.log`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of the MySQL Backup progress log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_progress_log_file)]."],Xs=["```mysql\ndeclare @@backup_wait_timeout integer\n```","_**System Variable**_ (⊕ 6.0.7)\n\ndefault: `50`, min: `0`, max: `2147483`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backup_wait_timeout)]."],Ys=["```mysql\ndeclare @@backupdir dirname\n```","_**System Variable**_ (⊕ 6.0.7)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default backup image file directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_backupdir)]."],Ks=["```mysql\ndeclare @@basedir dirname\n```","_**System Variable**_\n\ndefault: `parent of mysqld installation directory`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path of installation directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_basedir)]."],Zs=["```mysql\ndeclare @@big_tables boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allow big result sets by saving all temporary sets on file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_big_tables)]."],$s=["```mysql\ndeclare @@bind_address string\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndefault: `*`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","IP address or host name to bind to [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_bind_address)]."],Js=["```mysql\ndeclare @@binlog_format enumeration\n```","_**System Variable**_ (⊕ 5.1.5)\n\ndefault: `ROW`, valid values:\n\n- `ROW`\n- `STATEMENT`\n- `MIXED`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the format of the binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_format)]."],eo=["```mysql\ndeclare @@binlog_encryption boolean\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable encryption for binary log files and relay log files on this server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_encryption)]."],to=["```mysql\ndeclare @@binlog_rotate_encryption_master_key_at_startup boolean\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Rotate the binary log master key at server startup [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_rotate_encryption_master_key_at_startup)]."],no=["```mysql\ndeclare @@Binlog_cache_disk_use integer\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions that used a temporary file instead of the binary log cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Binlog_cache_disk_use)]."],so=["```mysql\ndeclare @@binlog_cache_size integer\n```","_**System Variable**_\n\ndefault: `32768`, min: `4096`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the cache to hold the SQL statements for the binary log during a transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_cache_size)]."],oo=["```mysql\ndeclare @@Binlog_cache_use integer\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions that used the temporary binary log cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Binlog_cache_use)]."],ao=["```mysql\ndeclare @@binlog_checksum string\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `CRC32`, valid values:\n\n- `NONE`\n- `CRC32`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable/disable binary log checksums [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_checksum)]."],io=["```mysql\ndeclare @@binlog_direct_non_transactional_updates boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_direct_non_transactional_updates)]."],ro=["```mysql\ndeclare @@binlog_error_action enumeration\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `ABORT_SERVER`, valid values:\n\n- `IGNORE_ERROR`\n- `ABORT_SERVER`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls what happens when the server cannot write to the binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_error_action)]."],mo=["```mysql\ndeclare @@binlog_expire_logs_seconds integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `2592000`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Purge binary logs after this many seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_expire_logs_seconds)]."],lo=["```mysql\ndeclare @@binlog_group_commit_sync_delay integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the number of microseconds to wait before synchronizing transactions to disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_group_commit_sync_delay)]."],co=["```mysql\ndeclare @@binlog_group_commit_sync_no_delay_count integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the maximum number of transactions to wait for before aborting the current delay specified by binlog_group_commit_sync_delay [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_group_commit_sync_no_delay_count)]."],_o=["```mysql\ndeclare @@binlog_gtid_simple_recovery boolean\n```","_**System Variable**_ (⊕ 5.6.23)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls how binary logs are iterated during GTID recovery [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_gtid_simple_recovery)]."],po=["```mysql\ndeclare @@binlog_max_flush_queue_time integer\n```","_**System Variable**_ (⊕ 5.6.6, ⊘ 5.7.9)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How long to read transactions before flushing to binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_max_flush_queue_time)]."],ho=["```mysql\ndeclare @@binlog_order_commits boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to commit in same order as writes to binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_order_commits)]."],yo=["```mysql\ndeclare @@binlog_row_image enumeration\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `full`, valid values:\n\n- `full`\n- `minimal`\n- `noblob`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use full or minimal images when logging row changes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_row_image)]."],vo=["```mysql\ndeclare @@binlog_row_metadata enumeration\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `MINIMAL`, valid values:\n\n- `FULL`\n- `MINIMAL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Configures the amount of table related metadata binary logged when using row-based logging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_row_metadata)]."],uo=["```mysql\ndeclare @@binlog_row_value_options set\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `''`, valid values:\n\n- `PARTIAL_JSON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables binary logging of partial JSON updates for row-based replication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_row_value_options)]."],bo=["```mysql\ndeclare @@binlog_rows_query_log_events boolean\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When enabled, enables logging of rows query log events when using row-based logging. Disabled by default. Do not enable when producing logs for pre-5.6 slaves/readers [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_rows_query_log_events)]."],fo=["```mysql\ndeclare @@Binlog_stmt_cache_disk_use integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of nontransactional statements that used a temporary file instead of the binary log statement cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Binlog_stmt_cache_disk_use)]."],qo=["```mysql\ndeclare @@binlog_stmt_cache_size integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndefault: `32768`, min: `4096`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the cache to hold nontransactional statements for the binary log during a transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_stmt_cache_size)]."],go=["```mysql\ndeclare @@Binlog_stmt_cache_use integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements that used the temporary binary log statement cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Binlog_stmt_cache_use)]."],So=["```mysql\ndeclare @@binlog_transaction_compression boolean\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable compression for transaction payloads in binary log files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_transaction_compression)]."],zo=["```mysql\ndeclare @@binlog_transaction_compression_level_zstd integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `3`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compression level for transaction payloads in binary log files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_transaction_compression_level_zstd)]."],Vo=["```mysql\ndeclare @@binlog_transaction_dependency_tracking enumeration\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `COMMIT_ORDER`, valid values:\n\n- `COMMIT_ORDER`\n- `WRITESET`\n- `WRITESET_SESSION`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Source of dependency information (commit timestamps or transaction write sets) from which to assess which transactions can be executed in parallel by slave's multithreaded applier [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_transaction_dependency_tracking)]."],To=["```mysql\ndeclare @@binlog_transaction_dependency_history_size integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `25000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of row hashes kept for looking up transaction that last updated some row [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlog_transaction_dependency_history_size)]."],Eo=["```mysql\ndeclare @@binlogging_impossible_mode enumeration\n```","_**System Variable**_ (⊕ 5.7.5, ⊘ 5.6.22, ⊗ 5.7.6)\n\ndefault: `IGNORE_ERROR`, valid values:\n\n- `IGNORE_ERROR`\n- `ABORT_SERVER`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Deprecated and later removed. Use binlog_error_action instead [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_binlogging_impossible_mode)]."],Ao=["```mysql\ndeclare @@block_encryption_mode string\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `aes-128-ecb`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Mode for block-based encryption algorithms [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_block_encryption_mode)]."],Ro=["```mysql\ndeclare @@bootstrap \n```","_**System Variable**_ (⊘ 5.7.6, ⊗ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used by mysql installation scripts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_bootstrap)]."],xo=["```mysql\ndeclare @@bulk_insert_buffer_size integer\n```","_**System Variable**_\n\ndefault: `8388608`, min: `0`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Size of tree cache used in bulk insert optimization [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_bulk_insert_buffer_size)]."],wo=["```mysql\ndeclare @@Bytes_received integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes received from all clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Bytes_received)]."],No=["```mysql\ndeclare @@Bytes_sent integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes sent to all clients [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Bytes_sent)]."],Co=["```mysql\ndeclare @@caching_sha2_password_auto_generate_rsa_keys boolean\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to autogenerate RSA key-pair files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_caching_sha2_password_auto_generate_rsa_keys)]."],ko=["```mysql\ndeclare @@caching_sha2_password_private_key_path filename\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `private_key.pem`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SHA2 authentication plugin private key path name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_caching_sha2_password_private_key_path)]."],Oo=["```mysql\ndeclare @@caching_sha2_password_public_key_path filename\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `public_key.pem`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SHA2 authentication plugin public key path name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_caching_sha2_password_public_key_path)]."],Io=["```mysql\ndeclare @@Caching_sha2_password_rsa_public_key string\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","caching_sha2_password authentication plugin RSA public key value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Caching_sha2_password_rsa_public_key)]."],Lo=["```mysql\ndeclare @@character_set_filesystem string\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `binary`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set the file system character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_filesystem)]."],Do=["```mysql\ndeclare @@character_set_server string\n```","_**System Variable**_ (⊕ 4.1.3)\n\ndefault: `utf8mb4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specify default character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_server)]."],Mo=["```mysql\ndeclare @@character_sets_dir dirname\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory where character sets are installed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_sets_dir)]."],Fo=["```mysql\ndeclare @@character_set string\n```","_**System Variable**_ (⊘ 4.1.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set)]."],Po=["```mysql\ndeclare @@character_set_client string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current client character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_client)]."],Bo=["```mysql\ndeclare @@character_set_connection string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current connection character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_connection)]."],Uo=["```mysql\ndeclare @@character_set_database string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The character set used by the default database [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_database)].\n\n> This option is dynamic, but only the server should set this information. You should not set the value of this variable manually."],Ho=["```mysql\ndeclare @@character_set_results string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current result character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_results)]."],Wo=["```mysql\ndeclare @@character_set_system string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The character set used by the server for storing identifiers [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_system)]."],Qo=["```mysql\ndeclare @@check_proxy_users boolean\n```","_**System Variable**_ (⊕ 5.7.7)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether built-in authentication plugins do proxying [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_check_proxy_users)]."],jo=["```mysql\ndeclare @@chroot dirname\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Chroot mysqld daemon during startup [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_chroot)]."],Go=["```mysql\ndeclare @@collation_server string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4_0900_ai_ci`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specify default collation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_server)]."],Xo=["```mysql\ndeclare @@collation_connection string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The collation of the connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_connection)]."],Yo=["```mysql\ndeclare @@collation_database string\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `utf8mb4_0900_ai_ci`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The collation used by the default database [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_database)].\n\n> This option is dynamic, but only the server should set this information. You should not set the value of this variable manually."],Ko=["```mysql\ndeclare @@Com_admin_commands integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of admin statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Zo=["```mysql\ndeclare @@Com_alter_db integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],$o=["```mysql\ndeclare @@Com_alter_db_upgrade integer\n```","_**System Variable**_ (⊗ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER DATABASE ... UPGRADE DATA DIRECTORY NAME statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Jo=["```mysql\ndeclare @@Com_alter_event integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count for ALTER EVENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ea=["```mysql\ndeclare @@Com_alter_function integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER FUNCTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ta=["```mysql\ndeclare @@Com_alter_procedure integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER PROCEDURE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],na=["```mysql\ndeclare @@Com_alter_resource_group integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER RESOURCE GROUP statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],sa=["```mysql\ndeclare @@Com_alter_server integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER SERVER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],oa=["```mysql\ndeclare @@Com_alter_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],aa=["```mysql\ndeclare @@Com_alter_tablespace integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER TABLESPACE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ia=["```mysql\ndeclare @@Com_alter_user integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER USER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ra=["```mysql\ndeclare @@Com_alter_user_default_role integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ALTER USER ... DEFAULT ROLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ma=["```mysql\ndeclare @@Com_analyze integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ANALYZE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],la=["```mysql\ndeclare @@Com_assign_to_keycache integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CACHE INDEX statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],da=["```mysql\ndeclare @@Com_backup integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of BACKUP DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ca=["```mysql\ndeclare @@Com_backup_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of BACKUP TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],_a=["```mysql\ndeclare @@Com_begin integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of BEGIN statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],pa=["```mysql\ndeclare @@Com_binlog integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of BINLOG statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ha=["```mysql\ndeclare @@Com_call_procedure integer\n```","_**System Variable**_ (⊕ 5.1.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of calls to stored procedures [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ya=["```mysql\ndeclare @@Com_change_db integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CHANGE DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],va=["```mysql\ndeclare @@Com_change_master integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CHANGE MASTER TO statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ua=["```mysql\ndeclare @@Com_change_repl_filter integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CHANGE REPLICATION FILTER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ba=["```mysql\ndeclare @@Com_check integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CHECK statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],fa=["```mysql\ndeclare @@Com_checksum integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CHECKSUM statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],qa=["```mysql\ndeclare @@Com_clone integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CLONE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ga=["```mysql\ndeclare @@Com_commit integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of COMMIT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Sa=["```mysql\ndeclare @@Com_create_db integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],za=["```mysql\ndeclare @@Com_create_event integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE EVENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Va=["```mysql\ndeclare @@Com_create_function integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE FUNCTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ta=["```mysql\ndeclare @@Com_create_index integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE INDEX statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ea=["```mysql\ndeclare @@Com_create_procedure integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE PROCEDURE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Aa=["```mysql\ndeclare @@Com_create_resource_group integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE RESOURCE GROUP statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ra=["```mysql\ndeclare @@Com_drop_resource_group integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP RESOURCE GROUP statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],xa=["```mysql\ndeclare @@Com_set_resource_group integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SET RESOURCE GROUP statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],wa=["```mysql\ndeclare @@Com_create_role integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE ROLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Na=["```mysql\ndeclare @@Com_create_server integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE SERVER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ca=["```mysql\ndeclare @@Com_create_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ka=["```mysql\ndeclare @@Com_create_trigger integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE TRIGGER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Oa=["```mysql\ndeclare @@Com_create_udf integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE FUNCTION (UDF) statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ia=["```mysql\ndeclare @@Com_create_user integer\n```","_**System Variable**_ (⊕ 5.0.30)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE USER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],La=["```mysql\ndeclare @@Com_create_view integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of CREATE VIEW statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Da=["```mysql\ndeclare @@Com_dealloc_sql integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DEALLOCATE PREPARE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ma=["```mysql\ndeclare @@Com_delete integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DELETE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Fa=["```mysql\ndeclare @@Com_delete_multi integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of multiple table DELETE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Pa=["```mysql\ndeclare @@Com_do integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DO statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ba=["```mysql\ndeclare @@Com_drop_db integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ua=["```mysql\ndeclare @@Com_drop_event integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP EVENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ha=["```mysql\ndeclare @@Com_drop_function integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP FUNCTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Wa=["```mysql\ndeclare @@Com_drop_index integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP INDEX statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Qa=["```mysql\ndeclare @@Com_drop_procedure integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP PROCEDURE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ja=["```mysql\ndeclare @@Com_drop_role integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP ROLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ga=["```mysql\ndeclare @@Com_drop_server integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP SERVER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Xa=["```mysql\ndeclare @@Com_drop_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ya=["```mysql\ndeclare @@Com_drop_trigger integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP TRIGGER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ka=["```mysql\ndeclare @@Com_drop_user integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP USER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Za=["```mysql\ndeclare @@Com_drop_view integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of DROP_VIEW statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],$a=["```mysql\ndeclare @@Com_empty_query integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of empty statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ja=["```mysql\ndeclare @@Com_execute_sql integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of EXECUTE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ei=["```mysql\ndeclare @@Com_explain_other integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of EXPLAIN FOR CONNECTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ti=["```mysql\ndeclare @@Com_flush integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of FLUSH statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ni=["```mysql\ndeclare @@Com_get_diagnostics integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of GET DIAGNOSTICS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],si=["```mysql\ndeclare @@Com_grant integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of GRANT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],oi=["```mysql\ndeclare @@Com_grant_roles integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of GRANT ROLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ai=["```mysql\ndeclare @@Com_group_replication_start integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of START GROUP_REPLICATION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ii=["```mysql\ndeclare @@Com_group_replication_stop integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STOP GROUP_REPLICATION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ri=["```mysql\ndeclare @@Com_ha_close integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of HANDLER CLOSE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],mi=["```mysql\ndeclare @@Com_ha_open integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of HANDLER OPEN statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],li=["```mysql\ndeclare @@Com_ha_read integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of HANDLER READ statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],di=["```mysql\ndeclare @@Com_help integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of HELP statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ci=["```mysql\ndeclare @@Com_insert integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of INSERT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],_i=["```mysql\ndeclare @@Com_insert_select integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of INSERT SELECT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],pi=["```mysql\ndeclare @@Com_install_component integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of INSTALL COMPONENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],hi=["```mysql\ndeclare @@Com_install_plugin integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of INSTALL PLUGIN statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],yi=["```mysql\ndeclare @@Com_kill integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of KILL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],vi=["```mysql\ndeclare @@Com_load integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of LOAD statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ui=["```mysql\ndeclare @@Com_load_master_data integer\n```","_**System Variable**_ (⊘ 4.1.22)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of LOAD MASTER DATA statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],bi=["```mysql\ndeclare @@Com_load_master_table integer\n```","_**System Variable**_ (⊘ 4.1.22)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of LOAD MASTER TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],fi=["```mysql\ndeclare @@Com_lock_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of LOCK TABLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],qi=["```mysql\ndeclare @@Com_optimize integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of OPTIMIZE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],gi=["```mysql\ndeclare @@Com_preload_keys integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of PRELOAD KEYS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Si=["```mysql\ndeclare @@Com_prepare_sql integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of PREPARE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],zi=["```mysql\ndeclare @@Com_purge integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of PURGE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Vi=["```mysql\ndeclare @@Com_purge_before_date integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of PURGE BEFORE DATE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ti=["```mysql\ndeclare @@Com_purge_bup_log integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of PURGE BACKUP LOG statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ei=["```mysql\ndeclare @@Com_release_savepoint integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RELEASE SAVEPOINT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ai=["```mysql\ndeclare @@Com_rename_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RENAME TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ri=["```mysql\ndeclare @@Com_rename_user integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RENAME USER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],xi=["```mysql\ndeclare @@Com_repair integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REPAIR statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],wi=["```mysql\ndeclare @@Com_replace integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REPLACE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ni=["```mysql\ndeclare @@Com_replace_select integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REPLACE SELECT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ci=["```mysql\ndeclare @@Com_reset integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RESET statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ki=["```mysql\ndeclare @@Com_resignal integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RESIGNAL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Oi=["```mysql\ndeclare @@Com_restart integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RESTART statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ii=["```mysql\ndeclare @@Com_restore integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RESTORE DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Li=["```mysql\ndeclare @@Com_restore_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of RESTORE TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Di=["```mysql\ndeclare @@Com_revoke integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REVOKE statements that revoke roles [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Mi=["```mysql\ndeclare @@Com_revoke_all integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REVOKE ALL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Fi=["```mysql\ndeclare @@Com_revoke_roles integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of REVOKE ROLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Pi=["```mysql\ndeclare @@Com_rollback integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ROLLBACK statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Bi=["```mysql\ndeclare @@Com_rollback_to_savepoint integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of ROLLBACK TO SAVEPOINT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ui=["```mysql\ndeclare @@Com_savepoint integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SAVEPOINT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Hi=["```mysql\ndeclare @@Com_select integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SELECT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Wi=["```mysql\ndeclare @@Com_set_option integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SET OPTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Qi=["```mysql\ndeclare @@Com_set_role integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SET ROLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ji=["```mysql\ndeclare @@Com_show_authors integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW AUTHORS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Gi=["```mysql\ndeclare @@Com_show_binlog_events integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW BINLOG EVENTS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Xi=["```mysql\ndeclare @@Com_show_binlogs integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW BINLOGS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Yi=["```mysql\ndeclare @@Com_show_charsets integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CHARSET statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ki=["```mysql\ndeclare @@Com_show_collations integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW COLLATION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Zi=["```mysql\ndeclare @@Com_show_column_types integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW COLUMN TYPES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],$i=["```mysql\ndeclare @@Com_show_contributors integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CONTRIBUTORS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ji=["```mysql\ndeclare @@Com_show_create_db integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],er=["```mysql\ndeclare @@Com_show_create_event integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE EVENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],tr=["```mysql\ndeclare @@Com_show_create_func integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE FUNCTION statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],nr=["```mysql\ndeclare @@Com_show_create_proc integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE PROCEDURE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],sr=["```mysql\ndeclare @@Com_show_create_table integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE TABLE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],or=["```mysql\ndeclare @@Com_show_create_trigger integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE TRIGGER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ar=["```mysql\ndeclare @@Com_show_create_user integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW CREATE USER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ir=["```mysql\ndeclare @@Com_show_databases integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW DATABASES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],rr=["```mysql\ndeclare @@Com_show_engine_logs integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW ENGINE LOGS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],mr=["```mysql\ndeclare @@Com_show_engine_mutex integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW ENGINE MUTEX statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],lr=["```mysql\ndeclare @@Com_show_engine_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW ENGINE STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],dr=["```mysql\ndeclare @@Com_show_errors integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW ERRORS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],cr=["```mysql\ndeclare @@Com_show_events integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW EVENTS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],_r=["```mysql\ndeclare @@Com_show_fields integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW FIELDS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],pr=["```mysql\ndeclare @@Com_show_function_code integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW FUNCTION CODE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],hr=["```mysql\ndeclare @@Com_show_function_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW FUNCTION STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],yr=["```mysql\ndeclare @@Com_show_grants integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW GRANTS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],vr=["```mysql\ndeclare @@Com_show_innodb_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW INNODB STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],ur=["```mysql\ndeclare @@Com_show_keys integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW KEYS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],br=["```mysql\ndeclare @@Com_show_logs integer\n```","_**System Variable**_ (⊗ 5.1.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW LOGS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],fr=["```mysql\ndeclare @@Com_show_master_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW MASTER STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],qr=["```mysql\ndeclare @@Com_show_ndb_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW NDB STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],gr=["```mysql\ndeclare @@Com_show_new_master integer\n```","_**System Variable**_ (⊗ 5.6.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW NEW MASTER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],Sr=["```mysql\ndeclare @@Com_show_open_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW OPEN TABLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],zr=["```mysql\ndeclare @@Com_show_plugins integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PLUGINS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Vr=["```mysql\ndeclare @@Com_show_privileges integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PRIVILEGES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Tr=["```mysql\ndeclare @@Com_show_procedure_code integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PROCEDURE CODE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Er=["```mysql\ndeclare @@Com_show_procedure_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PROCEDURE STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ar=["```mysql\ndeclare @@Com_show_processlist integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PROCESSLIST statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Rr=["```mysql\ndeclare @@Com_show_profile integer\n```","_**System Variable**_ (⊕ 6.0.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PROFILE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],xr=["```mysql\ndeclare @@Com_show_profiles integer\n```","_**System Variable**_ (⊕ 6.0.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW PROFILES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],wr=["```mysql\ndeclare @@Com_show_relaylog_events integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW RELAYLOG EVENTS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Nr=["```mysql\ndeclare @@Com_show_slave_hosts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW SLAVE HOSTS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Cr=["```mysql\ndeclare @@Com_show_slave_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW SLAVE STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],kr=["```mysql\ndeclare @@Com_show_slave_status_nonblocking integer\n```","_**System Variable**_ (⊕ 5.7.0, ⊗ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW SLAVE STATUS NONBLOCKING statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],Or=["```mysql\ndeclare @@Com_show_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ir=["```mysql\ndeclare @@Com_show_storage_engines integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW STORAGE ENGINES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Lr=["```mysql\ndeclare @@Com_show_table_status integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW TABLE STATUS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Dr=["```mysql\ndeclare @@Com_show_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW TABLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Mr=["```mysql\ndeclare @@Com_show_triggers integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW TRIGGERS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Fr=["```mysql\ndeclare @@Com_show_variables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW VARIABLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Pr=["```mysql\ndeclare @@Com_show_warnings integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHOW WARNINGS statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Br=["```mysql\ndeclare @@Com_shutdown integer\n```","_**System Variable**_ (⊕ 5.7.9)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SHUTDOWN statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Ur=["```mysql\ndeclare @@Com_signal integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of SIGNAL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Hr=["```mysql\ndeclare @@Com_slave_start integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of START SLAVE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Wr=["```mysql\ndeclare @@Com_slave_stop integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STOP SLAVE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Qr=["```mysql\ndeclare @@Com_stmt_close integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT CLOSE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],jr=["```mysql\ndeclare @@Com_stmt_execute integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT EXECUTE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Gr=["```mysql\ndeclare @@Com_stmt_fetch integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT FETCH statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Xr=["```mysql\ndeclare @@Com_stmt_prepare integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT PREPARE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Yr=["```mysql\ndeclare @@Com_stmt_reprepare integer\n```","_**System Variable**_ (⊕ 6.0.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of automatic repreparations of prepared statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Kr=["```mysql\ndeclare @@Com_stmt_reset integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT RESET statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Zr=["```mysql\ndeclare @@Com_stmt_send_long_data integer\n```","_**System Variable**_ (⊕ 5.0.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of STATEMENT SEND LONG DATA statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],$r=["```mysql\ndeclare @@Com_truncate integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of TRUNCATE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],Jr=["```mysql\ndeclare @@Com_uninstall_component integer\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of UINSTALL COMPONENT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],em=["```mysql\ndeclare @@Com_uninstall_plugin integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of UNINSTALL PLUGIN statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],tm=["```mysql\ndeclare @@Com_unlock_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of UNLOCK TABLES statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],nm=["```mysql\ndeclare @@Com_update integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of UPDATE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],sm=["```mysql\ndeclare @@Com_update_multi integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of multiple UPDATE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],om=["```mysql\ndeclare @@Com_xa_commit integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA COMMIT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],am=["```mysql\ndeclare @@Com_xa_end integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA END statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],im=["```mysql\ndeclare @@Com_xa_prepare integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA PREPARE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],rm=["```mysql\ndeclare @@Com_xa_recover integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA RECOVER statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],mm=["```mysql\ndeclare @@Com_xa_rollback integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA ROLLBACK statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],lm=["```mysql\ndeclare @@Com_xa_start integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of XA START statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Com_xxx)]."],dm=["```mysql\ndeclare @@completion_type enumeration\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `NO_CHAIN`, valid values:\n\n- `NO_CHAIN`\n- `CHAIN`\n- `RELEASE`\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default completion type [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_completion_type)]."],cm=["```mysql\ndeclare @@Compression integer\n```","_**System Variable**_ (⊕ 5.0.16, ⊘ 8.0.18)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the client connection uses compression in the client/server protocol [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Compression)]."],_m=["```mysql\ndeclare @@Compression_algorithm string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compression algorithm for current connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Compression_algorithm)]."],pm=["```mysql\ndeclare @@Compression_level integer\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compression level for current connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Compression_level)]."],hm=["```mysql\ndeclare @@concurrent_insert enumeration\n```","_**System Variable**_\n\ndefault: `AUTO`, valid values:\n\n- `NEVER`\n- `AUTO`\n- `ALWAYS`\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control ability to select and insert at same time with MyISAM tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_concurrent_insert)]."],ym=["```mysql\ndeclare @@Connection_control_delay_generated integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many times the server delayed a connection request [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_control_delay_generated)]."],vm=["```mysql\ndeclare @@connection_control_failed_connections_threshold integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `3`, min: `0`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Consecutive failed connection attempts before delays occur [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connection_control_failed_connections_threshold)]."],um=["```mysql\ndeclare @@connection_control_max_connection_delay integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `2147483647`, min: `1000`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum delay (milliseconds) for server response to failed connection attempts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connection_control_max_connection_delay)]."],bm=["```mysql\ndeclare @@connection_control_min_connection_delay integer\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `1000`, min: `1000`, max: `2147483647`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Minimum delay (milliseconds) for server response to failed connection attempts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connection_control_min_connection_delay)]."],fm=["```mysql\ndeclare @@connect_timeout integer\n```","_**System Variable**_\n\ndefault: `10`, min: `2`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake' [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_connect_timeout)]."],qm=["```mysql\ndeclare @@Connection_errors_accept integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of errors calling accept on the listening port [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_accept)]."],gm=["```mysql\ndeclare @@Connection_errors_internal integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections refused due to internal errors [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_internal)]."],Sm=["```mysql\ndeclare @@Connection_errors_max_connections integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections refused due to the max_connections limit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_max_connections)]."],zm=["```mysql\ndeclare @@Connection_errors_peer_address integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of errors searching for connection client IP addresses [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_peer_address)]."],Vm=["```mysql\ndeclare @@Connection_errors_select integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of errors calling select/poll on the listening port [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_select)]."],Tm=["```mysql\ndeclare @@Connection_errors_tcpwrap integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections refused by libwrap [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connection_errors_tcpwrap)]."],Em=["```mysql\ndeclare @@Connections integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connection attempts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Connections)]."],Am=["```mysql\ndeclare @@platforms boolean\n```","_**System Variable**_ (⊕ 5.5.3)\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable support for super large pages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_super-large-pages)]."],Rm=["```mysql\ndeclare @@core_file boolean\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Write core file on server crashes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_core_file)]."],xm=["```mysql\ndeclare @@Created_tmp_disk_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of temporary tables on disk created automatically by the server while executing statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Created_tmp_disk_tables)]."],wm=["```mysql\ndeclare @@Created_tmp_files integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many temporary files mysqld has created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Created_tmp_files)]."],Nm=["```mysql\ndeclare @@Created_tmp_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many temporary tables mysqld has created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Created_tmp_tables)]."],Cm=["```mysql\ndeclare @@create_admin_listener_thread boolean\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use dedicated listening thread for connections on administrative interface [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_create_admin_listener_thread)]."],km=["```mysql\ndeclare @@create_old_temporals boolean\n```","_**System Variable**_ (⊕ 5.6.25-ndb-7.4.7, ⊘ 5.6.25-ndb-7.4.7, ⊗ 5.7.0)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use pre-5.6.4 storage format for temporal types when creating tables. Intended for use in replication and upgrades/downgrades between NDB 7.2 and NDB 7.3/7.4 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_create_old_temporals)]."],Om=["```mysql\ndeclare @@cte_max_recursion_depth integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `1000`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Common table expression maximum recursion depth [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_cte_max_recursion_depth)]."],Im=["```mysql\ndeclare @@Current_tls_ca filename\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_ca system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_ca)]."],Lm=["```mysql\ndeclare @@Current_tls_capath dirname\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_capath system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_capath)]."],Dm=["```mysql\ndeclare @@Current_tls_cert filename\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_cert system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_cert)]."],Mm=["```mysql\ndeclare @@Current_tls_cipher string\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_cipher system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_cipher)]."],Fm=["```mysql\ndeclare @@Current_tls_ciphersuites string\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of tsl_ciphersuites system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_ciphersuites)]."],Pm=["```mysql\ndeclare @@Current_tls_crl filename\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_crl system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_crl)]."],Bm=["```mysql\ndeclare @@Current_tls_crlpath dirname\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_crlpath system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_crlpath)]."],Um=["```mysql\ndeclare @@Current_tls_key filename\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of ssl_key system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_key)]."],Hm=["```mysql\ndeclare @@Current_tls_version string\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Current value of tls_version system variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Current_tls_version)]."],Wm=["```mysql\ndeclare @@daemon_memcached_enable_binlog boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","undefined [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_enable_binlog)]."],Qm=["```mysql\ndeclare @@daemon_memcached_engine_lib_name filename\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `innodb_engine.so`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the shared library that implements the InnoDB memcached plugin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_engine_lib_name)]."],jm=["```mysql\ndeclare @@daemon_memcached_engine_lib_path dirname\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains the shared library that implements the InnoDB memcached plugin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_engine_lib_path)]."],Gm=["```mysql\ndeclare @@daemon_memcached_option string\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Space-separated options that are passed to the underlying memcached daemon on startup [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_option)]."],Xm=["```mysql\ndeclare @@daemon_memcached_r_batch_size integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_r_batch_size)]."],Ym=["```mysql\ndeclare @@daemon_memcached_w_batch_size integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_daemon_memcached_w_batch_size)]."],Km=["```mysql\ndeclare @@daemonize boolean\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Run as System V daemon [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_daemonize)]."],Zm=["```mysql\ndeclare @@datadir dirname\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path of data directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_datadir)]."],$m=["```mysql\ndeclare @@date_format string\n```","_**System Variable**_ (⊗ 8.0.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The DATE format (unused) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_date_format)]."],Jm=["```mysql\ndeclare @@datetime_format string\n```","_**System Variable**_ (⊗ 8.0.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The DATETIME/TIMESTAMP format (unused) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_datetime_format)]."],el=["```mysql\ndeclare @@debug string\n```","_**System Variable**_\n\ndefault: `d:t:i:O,\\mysqld.trace`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Output debug log; supported only if MySQL was built with debugging support [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_debug)]."],tl=["```mysql\ndeclare @@debug_sync string\n```","_**System Variable**_ (⊕ 6.0.6)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Interface to Debug Sync facility [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_debug_sync)]."],nl=["```mysql\ndeclare @@default_collation_for_utf8mb4 enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\nvalid values:\n\n- `utf8mb4_0900_ai_ci`\n- `utf8mb4_general_ci`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default collation for utf8mb4 character set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_collation_for_utf8mb4)]."],sl=["```mysql\ndeclare @@default_storage_engine enumeration\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndefault: `MyISAM`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default storage engine (table type) for tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_storage_engine)]."],ol=["```mysql\ndeclare @@default_table_encryption boolean\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The default schema and tablespace encryption setting [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_table_encryption)]."],al=["```mysql\ndeclare @@default_authentication_plugin enumeration\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `caching_sha2_password`, valid values:\n\n- `mysql_native_password`\n- `sha256_password`\n- `caching_sha2_password`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default authentication plugin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin)]."],il=["```mysql\ndeclare @@default_password_lifetime integer\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Age in days when passwords effectively expire [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_password_lifetime)]."],rl=["```mysql\ndeclare @@default_tmp_storage_engine enumeration\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `InnoDB`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The default storage engine (table type) for TEMPORARY tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_tmp_storage_engine)]."],ml=["```mysql\ndeclare @@default_week_format integer\n```","_**System Variable**_\n\ndefault: `0`, min: `0`, max: `7`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default week format used by WEEK() functions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_week_format)]."],ll=["```mysql\ndeclare @@delay_key_write enumeration\n```","_**System Variable**_\n\ndefault: `ON`, valid values:\n\n- `ON`\n- `OFF`\n- `ALL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Type of DELAY_KEY_WRITE [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delay_key_write)]."],dl=["```mysql\ndeclare @@Delayed_errors integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows written with INSERT DELAYED for which some error occurred [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Delayed_errors)]."],cl=["```mysql\ndeclare @@delayed_insert_limit integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndefault: `100`, min: `1`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_insert_limit)]."],_l=["```mysql\ndeclare @@Delayed_insert_threads integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of INSERT DELAYED thread handlers in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Delayed_insert_threads)]."],pl=["```mysql\ndeclare @@delayed_insert_timeout integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndefault: `300`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_insert_timeout)]."],hl=["```mysql\ndeclare @@delayed_queue_size integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndefault: `1000`, min: `1`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","What size queue (in rows) should be allocated for handling INSERT DELAYED [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_delayed_queue_size)]."],yl=["```mysql\ndeclare @@Delayed_writes integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of INSERT DELAYED rows written [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Delayed_writes)]."],vl=["```mysql\ndeclare @@disable_gtid_unsafe_statements boolean\n```","_**System Variable**_ (⊕ 5.6.5, ⊗ 5.6.9)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Obsolete: Replaced by enforce_gtid_consistency in MySQL 5.6.9 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_disable_gtid_unsafe_statements)]."],ul=["```mysql\ndeclare @@disabled_storage_engines string\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `empty string`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Storage engines that cannot be used to create tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_disabled_storage_engines)]."],bl=["```mysql\ndeclare @@disconnect_on_expired_password boolean\n```","_**System Variable**_ (⊕ 5.7.1)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether server disconnects clients with expired passwords if clients cannot handle such accounts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_disconnect_on_expired_password)]."],fl=["```mysql\ndeclare @@div_precision_increment integer\n```","_**System Variable**_ (⊕ 5.0.6)\n\ndefault: `4`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Scale of the result of '/' operator will be increased by this many digits [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_div_precision_increment)]."],ql=["```mysql\ndeclare @@end_markers_in_json boolean\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Whether optimizer JSON output should add end markers [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_end_markers_in_json)]."],gl=["```mysql\ndeclare @@enforce_gtid_consistency enumeration\n```","_**System Variable**_ (⊕ 5.6.9)\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `ON`\n- `WARN`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Prevents execution of statements that cannot be logged in a transactionally safe manner [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_enforce_gtid_consistency)]."],Sl=["```mysql\ndeclare @@engine_condition_pushdown boolean\n```","_**System Variable**_ (⊕ 5.0.3, ⊘ 5.5.3, ⊗ 5.6.1)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Push supported query conditions to the storage engine [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_engine_condition_pushdown)]."],zl=["```mysql\ndeclare @@eq_range_index_dive_limit integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `200`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The cutoff for switching from index dives to index statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_eq_range_index_dive_limit)]."],Vl=["```mysql\ndeclare @@error_count integer\n```","_**System Variable**_\n\ndynamic: no, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of errors [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_error_count)]."],Tl=["```mysql\ndeclare @@event_scheduler enumeration\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `ON`, valid values:\n\n- `ON`\n- `OFF`\n- `DISABLED`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable/disable and start/stop the event scheduler [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_event_scheduler)]."],El=["```mysql\ndeclare @@executed_gtids_compression_period integer\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 5.7.6)\n\ndefault: `1000`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Renamed to gtid_executed_compression_period [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_executed_gtids_compression_period)]."],Al=["```mysql\ndeclare @@expire_logs_days integer\n```","_**System Variable**_ (⊘ 8.0.3)\n\ndefault: `0`, min: `0`, max: `99`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Purge binary logs after this many days [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_expire_logs_days)]."],Rl=["```mysql\ndeclare @@explicit_defaults_for_timestamp boolean\n```","_**System Variable**_ (⊕ 5.6.6, ⊘ 5.6.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether TIMESTAMP columns are nullable and have DEFAULT NULL [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp)]."],xl=["```mysql\ndeclare @@external_user string\n```","_**System Variable**_ (⊕ 5.5.7)\n\ndynamic: no, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The external proxy user [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_external_user)]."],wl=["```mysql\ndeclare @@federated integer\n```","_**System Variable**_ (⊕ 6.0.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables the FEDERATED storage engine [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#federated-storage-engine)]."],Nl=["```mysql\ndeclare @@Firewall_access_denied integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements rejected by MySQL Enterprise Firewall [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Firewall_access_denied)]."],Cl=["```mysql\ndeclare @@Firewall_access_granted integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements accepted by MySQL Enterprise Firewall [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Firewall_access_granted)]."],kl=["```mysql\ndeclare @@Firewall_cached_entries integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements recorded by MySQL Enterprise Firewall [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Firewall_cached_entries)]."],Ol=["```mysql\ndeclare @@flush boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Flush tables to disk between SQL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_flush)]."],Il=["```mysql\ndeclare @@Flush_commands integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of FLUSH statements executed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Flush_commands)]."],Ll=["```mysql\ndeclare @@flush_time integer\n```","_**System Variable**_\n\ndefault: `0`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A dedicated thread is created to flush all tables at the given interval [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_flush_time)]."],Dl=["```mysql\ndeclare @@foreign_key_checks boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled (the default), foreign key constraints for InnoDB tables are checked [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_foreign_key_checks)]."],Ml=["```mysql\ndeclare @@ft_boolean_syntax string\n```",'_**System Variable**_\n\ndefault: `+ -><()~*:""&|`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported',"List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_boolean_syntax)]."],Fl=["```mysql\ndeclare @@ft_max_word_len integer\n```","_**System Variable**_\n\nmin: `10`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_max_word_len)]."],Pl=["```mysql\ndeclare @@ft_min_word_len integer\n```","_**System Variable**_\n\ndefault: `4`, min: `1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_min_word_len)]."],Bl=["```mysql\ndeclare @@ft_query_expansion_limit integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `20`, min: `0`, max: `1000`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of best matches to use for query expansion [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_query_expansion_limit)]."],Ul=["```mysql\ndeclare @@ft_stopword_file filename\n```","_**System Variable**_ (⊕ 4.1.10)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use stopwords from this file instead of built-in list [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ft_stopword_file)]."],Hl=["```mysql\ndeclare @@gdb boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set up signals usable for debugging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_gdb)]."],Wl=["```mysql\ndeclare @@general_log boolean\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable|disable general log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_general_log)]."],Ql=["```mysql\ndeclare @@general_log_file filename\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `host_name.log`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of the general query log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_general_log_file)]."],jl=["```mysql\ndeclare @@generated_random_password_length integer\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `20`, min: `5`, max: `255`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum length of generated passwords [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_generated_random_password_length)]."],Gl=["```mysql\ndeclare @@group_concat_max_len integer\n```","_**System Variable**_ (⊕ 4.1.10)\n\ndefault: `1024`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The maximum length of the result of function group_concat [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len)]."],Xl=["```mysql\ndeclare @@gtid_done string\n```","_**System Variable**_ (⊕ 5.6.5, ⊗ 5.6.9)\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Obsolete: Replaced by gtid_executed in MySQL 5.6.9 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_done)]."],Yl=["```mysql\ndeclare @@gtid_executed string\n```","_**System Variable**_ (⊕ 5.6.9)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Global: All GTIDs in the binary log (global) or current transaction (session). Read-only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_executed)]."],Kl=["```mysql\ndeclare @@gtid_executed_compression_period integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `1000`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compress gtid_executed table each time this many transactions have occurred. 0 means never compress this table. Applies only when binary logging is disabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_executed_compression_period)]."],Zl=["```mysql\ndeclare @@gtid_lost string\n```","_**System Variable**_ (⊕ 5.6.5, ⊗ 5.6.9)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Obsolete: Replaced by gtid_purged in MySQL 5.6.9 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_lost)]."],$l=["```mysql\ndeclare @@gtid_mode enumeration\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `OFF_PERMISSIVE`\n- `ON_PERMISSIVE`\n- `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls whether GTID based logging is enabled and what type of transactions the logs can contain [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_mode)]."],Jl=["```mysql\ndeclare @@gtid_next enumeration\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `AUTOMATIC`, valid values:\n\n- `AUTOMATIC`\n- `ANONYMOUS`\n- `UUID:NUMBER`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the GTID for the next statement to execute; see documentation for details [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_next)]."],ed=["```mysql\ndeclare @@gtid_owned string\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The set of GTIDs owned by this client (session), or by all clients, together with the thread ID of the owner (global). Read-only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_owned)]."],td=["```mysql\ndeclare @@gtid_purged string\n```","_**System Variable**_ (⊕ 5.6.9)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The set of all GTIDs that have been purged from the binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_gtid_purged)]."],nd=["```mysql\ndeclare @@Handler_commit integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of internal COMMIT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_commit)]."],sd=["```mysql\ndeclare @@Handler_delete integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that rows have been deleted from tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_delete)]."],od=["```mysql\ndeclare @@Handler_discover integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that tables have been discovered [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_discover)]."],ad=["```mysql\ndeclare @@Handler_external_lock integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of locks started while a statement executed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_external_lock)]."],id=["```mysql\ndeclare @@Handler_mrr_init integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times storage engine MRR implementation is used for table access [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_mrr_init)]."],rd=["```mysql\ndeclare @@Handler_prepare integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A counter for the prepare phase of two-phase commit operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_prepare)]."],md=["```mysql\ndeclare @@Handler_read_first integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times the first entry in an index was read [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_first)]."],ld=["```mysql\ndeclare @@Handler_read_key integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read a row based on a key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_key)]."],dd=["```mysql\ndeclare @@Handler_read_last integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read the last index entry [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_last)]."],cd=["```mysql\ndeclare @@Handler_read_next integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read the next row in key order [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_next)]."],_d=["```mysql\ndeclare @@Handler_read_prev integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read the previous row in key order [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_prev)]."],pd=["```mysql\ndeclare @@Handler_read_rnd integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read a row based on a fixed position [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_rnd)]."],hd=["```mysql\ndeclare @@Handler_read_rnd_next integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read the next row in the data file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_read_rnd_next)]."],yd=["```mysql\ndeclare @@Handler_rollback integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests for a storage engine to perform a rollback operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_rollback)]."],vd=["```mysql\ndeclare @@Handler_savepoint integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests for a storage engine to place a savepoint [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_savepoint)]."],ud=["```mysql\ndeclare @@Handler_savepoint_rollback integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests for a storage engine to roll back to a savepoint [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_savepoint_rollback)]."],bd=["```mysql\ndeclare @@Handler_update integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to update a row in a table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_update)]."],fd=["```mysql\ndeclare @@Handler_write integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to insert a row in a table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Handler_write)]."],qd=["```mysql\ndeclare @@have_archive boolean\n```","_**System Variable**_ (⊕ 4.1.13, ⊗ 5.1.14)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports archive tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_archive)]."],gd=["```mysql\ndeclare @@have_blackhole_engine boolean\n```","_**System Variable**_ (⊕ 4.1.11, ⊗ 5.1.14)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports BLACKHOLE tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_blackhole_engine)]."],Sd=["```mysql\ndeclare @@have_community_features boolean\n```","_**System Variable**_ (⊕ 5.1.24)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether statement profiling capability is available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_community_features)]."],zd=["```mysql\ndeclare @@have_compress boolean\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Availability of the zlib compression library [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_compress)]."],Vd=["```mysql\ndeclare @@have_crypt boolean\n```","_**System Variable**_ (⊕ 4.1.10, ⊘ 5.7.6, ⊗ 8.0.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Availability of the crypt() system call [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_crypt)]."],Td=["```mysql\ndeclare @@have_csv boolean\n```","_**System Variable**_ (⊕ 4.1.14, ⊗ 5.6.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports csv tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_csv)]."],Ed=["```mysql\ndeclare @@have_dynamic_loading boolean\n```","_**System Variable**_ (⊕ 5.1.10)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports dynamic loading of plugins [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_dynamic_loading)]."],Ad=["```mysql\ndeclare @@have_example_engine boolean\n```","_**System Variable**_ (⊕ 4.1.14, ⊗ 5.1.14)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports EXAMPLE tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_example_engine)]."],Rd=["```mysql\ndeclare @@have_federated_engine boolean\n```","_**System Variable**_ (⊕ 5.0.6, ⊗ 5.1.14)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports FEDERATED tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_federated_engine)]."],xd=["```mysql\ndeclare @@have_geometry boolean\n```","_**System Variable**_ (⊕ 4.1.13)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports spatial data types [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_geometry)]."],wd=["```mysql\ndeclare @@have_innodb boolean\n```","_**System Variable**_ (⊗ 5.6.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_innodb)]."],Nd=["```mysql\ndeclare @@have_isam boolean\n```","_**System Variable**_ (⊗ 5.1.7)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports isam tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_isam)]."],Cd=["```mysql\ndeclare @@have_merge_engine boolean\n```","_**System Variable**_ (⊕ 5.0.24, ⊗ 5.1.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports merge tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_merge_engine)]."],kd=["```mysql\ndeclare @@have_ndbcluster boolean\n```","_**System Variable**_ (⊕ 4.1.2, ⊗ 5.6.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports NDB Cluster tables (set by --ndbcluster option) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_ndbcluster)]."],Od=["```mysql\ndeclare @@have_openssl boolean\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_openssl)]."],Id=["```mysql\ndeclare @@have_partition_engine boolean\n```","_**System Variable**_ (⊕ 5.1.1, ⊘ 5.1.6)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports partitioning [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],Ld=["```mysql\ndeclare @@have_partitioning boolean\n```","_**System Variable**_ (⊕ 5.1.6, ⊗ 5.6.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports partitioning [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_partitioning)]."],Dd=["```mysql\ndeclare @@have_profiling boolean\n```","_**System Variable**_ (⊕ 6.0.14, ⊘ 5.6.8)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether statement profiling capability is available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_profiling)]."],Md=["```mysql\ndeclare @@have_query_cache boolean\n```","_**System Variable**_ (⊘ 5.7.20)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_query_cache)]."],Fd=["```mysql\ndeclare @@have_raid boolean\n```","_**System Variable**_ (⊗ 5.1.7)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports the raid option [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_raid)]."],Pd=["```mysql\ndeclare @@have_row_based_replication boolean\n```","_**System Variable**_ (⊕ 5.1.5, ⊗ 5.1.15)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Shows whether row-based replication is supported [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_row_based_replication)]."],Bd=["```mysql\ndeclare @@have_rtree_keys boolean\n```","_**System Variable**_ (⊕ 4.1.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","YES if RTREE indexes are available, NO if not. (These are used for spatial indexes in MyISAM tables.) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_rtree_keys)]."],Ud=["```mysql\ndeclare @@have_ssl string\n```","_**System Variable**_ (⊕ 5.1.17)\n\nvalid values:\n\n- `YES`\n- `DISABLED`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld supports SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_ssl)]."],Hd=["```mysql\ndeclare @@have_statement_timeout boolean\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether statement execution timeout is available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_statement_timeout)]."],Wd=["```mysql\ndeclare @@have_symlink boolean\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Is symbolic link support enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_have_symlink)]."],Qd=["```mysql\ndeclare @@help \n```","_**System Variable**_ (⊕ 4.1.10a)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Display help message and exit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_help)]."],jd=["```mysql\ndeclare @@histogram_generation_max_mem_size integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `20000000`, min: `1000000`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum memory for creating histogram statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_histogram_generation_max_mem_size)]."],Gd=["```mysql\ndeclare @@host_cache_size integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `-1`, min: `0`, max: `65536`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the host cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_host_cache_size)]."],Xd=["```mysql\ndeclare @@hostname string\n```","_**System Variable**_ (⊕ 5.1.17)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The name of the server host [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_hostname)]."],Yd=["```mysql\ndeclare @@identity integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_identity)]."],Kd=["```mysql\ndeclare @@ignore_builtin_innodb boolean\n```","_**System Variable**_ (⊕ 5.1.33, ⊘ 5.5.22, ⊗ 8.0.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Ignore the built-in InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ignore_builtin_innodb)]."],Zd=["```mysql\ndeclare @@ignore_db_dirs string\n```","_**System Variable**_ (⊕ 5.6.3, ⊘ 5.7.16, ⊗ 8.0.0)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directories treated as nondatabase directories [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ignore_db_dirs)]."],$d=["```mysql\ndeclare @@information_schema_stats_expiry integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `86400`, min: `0`, max: `31536000`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Expiration setting for cached table statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_information_schema_stats_expiry)]."],Jd=["```mysql\ndeclare @@init_file filename\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Read SQL statements from this file at startup [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_init_file)]."],ec=["```mysql\ndeclare @@init_connect string\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Statements that are executed for each new connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_init_connect)]."],tc=["```mysql\ndeclare @@init_slave string\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Statements that are executed when a slave connects to a master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_init_slave)]."],nc=["```mysql\ndeclare @@initialize boolean\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to run in initialization mode (secure) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_initialize)]."],sc=["```mysql\ndeclare @@innodb boolean\n```","_**System Variable**_ (⊘ 5.7.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable InnoDB (if this version of MySQL supports it) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_innodb)]."],oc=["```mysql\ndeclare @@innodb_adaptive_flushing boolean\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control InnoDB adaptive flushing of dirty pages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_adaptive_flushing)]."],ac=["```mysql\ndeclare @@innodb_adaptive_flushing_lwm integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `10`, min: `0`, max: `70`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_adaptive_flushing_lwm)]."],ic=["```mysql\ndeclare @@innodb_adaptive_hash_index boolean\n```","_**System Variable**_ (⊕ 6.0.5)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable InnoDB adaptive hash indexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_adaptive_hash_index)]."],rc=["```mysql\ndeclare @@innodb_adaptive_hash_index_parts numeric\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `8`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Partitions the adaptive hash index search system into n partitions, with each partition protected by a separate latch. Each index is bound to a specific partition based on space ID and index ID attributes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_adaptive_hash_index_parts)]."],mc=["```mysql\ndeclare @@innodb_adaptive_max_sleep_delay integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `150000`, min: `0`, max: `1000000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allows InnoDB to automatically adjust the value of innodb_thread_sleep_delay up or down according to the current workload [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_adaptive_max_sleep_delay)]."],lc=["```mysql\ndeclare @@innodb_api_bk_commit_interval integer\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `5`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How often to auto-commit idle connections that use the InnoDB memcached interface, in seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_api_bk_commit_interval)]."],dc=["```mysql\ndeclare @@innodb_api_disable_rowlock boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","undefined [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_api_disable_rowlock)]."],cc=["```mysql\ndeclare @@innodb_api_enable_binlog boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Lets you use the InnoDB memcached plugin with the MySQL binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_api_enable_binlog)]."],_c=["```mysql\ndeclare @@innodb_api_enable_mdl boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_api_enable_mdl)]."],pc=["```mysql\ndeclare @@innodb_api_trx_level integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Lets you control the transaction isolation level on queries processed by the memcached interface [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_api_trx_level)]."],hc=["```mysql\ndeclare @@innodb_autoextend_increment integer\n```","_**System Variable**_ (⊕ 4.1.5)\n\ndefault: `64`, min: `1`, max: `1000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Data file autoextend increment in megabytes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_autoextend_increment)]."],yc=["```mysql\ndeclare @@innodb_autoinc_lock_mode integer\n```","_**System Variable**_ (⊕ 5.1.22)\n\ndefault: `2`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set InnoDB auto-increment lock mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_autoinc_lock_mode)]."],vc=["```mysql\ndeclare @@Innodb_available_undo_logs integer\n```","_**System Variable**_ (⊕ 5.6.5, ⊘ 5.7.19, ⊗ 8.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Display the total number of InnoDB rollback segments; different from innodb_rollback_segments, which displays the number of active rollback segments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_available_undo_logs)]."],uc=["```mysql\ndeclare @@innodb_background_drop_list_empty boolean\n```","_**System Variable**_ (⊕ 5.7.10)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This debug option delays table creation until the background drop list is empty [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_background_drop_list_empty)]."],bc=["```mysql\ndeclare @@Innodb_buffer_pool_bytes_data integer\n```","_**System Variable**_ (⊕ 5.5.30)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes containing data (dirty or clean) in the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_bytes_data)]."],fc=["```mysql\ndeclare @@Innodb_buffer_pool_bytes_dirty integer\n```","_**System Variable**_ (⊕ 5.5.30)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes currently dirty in the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_bytes_dirty)]."],qc=["```mysql\ndeclare @@innodb_buffer_pool_chunk_size integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `134217728`, min: `1048576`, max: `innodb_buffer_pool_size / innodb_buffer_pool_instances`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the chunk size that is used when resizing the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_chunk_size)]."],gc=["```mysql\ndeclare @@innodb_buffer_pool_debug boolean\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permits multiple buffer pool instances when the buffer pool is less than 1GB in size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_debug)]."],Sc=["```mysql\ndeclare @@innodb_buffer_pool_dump_at_shutdown boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_dump_at_shutdown)]."],zc=["```mysql\ndeclare @@innodb_buffer_pool_dump_now boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Immediately records the pages cached in the InnoDB buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_dump_now)]."],Vc=["```mysql\ndeclare @@innodb_buffer_pool_dump_pct integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `25`, min: `1`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the percentage of the most recently used pages for each buffer pool to read out and dump [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_dump_pct)]."],Tc=["```mysql\ndeclare @@Innodb_buffer_pool_dump_status string\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Display status of buffer pool recording operation triggered by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_dump_status)]."],Ec=["```mysql\ndeclare @@innodb_buffer_pool_filename filename\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `ib_buffer_pool`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_filename)]."],Ac=["```mysql\ndeclare @@innodb_buffer_pool_in_core_file boolean\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls writing of buffer pool pages to core files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_in_core_file)]."],Rc=["```mysql\ndeclare @@innodb_buffer_pool_instances integer\n```","_**System Variable**_ (⊕ 5.5.4)\n\ndefault: `8 (or 1 if innodb_buffer_pool_size < 1GB`, min: `1`, max: `64`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how many parts the InnoDB buffer pool is divided into [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_instances)]."],xc=["```mysql\ndeclare @@innodb_buffer_pool_load_abort boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Interrupts process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_load_abort)]."],wc=["```mysql\ndeclare @@innodb_buffer_pool_load_at_startup boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_load_at_startup)].'],Nc=["```mysql\ndeclare @@innodb_buffer_pool_load_now boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_load_now)].'],Cc=["```mysql\ndeclare @@Innodb_buffer_pool_load_status string\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Display status of buffer pool warmup operation triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_load_status)]."],kc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_data integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages containing data (dirty or clean) in the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_data)]."],Oc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_dirty integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages currently dirty in the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_dirty)]."],Ic=["```mysql\ndeclare @@Innodb_buffer_pool_pages_flushed integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of buffer pool page-flush requests [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_flushed)]."],Lc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_free integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of buffer pool pages free [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_free)]."],Dc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_latched integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of latched pages in InnoDB buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_latched)]."],Mc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_misc integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages that are busy because they have been allocated for administrative overhead [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_misc)]."],Fc=["```mysql\ndeclare @@Innodb_buffer_pool_pages_total integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total size of buffer pool, in pages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_pages_total)]."],Pc=["```mysql\ndeclare @@Innodb_buffer_pool_read_ahead integer\n```","_**System Variable**_ (⊕ 5.1.42)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages read by the InnoDB read-ahead thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_read_ahead)]."],Bc=["```mysql\ndeclare @@Innodb_buffer_pool_read_ahead_evicted integer\n```","_**System Variable**_ (⊕ 5.1.42)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of read-ahead pages evicted without being accessed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_read_ahead_evicted)]."],Uc=["```mysql\ndeclare @@Innodb_buffer_pool_read_ahead_rnd integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of random read-aheads initiated by InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_read_ahead_rnd)]."],Hc=["```mysql\ndeclare @@Innodb_buffer_pool_read_ahead_seq integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sequential read-aheads initiated by InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_read_ahead_seq)]."],Wc=["```mysql\ndeclare @@Innodb_buffer_pool_read_requests integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of logical read requests InnoDB has done [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_read_requests)]."],Qc=["```mysql\ndeclare @@Innodb_buffer_pool_reads integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of logical reads that InnoDB could not satisfy from the buffer pool and had to do a single-page read [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_reads)]."],jc=["```mysql\ndeclare @@Innodb_buffer_pool_resize_status string\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The status of the dynamic buffer pool resizing operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_resize_status)]."],Gc=["```mysql\ndeclare @@innodb_buffer_pool_size integer\n```","_**System Variable**_\n\ndefault: `8388608`, min: `1048576`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the memory buffer InnoDB uses to cache data and indexes of its tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_buffer_pool_size)]."],Xc=["```mysql\ndeclare @@Innodb_buffer_pool_wait_free integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Counts number of waits for pages to be flushed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_wait_free)]."],Yc=["```mysql\ndeclare @@Innodb_buffer_pool_write_requests integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of writes done to the buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_buffer_pool_write_requests)]."],Kc=["```mysql\ndeclare @@innodb_change_buffer_max_size integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `25`, min: `0`, max: `50`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum size for the InnoDB change buffer, as a percentage of the total size of buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_change_buffer_max_size)]."],Zc=["```mysql\ndeclare @@innodb_change_buffering enumeration\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `all`, valid values:\n\n- `none`\n- `inserts`\n- `deletes`\n- `changes`\n- `purges`\n- `all`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether InnoDB performs insert buffering [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_change_buffering)]."],$c=["```mysql\ndeclare @@innodb_change_buffering_debug integer\n```","_**System Variable**_ (⊕ 5.1.53)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets a debug flag for InnoDB change buffering [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_change_buffering_debug)]."],Jc=["```mysql\ndeclare @@innodb_checkpoint_disabled boolean\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Disables checkpoints so that a deliberate server exit always initiates recovery [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_checkpoint_disabled)]."],e_=["```mysql\ndeclare @@innodb_checksum_algorithm enumeration\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `crc32`, valid values:\n\n- `innodb`\n- `crc32`\n- `none`\n- `strict_innodb`\n- `strict_crc32`\n- `strict_none`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_checksum_algorithm)]."],t_=["```mysql\ndeclare @@innodb_checksums boolean\n```","_**System Variable**_ (⊕ 5.0.3, ⊘ 5.6.3, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable InnoDB checksums validation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_checksums)]."],n_=["```mysql\ndeclare @@innodb_cmp_per_index_enabled boolean\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_cmp_per_index_enabled)]."],s_=["```mysql\ndeclare @@innodb_commit_concurrency integer\n```","_**System Variable**_ (⊕ 5.0.12)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Helps in performance tuning in heavily concurrent environments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_commit_concurrency)]."],o_=["```mysql\ndeclare @@innodb_compress_debug enumeration\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `none`, valid values:\n\n- `none`\n- `zlib`\n- `lz4`\n- `lz4hc`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compresses all tables using a specified compression algorithm [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_compress_debug)]."],a_=["```mysql\ndeclare @@innodb_compression_failure_threshold_pct integer\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `5`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the cutoff point at which MySQL begins adding padding within compressed pages to avoid expensive compression failures [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_compression_failure_threshold_pct)]."],i_=["```mysql\ndeclare @@innodb_compression_level integer\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `6`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the level of zlib compression to use for InnoDB compressed tables and indexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_compression_level)]."],r_=["```mysql\ndeclare @@innodb_compression_pad_pct_max integer\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `50`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the maximum percentage that can be reserved as free space within each compressed page, to avoid compression failures when tightly packed data is recompressed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_compression_pad_pct_max)]."],m_=["```mysql\ndeclare @@innodb_concurrency_tickets integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `5000`, min: `1`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_concurrency_tickets)]."],l_=["```mysql\ndeclare @@innodb_data_file_path string\n```","_**System Variable**_\n\ndefault: `ibdata1:12M:autoextend`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to individual files and their sizes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_data_file_path)]."],d_=["```mysql\ndeclare @@Innodb_data_fsyncs integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of fsync() operations so far [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_fsyncs)]."],c_=["```mysql\ndeclare @@innodb_data_home_dir dirname\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The common part for InnoDB table spaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_data_home_dir)]."],__=["```mysql\ndeclare @@Innodb_data_pending_fsyncs integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current number of pending fsync() operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_pending_fsyncs)]."],p_=["```mysql\ndeclare @@Innodb_data_pending_reads integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current number of pending reads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_pending_reads)]."],h_=["```mysql\ndeclare @@Innodb_data_pending_writes integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pending writes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_pending_writes)]."],y_=["```mysql\ndeclare @@Innodb_data_read integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The amount of data read so far, in bytes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_read)]."],v_=["```mysql\ndeclare @@Innodb_data_reads integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of data reads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_reads)]."],u_=["```mysql\ndeclare @@Innodb_data_writes integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of data writes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_writes)]."],b_=["```mysql\ndeclare @@Innodb_data_written integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The amount of data written in bytes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_data_written)]."],f_=["```mysql\ndeclare @@innodb_ddl_log_crash_reset_debug boolean\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A debug option that resets DDL log crash injection counters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ddl_log_crash_reset_debug)]."],q_=["```mysql\ndeclare @@innodb_deadlock_detect boolean\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables or disables deadlock detection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_deadlock_detect)]."],g_=["```mysql\ndeclare @@innodb_dedicated_server boolean\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables automatic configuration of buffer pool size, log file size, and flush method [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_dedicated_server)]."],S_=["```mysql\ndeclare @@innodb_default_row_format enumeration\n```","_**System Variable**_ (⊕ 5.7.9)\n\ndefault: `DYNAMIC`, valid values:\n\n- `DYNAMIC`\n- `COMPACT`\n- `REDUNDANT`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the default row format (ROW_FORMAT) for InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_default_row_format)]."],z_=["```mysql\ndeclare @@Innodb_dblwr_pages_written integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of doublewrite pages that have been written [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_dblwr_pages_written)]."],V_=["```mysql\ndeclare @@Innodb_dblwr_writes integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of doublewrite operations that have been performed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_dblwr_writes)]."],T_=["```mysql\ndeclare @@innodb_directories dirname\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines directories to scan at startup for tablespace data files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_directories)]."],E_=["```mysql\ndeclare @@innodb_disable_sort_file_cache boolean\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Disable OS file system cache for merge-sort temporary files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_disable_sort_file_cache)]."],A_=["```mysql\ndeclare @@innodb_disable_resize_buffer_pool_debug boolean\n```","_**System Variable**_ (⊕ 5.7.6, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Disables resizing of the InnoDB buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_disable_resize_buffer_pool_debug)]."],R_=["```mysql\ndeclare @@innodb_doublewrite boolean\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable InnoDB doublewrite buffer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_doublewrite)]."],x_=["```mysql\ndeclare @@innodb_doublewrite_batch_size integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of doublewrite pages to write in a batch [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_doublewrite_batch_size)]."],w_=["```mysql\ndeclare @@innodb_doublewrite_dir dirname\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Doublewrite buffer file directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_doublewrite_dir)]."],N_=["```mysql\ndeclare @@innodb_doublewrite_files integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `innodb_buffer_pool_instances * 2`, min: `2`, max: `256`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of doublewrite files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_doublewrite_files)]."],C_=["```mysql\ndeclare @@innodb_doublewrite_pages integer\n```","_**System Variable**_ (⊕ 8.0.20)\n\ndefault: `innodb_write_io_threads value`, min: `innodb_write_io_threads value`, max: `512`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of doublewrite pages per thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_doublewrite_pages)]."],k_=["```mysql\ndeclare @@innodb_extra_dirty_writes boolean\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_extra_dirty_writes)]."],O_=["```mysql\ndeclare @@innodb_fast_shutdown integer\n```","_**System Variable**_\n\ndefault: `1`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Speeds up the shutdown process of the InnoDB storage engine [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_fast_shutdown)]."],I_=["```mysql\ndeclare @@innodb_fil_make_page_dirty_debug integer\n```","_**System Variable**_ (⊕ 5.6.17)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Dirties the first page of the specified tablespace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_fil_make_page_dirty_debug)]."],L_=["```mysql\ndeclare @@innodb_file_format string\n```","_**System Variable**_ (⊕ 5.4.2, ⊘ 5.7.7, ⊗ 8.0.0)\n\ndefault: `Barracuda`, valid values:\n\n- `Antelope`\n- `Barracuda`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The format for new InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_file_format)]."],D_=["```mysql\ndeclare @@innodb_file_format_check boolean\n```","_**System Variable**_ (⊕ 5.4.2, ⊘ 5.7.7, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether InnoDB performs file format compatibility checking [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_file_format_check)]."],M_=["```mysql\ndeclare @@innodb_file_format_max string\n```","_**System Variable**_ (⊕ 5.5.5, ⊘ 5.7.7, ⊗ 8.0.0)\n\ndefault: `Barracuda`, valid values:\n\n- `Antelope`\n- `Barracuda`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The file format tag in the shared tablespace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_file_format_max)]."],F_=["```mysql\ndeclare @@innodb_file_io_threads integer\n```","_**System Variable**_ (⊗ 5.5.0)\n\ndefault: `4`, min: `4`, max: `64`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of file I/O threads in InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_file_io_threads)]."],P_=["```mysql\ndeclare @@innodb_file_per_table boolean\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Stores each InnoDB table and its indexes in a separate .ibd file in the database directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_file_per_table)]."],B_=["```mysql\ndeclare @@innodb_fill_factor integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `100`, min: `10`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the percentage B-tree leaf and non-leaf page space that is to be filled with data. The remaining space is reserved for future growth [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_fill_factor)]."],U_=["```mysql\ndeclare @@innodb_flush_log_at_timeout integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Write and flush logs every N seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flush_log_at_timeout)]."],H_=["```mysql\ndeclare @@innodb_flush_log_at_trx_commit enumeration\n```","_**System Variable**_\n\ndefault: `1`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flush_log_at_trx_commit)]."],W_=["```mysql\ndeclare @@innodb_flush_method string\n```","_**System Variable**_\n\ndefault: `fsync`, valid values:\n\n- `fsync`\n- `O_DSYNC`\n- `littlesync`\n- `nosync`\n- `O_DIRECT`\n- `O_DIRECT_NO_FSYNC`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies to flush data [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flush_method)]."],Q_=["```mysql\ndeclare @@innodb_flush_neighbors enumeration\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `0`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies whether or not flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flush_neighbors)]."],j_=["```mysql\ndeclare @@innodb_flush_sync boolean\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable innodb_flush_sync to ignore the innodb_io_capacity setting for bursts of I/O activity that occur at checkpoints. Disable innodb_flush_sync to adhere to the limit on I/O activity defined by the innodb_io_capacity setting [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flush_sync)]."],G_=["```mysql\ndeclare @@innodb_flushing_avg_loops integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `30`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_flushing_avg_loops)]."],X_=["```mysql\ndeclare @@innodb_force_load_corrupted boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_force_load_corrupted)]."],Y_=["```mysql\ndeclare @@innodb_force_recovery integer\n```","_**System Variable**_\n\ndefault: `0`, min: `0`, max: `6`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Helps to save your data in case the disk image of the database becomes corrupt [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_force_recovery)]."],K_=["```mysql\ndeclare @@innodb_fsync_threshold integer\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `0`, min: `0`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls how often InnoDB calls fsync when creating a new file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_fsync_threshold)]."],Z_=["```mysql\ndeclare @@innodb_ft_aux_table string\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the qualified name of an InnoDB table containing a FULLTEXT index for diagnostic purposes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_aux_table)]."],$_=["```mysql\ndeclare @@innodb_ft_cache_size integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `8000000`, min: `1600000`, max: `80000000`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_cache_size)]."],J_=["```mysql\ndeclare @@innodb_ft_enable_diag_print boolean\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable additional full-text search diagnostic output [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_enable_diag_print)]."],ep=["```mysql\ndeclare @@innodb_ft_enable_stopword boolean\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","During creation of an InnoDB FULLTEXT index, omits stopwords from the search index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_enable_stopword)]."],tp=["```mysql\ndeclare @@innodb_ft_max_token_size integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `84`, min: `10`, max: `84`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum length of words that are stored in an InnoDB FULLTEXT index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_max_token_size)]."],np=["```mysql\ndeclare @@innodb_ft_min_token_size integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `3`, min: `0`, max: `16`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Minimum length of words that are stored in an InnoDB FULLTEXT index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_min_token_size)]."],sp=["```mysql\ndeclare @@innodb_ft_num_word_optimize integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `2000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_num_word_optimize)]."],op=["```mysql\ndeclare @@innodb_ft_result_cache_limit integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `2000000000`, min: `1000000`, max: `2**32-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The InnoDB FULLTEXT search query result cache limit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_result_cache_limit)]."],ap=["```mysql\ndeclare @@innodb_ft_server_stopword_table string\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_server_stopword_table)]."],ip=["```mysql\ndeclare @@innodb_ft_sort_pll_degree integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `2`, min: `1`, max: `32`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_sort_pll_degree)]."],rp=["```mysql\ndeclare @@innodb_ft_total_cache_size integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `640000000`, min: `32000000`, max: `1600000000`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total memory allocated for the InnoDB FULLTEXT search index cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_total_cache_size)]."],mp=["```mysql\ndeclare @@innodb_ft_user_stopword_table string\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_ft_user_stopword_table)]."],lp=["```mysql\ndeclare @@Innodb_have_atomic_builtins integer\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether atomic instructions are available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_have_atomic_builtins)]."],dp=["```mysql\ndeclare @@Innodb_have_sync_atomic integer\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether atomic instructions are available [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_have_sync_atomic)]."],cp=["```mysql\ndeclare @@Innodb_heap_enabled integer\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the InnoDB memory heap is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_heap_enabled)]."],_p=["```mysql\ndeclare @@innodb_idle_flush_pct integer\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `100`, min: `0`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Limits I/0 operations when InnoDB is idle [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_idle_flush_pct)]."],pp=["```mysql\ndeclare @@innodb_io_capacity integer\n```","_**System Variable**_ (⊕ 5.1.38)\n\ndefault: `200`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The limit on the maximum number of I/O operations per second [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_io_capacity)]."],hp=["```mysql\ndeclare @@innodb_io_capacity_max integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `see description`, min: `100`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_io_capacity_max)]."],yp=["```mysql\ndeclare @@innodb_large_prefix boolean\n```","_**System Variable**_ (⊕ 5.6.3, ⊘ 5.7.7, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables longer keys for column prefix indexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_large_prefix)]."],vp=["```mysql\ndeclare @@innodb_limit_optimistic_insert_debug integer\n```","_**System Variable**_ (⊕ 5.1.68)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Limits the number of records per B-tree page [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_limit_optimistic_insert_debug)]."],up=["```mysql\ndeclare @@innodb_lock_wait_timeout integer\n```","_**System Variable**_\n\ndefault: `50`, min: `1`, max: `1073741824`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_lock_wait_timeout)]."],bp=["```mysql\ndeclare @@innodb_locks_unsafe_for_binlog boolean\n```","_**System Variable**_ (⊕ 4.1.4, ⊘ 5.6.3, ⊗ 8.0.0)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Force InnoDB not to use next-key locking. Instead use only row-level locking [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_locks_unsafe_for_binlog)]."],fp=["```mysql\ndeclare @@innodb_log_arch_dir dirname\n```","_**System Variable**_ (⊘ 5.0.24, ⊗ 5.1.21)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Where full logs should be archived [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_arch_dir)]."],qp=["```mysql\ndeclare @@innodb_log_archive integer\n```","_**System Variable**_ (⊗ 5.1.18)\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Unused [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_archive)]."],gp=["```mysql\ndeclare @@innodb_log_buffer_size integer\n```","_**System Variable**_\n\ndefault: `1048576`, min: `1048576`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of buffer which InnoDB uses to write log to the log files on disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_buffer_size)]."],Sp=["```mysql\ndeclare @@innodb_log_checkpoint_fuzzy_now boolean\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A debug option that forces InnoDB to write a fuzzy checkpoint [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_checkpoint_fuzzy_now)]."],zp=["```mysql\ndeclare @@innodb_log_checkpoint_now boolean\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A debug option that forces InnoDB to write a checkpoint [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_checkpoint_now)]."],Vp=["```mysql\ndeclare @@innodb_log_checksum_algorithm enumeration\n```","_**System Variable**_ (⊕ 5.7.8, ⊗ 5.7.9)\n\ndefault: `innodb`, valid values:\n\n- `innodb`\n- `crc32`\n- `none`\n- `strict_innodb`\n- `strict_crc32`\n- `strict_none`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how to generate and verify the checksum stored in each redo log disk block [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_checksum_algorithm)]."],Tp=["```mysql\ndeclare @@innodb_log_checksums boolean\n```","_**System Variable**_ (⊕ 5.7.9)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables or disables checksums for redo log pages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_checksums)]."],Ep=["```mysql\ndeclare @@innodb_log_compressed_pages boolean\n```","_**System Variable**_ (⊕ 5.6.11)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies whether images of re-compressed pages are stored in InnoDB redo logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_compressed_pages)]."],Ap=["```mysql\ndeclare @@innodb_log_file_size integer\n```","_**System Variable**_\n\ndefault: `5242880`, min: `1048576`, max: `4294967295`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of each log file in a log group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_file_size)]."],Rp=["```mysql\ndeclare @@innodb_log_files_in_group integer\n```","_**System Variable**_\n\ndefault: `2`, min: `2`, max: `100`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of InnoDB log files in the log group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_files_in_group)]."],xp=["```mysql\ndeclare @@innodb_log_group_home_dir dirname\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to InnoDB log files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_group_home_dir)]."],wp=["```mysql\ndeclare @@innodb_log_spin_cpu_abs_lwm integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `80`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Minimum amount of CPU usage below which user threads no longer spin while waiting for flushed redo [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_spin_cpu_abs_lwm)]."],Np=["```mysql\ndeclare @@innodb_log_spin_cpu_pct_hwm integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `50`, min: `0`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum amount of CPU usage above which user threads no longer spin while waiting for flushed redo [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_spin_cpu_pct_hwm)]."],Cp=["```mysql\ndeclare @@Innodb_log_waits integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that the log buffer was too small and a wait was required for it to be flushed before continuing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_log_waits)]."],kp=["```mysql\ndeclare @@innodb_log_wait_for_flush_spin_hwm integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `400`, min: `0`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum average log flush time beyond which user threads no longer spin while waiting for flushed redo [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_wait_for_flush_spin_hwm)]."],Op=["```mysql\ndeclare @@innodb_log_write_ahead_size integer\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `8192`, min: `512 (log file block size)`, max: `Equal to innodb_page_size`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The write-ahead block size for the redo log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_write_ahead_size)]."],Ip=["```mysql\ndeclare @@Innodb_log_write_requests integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of log write requests [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_log_write_requests)]."],Lp=["```mysql\ndeclare @@Innodb_log_writes integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of physical writes to the log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_log_writes)]."],Dp=["```mysql\ndeclare @@innodb_log_writer_threads boolean\n```","_**System Variable**_ (⊕ 8.0.22)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables dedicated log writer threads for writing and flushing redo logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_log_writer_threads)]."],Mp=["```mysql\ndeclare @@innodb_lru_scan_depth integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `1024`, min: `100`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_lru_scan_depth)]."],Fp=["```mysql\ndeclare @@innodb_max_dirty_pages_pct numeric\n```","_**System Variable**_\n\ndefault: `90`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Percentage of dirty pages allowed in buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_dirty_pages_pct)]."],Pp=["```mysql\ndeclare @@innodb_max_dirty_pages_pct_lwm numeric\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `10`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_dirty_pages_pct_lwm)]."],Bp=["```mysql\ndeclare @@innodb_max_merged_io integer\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndefault: `64`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of background I/O requests to merge to issue a larger I/O request [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_merged_io)]."],Up=["```mysql\ndeclare @@innodb_max_purge_lag integer\n```","_**System Variable**_ (⊕ 4.1.6)\n\ndefault: `0`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Desired maximum length of the purge queue (0 = no limit) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_purge_lag)]."],Hp=["```mysql\ndeclare @@innodb_max_purge_lag_delay integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_purge_lag_delay)]."],Wp=["```mysql\ndeclare @@innodb_max_undo_log_size integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `1073741824`, min: `10485760`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the threshold for truncating the InnoDB undo log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_max_undo_log_size)]."],Qp=["```mysql\ndeclare @@innodb_additional_mem_pool_size integer\n```","_**System Variable**_ (⊘ 5.6.3, ⊗ 5.7.4)\n\ndefault: `1048576`, min: `524288`, max: `4294967295`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_additional_mem_pool_size)]."],jp=["```mysql\ndeclare @@innodb_merge_threshold_set_all_debug integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `50`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Overrides the current MERGE_THRESHOLD setting with the specified value for all indexes that are currently in the dictionary cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_merge_threshold_set_all_debug)]."],Gp=["```mysql\ndeclare @@innodb_mirrored_log_groups integer\n```","_**System Variable**_\n\ndefault: `1`, min: `1`, max: `10`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Obsolete setting; do not use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_mirrored_log_groups)]."],Xp=["```mysql\ndeclare @@innodb_monitor_disable string\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Turns off one or more counters in the information_schema.innodb_metrics table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_monitor_disable)]."],Yp=["```mysql\ndeclare @@innodb_monitor_enable string\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Turns on one or more counters in the information_schema.innodb_metrics table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_monitor_enable)]."],Kp=["```mysql\ndeclare @@innodb_monitor_reset enumeration\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `empty string`, valid values:\n\n- `counter`\n- `module`\n- `pattern`\n- `all`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_monitor_reset)]."],Zp=["```mysql\ndeclare @@innodb_monitor_reset_all enumeration\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `empty string`, valid values:\n\n- `counter`\n- `module`\n- `pattern`\n- `all`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_monitor_reset_all)]."],$p=["```mysql\ndeclare @@Innodb_num_open_files integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of physical files currently opened by InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_num_open_files)]."],Jp=["```mysql\ndeclare @@innodb_numa_interleave boolean\n```","_**System Variable**_ (⊕ 5.7.9)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables the NUMA MPOL_INTERLEAVE memory policy for allocation of the InnoDB buffer pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_numa_interleave)]."],eh=["```mysql\ndeclare @@innodb_old_blocks_pct integer\n```","_**System Variable**_ (⊕ 5.1.41)\n\ndefault: `37`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Percentage of the InnoDB buffer pool to reserve for old blocks [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_old_blocks_pct)]."],th=["```mysql\ndeclare @@innodb_old_blocks_time integer\n```","_**System Variable**_ (⊕ 5.1.41)\n\ndefault: `1000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_old_blocks_time)]."],nh=["```mysql\ndeclare @@innodb_online_alter_log_max_size integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `134217728`, min: `65536`, max: `2**64-1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies an upper limit on size of the temporary log files used during online DDL operations for InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_online_alter_log_max_size)]."],sh=["```mysql\ndeclare @@innodb_open_files integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `-1`, min: `10`, max: `4294967295`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of files that InnoDB keeps open at the same time [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_open_files)]."],oh=["```mysql\ndeclare @@innodb_optimize_fulltext_only boolean\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_optimize_fulltext_only)]."],ah=["```mysql\ndeclare @@innodb_optimize_point_storage boolean\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable this option to store POINT data as fixed-length data rather than a variable-length data [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_optimize_point_storage)]."],ih=["```mysql\ndeclare @@Innodb_os_log_fsyncs integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of fsync() writes done to the log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_os_log_fsyncs)]."],rh=["```mysql\ndeclare @@Innodb_os_log_pending_fsyncs integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pending log file fsync() operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_os_log_pending_fsyncs)]."],mh=["```mysql\ndeclare @@Innodb_os_log_pending_writes integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pending log file writes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_os_log_pending_writes)]."],lh=["```mysql\ndeclare @@Innodb_os_log_written integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes written to the log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_os_log_written)]."],dh=["```mysql\ndeclare @@innodb_page_cleaners integer\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `4`, min: `1`, max: `64`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of page cleaner threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_page_cleaners)]."],ch=["```mysql\ndeclare @@innodb_page_size enumeration\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `16384`, valid values:\n\n- `4096`\n- `8192`\n- `16384`\n- `32768`\n- `65536`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the page size for all InnoDB tablespaces in an instance [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_page_size)]."],_h=["```mysql\ndeclare @@Innodb_page_size integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The compiled-in InnoDB page size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_page_size)]."],ph=["```mysql\ndeclare @@Innodb_pages_created integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_pages_created)]."],hh=["```mysql\ndeclare @@Innodb_pages_read integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages read [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_pages_read)]."],yh=["```mysql\ndeclare @@Innodb_pages_written integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages written [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_pages_written)]."],vh=["```mysql\ndeclare @@innodb_parallel_read_threads integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `4`, min: `1`, max: `256`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the number of threads for parallel index reads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_parallel_read_threads)]."],uh=["```mysql\ndeclare @@innodb_print_all_deadlocks boolean\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","During shutdown, prints information about all InnoDB deadlocks to the server error log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_print_all_deadlocks)]."],bh=["```mysql\ndeclare @@innodb_print_ddl_logs boolean\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether or not to print DDL logs to the error log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_print_ddl_logs)]."],fh=["```mysql\ndeclare @@innodb_purge_batch_size integer\n```","_**System Variable**_ (⊕ 5.5.4)\n\ndefault: `300`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies the number of InnoDB redo logs that trigger a purge operation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_purge_batch_size)]."],qh=["```mysql\ndeclare @@innodb_purge_rseg_truncate_frequency integer\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `128`, min: `1`, max: `128`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The rate at which undo log purge should be invoked as part of the purge action. A value of n invokes undo log purge on every nth iteration of purge invocation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_purge_rseg_truncate_frequency)]."],gh=["```mysql\ndeclare @@innodb_purge_threads integer\n```","_**System Variable**_ (⊕ 5.5.4)\n\ndefault: `4`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_purge_threads)]."],Sh=["```mysql\ndeclare @@innodb_random_read_ahead boolean\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables the random read-ahead technique for optimizing InnoDB I/O [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_random_read_ahead)]."],zh=["```mysql\ndeclare @@innodb_read_ahead_threshold integer\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `56`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The sensitivity of InnoDB linear read-ahead [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_read_ahead_threshold)]."],Vh=["```mysql\ndeclare @@innodb_read_io_threads integer\n```","_**System Variable**_ (⊕ 5.1.38)\n\ndefault: `4`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of background I/O threads for read prefetch requests [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_read_io_threads)]."],Th=["```mysql\ndeclare @@innodb_read_only boolean\n```","_**System Variable**_ (⊕ 5.6.7)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Starts the server in read-only mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_read_only)]."],Eh=["```mysql\ndeclare @@innodb_redo_log_archive_dirs string\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Labeled redo log archive directories [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_redo_log_archive_dirs)]."],Ah=["```mysql\ndeclare @@innodb_redo_log_encrypt boolean\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls encryption of redo log data for encrypted tablespaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_redo_log_encrypt)]."],Rh=["```mysql\ndeclare @@innodb_replication_delay integer\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The slave server replication thread delay [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_replication_delay)]."],xh=["```mysql\ndeclare @@innodb_rollback_on_timeout boolean\n```","_**System Variable**_ (⊕ 5.1.15)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Roll back entire transaction on transaction timeout, not just last statement [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_rollback_on_timeout)]."],wh=["```mysql\ndeclare @@innodb_rollback_segments integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `128`, min: `1`, max: `128`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_rollback_segments)]."],Nh=["```mysql\ndeclare @@Innodb_row_lock_current_waits integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of row locks currently being waited for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_row_lock_current_waits)]."],Ch=["```mysql\ndeclare @@Innodb_row_lock_time integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total time spent in acquiring row locks, in milliseconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_row_lock_time)]."],kh=["```mysql\ndeclare @@Innodb_row_lock_time_avg integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The average time to acquire a row lock, in milliseconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_row_lock_time_avg)]."],Oh=["```mysql\ndeclare @@Innodb_row_lock_time_max integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum time to acquire a row lock, in milliseconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_row_lock_time_max)]."],Ih=["```mysql\ndeclare @@Innodb_row_lock_waits integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times a row lock had to be waited for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_row_lock_waits)]."],Lh=["```mysql\ndeclare @@Innodb_rows_deleted integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows deleted from InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_rows_deleted)]."],Dh=["```mysql\ndeclare @@Innodb_rows_inserted integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows inserted into InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_rows_inserted)]."],Mh=["```mysql\ndeclare @@Innodb_rows_read integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows read from InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_rows_read)]."],Fh=["```mysql\ndeclare @@Innodb_rows_updated integer\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows updated in InnoDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_rows_updated)]."],Ph=["```mysql\ndeclare @@innodb_saved_page_number_debug integer\n```","_**System Variable**_ (⊕ 5.6.17)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Saves a page number [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_saved_page_number_debug)]."],Bh=["```mysql\ndeclare @@innodb_scan_directories dirname\n```","_**System Variable**_ (⊕ 8.0.2, ⊗ 8.0.4)\n\ndefault: `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines directories to scan for tablespace files during InnoDB recovery [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_scan_directories)]."],Uh=["```mysql\ndeclare @@innodb_sort_buffer_size integer\n```","_**System Variable**_ (⊕ 5.6.4)\n\ndefault: `1048576`, min: `65536`, max: `67108864`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies size of a buffer used for sorting data during creation of an InnoDB index [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_sort_buffer_size)]."],Hh=["```mysql\ndeclare @@innodb_spin_wait_delay integer\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `6`, min: `0`, max: `1000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum delay between polls for a spin lock [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_spin_wait_delay)]."],Wh=["```mysql\ndeclare @@innodb_spin_wait_pause_multiplier integer\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `50`, min: `1`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines a multiplier value used to determine the number of PAUSE instructions in spin-wait loops [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_spin_wait_pause_multiplier)]."],Qh=["```mysql\ndeclare @@innodb_stats_auto_recalc boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_auto_recalc)]."],jh=["```mysql\ndeclare @@innodb_stats_include_delete_marked boolean\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Include delete-marked records when calculating persistent InnoDB statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_include_delete_marked)]."],Gh=["```mysql\ndeclare @@innodb_stats_method enumeration\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `nulls_equal`, valid values:\n\n- `nulls_equal`\n- `nulls_unequal`\n- `nulls_ignored`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how InnoDB index statistics collection code should treat NULLs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_method)]."],Xh=["```mysql\ndeclare @@innodb_stats_on_metadata boolean\n```","_**System Variable**_ (⊕ 5.5.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable InnoDB table statistics updates for metadata statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_on_metadata)]."],Yh=["```mysql\ndeclare @@innodb_stats_persistent boolean\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Turns on the InnoDB persistent statistics feature [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_persistent)]."],Kh=["```mysql\ndeclare @@innodb_stats_persistent_sample_pages integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `20`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_persistent_sample_pages)]."],Zh=["```mysql\ndeclare @@innodb_stats_sample_pages integer\n```","_**System Variable**_ (⊕ 5.4.2, ⊘ 5.6.3, ⊗ 8.0.0)\n\ndefault: `8`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of index pages to sample for index distribution statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_sample_pages)]."],$h=["```mysql\ndeclare @@innodb_stats_transient_sample_pages integer\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `8`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_stats_transient_sample_pages)]."],Jh=["```mysql\ndeclare @@innodb_status_output boolean\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used to enable or disable periodic output for the standard InnoDB Monitor. Also used in combination with innodb_status_output_locks to enable and disable periodic output for the InnoDB Lock Monitor [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_status_output)]."],ey=["```mysql\ndeclare @@innodb_status_output_locks boolean\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used to enable or disable periodic output for the standard InnoDB Lock Monitor. innodb_status_output must also be enabled to produce periodic output for the InnoDB Lock Monitor [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_status_output_locks)]."],ty=["```mysql\ndeclare @@innodb_strict_mode boolean\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether InnoDB returns errors rather than warnings for exceptional conditions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_strict_mode)]."],ny=["```mysql\ndeclare @@innodb_support_xa boolean\n```","_**System Variable**_ (⊕ 5.0.3, ⊘ 5.7.10, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable InnoDB support for the XA two-phase commit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_support_xa)]."],sy=["```mysql\ndeclare @@innodb_sync_array_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `1`, min: `1`, max: `1024`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_sync_array_size)]."],oy=["```mysql\ndeclare @@innodb_sync_spin_loops integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `30`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Count of spin-loop rounds in InnoDB mutexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_sync_spin_loops)]."],ay=["```mysql\ndeclare @@innodb_sync_debug boolean\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables InnoDB sync debug checking [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_sync_debug)]."],iy=["```mysql\ndeclare @@Innodb_system_rows_deleted integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows deleted from system schema tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_system_rows_deleted)]."],ry=["```mysql\ndeclare @@Innodb_system_rows_inserted integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows inserted into system schema tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_system_rows_inserted)]."],my=["```mysql\ndeclare @@Innodb_system_rows_read integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows read from system schema tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_system_rows_read)]."],ly=["```mysql\ndeclare @@innodb_table_locks boolean\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable InnoDB locking in LOCK TABLES [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_table_locks)]."],dy=["```mysql\ndeclare @@innodb_temp_data_file_path string\n```","_**System Variable**_ (⊕ 5.7.1)\n\ndefault: `ibtmp1:12M:autoextend`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to temporary tablespace data files and their sizes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_temp_data_file_path)]."],cy=["```mysql\ndeclare @@innodb_temp_tablespaces_dir dirname\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `#innodb_temp`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Session temporary tablespaces path [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_temp_tablespaces_dir)]."],_y=["```mysql\ndeclare @@internal_tmp_mem_storage_engine enumeration\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `TempTable`, valid values:\n\n- `TempTable`\n- `MEMORY`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Defines the storage to use for internal in-memory temporary tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_internal_tmp_mem_storage_engine)]."],py=["```mysql\ndeclare @@innodb_tmpdir dirname\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The directory location for the temporary table files created during online ALTER TABLE operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_tmpdir)]."],hy=["```mysql\ndeclare @@innodb_thread_concurrency integer\n```","_**System Variable**_\n\ndefault: `8`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_thread_concurrency)]."],yy=["```mysql\ndeclare @@innodb_thread_concurrency_timer_based boolean\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use the lock-free method of handling thread concurrency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_thread_concurrency_timer_based)]."],vy=["```mysql\ndeclare @@innodb_thread_sleep_delay integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `10000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_thread_sleep_delay)]."],uy=["```mysql\ndeclare @@Innodb_truncated_status_writes integer\n```","_**System Variable**_ (⊕ 5.5.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times output from the SHOW ENGINE INNODB STATUS statement has been truncated [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_truncated_status_writes)]."],by=["```mysql\ndeclare @@innodb_trx_purge_view_update_only_debug boolean\n```","_**System Variable**_ (⊕ 5.1.68)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Pauses purging of delete-marked records while allowing the purge view to be updated [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_trx_purge_view_update_only_debug)]."],fy=["```mysql\ndeclare @@innodb_trx_rseg_n_slots_debug integer\n```","_**System Variable**_ (⊕ 5.1.62)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets a debug flag that limits TRX_RSEG_N_SLOTS to a given value for the trx_rsegf_undo_find_free function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_trx_rseg_n_slots_debug)]."],qy=["```mysql\ndeclare @@innodb_undo_directory dirname\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_undo_directory)]."],gy=["```mysql\ndeclare @@innodb_undo_log_encrypt boolean\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls encryption of undo log data for encrypted tablespaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_undo_log_encrypt)]."],Sy=["```mysql\ndeclare @@innodb_undo_log_truncate boolean\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable this option to mark the InnoDB undo tablespace for truncation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_undo_log_truncate)]."],zy=["```mysql\ndeclare @@innodb_undo_logs integer\n```","_**System Variable**_ (⊕ 5.6.3, ⊘ 5.7.19, ⊗ 8.0.2)\n\ndefault: `128`, min: `1`, max: `128`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the number of undo logs (rollback segments) used by InnoDB; an alias for innodb_rollback_segments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_undo_logs)]."],Vy=["```mysql\ndeclare @@innodb_undo_tablespaces integer\n```","_**System Variable**_ (⊕ 5.6.3, ⊘ 8.0.4)\n\ndefault: `2`, min: `2`, max: `127`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of tablespace files that rollback segments are divided between [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_undo_tablespaces)]."],Ty=["```mysql\ndeclare @@Innodb_undo_tablespaces_active integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The number of active undo tablespaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_undo_tablespaces_active)]."],Ey=["```mysql\ndeclare @@Innodb_undo_tablespaces_explicit integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The number of user-created undo tablespaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_undo_tablespaces_explicit)]."],Ay=["```mysql\ndeclare @@Innodb_undo_tablespaces_implicit integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The number of undo tablespaces created by InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_undo_tablespaces_implicit)]."],Ry=["```mysql\ndeclare @@Innodb_undo_tablespaces_total integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of undo tablespaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_undo_tablespaces_total)]."],xy=["```mysql\ndeclare @@innodb_use_legacy_cardinality_algorithm boolean\n```","_**System Variable**_ (⊕ 5.1.35)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to use legacy InnoDB index cardinality calculation algorithm [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_use_legacy_cardinality_algorithm)]."],wy=["```mysql\ndeclare @@innodb_use_native_aio boolean\n```","_**System Variable**_ (⊕ 5.5.4)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies whether to use the Linux asynchronous I/O subsystem [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_use_native_aio)]."],Ny=["```mysql\ndeclare @@innodb_use_sys_malloc boolean\n```","_**System Variable**_ (⊕ 5.4.2, ⊘ 5.6.3, ⊗ 5.7.4)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether InnoDB uses the OS or its own memory allocator [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_use_sys_malloc)]."],Cy=["```mysql\ndeclare @@innodb_version string\n```","_**System Variable**_ (⊕ 5.4.2)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The version of InnoDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_version)]."],ky=["```mysql\ndeclare @@Innodb_wake_ups integer\n```","_**System Variable**_ (⊗ 5.4.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of wakeups that should not occur [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Innodb_wake_ups)]."],Oy=["```mysql\ndeclare @@innodb_write_io_threads integer\n```","_**System Variable**_ (⊕ 5.1.38)\n\ndefault: `4`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of background I/O threads for writing dirty pages from the buffer cache to disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_innodb_write_io_threads)]."],Iy=["```mysql\ndeclare @@insert_id integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set the value to be used by the following INSERT or ALTER TABLE statement when inserting an AUTO_INCREMENT value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_insert_id)]."],Ly=["```mysql\ndeclare @@interactive_timeout integer\n```","_**System Variable**_\n\ndefault: `28800`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds the server waits for activity on an interactive connection before closing it [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout)]."],Dy=["```mysql\ndeclare @@internal_tmp_disk_storage_engine enumeration\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 8.0.16)\n\ndefault: `INNODB`, valid values:\n\n- `MYISAM`\n- `INNODB`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Storage engine for internal temporary tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_internal_tmp_disk_storage_engine)]."],My=["```mysql\ndeclare @@join_buffer_size integer\n```","_**System Variable**_\n\ndefault: `131072`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Size of buffer that is used for full joins [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size)]."],Fy=["```mysql\ndeclare @@join_cache_level integer\n```","_**System Variable**_ (⊕ 6.0.9, ⊗ 6.0.14)\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How join buffers are used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_cache_level)]."],Py=["```mysql\ndeclare @@keep_files_on_create boolean\n```","_**System Variable**_ (⊕ 5.1.21)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Do not overwrite existing .MYD/.MYI files in default database directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keep_files_on_create)]."],By=["```mysql\ndeclare @@Key_blocks_not_flushed integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of key blocks in the key cache that have changed but have not yet been flushed to disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_blocks_not_flushed)]."],Uy=["```mysql\ndeclare @@Key_blocks_unused integer\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of unused blocks in the key cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_blocks_unused)]."],Hy=["```mysql\ndeclare @@Key_blocks_used integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of used blocks in the key cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_blocks_used)]."],Wy=["```mysql\ndeclare @@key_buffer_size integer\n```","_**System Variable**_\n\ndefault: `8388608`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of buffer used for index blocks for MyISAM tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_buffer_size)]."],Qy=["```mysql\ndeclare @@key_cache_age_threshold integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `300`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_age_threshold)]."],jy=["```mysql\ndeclare @@key_cache_block_size integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `1024`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default size of key cache blocks [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_block_size)]."],Gy=["```mysql\ndeclare @@key_cache_division_limit integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `100`, min: `1`, max: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The minimum percentage of warm blocks in key cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_key_cache_division_limit)]."],Xy=["```mysql\ndeclare @@Key_read_requests integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to read a key block from the cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_read_requests)]."],Yy=["```mysql\ndeclare @@Key_reads integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of physical reads of a key block from disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_reads)]."],Ky=["```mysql\ndeclare @@Key_write_requests integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of requests to write a key block to the cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_write_requests)]."],Zy=["```mysql\ndeclare @@Key_writes integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of physical writes of a key block from disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Key_writes)]."],$y=["```mysql\ndeclare @@keyring_aws_cmk_id string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","AWS keyring plugin customer master key ID value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_aws_cmk_id)]."],Jy=["```mysql\ndeclare @@keyring_aws_conf_file filename\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `platform specific`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","AWS keyring plugin configuration file location [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_aws_conf_file)]."],ev=["```mysql\ndeclare @@keyring_aws_data_file filename\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `platform specific`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","AWS keyring plugin storage file location [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_aws_data_file)]."],tv=["```mysql\ndeclare @@keyring_aws_region enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `us-east-1`, valid values:\n\n- `ap-northeast-1`\n- `ap-northeast-2`\n- `ap-south-1`\n- `ap-southeast-1`\n- `ap-southeast-2`\n- `eu-central-1`\n- `eu-west-1`\n- `sa-east-1`\n- `us-east-1`\n- `us-west-1`\n- `us-west-2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","AWS keyring plugin region [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_aws_region)]."],nv=["```mysql\ndeclare @@keyring_encrypted_file_data filename\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `platform specific`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","keyring_encrypted_file plugin data file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_encrypted_file_data)]."],sv=["```mysql\ndeclare @@keyring_encrypted_file_password string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","keyring_encrypted_file plugin password [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_encrypted_file_password)]."],ov=["```mysql\ndeclare @@keyring_file_data filename\n```","_**System Variable**_ (⊕ 5.7.11)\n\ndefault: `platform specific`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","keyring_file plugin data file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_file_data)]."],av=["```mysql\ndeclare @@keyring_hashicorp_auth_path string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `/v1/auth/approle/login`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The HashiCorp Vault AppRole authentication path [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_auth_path)]."],iv=["```mysql\ndeclare @@keyring_hashicorp_ca_path filename\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to the keyring_hashicorp CA file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_ca_path)]."],rv=["```mysql\ndeclare @@keyring_hashicorp_caching boolean\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable keyring_hashicorp caching [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_caching)]."],mv=["```mysql\ndeclare @@keyring_hashicorp_commit_auth_path string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_auth_path value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_auth_path)]."],lv=["```mysql\ndeclare @@keyring_hashicorp_commit_ca_path string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_ca_path value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_ca_path)]."],dv=["```mysql\ndeclare @@keyring_hashicorp_commit_caching string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_caching value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_caching)]."],cv=["```mysql\ndeclare @@keyring_hashicorp_commit_role_id string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_role_id value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_role_id)]."],_v=["```mysql\ndeclare @@keyring_hashicorp_commit_server_url string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_server_url value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_server_url)]."],pv=["```mysql\ndeclare @@keyring_hashicorp_commit_store_path string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The actual keyring_hashicorp_store_path value in use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_commit_store_path)]."],hv=["```mysql\ndeclare @@keyring_hashicorp_role_id string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The HashiCorp Vault AppRole authentication role ID [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_role_id)]."],yv=["```mysql\ndeclare @@keyring_hashicorp_secret_id string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The HashiCorp Vault AppRole authentication secret ID [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_secret_id)]."],vv=["```mysql\ndeclare @@keyring_hashicorp_server_url string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `https://127.0.0.1:8200`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The HashiCorp Vault server URL [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_server_url)]."],uv=["```mysql\ndeclare @@keyring_hashicorp_store_path string\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The HashiCorp Vault store path [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_hashicorp_store_path)]."],bv=["```mysql\ndeclare @@keyring_okv_conf_dir dirname\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Oracle Key Vault keyring plugin configuration directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_okv_conf_dir)]."],fv=["```mysql\ndeclare @@keyring_operations boolean\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether keyring operations are enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_keyring_operations)]."],qv=["```mysql\ndeclare @@language dirname\n```","_**System Variable**_ (⊘ 5.6.1)\n\ndefault: `/usr/local/mysql/share/mysql/english/`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Client error messages in given language. May be given as a full path [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_language)]."],gv=["```mysql\ndeclare @@large_files_support \n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether large files are supported [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_large_files_support)]."],Sv=["```mysql\ndeclare @@large_page_size integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of memory pages when large page support is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_large_page_size)]."],zv=["```mysql\ndeclare @@last_insert_id integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The most recent AUTO_INCREMENT value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_last_insert_id)]."],Vv=["```mysql\ndeclare @@Last_query_cost numeric\n```","_**System Variable**_ (⊕ 5.0.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total cost of the last compiled query as computed by the query optimizer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Last_query_cost)]."],Tv=["```mysql\ndeclare @@Last_query_partial_plans integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of iterations in execution plan construction for the previous statement [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Last_query_partial_plans)]."],Ev=["```mysql\ndeclare @@lc_time_names string\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The locale that controls the language used to display day and month names [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lc_time_names)]."],Av=["```mysql\ndeclare @@license string\n```","_**System Variable**_\n\ndefault: `GPL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Type of license for the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_license)]."],Rv=["```mysql\ndeclare @@local_infile boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether LOCAL is supported for LOAD DATA statements. Default can be overridden by a number of server and client settings, see text for more information [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_local_infile)]."],xv=["```mysql\ndeclare @@lock_order boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable LOCK_ORDER tool at runtime [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order)]."],wv=["```mysql\ndeclare @@lock_order_debug_loop boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to cause debug assert when LOCK_ORDER tool encounters dependency flagged as a loop [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_debug_loop)]."],Nv=["```mysql\ndeclare @@lock_order_debug_missing_arc boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to cause debug assert when LOCK_ORDER tool encounters undeclared dependency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_debug_missing_arc)]."],Cv=["```mysql\ndeclare @@lock_order_debug_missing_key boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to cause debug assert when LOCK_ORDER tool encounters object not properly instrumented with the Performance Schema [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_debug_missing_key)]."],kv=["```mysql\ndeclare @@lock_order_debug_missing_unlock boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to cause debug assert when LOCK_ORDER tool encounters lock that is destroyed while still held [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_debug_missing_unlock)]."],Ov=["```mysql\ndeclare @@lock_order_dependencies filename\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `empty string`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to the lock_order_dependencies.txt file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_dependencies)]."],Iv=["```mysql\ndeclare @@lock_order_extra_dependencies filename\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `empty string`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to a second dependency file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_extra_dependencies)]."],Lv=["```mysql\ndeclare @@lock_order_output_directory dirname\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `empty string`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory where LOCK_ORDER tool writes logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_output_directory)]."],Dv=["```mysql\ndeclare @@lock_order_print_txt boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to perform lock-order graph analysis and print textual report [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_print_txt)]."],Mv=["```mysql\ndeclare @@lock_order_trace_loop boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to print log file trace when LOCK_ORDER tool encounters dependency flagged as a loop [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_trace_loop)]."],Fv=["```mysql\ndeclare @@lock_order_trace_missing_arc boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to print log file trace when LOCK_ORDER tool encounters undeclared dependency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_trace_missing_arc)]."],Pv=["```mysql\ndeclare @@lock_order_trace_missing_key boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to print log file trace when LOCK_ORDER tool encounters object not properly instrumented with the Performance Schema [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_trace_missing_key)]."],Bv=["```mysql\ndeclare @@lock_order_trace_missing_unlock boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to print log file trace when LOCK_ORDER tool encounters lock that is destroyed while still held [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_order_trace_missing_unlock)]."],Uv=["```mysql\ndeclare @@lock_wait_timeout integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `31536000`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Timeout for metadata locks [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_wait_timeout)]."],Hv=["```mysql\ndeclare @@Locked_connects integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of attempts to connect to locked accounts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Locked_connects)]."],Wv=["```mysql\ndeclare @@locked_in_memory \n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether mysqld is locked in memory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_locked_in_memory)]."],Qv=["```mysql\ndeclare @@log filename\n```","_**System Variable**_ (⊘ 5.1.29, ⊗ 5.6.1)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log connections and queries to file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_log)]."],jv=["```mysql\ndeclare @@log_bin_trust_function_creators boolean\n```","_**System Variable**_ (⊕ 5.0.16)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_bin_trust_function_creators)]."],Gv=["```mysql\ndeclare @@log_bin_trust_routine_creators boolean\n```","_**System Variable**_ (⊕ 5.0.6, ⊘ 5.0.16, ⊗ 5.5.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","(deprecated) Use log-bin-trust-function-creators instead [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_bin_trust_routine_creators)]."],Xv=["```mysql\ndeclare @@log_output set\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `FILE`, valid values:\n\n- `TABLE`\n- `FILE`\n- `NONE`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The destination for general query log and slow query log output [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_output)]."],Yv=["```mysql\ndeclare @@log_queries_not_using_indexes boolean\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log queries that are executed without benefit of any index to the slow query log if it is open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_queries_not_using_indexes)]."],Kv=["```mysql\ndeclare @@log_slow_queries boolean\n```","_**System Variable**_ (⊘ 5.1.29, ⊗ 5.6.1)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slow_queries)]."],Zv=["```mysql\ndeclare @@log_backward_compatible_user_definitions boolean\n```","_**System Variable**_ (⊕ 5.7.6, ⊗ 5.7.9)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_backward_compatible_user_definitions)]."],$v=["```mysql\ndeclare @@log_bin boolean\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the binary log is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_bin)]."],Jv=["```mysql\ndeclare @@log_bin_basename filename\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path and base name for binary log files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_bin_basename)]."],eu=["```mysql\ndeclare @@log_bin_use_v1_row_events boolean\n```","_**System Variable**_ (⊕ 5.6.6, ⊘ 8.0.18)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether server is using version 1 binary log row events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_bin_use_v1_row_events)]."],tu=["```mysql\ndeclare @@log_builtin_as_identified_by_password boolean\n```","_**System Variable**_ (⊕ 5.7.9, ⊗ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_builtin_as_identified_by_password)]."],nu=["```mysql\ndeclare @@log_error_filter_rules string\n```","_**System Variable**_ (⊕ 8.0.2, ⊗ 8.0.4)\n\ndefault: `set by server`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Filter rules for error logging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error_filter_rules)]."],su=["```mysql\ndeclare @@log_error_services string\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `log_filter_internal; log_sink_internal`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Components to use for error logging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error_services)]."],ou=["```mysql\ndeclare @@log_error_suppression_list string\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Warning/information error log messages to suppress [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error_suppression_list)]."],au=["```mysql\ndeclare @@log_error_verbosity integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Error logging verbosity level [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error_verbosity)]."],iu=["```mysql\ndeclare @@log_slave_updates boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the slave should log the updates performed by its SQL thread to its own binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slave_updates)]."],ru=["```mysql\ndeclare @@log_slow_admin_statements boolean\n```","_**System Variable**_ (⊕ 5.7.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slow_admin_statements)]."],mu=["```mysql\ndeclare @@log_slow_extra boolean\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to write extra information to the slow query log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slow_extra)]."],lu=["```mysql\ndeclare @@log_slow_slave_statements boolean\n```","_**System Variable**_ (⊕ 5.7.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Cause slow statements as executed by the slave to be written to the slow query log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_slow_slave_statements)]."],du=["```mysql\ndeclare @@log_statements_unsafe_for_binlog boolean\n```","_**System Variable**_ (⊕ 5.7.11)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Disables error 1592 warnings being written to the error log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_statements_unsafe_for_binlog)]."],cu=["```mysql\ndeclare @@log_syslog boolean\n```","_**System Variable**_ (⊕ 5.7.5, ⊘ 8.0.2, ⊗ 8.0.13)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to write error log to syslog [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_syslog)]."],_u=["```mysql\ndeclare @@log_syslog_facility string\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 8.0.13)\n\ndefault: `daemon`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Facility for syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_syslog_facility)]."],pu=["```mysql\ndeclare @@log_syslog_include_pid boolean\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 8.0.13)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to include server PID in syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_syslog_include_pid)]."],hu=["```mysql\ndeclare @@log_syslog_tag string\n```","_**System Variable**_ (⊕ 5.7.5, ⊗ 8.0.13)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Tag for server identifier in syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_syslog_tag)]."],yu=["```mysql\ndeclare @@log_throttle_queries_not_using_indexes integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Throttle write rate to slow log for queries not using indexes slow query log if it is open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_throttle_queries_not_using_indexes)]."],vu=["```mysql\ndeclare @@log_timestamps enumeration\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `UTC`, valid values:\n\n- `UTC`\n- `SYSTEM`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log timestamp format [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_timestamps)]."],uu=["```mysql\ndeclare @@long_query_time numeric\n```","_**System Variable**_\n\ndefault: `10`, min: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log all queries that have taken more than long_query_time seconds to execute to file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time)]."],bu=["```mysql\ndeclare @@low_priority_updates boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether INSERT/DELETE/UPDATE has lower priority than selects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_low_priority_updates)]."],fu=["```mysql\ndeclare @@lower_case_file_system boolean\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable describes the case sensitivity of file names on the file system [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_file_system)]."],qu=["```mysql\ndeclare @@lower_case_table_names integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If set to 1, table names are stored in lowercase on disk and table names will be case-insensitive. Should be set to 2 if you are using a case-insensitive file system [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names)]."],gu=["```mysql\ndeclare @@mandatory_roles string\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Automatically granted roles for all users [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mandatory_roles)]."],Su=["```mysql\ndeclare @@master_info_repository string\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `TABLE`, valid values:\n\n- `FILE`\n- `TABLE`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_master_info_repository)]."],zu=["```mysql\ndeclare @@master_verify_checksum boolean\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Cause master to examine checksums when reading from the binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_master_verify_checksum)]."],Vu=["```mysql\ndeclare @@max_allowed_packet integer\n```","_**System Variable**_\n\ndefault: `67108864`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Max packet length to send to/receive from server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_allowed_packet)]."],Tu=["```mysql\ndeclare @@max_binlog_cache_size integer\n```","_**System Variable**_\n\ndefault: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Can be used to restrict the total size used to cache a multi-statement transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_binlog_cache_size)]."],Eu=["```mysql\ndeclare @@max_binlog_size integer\n```","_**System Variable**_\n\ndefault: `1073741824`, min: `4096`, max: `1073741824`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Binary log will be rotated automatically when size exceeds this value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_binlog_size)]."],Au=["```mysql\ndeclare @@max_binlog_stmt_cache_size integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndefault: `18446744073709547520`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Can be used to restrict the total size used to cache all nontransactional statements during a transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_binlog_stmt_cache_size)]."],Ru=["```mysql\ndeclare @@max_connect_errors integer\n```","_**System Variable**_\n\ndefault: `100`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of interrupted connections from a host before this host is blocked from further connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_connect_errors)]."],xu=["```mysql\ndeclare @@max_connections integer\n```","_**System Variable**_\n\ndefault: `151`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of simultaneous clients allowed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_connections)]."],wu=["```mysql\ndeclare @@max_delayed_threads integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndefault: `20`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Do not start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_delayed_threads)]."],Nu=["```mysql\ndeclare @@max_digest_length integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `1024`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum digest size in bytes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_digest_length)]."],Cu=["```mysql\ndeclare @@max_error_count integer\n```","_**System Variable**_\n\ndefault: `1024`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Max number of errors/warnings to store for a statement [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_error_count)]."],ku=["```mysql\ndeclare @@max_execution_time integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Statement execution timeout value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_execution_time)]."],Ou=["```mysql\ndeclare @@Max_execution_time_exceeded integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements that exceeded the execution timeout value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_execution_time_exceeded)]."],Iu=["```mysql\ndeclare @@Max_execution_time_set integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements for which execution timeout was set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_execution_time_set)]."],Lu=["```mysql\ndeclare @@Max_execution_time_set_failed integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements for which execution timeout setting failed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_execution_time_set_failed)]."],Du=["```mysql\ndeclare @@max_heap_table_size integer\n```","_**System Variable**_\n\ndefault: `16777216`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Do not allow creation of heap tables bigger than this [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size)]."],Mu=["```mysql\ndeclare @@max_insert_delayed_threads integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable is a synonym for max_delayed_threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_insert_delayed_threads)]."],Fu=["```mysql\ndeclare @@max_join_size integer\n```","_**System Variable**_\n\ndefault: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Joins that are probably going to read more than max_join_size records return an error [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_join_size)]."],Pu=["```mysql\ndeclare @@max_length_for_sort_data integer\n```","_**System Variable**_ (⊕ 4.1.1, ⊘ 8.0.20)\n\ndefault: `4096`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Max number of bytes in sorted records [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_length_for_sort_data)]."],Bu=["```mysql\ndeclare @@max_long_data_size integer\n```","_**System Variable**_ (⊕ 5.5.11, ⊘ 5.5.11)\n\ndefault: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Max size of parameter values that mysql_stmt_send_long_data() can send [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_long_data_size)]."],Uu=["```mysql\ndeclare @@max_points_in_geometry integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `65536`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Maximum number of points in geometry values for ST_Buffer_Strategy() [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_points_in_geometry)]."],Hu=["```mysql\ndeclare @@max_prepared_stmt_count integer\n```","_**System Variable**_ (⊕ 5.1.10)\n\ndefault: `16382`, min: `0`, max: `4194304`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum number of prepared statements in the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_prepared_stmt_count)]."],Wu=["```mysql\ndeclare @@max_relay_log_size integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If nonzero, relay log is rotated automatically when its size exceeds this value. If zero, size at which rotation occurs is determined by the value of max_binlog_size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_relay_log_size)]."],Qu=["```mysql\ndeclare @@max_seeks_for_key integer\n```","_**System Variable**_\n\ndefault: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Limit assumed max number of seeks when looking up rows based on a key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_seeks_for_key)]."],ju=["```mysql\ndeclare @@max_sort_length integer\n```","_**System Variable**_\n\ndefault: `1024`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Number of bytes to use when sorting data values [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_sort_length)]."],Gu=["```mysql\ndeclare @@max_sp_recursion_depth integer\n```","_**System Variable**_ (⊕ 5.0.17)\n\ndefault: `0`, max: `255`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum stored procedure recursion depth [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_sp_recursion_depth)]."],Xu=["```mysql\ndeclare @@max_statement_time integer\n```","_**System Variable**_ (⊕ 5.7.4, ⊗ 5.7.8)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Statement execution timeout value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_statement_time)]."],Yu=["```mysql\ndeclare @@max_tmp_tables integer\n```","_**System Variable**_ (⊘ 5.6.7, ⊗ 8.0.3)\n\ndefault: `32`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Unused [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_tmp_tables)]."],Ku=["```mysql\ndeclare @@Max_statement_time_exceeded integer\n```","_**System Variable**_ (⊕ 5.7.4, ⊗ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements that exceeded the execution timeout value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_statement_time_exceeded)]."],Zu=["```mysql\ndeclare @@Max_statement_time_set integer\n```","_**System Variable**_ (⊕ 5.7.4, ⊗ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements for which execution timeout was set [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_statement_time_set)]."],$u=["```mysql\ndeclare @@Max_statement_time_set_failed integer\n```","_**System Variable**_ (⊕ 5.7.4, ⊗ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements for which execution timeout setting failed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_statement_time_set_failed)]."],Ju=["```mysql\ndeclare @@Max_used_connections integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of connections that have been in use simultaneously since the server started [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_used_connections)]."],eb=["```mysql\ndeclare @@Max_used_connections_time datetime\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The time at which Max_used_connections reached its current value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Max_used_connections_time)]."],tb=["```mysql\ndeclare @@max_user_connections integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of active connections for a single user (0 = no limit) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_user_connections)]."],nb=["```mysql\ndeclare @@max_write_lock_count integer\n```","_**System Variable**_\n\ndefault: `18446744073709551615`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","After this many write locks, allow some read locks to run in between [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_write_lock_count)]."],sb=["```mysql\ndeclare @@mecab_charset string\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The character set currently used by the MeCab full-text parser plugin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_mecab_charset)]."],ob=["```mysql\ndeclare @@mecab_rc_file filename\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path to the mecabrc configuration file for the MeCab parser for full-text search [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mecab_rc_file)]."],ab=["```mysql\ndeclare @@memlock boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Lock the mysqld process in memory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_memlock)]."],ib=["```mysql\ndeclare @@disabledby boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable connection encryption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_ssl)]."],rb=["```mysql\ndeclare @@metadata_locks_cache_size integer\n```","_**System Variable**_ (⊕ 5.6.4, ⊘ 5.7.4, ⊗ 8.0.13)\n\ndefault: `1024`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the metadata locks cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_metadata_locks_cache_size)]."],mb=["```mysql\ndeclare @@metadata_locks_hash_instances integer\n```","_**System Variable**_ (⊕ 5.6.8, ⊘ 5.7.4, ⊗ 8.0.13)\n\ndefault: `8`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of metadata lock hashes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_metadata_locks_hash_instances)]."],lb=["```mysql\ndeclare @@min_examined_row_limit integer\n```","_**System Variable**_ (⊕ 6.0.4)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Queries examining fewer than this number of rows are not logged to slow query log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_min_examined_row_limit)]."],db=["```mysql\ndeclare @@multi_range_count integer\n```","_**System Variable**_ (⊕ 5.0.3, ⊘ 5.6.7, ⊗ 6.0.3)\n\ndefault: `256`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of ranges to send to a table handler at once during range selects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_multi_range_count)]."],cb=["```mysql\ndeclare @@myisam_data_pointer_size integer\n```","_**System Variable**_ (⊕ 4.1.2)\n\ndefault: `6`, min: `2`, max: `7`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default pointer size to be used for MyISAM tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_data_pointer_size)]."],_b=["```mysql\ndeclare @@myisam_max_extra_sort_file_size integer\n```","_**System Variable**_ (⊘ 5.0.6)\n\ndefault: `2147483648`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Deprecated option [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_max_extra_sort_file_size)]."],pb=["```mysql\ndeclare @@myisam_max_sort_file_size integer\n```","_**System Variable**_\n\ndefault: `9223372036854775807`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Do not use the fast sort index method to create index if the temporary file would get bigger than this [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_max_sort_file_size)]."],hb=["```mysql\ndeclare @@myisam_mmap_size integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `18446744073709551615`, min: `7`, max: `18446744073709551615`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum amount of memory to use for memory mapping compressed MyISAM files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_mmap_size)]."],yb=["```mysql\ndeclare @@myisam_recover_options enumeration\n```","_**System Variable**_\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `DEFAULT`\n- `BACKUP`\n- `FORCE`\n- `QUICK`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set the mode for automatic MyISAM recovery [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_recover_options)]."],vb=["```mysql\ndeclare @@myisam_repair_threads integer\n```","_**System Variable**_\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_repair_threads)]."],ub=["```mysql\ndeclare @@myisam_sort_buffer_size integer\n```","_**System Variable**_\n\ndefault: `8388608`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The buffer allocated when sorting the index for a REPAIR TABLE or when creating indexes for CREATE INDEX or ALTER TABLE [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_sort_buffer_size)]."],bb=["```mysql\ndeclare @@myisam_stats_method enumeration\n```","_**System Variable**_ (⊕ 5.0.14)\n\ndefault: `nulls_unequal`, valid values:\n\n- `nulls_equal`\n- `nulls_unequal`\n- `nulls_ignored`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies how MyISAM index statistics collection code should treat NULLs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_stats_method)]."],fb=["```mysql\ndeclare @@myisam_use_mmap boolean\n```","_**System Variable**_ (⊕ 5.1.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use memory mapping for reading and writing MyISAM tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_myisam_use_mmap)]."],qb=["```mysql\ndeclare @@mysql_native_password_proxy_users boolean\n```","_**System Variable**_ (⊕ 5.7.7)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the mysql_native_password authentication plugin does proxying [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysql_native_password_proxy_users)]."],gb=["```mysql\ndeclare @@mysql_firewall_max_query_size integer\n```","_**System Variable**_ (⊕ 5.6.24, ⊗ 5.6.26)\n\ndefault: `4096`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum size of recorded statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysql_firewall_max_query_size)]."],Sb=["```mysql\ndeclare @@mysql_firewall_mode boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether MySQL Enterprise Firewall is operational [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysql_firewall_mode)]."],zb=["```mysql\ndeclare @@mysql_firewall_trace boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable firewall trace [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_mysql_firewall_trace)]."],Vb=["```mysql\ndeclare @@Ndb_api_bytes_received_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) received from the data nodes by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_received_count)]."],Tb=["```mysql\ndeclare @@Ndb_api_bytes_received_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) received from the data nodes in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_received_count_session)]."],Eb=["```mysql\ndeclare @@Ndb_api_bytes_received_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) received from the data nodes by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_received_count_slave)]."],Ab=["```mysql\ndeclare @@Ndb_api_bytes_sent_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) sent to the data nodes by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_sent_count)]."],Rb=["```mysql\ndeclare @@Ndb_api_bytes_sent_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) sent to the data nodes in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_sent_count_session)]."],xb=["```mysql\ndeclare @@Ndb_api_bytes_sent_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Amount of data (in bytes) sent to the data nodes by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_bytes_sent_count_slave)]."],wb=["```mysql\ndeclare @@Ndb_api_event_bytes_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes of events received by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_bytes_count)]."],Nb=["```mysql\ndeclare @@Ndb_api_event_bytes_count_injector integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of bytes of events received by the NDB binary log injector thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_bytes_count_injector)]."],Cb=["```mysql\ndeclare @@Ndb_api_event_data_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of row change events received by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_data_count)]."],kb=["```mysql\ndeclare @@Ndb_api_event_data_count_injector integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of row change events received by the NDB binary log injector thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_data_count_injector)]."],Ob=["```mysql\ndeclare @@Ndb_api_event_nondata_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of events received, other than row change events, by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_nondata_count)]."],Ib=["```mysql\ndeclare @@Ndb_api_event_nondata_count_injector integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of events received, other than row change events, by the NDB binary log injector thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_event_nondata_count_injector)]."],Lb=["```mysql\ndeclare @@Ndb_api_pk_op_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using primary keys by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pk_op_count)]."],Db=["```mysql\ndeclare @@Ndb_api_pk_op_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using primary keys in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pk_op_count_session)]."],Mb=["```mysql\ndeclare @@Ndb_api_pk_op_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using primary keys by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pk_op_count_slave)]."],Fb=["```mysql\ndeclare @@Ndb_api_pruned_scan_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of scans that have been pruned to a single partition by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pruned_scan_count)]."],Pb=["```mysql\ndeclare @@Ndb_api_pruned_scan_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of scans that have been pruned to a single partition in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pruned_scan_count_session)]."],Bb=["```mysql\ndeclare @@Ndb_api_pruned_scan_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of scans that have been pruned to a single partition by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_pruned_scan_count_slave)]."],Ub=["```mysql\ndeclare @@Ndb_api_range_scan_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of range scans that have been started by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_range_scan_count)]."],Hb=["```mysql\ndeclare @@Ndb_api_range_scan_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of range scans that have been started in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_range_scan_count_session)]."],Wb=["```mysql\ndeclare @@Ndb_api_range_scan_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of range scans that have been started by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_range_scan_count_slave)]."],Qb=["```mysql\ndeclare @@Ndb_api_read_row_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_read_row_count)]."],jb=["```mysql\ndeclare @@Ndb_api_read_row_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_read_row_count_session)]."],Gb=["```mysql\ndeclare @@Ndb_api_read_row_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_read_row_count_slave)]."],Xb=["```mysql\ndeclare @@Ndb_api_scan_batch_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of batches of rows received by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_scan_batch_count)]."],Yb=["```mysql\ndeclare @@Ndb_api_scan_batch_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of batches of rows received in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_scan_batch_count_session)]."],Kb=["```mysql\ndeclare @@Ndb_api_scan_batch_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of batches of rows received by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_scan_batch_count_slave)]."],Zb=["```mysql\ndeclare @@Ndb_api_table_scan_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of table scans that have been started, including scans of internal tables, by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_table_scan_count)]."],$b=["```mysql\ndeclare @@Ndb_api_table_scan_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of table scans that have been started, including scans of internal tables, in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_table_scan_count_session)]."],Jb=["```mysql\ndeclare @@Ndb_api_table_scan_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of table scans that have been started, including scans of internal tables, by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_table_scan_count_slave)]."],ef=["```mysql\ndeclare @@Ndb_api_trans_abort_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_abort_count)]."],tf=["```mysql\ndeclare @@Ndb_api_trans_abort_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_abort_count_session)]."],nf=["```mysql\ndeclare @@Ndb_api_trans_abort_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_abort_count_slave)]."],sf=["```mysql\ndeclare @@Ndb_api_trans_close_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_close_count)]."],of=["```mysql\ndeclare @@Ndb_api_trans_close_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_close_count_session)]."],af=["```mysql\ndeclare @@Ndb_api_trans_close_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_close_count_slave)]."],rf=["```mysql\ndeclare @@Ndb_api_trans_commit_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions committed by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_commit_count)]."],mf=["```mysql\ndeclare @@Ndb_api_trans_commit_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions committed in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_commit_count_session)]."],lf=["```mysql\ndeclare @@Ndb_api_trans_commit_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions committed by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_commit_count_slave)]."],df=["```mysql\ndeclare @@Ndb_api_trans_local_read_row_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_local_read_row_count)]."],cf=["```mysql\ndeclare @@Ndb_api_trans_local_read_row_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_local_read_row_count_session)]."],_f=["```mysql\ndeclare @@Ndb_api_trans_local_read_row_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows that have been read by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_local_read_row_count_slave)]."],pf=["```mysql\ndeclare @@Ndb_api_trans_start_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions started by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_start_count)]."],hf=["```mysql\ndeclare @@Ndb_api_trans_start_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions started in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_start_count_session)]."],yf=["```mysql\ndeclare @@Ndb_api_trans_start_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions started by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_trans_start_count_slave)]."],vf=["```mysql\ndeclare @@Ndb_api_uk_op_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using unique keys by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_uk_op_count)]."],uf=["```mysql\ndeclare @@Ndb_api_uk_op_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using unique keys in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_uk_op_count_session)]."],bf=["```mysql\ndeclare @@Ndb_api_uk_op_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of operations based on or using unique keys by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_uk_op_count_slave)]."],ff=["```mysql\ndeclare @@Ndb_api_wait_exec_complete_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for execution of an operation to complete by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_exec_complete_count)]."],qf=["```mysql\ndeclare @@Ndb_api_wait_exec_complete_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for execution of an operation to complete in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_exec_complete_count_session)]."],gf=["```mysql\ndeclare @@Ndb_api_wait_exec_complete_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for execution of an operation to complete by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_exec_complete_count_slave)]."],Sf=["```mysql\ndeclare @@Ndb_api_wait_meta_request_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked waiting for a metadata-based signal by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_meta_request_count)]."],zf=["```mysql\ndeclare @@Ndb_api_wait_meta_request_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked waiting for a metadata-based signal in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_meta_request_count_session)]."],Vf=["```mysql\ndeclare @@Ndb_api_wait_meta_request_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked waiting for a metadata-based signal by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_meta_request_count_slave)]."],Tf=["```mysql\ndeclare @@Ndb_api_wait_nanos_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_nanos_count)]."],Ef=["```mysql\ndeclare @@Ndb_api_wait_nanos_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total time (in nanoseconds) spent waiting for some type of signal from the data nodes in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_nanos_count_session)]."],Af=["```mysql\ndeclare @@Ndb_api_wait_nanos_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_nanos_count_slave)]."],Rf=["```mysql\ndeclare @@Ndb_api_wait_scan_result_count integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for a scan-based signal by this MySQL Server (SQL node) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_scan_result_count)]."],xf=["```mysql\ndeclare @@Ndb_api_wait_scan_result_count_session integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for a scan-based signal in this client session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_scan_result_count_session)]."],wf=["```mysql\ndeclare @@Ndb_api_wait_scan_result_count_slave integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.11)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times thread has been blocked while waiting for a scan-based signal by this slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_api_wait_scan_result_count_slave)]."],Nf=["```mysql\ndeclare @@ndb_autoincrement_prefetch_sz integer\n```","_**System Variable**_ (⊕ 4.1.8)\n\ndefault: `512`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","NDB auto-increment prefetch size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_autoincrement_prefetch_sz)]."],Cf=["```mysql\ndeclare @@ndb_cache_check_time integer\n```","_**System Variable**_ (⊘ 5.7.20)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_cache_check_time)]."],kf=["```mysql\ndeclare @@ndb_clear_apply_status boolean\n```","_**System Variable**_ (⊕ 5.6.28-ndb-7.4.9)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Causes RESET SLAVE to clear all rows from the ndb_apply_status table; ON by default [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_clear_apply_status)]."],Of=["```mysql\ndeclare @@Ndb_cluster_node_id integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If the server is acting as an NDB Cluster node, then the value of this variable its node ID in the cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_cluster_node_id)]."],If=["```mysql\ndeclare @@Ndb_config_from_host integer\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The host name or IP address of the Cluster management server Formerly Ndb_connected_host [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_config_from_host)]."],Lf=["```mysql\ndeclare @@Ndb_config_from_port integer\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The port for connecting to Cluster management server. Formerly Ndb_connected_port [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_config_from_port)]."],Df=["```mysql\ndeclare @@Ndb_conflict_fn_epoch integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows that have been found in conflict by the NDB$EPOCH() conflict detection function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_epoch)]."],Mf=["```mysql\ndeclare @@Ndb_conflict_fn_epoch2 integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows that have been found in conflict by the NDB$EPOCH2() conflict detection function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_epoch2)]."],Ff=["```mysql\ndeclare @@Ndb_conflict_fn_epoch2_trans integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows that have been found in conflict by the NDB$EPOCH2_TRANS() conflict detection function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_epoch2_trans)]."],Pf=["```mysql\ndeclare @@Ndb_conflict_fn_epoch_trans integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows that have been found in conflict by the NDB$EPOCH_TRANS() conflict detection function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_epoch_trans)]."],Bf=["```mysql\ndeclare @@Ndb_conflict_fn_max integer\n```","_**System Variable**_ (⊕ 5.1.22-ndb-6.3.3)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'If the server is part of an NDB Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_max)].'],Uf=["```mysql\ndeclare @@Ndb_conflict_fn_max_del_win integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that conflict resolution based on outcome of NDB$MAX_DELETE_WIN() has been applied [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_max_del_win)]."],Hf=["```mysql\ndeclare @@Ndb_conflict_fn_old integer\n```","_**System Variable**_ (⊕ 5.1.22-ndb-6.3.4)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'If the server is part of an NDB Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_fn_old)].'],Wf=["```mysql\ndeclare @@Ndb_conflict_last_conflict_epoch integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Most recent NDB epoch on this slave in which a conflict was detected [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_last_conflict_epoch)]."],Qf=["```mysql\ndeclare @@Ndb_conflict_last_stable_epoch integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows found to be in conflict by a transactional conflict function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_last_stable_epoch)]."],jf=["```mysql\ndeclare @@Ndb_conflict_reflected_op_discard_count integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of reflected operations that were not applied due an error during execution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_reflected_op_discard_count)]."],Gf=["```mysql\ndeclare @@Ndb_conflict_reflected_op_prepare_count integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of reflected operations received that have been prepared for execution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_reflected_op_prepare_count)]."],Xf=["```mysql\ndeclare @@Ndb_conflict_refresh_op_count integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of refresh operations that have been prepared [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_refresh_op_count)]."],Yf=["```mysql\ndeclare @@Ndb_conflict_trans_conflict_commit_count integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of epoch transactions committed after requiring transactional conflict handling [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_trans_conflict_commit_count)]."],Kf=["```mysql\ndeclare @@Ndb_conflict_trans_detect_iter_count integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of internal iterations required to commit an epoch transaction. Should be (slightly) greater than or equal to Ndb_conflict_trans_conflict_commit_count [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_trans_detect_iter_count)]."],Zf=["```mysql\ndeclare @@Ndb_conflict_trans_reject_count integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions rejected after being found in conflict by a transactional conflict function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_trans_reject_count)]."],$f=["```mysql\ndeclare @@Ndb_conflict_trans_row_conflict_count integer\n```","_**System Variable**_ (⊕ 5.6.21-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows found in conflict by a transactional conflict function. Includes any rows included in or dependent on conflicting transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_trans_row_conflict_count)]."],Jf=["```mysql\ndeclare @@Ndb_conflict_trans_row_reject_count integer\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Total number of rows realigned after being found in conflict by a transactional conflict function. Includes Ndb_conflict_trans_row_conflict_count and any rows included in or dependent on conflicting transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_conflict_trans_row_reject_count)]."],eq=["```mysql\ndeclare @@ndb_data_node_neighbour integer\n```","_**System Variable**_ (⊕ 5.7.12-ndb-7.5.2)\n\ndefault: `0`, min: `0`, max: `255`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'Specifies cluster data node "closest" to this MySQL Server, for transaction hinting and fully replicated tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_data_node_neighbour)].'],tq=["```mysql\ndeclare @@ndb_default_column_format enumeration\n```","_**System Variable**_ (⊕ 5.7.11-ndb-7.5.1)\n\ndefault: `FIXED`, valid values:\n\n- `FIXED`\n- `DYNAMIC`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets default row format and column format (FIXED or DYNAMIC) used for new NDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_default_column_format)]."],nq=["```mysql\ndeclare @@ndb_deferred_constraints integer\n```","_**System Variable**_ (⊕ 5.1.56-ndb-7.1.14)\n\ndefault: `0`, min: `0`, max: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_deferred_constraints)]."],sq=["```mysql\ndeclare @@ndb_dbg_check_shares integer\n```","_**System Variable**_ (⊕ 8.0.13-ndb-8.0.13)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Check for any lingering shares (debug builds only) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_dbg_check_shares)]."],oq=["```mysql\ndeclare @@ndb_distribution enumeration\n```","_**System Variable**_ (⊕ 5.1.32-ndb-7.0.4)\n\ndefault: `KEYHASH`, valid values:\n\n- `LINHASH`\n- `KEYHASH`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_distribution)]."],aq=["```mysql\ndeclare @@Ndb_epoch_delete_delete_count integer\n```","_**System Variable**_ (⊕ 5.6.22-ndb-7.4.2)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of delete-delete conflicts detected (delete operation is applied, but row does not exist) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_epoch_delete_delete_count)]."],iq=["```mysql\ndeclare @@ndb_eventbuffer_free_percent integer\n```","_**System Variable**_ (⊕ 5.6.22-ndb-7.4.3)\n\ndefault: `20`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Percentage of free memory that should be available in event buffer before resumption of buffering, after reaching limit set by ndb_eventbuffer_max_alloc [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_eventbuffer_free_percent)]."],rq=["```mysql\ndeclare @@ndb_eventbuffer_max_alloc integer\n```","_**System Variable**_ (⊕ 5.6.14-ndb-7.3.3)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum memory that can be allocated for buffering events by the NDB API. Defaults to 0 (no limit) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_eventbuffer_max_alloc)]."],mq=["```mysql\ndeclare @@Ndb_execute_count integer\n```","_**System Variable**_ (⊕ 5.1.22-ndb-6.3.6)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Provides the number of round trips to the NDB kernel made by operations [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_execute_count)]."],lq=["```mysql\ndeclare @@ndb_extra_logging integer\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls logging of NDB Cluster schema, connection, and data distribution events in the MySQL error log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_extra_logging)]."],dq=["```mysql\ndeclare @@ndb_force_send boolean\n```","_**System Variable**_ (⊕ 4.1.8)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Forces sending of buffers to NDB immediately, without waiting for other threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_force_send)]."],cq=["```mysql\ndeclare @@ndb_fully_replicated boolean\n```","_**System Variable**_ (⊕ 5.7.12-ndb-7-5-2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether new NDB tables are fully replicated [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_fully_replicated)]."],_q=["```mysql\ndeclare @@ndb_index_stat_cache_entries integer\n```","_**System Variable**_ (⊘ 5.1.19, ⊗ 5.6.16-ndb-7.3.5)\n\ndefault: `32`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the granularity of the statistics by determining the number of starting and ending keys [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_index_stat_cache_entries)]."],pq=["```mysql\ndeclare @@ndb_index_stat_enable boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use NDB index statistics in query optimization [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_index_stat_enable)]."],hq=["```mysql\ndeclare @@ndb_index_stat_option string\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `loop_checkon=1000ms,loop_idle=1000ms,loop_busy=100ms,         update_batch=1,read_batch=4,idle_batch=32,check_batch=32,         check_delay=1m,delete_batch=8,clean_delay=0,error_batch=4,         error_delay=1m,evict_batch=8,evict_delay=1m,cache_limit=32M,         cache_lowpct=90`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Comma-separated list of tunable options for NDB index statistics; the list should contain no spaces [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_index_stat_option)]."],yq=["```mysql\ndeclare @@ndb_index_stat_update_freq integer\n```","_**System Variable**_ (⊘ 5.1.19, ⊗ 5.6.16-ndb-7.3.5)\n\ndefault: `20`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How often to query data nodes instead of the statistics cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_index_stat_update_freq)]."],vq=["```mysql\ndeclare @@ndb_join_pushdown boolean\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.2.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables pushing down of joins to data nodes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_join_pushdown)]."],uq=["```mysql\ndeclare @@Ndb_last_commit_epoch_server integer\n```","_**System Variable**_ (⊕ 5.6.20-ndb-7.4.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Epoch most recently committed by NDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_last_commit_epoch_server)]."],bq=["```mysql\ndeclare @@Ndb_last_commit_epoch_session integer\n```","_**System Variable**_ (⊕ 5.6.20-ndb-7.4.1)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Epoch most recently committed by this NDB client [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_last_commit_epoch_session)]."],fq=["```mysql\ndeclare @@ndb_log_apply_status boolean\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.1.10)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether or not a MySQL server acting as a slave logs mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_apply_status)]."],qq=["```mysql\ndeclare @@ndb_log_bin boolean\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Write updates to NDB tables in the binary log. Effective only if binary logging is enabled with --log-bin [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_bin)]."],gq=["```mysql\ndeclare @@ndb_log_binlog_index boolean\n```","_**System Variable**_ (⊕ 5.1.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Insert mapping between epochs and binary log positions into the ndb_binlog_index table. Defaults to ON. Effective only if binary logging is enabled on the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_binlog_index)]."],Sq=["```mysql\ndeclare @@ndb_log_empty_epochs boolean\n```","_**System Variable**_ (⊕ 5.1.31-ndb-6.4.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_empty_epochs)]."],zq=["```mysql\ndeclare @@ndb_log_empty_update boolean\n```","_**System Variable**_ (⊕ 5.1.31-ndb-6.4.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When enabled, updates which produce no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_empty_update)]."],Vq=["```mysql\ndeclare @@ndb_log_exclusive_reads boolean\n```","_**System Variable**_ (⊕ 5.6.20-ndb-7.4.1)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_exclusive_reads)]."],Tq=["```mysql\ndeclare @@ndb_log_orig boolean\n```","_**System Variable**_ (⊕ 5.1.22-ndb-6.3.2)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the id and epoch of the originating server are recorded in the mysql.ndb_binlog_index table. Set using the --ndb-log-orig option when starting mysqld [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_orig)]."],Eq=["```mysql\ndeclare @@ndb_log_transaction_id boolean\n```","_**System Variable**_ (⊕ 5.5.15-ndb-7.2.1)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether NDB transaction IDs are written into the binary log (Read-only.) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_log_transaction_id)]."],Aq=["```mysql\ndeclare @@ndb_metadata_check boolean\n```","_**System Variable**_ (⊕ 8.0.16-ndb-8.0.16)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable auto-detection of NDB metadata changes with respect to MySQL data dictionary; enabled by default [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_metadata_check)]."],Rq=["```mysql\ndeclare @@Ndb_metadata_blacklist_size integer\n```","_**System Variable**_ (⊕ 8.0.18-ndb-8.0.18)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of NDB metadata objects that NDB binlog thread has failed to synchronize [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_metadata_blacklist_size)]."],xq=["```mysql\ndeclare @@ndb_metadata_check_interval integer\n```","_**System Variable**_ (⊕ 8.0.16-ndb-8.0.16)\n\ndefault: `60`, min: `0`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Interval in seconds to perform check for NDB metadata changes with respect to MySQL data dictionary [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_metadata_check_interval)]."],wq=["```mysql\ndeclare @@Ndb_metadata_detected_count integer\n```","_**System Variable**_ (⊕ 8.0.16-ndb-8.0.16)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times NDB metadata change monitor thread has detected changes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_metadata_detected_count)]."],Nq=["```mysql\ndeclare @@ndb_metadata_sync boolean\n```","_**System Variable**_ (⊕ 8.0.19-ndb-8.0.19)\n\ndefault: `false`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Triggers immediate synchronization of all changes between NDB dictionary and MySQL data dictionary; causes ndb_metadata_check and ndb_metadata_check_interval values to be ignored. Resets to false when synchronization is complete [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_metadata_sync)]."],Cq=["```mysql\ndeclare @@Ndb_metadata_synced_count integer\n```","_**System Variable**_ (⊕ 8.0.18-ndb-8.0.18)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of NDB metadata objects which have been synchronized [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_metadata_synced_count)]."],kq=["```mysql\ndeclare @@Ndb_number_of_data_nodes integer\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If the server is part of an NDB Cluster, the value of this variable is the number of data nodes in the cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_number_of_data_nodes)]."],Oq=["```mysql\ndeclare @@ndb_optimized_node_selection integer\n```","_**System Variable**_ (⊕ 4.1.9)\n\ndefault: `3`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Determines how an SQL node chooses a cluster data node to use as transaction coordinator [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_optimized_node_selection)]."],Iq=["```mysql\ndeclare @@Ndb_pruned_scan_count integer\n```","_**System Variable**_ (⊕ 5.1.32-ndb-7.0.5)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of scans executed by NDB since the cluster was last started where partition pruning could be used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_pruned_scan_count)]."],Lq=["```mysql\ndeclare @@Ndb_pushed_queries_defined integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.2.0)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that API nodes have attempted to push down to the data nodes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_pushed_queries_defined)]."],Dq=["```mysql\ndeclare @@Ndb_pushed_queries_dropped integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.2.0)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that API nodes have tried to push down, but failed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_pushed_queries_dropped)]."],Mq=["```mysql\ndeclare @@Ndb_pushed_queries_executed integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.2.0)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins successfully pushed down and executed on the data nodes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_pushed_queries_executed)]."],Fq=["```mysql\ndeclare @@Ndb_pushed_reads integer\n```","_**System Variable**_ (⊕ 5.1.51-ndb-7.2.0)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of reads executed on the data nodes by pushed-down joins [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_pushed_reads)]."],Pq=["```mysql\ndeclare @@ndb_read_backup boolean\n```","_**System Variable**_ (⊕ 5.7.12-ndb-7.5.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable read from any replica for all NDB tables; use NDB_TABLE=READ_BACKUP={0|1} with CREATE TABLE or ALTER TABLE to enable or disable for individual NDB tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_read_backup)]."],Bq=["```mysql\ndeclare @@ndb_recv_thread_activation_threshold integer\n```","_**System Variable**_ (⊕ 5.6.10-ndb-7.3.1)\n\ndefault: `8`, min: `0 (MIN_ACTIVATION_THRESHOLD)`, max: `16 (MAX_ACTIVATION_THRESHOLD)`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Activation threshold when receive thread takes over the polling of the cluster connection (measured in concurrently active threads) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_recv_thread_activation_threshold)]."],Uq=["```mysql\ndeclare @@ndb_recv_thread_cpu_mask bitmap\n```","_**System Variable**_ (⊕ 5.6.10-ndb-7.3.1)\n\ndefault: `[empty]`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","CPU mask for locking receiver threads to specific CPUs; specified as hexadecimal. See documentation for details [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_recv_thread_cpu_mask)]."],Hq=["```mysql\ndeclare @@ndb_report_thresh_binlog_epoch_slip integer\n```","_**System Variable**_\n\ndefault: `10`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","NDB 7.5.4 and later: Threshold for number of epochs completely buffered, but not yet consumed by binlog injector thread which when exceeded generates BUFFERED_EPOCHS_OVER_THRESHOLD event buffer status message; prior to NDB 7.5.4: Threshold for number of epochs to lag behind before reporting binary log status [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_report_thresh_binlog_epoch_slip)]."],Wq=["```mysql\ndeclare @@ndb_report_thresh_binlog_mem_usage integer\n```","_**System Variable**_\n\ndefault: `10`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This is a threshold on the percentage of free memory remaining before reporting binary log status [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_report_thresh_binlog_mem_usage)]."],Qq=["```mysql\ndeclare @@ndb_row_checksum integer\n```","_**System Variable**_ (⊕ 5.7.23-ndb-7.6.8)\n\ndefault: `1`, min: `0`, max: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When enabled, set row checksums; enabled by default [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_row_checksum)]."],jq=["```mysql\ndeclare @@Ndb_scan_count integer\n```","_**System Variable**_ (⊕ 5.1.32-ndb-7.0.5)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of scans executed by NDB since the cluster was last started [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_scan_count)]."],Gq=["```mysql\ndeclare @@ndb_schema_dist_lock_wait_timeout integer\n```","_**System Variable**_ (⊕ 8.0.18-ndb-8.0.18)\n\ndefault: `30`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Time during schema distribution to wait for lock before returning error [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_schema_dist_lock_wait_timeout)]."],Xq=["```mysql\ndeclare @@ndb_schema_dist_timeout integer\n```","_**System Variable**_ (⊕ 8.0.16-ndb-8.0.16)\n\ndefault: `120`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Time to wait before detecting timeout during schema distribution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_schema_dist_timeout)]."],Yq=["```mysql\ndeclare @@ndb_schema_dist_upgrade_allowed boolean\n```","_**System Variable**_ (⊕ 8.0.17-ndb-8.0.17)\n\ndefault: `true`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allow schema distribution table upgrade when connecting to NDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_schema_dist_upgrade_allowed)]."],Kq=["```mysql\ndeclare @@ndb_show_foreign_key_mock_tables boolean\n```","_**System Variable**_ (⊕ 5.6.11-ndb-7.3.2)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Show the mock tables used to support foreign_key_checks=0 [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_show_foreign_key_mock_tables)]."],Zq=["```mysql\ndeclare @@ndb_slave_conflict_role enumeration\n```","_**System Variable**_ (⊕ 5.6.20-ndb-7.4.1)\n\ndefault: `NONE`, valid values:\n\n- `NONE`\n- `PRIMARY`\n- `SECONDARY`\n- `PASS`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Role for slave to play in conflict detection and resolution. Value is one of PRIMARY, SECONDARY, PASS, or NONE (default). Can be changed only when slave SQL thread is stopped. See documentation for further information [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_slave_conflict_role)]."],$q=["```mysql\ndeclare @@Ndb_slave_max_replicated_epoch integer\n```","_**System Variable**_ (⊕ 5.6.20-ndb-7.4.1)\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The most recently committed NDB epoch on this slave. When this value is greater than or equal to Ndb_conflict_last_conflict_epoch, no conflicts have yet been detected [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_slave_max_replicated_epoch)]."],Jq=["```mysql\ndeclare @@Ndb_system_name string\n```","_**System Variable**_ (⊕ 5.7.18-ndb-7.6.2)\n\ndefault: `[none]`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Configured cluster system name; empty if server not connected to NDB [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_system_name)]."],eg=["```mysql\ndeclare @@ndb_table_no_logging boolean\n```","_**System Variable**_ (⊕ 5.1.23-ndb-6.3.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","NDB tables created when this setting is enabled are not checkpointed to disk (although table schema files are created). The setting in effect when the table is created with or altered to use NDBCLUSTER persists for the lifetime of the table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_table_no_logging)]."],tg=["```mysql\ndeclare @@ndb_table_temporary boolean\n```","_**System Variable**_ (⊕ 5.1.23-ndb-6.3.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","NDB tables are not persistent on disk: no schema files are created and the tables are not logged [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_table_temporary)]."],ng=["```mysql\ndeclare @@Ndb_trans_hint_count_session integer\n```","_**System Variable**_ (⊕ 8.0.17-ndb-8.0.17)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of transactions using hints that have been started in this session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ndb_trans_hint_count_session)]."],sg=["```mysql\ndeclare @@ndb_use_copying_alter_table \n```","_**System Variable**_ (⊕ 5.1.12)\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use copying ALTER TABLE operations in NDB Cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_use_copying_alter_table)]."],og=["```mysql\ndeclare @@ndb_use_exact_count boolean\n```","_**System Variable**_ (⊕ 4.1.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use exact row count when planning queries [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_use_exact_count)]."],ag=["```mysql\ndeclare @@ndb_use_transactions boolean\n```","_**System Variable**_ (⊕ 4.1.18)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_use_transactions)]."],ig=["```mysql\ndeclare @@ndb_version string\n```","_**System Variable**_ (⊕ 5.1.16-ndb-7.1.19)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Shows build and NDB engine version as an integer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_version)]."],rg=["```mysql\ndeclare @@ndb_version_string string\n```","_**System Variable**_ (⊕ 5.1.16-ndb-7.1.19)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Shows build information including NDB engine version in ndb-x.y.z format [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndb_version_string)]."],mg=["```mysql\ndeclare @@ndbinfo enumeration\n```","_**System Variable**_ (⊕ 8.0.13-ndb-8.0.13)\n\ndefault: `ON`, valid values:\n\n- `OFF`\n- `FORCE`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable ndbinfo plugin, if supported [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_ndbinfo)]."],lg=["```mysql\ndeclare @@ndbinfo_database string\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `ndbinfo`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The name used for the NDB information database; read only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_database)]."],dg=["```mysql\ndeclare @@ndbinfo_max_bytes integer\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used for debugging only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_max_bytes)]."],cg=["```mysql\ndeclare @@ndbinfo_max_rows integer\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `10`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used for debugging only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_max_rows)]."],_g=["```mysql\ndeclare @@ndbinfo_offline boolean\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Put the ndbinfo database into offline mode, in which no rows are returned from tables or views [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_offline)]."],pg=["```mysql\ndeclare @@ndbinfo_show_hidden boolean\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to show ndbinfo internal base tables in the mysql client. The default is OFF [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_show_hidden)]."],hg=["```mysql\ndeclare @@ndbinfo_table_prefix string\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndefault: `ndb$`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The prefix to use for naming ndbinfo internal base tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_table_prefix)]."],yg=["```mysql\ndeclare @@ndbinfo_version string\n```","_**System Variable**_ (⊕ 5.1.41-ndb-7.1.1)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The version of the ndbinfo engine; read only [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ndbinfo_version)]."],vg=["```mysql\ndeclare @@net_buffer_length integer\n```","_**System Variable**_\n\ndefault: `16384`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Buffer length for TCP/IP and socket communication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_buffer_length)]."],ug=["```mysql\ndeclare @@net_read_timeout integer\n```","_**System Variable**_\n\ndefault: `30`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for more data from a connection before aborting the read [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout)]."],bg=["```mysql\ndeclare @@net_retry_count integer\n```","_**System Variable**_\n\ndefault: `10`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times to retry an interrupted read or write on a communication port before giving up [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_retry_count)]."],fg=["```mysql\ndeclare @@net_write_timeout integer\n```","_**System Variable**_\n\ndefault: `60`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for a block to be written to a connection before aborting the write [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout)]."],qg=["```mysql\ndeclare @@ngram_token_size integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `2`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the n-gram token size for the full-text search ngram parser [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ngram_token_size)]."],gg=["```mysql\ndeclare @@Not_flushed_delayed_rows integer\n```","_**System Variable**_ (⊘ 5.6.7)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows waiting to be written in INSERT DELAY queues [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Not_flushed_delayed_rows)]."],Sg=["```mysql\ndeclare @@offline_mode boolean\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether server is offline [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_offline_mode)]."],zg=["```mysql\ndeclare @@old boolean\n```","_**System Variable**_ (⊕ 5.1.18)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Cause the server to revert to certain behaviors present in older versions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_old)]."],Vg=["```mysql\ndeclare @@old_alter_table boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use old, nonoptimized alter table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_old_alter_table)]."],Tg=["```mysql\ndeclare @@old_passwords enumeration\n```","_**System Variable**_ (⊘ 5.7.6, ⊗ 8.0.11)\n\ndefault: `0`, valid values:\n\n- `0`\n- `2`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Selects password hashing method for PASSWORD() [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_old_passwords)]."],Eg=["```mysql\ndeclare @@Ongoing_anonymous_gtid_violating_transaction_count integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of ongoing anonymous transactions that violate GTID consistency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ongoing_anonymous_gtid_violating_transaction_count)]."],Ag=["```mysql\ndeclare @@Ongoing_anonymous_transaction_count integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of ongoing anonymous transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ongoing_anonymous_transaction_count)]."],Rg=["```mysql\ndeclare @@Ongoing_automatic_gtid_violating_transaction_count integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of ongoing automatic transactions that violate GTID consistency [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ongoing_automatic_gtid_violating_transaction_count)]."],xg=["```mysql\ndeclare @@open_files_limit integer\n```","_**System Variable**_\n\ndefault: `5000, with possible adjustment`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If not 0, mysqld uses setrlimit() to reserve this many file descriptors [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_open_files_limit)]."],wg=["```mysql\ndeclare @@Open_files integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of files that are open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Open_files)]."],Ng=["```mysql\ndeclare @@Open_streams integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of streams that are open (used mainly for logging) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Open_streams)]."],Cg=["```mysql\ndeclare @@Open_table_definitions integer\n```","_**System Variable**_ (⊕ 5.1.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of cached table definitions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Open_table_definitions)]."],kg=["```mysql\ndeclare @@Open_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of tables that are open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Open_tables)]."],Og=["```mysql\ndeclare @@Opened_files integer\n```","_**System Variable**_ (⊕ 5.1.21)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of files that have been opened using my_open() [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Opened_files)]."],Ig=["```mysql\ndeclare @@Opened_table_definitions integer\n```","_**System Variable**_ (⊕ 6.0.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of table definitions that have been cached [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Opened_table_definitions)]."],Lg=["```mysql\ndeclare @@Opened_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of tables that have been opened [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Opened_tables)]."],Dg=["```mysql\ndeclare @@optimizer_join_cache_level integer\n```","_**System Variable**_ (⊕ 6.0.14, ⊗ 5.6.3)\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How join buffers are used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_join_cache_level)]."],Mg=["```mysql\ndeclare @@optimizer_prune_level integer\n```","_**System Variable**_ (⊕ 5.0.1)\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_prune_level)]."],Fg=["```mysql\ndeclare @@optimizer_search_depth integer\n```","_**System Variable**_ (⊕ 5.0.1)\n\ndefault: `62`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Maximum depth of search performed by the query optimizer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_search_depth)]."],Pg=["```mysql\ndeclare @@optimizer_switch set\n```","_**System Variable**_ (⊕ 5.4.2)\n\nvalid values:\n\n- `batched_key_access={on|off}`\n- `block_nested_loop={on|off}`\n- `condition_fanout_filter={on|off}`\n- `derived_merge={on|off}`\n- `duplicateweedout={on|off}`\n- `engine_condition_pushdown={on|off}`\n- `firstmatch={on|off}`\n- `hash_join={on|off}`\n- `index_condition_pushdown={on|off}`\n- `index_merge={on|off}`\n- `index_merge_intersection={on|off}`\n- `index_merge_sort_union={on|off}`\n- `index_merge_union={on|off}`\n- `loosescan={on|off}`\n- `materialization={on|off}`\n- `mrr={on|off}`\n- `mrr_cost_based={on|off}`\n- `prefer_ordering_index={on|off}`\n- `semijoin={on|off}`\n- `skip_scan={on|off}`\n- `subquery_materialization_cost_based={on|off}`\n- `use_index_extensions={on|off}`\n- `use_invisible_indexes={on|off}`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Enable control over which optimizations to use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch)]."],Bg=["```mysql\ndeclare @@optimizer_trace string\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control optimizer tracing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace)]."],Ug=["```mysql\ndeclare @@optimizer_trace_features string\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control optimizer tracing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace_features)]."],Hg=["```mysql\ndeclare @@optimizer_trace_limit integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control optimizer tracing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace_limit)]."],Wg=["```mysql\ndeclare @@optimizer_trace_max_mem_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `1048576`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Control optimizer tracing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace_max_mem_size)]."],Qg=["```mysql\ndeclare @@optimizer_trace_offset integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control optimizer tracing [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_trace_offset)]."],jg=["```mysql\ndeclare @@optimizer_use_mrr enumeration\n```","_**System Variable**_ (⊕ 6.0.3, ⊗ 6.0.14)\n\ndefault: `force`, valid values:\n\n- `auto`\n- `disable`\n- `force`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How the optimizer reads multiple ranges of index tuples [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_use_mrr)]."],Gg=["```mysql\ndeclare @@original_commit_timestamp numeric\n```","_**System Variable**_ (⊕ 8.0.1)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The time when a transaction was committed on the original master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_original_commit_timestamp)]."],Xg=["```mysql\ndeclare @@immediate_server_version integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The MySQL Server release number of the server that is the immediate master in a replication topology [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_immediate_server_version)]."],Yg=["```mysql\ndeclare @@original_server_version integer\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The MySQL Server release number of the server where a transaction was originally committed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_original_server_version)]."],Kg=["```mysql\ndeclare @@parser_max_mem_size integer\n```","_**System Variable**_ (⊕ 5.7.12)\n\ndefault: `18446744073709551615`, min: `10000000`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum amount of memory available to parser [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_parser_max_mem_size)]."],Zg=["```mysql\ndeclare @@partial_revokes boolean\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether partial revocation is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_partial_revokes)]."],$g=["```mysql\ndeclare @@password_history integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `0`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of password changes required before password reuse [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_password_history)]."],Jg=["```mysql\ndeclare @@password_require_current boolean\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether password changes require current password verification [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_password_require_current)]."],eS=["```mysql\ndeclare @@password_reuse_interval integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `0`, min: `0`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of days elapsed required before password reuse [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_password_reuse_interval)]."],tS=["```mysql\ndeclare @@performance_schema boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether Performance Schema is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema)]."],nS=["```mysql\ndeclare @@Performance_schema_accounts_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many accounts table rows could not be added [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_accounts_lost)]."],sS=["```mysql\ndeclare @@performance_schema_accounts_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`, min: `-1`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the accounts table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_accounts_size)]."],oS=["```mysql\ndeclare @@Performance_schema_cond_classes_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many condition instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_cond_classes_lost)]."],aS=["```mysql\ndeclare @@Performance_schema_cond_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many condition instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_cond_instances_lost)]."],iS=["```mysql\ndeclare @@Performance_schema_digest_lost integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many digests could not be instrumented [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_digest_lost)]."],rS=["```mysql\ndeclare @@performance_schema_digests_size integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `-1`, min: `-1`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the events_statements_summary_by_digest table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_digests_size)]."],mS=["```mysql\ndeclare @@performance_schema_error_size integer\n```","_**System Variable**_\n\ndefault: `number of server error codes`, min: `0`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of instrumented errors [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_error_size)]."],lS=["```mysql\ndeclare @@performance_schema_events_stages_history_long_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the events_stages_history_long table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_stages_history_long_size)]."],dS=["```mysql\ndeclare @@performance_schema_events_stages_history_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows per thread in the events_stages_history table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_stages_history_size)]."],cS=["```mysql\ndeclare @@performance_schema_events_statements_history_long_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the events_statements_history_long table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_statements_history_long_size)]."],_S=["```mysql\ndeclare @@performance_schema_events_statements_history_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows per thread in the events_statements_history table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_statements_history_size)]."],pS=["```mysql\ndeclare @@performance_schema_events_transactions_history_long_size integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the events_transactions_history_long table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_transactions_history_long_size)]."],hS=["```mysql\ndeclare @@performance_schema_events_transactions_history_size integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows per thread in the events_transactions_history table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_transactions_history_size)]."],yS=["```mysql\ndeclare @@performance_schema_events_waits_history_long_size integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the events_waits_history_long table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_waits_history_long_size)]."],vS=["```mysql\ndeclare @@performance_schema_events_waits_history_size integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows per thread in the events_waits_history table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_events_waits_history_size)]."],uS=["```mysql\ndeclare @@Performance_schema_file_classes_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many file instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_file_classes_lost)]."],bS=["```mysql\ndeclare @@Performance_schema_file_handles_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many file instrument instances could not be opened [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_file_handles_lost)]."],fS=["```mysql\ndeclare @@Performance_schema_file_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many file instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_file_instances_lost)]."],qS=["```mysql\ndeclare @@Performance_schema_hosts_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many hosts table rows could not be added [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_hosts_lost)]."],gS=["```mysql\ndeclare @@performance_schema_hosts_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`, min: `-1`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the hosts table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_hosts_size)]."],SS=["```mysql\ndeclare @@Performance_schema_index_stat_lost integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of indexes for which statistics were lost [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_index_stat_lost)]."],zS=["```mysql\ndeclare @@Performance_schema_locker_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many events are lost or not recorded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_locker_lost)]."],VS=["```mysql\ndeclare @@performance_schema_max_cond_classes integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `100`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of condition instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_cond_classes)]."],TS=["```mysql\ndeclare @@performance_schema_max_cond_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented condition objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_cond_instances)]."],ES=["```mysql\ndeclare @@performance_schema_max_digest_length integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `1024`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum Performance Schema digest size in bytes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_digest_length)]."],AS=["```mysql\ndeclare @@performance_schema_max_digest_sample_age integer\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `60`, min: `0`, max: `1048576`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The query resample age in seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_digest_sample_age)]."],RS=["```mysql\ndeclare @@performance_schema_max_file_classes integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `80`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of file instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_file_classes)]."],xS=["```mysql\ndeclare @@performance_schema_max_file_handles integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `32768`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of opened file objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_file_handles)]."],wS=["```mysql\ndeclare @@performance_schema_max_file_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented file objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_file_instances)]."],NS=["```mysql\ndeclare @@performance_schema_max_index_stat integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum number of indexes to keep statistics for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_index_stat)]."],CS=["```mysql\ndeclare @@performance_schema_max_memory_classes integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `450`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of memory instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_memory_classes)]."],kS=["```mysql\ndeclare @@performance_schema_max_metadata_locks integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of metadata locks to track [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_metadata_locks)]."],OS=["```mysql\ndeclare @@performance_schema_max_mutex_classes integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `300`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of mutex instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_mutex_classes)]."],IS=["```mysql\ndeclare @@performance_schema_max_mutex_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented mutex objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_mutex_instances)]."],LS=["```mysql\ndeclare @@performance_schema_max_prepared_statements_instances integer\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the prepared_statements_instances table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_prepared_statements_instances)]."],DS=["```mysql\ndeclare @@performance_schema_max_program_instances integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of stored programs for statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_program_instances)]."],MS=["```mysql\ndeclare @@performance_schema_max_rwlock_classes integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `60`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of rwlock instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_rwlock_classes)]."],FS=["```mysql\ndeclare @@performance_schema_max_rwlock_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented rwlock objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_rwlock_instances)]."],PS=["```mysql\ndeclare @@performance_schema_max_socket_classes integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `10`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of socket instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_socket_classes)]."],BS=["```mysql\ndeclare @@performance_schema_max_socket_instances integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented socket objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_socket_instances)]."],US=["```mysql\ndeclare @@performance_schema_max_sql_text_length integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `1024`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of bytes stored from SQL statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_sql_text_length)]."],HS=["```mysql\ndeclare @@performance_schema_max_stage_classes integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `175`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of stage instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_stage_classes)]."],WS=["```mysql\ndeclare @@performance_schema_max_statement_classes integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of statement instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_statement_classes)]."],QS=["```mysql\ndeclare @@performance_schema_max_statement_stack integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `10`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum stored program nesting for statistics [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_statement_stack)]."],jS=["```mysql\ndeclare @@performance_schema_max_table_handles integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of opened table objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_table_handles)]."],GS=["```mysql\ndeclare @@performance_schema_max_table_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented table objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_table_instances)]."],XS=["```mysql\ndeclare @@performance_schema_max_table_lock_stat integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum number of tables to keep lock statistics for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_table_lock_stat)]."],YS=["```mysql\ndeclare @@performance_schema_max_thread_classes integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `100`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of thread instruments [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_thread_classes)]."],KS=["```mysql\ndeclare @@performance_schema_max_thread_instances integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The maximum number of instrumented thread objects [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_max_thread_instances)]."],ZS=["```mysql\ndeclare @@Performance_schema_memory_classes_lost integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many memory instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_memory_classes_lost)]."],$S=["```mysql\ndeclare @@Performance_schema_metadata_lock_lost integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of metadata locks that could not be recorded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_metadata_lock_lost)]."],JS=["```mysql\ndeclare @@Performance_schema_mutex_classes_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many mutex instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_mutex_classes_lost)]."],ez=["```mysql\ndeclare @@Performance_schema_mutex_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many mutex instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_mutex_instances_lost)]."],tz=["```mysql\ndeclare @@Performance_schema_nested_statement_lost integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of stored program statements for which statistics were lost [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_nested_statement_lost)]."],nz=["```mysql\ndeclare @@Performance_schema_prepared_statements_lost integer\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of prepared statements that could not be instrumented [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_prepared_statements_lost)]."],sz=["```mysql\ndeclare @@Performance_schema_program_lost integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of stored programs for which statistics were lost [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_program_lost)]."],oz=["```mysql\ndeclare @@Performance_schema_rwlock_classes_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many rwlock instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_rwlock_classes_lost)]."],az=["```mysql\ndeclare @@Performance_schema_rwlock_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many rwlock instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_rwlock_instances_lost)]."],iz=["```mysql\ndeclare @@Performance_schema_session_connect_attrs_longest_seen integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The size of the longest valid connection attribute buffer seen [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_session_connect_attrs_longest_seen)]."],rz=["```mysql\ndeclare @@Performance_schema_session_connect_attrs_lost integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of connections for which attribute strings could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_session_connect_attrs_lost)]."],mz=["```mysql\ndeclare @@performance_schema_session_connect_attrs_size integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `-1`, min: `-1`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of the connection attribute strings buffer per thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_session_connect_attrs_size)]."],lz=["```mysql\ndeclare @@performance_schema_setup_actors_size integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the setup_actors table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_setup_actors_size)]."],dz=["```mysql\ndeclare @@performance_schema_setup_objects_size integer\n```","_**System Variable**_ (⊕ 5.6.1)\n\ndefault: `-1`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the setup_objects table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_setup_objects_size)]."],cz=["```mysql\ndeclare @@Performance_schema_socket_classes_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many socket instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_socket_classes_lost)]."],_z=["```mysql\ndeclare @@Performance_schema_socket_instances_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many socket instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_socket_instances_lost)]."],pz=["```mysql\ndeclare @@Performance_schema_stage_classes_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many stage instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_stage_classes_lost)]."],hz=["```mysql\ndeclare @@Performance_schema_statement_classes_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many statement instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_statement_classes_lost)]."],yz=["```mysql\ndeclare @@Performance_schema_table_handles_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many table instrument instances could not be opened [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_table_handles_lost)]."],vz=["```mysql\ndeclare @@Performance_schema_table_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many table instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_table_instances_lost)]."],uz=["```mysql\ndeclare @@Performance_schema_table_lock_stat_lost integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of tables for which lock statistics were lost [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_table_lock_stat_lost)]."],bz=["```mysql\ndeclare @@Performance_schema_thread_classes_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many thread instruments could not be loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_thread_classes_lost)]."],fz=["```mysql\ndeclare @@Performance_schema_thread_instances_lost integer\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many thread instrument instances could not be created [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_thread_instances_lost)]."],qz=["```mysql\ndeclare @@Performance_schema_users_lost integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many users table rows could not be added [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Performance_schema_users_lost)]."],gz=["```mysql\ndeclare @@performance_schema_users_size integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `-1`, min: `-1`, max: `1048576`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rows in the users table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_performance_schema_users_size)]."],Sz=["```mysql\ndeclare @@persisted_globals_load boolean\n```","_**System Variable**_ (⊕ 8.0.0)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to load persisted configuration settings [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_persisted_globals_load)]."],zz=["```mysql\ndeclare @@persist_only_admin_x509_subject string\n```","_**System Variable**_ (⊕ 8.0.14)\n\ndefault: `empty string`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SSL certificate X.509 Subject that enables persisting persist-restricted system variables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_persist_only_admin_x509_subject)]."],Vz=["```mysql\ndeclare @@pid_file filename\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Process ID file used by mysqld_safe [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pid_file)]."],Tz=["```mysql\ndeclare @@plugin_dir dirname\n```","_**System Variable**_ (⊕ 5.1.2)\n\ndefault: `BASEDIR/lib/plugin`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory for plugins [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_plugin_dir)]."],Ez=["```mysql\ndeclare @@port integer\n```","_**System Variable**_\n\ndefault: `3306`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Port number on which to listen for TCP/IP connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_port)]."],Az=["```mysql\ndeclare @@preload_buffer_size integer\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `32768`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Size of buffer that is allocated when preloading indexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_preload_buffer_size)]."],Rz=["```mysql\ndeclare @@prepared_stmt_count integer\n```","_**System Variable**_ (⊕ 5.1.10, ⊗ 5.1.13)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current number of prepared statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_prepared_stmt_count)]."],xz=["```mysql\ndeclare @@Prepared_stmt_count integer\n```","_**System Variable**_ (⊕ 5.1.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current number of prepared statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Prepared_stmt_count)]."],wz=["```mysql\ndeclare @@print_identified_with_as_hex boolean\n```","_**System Variable**_ (⊕ 8.0.17)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For SHOW CREATE USER, print hash values containing unprintable characters in hex [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_print_identified_with_as_hex)]."],Nz=["```mysql\ndeclare @@profiling boolean\n```","_**System Variable**_ (⊕ 6.0.5, ⊘ 5.6.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable statement profiling [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_profiling)]."],Cz=["```mysql\ndeclare @@profiling_history_size integer\n```","_**System Variable**_ (⊕ 6.0.5, ⊘ 5.6.8)\n\ndefault: `15`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many statements to maintain profiling information for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_profiling_history_size)]."],kz=["```mysql\ndeclare @@protocol_compression_algorithms set\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `zlib,zstd,uncompressed`, valid values:\n\n- `zlib`\n- `zstd`\n- `uncompressed`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permitted compression algorithms for incoming connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_protocol_compression_algorithms)]."],Oz=["```mysql\ndeclare @@protocol_version integer\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The version of the client/server protocol used by the MySQL server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_protocol_version)]."],Iz=["```mysql\ndeclare @@proxy_user string\n```","_**System Variable**_ (⊕ 5.5.7)\n\ndynamic: no, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The user proxied by the external proxy user [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_proxy_user)]."],Lz=["```mysql\ndeclare @@pseudo_slave_mode integer\n```","_**System Variable**_ (⊕ 5.6.10)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For internal server use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pseudo_slave_mode)]."],Dz=["```mysql\ndeclare @@pseudo_thread_id integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For internal server use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_pseudo_thread_id)]."],Mz=["```mysql\ndeclare @@Qcache_free_blocks integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of free memory blocks in the query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_free_blocks)]."],Fz=["```mysql\ndeclare @@Qcache_free_memory integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The amount of free memory for the query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_free_memory)]."],Pz=["```mysql\ndeclare @@Qcache_hits integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of query cache hits [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_hits)]."],Bz=["```mysql\ndeclare @@Qcache_inserts integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of query cache inserts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_inserts)]."],Uz=["```mysql\ndeclare @@Qcache_lowmem_prunes integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of queries that were deleted from the query cache due to lack of free memory in the cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_lowmem_prunes)]."],Hz=["```mysql\ndeclare @@Qcache_not_cached integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of noncached queries (not cacheable, or not cached due to the query_cache_type setting) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_not_cached)]."],Wz=["```mysql\ndeclare @@Qcache_queries_in_cache integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of queries registered in the query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_queries_in_cache)]."],Qz=["```mysql\ndeclare @@Qcache_total_blocks integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of blocks in the query cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Qcache_total_blocks)]."],jz=["```mysql\ndeclare @@Queries integer\n```","_**System Variable**_ (⊕ 6.0.10)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements executed by the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Queries)]."],Gz=["```mysql\ndeclare @@query_alloc_block_size integer\n```","_**System Variable**_\n\ndefault: `8192`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allocation block size for query parsing and execution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_alloc_block_size)]."],Xz=["```mysql\ndeclare @@query_cache_limit integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `1048576`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Do not cache results that are bigger than this [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_cache_limit)]."],Yz=["```mysql\ndeclare @@query_cache_min_res_unit integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `4096`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_cache_min_res_unit)]."],Kz=["```mysql\ndeclare @@query_cache_size integer\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The memory allocated to store results from old queries [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_cache_size)]."],Zz=["```mysql\ndeclare @@query_cache_type enumeration\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `0`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Query cache type [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_cache_type)]."],$z=["```mysql\ndeclare @@query_cache_wlock_invalidate boolean\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Invalidate queries in query cache on LOCK for write [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_cache_wlock_invalidate)]."],Jz=["```mysql\ndeclare @@query_prealloc_size integer\n```","_**System Variable**_\n\ndefault: `8192`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Persistent buffer for query parsing and execution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_query_prealloc_size)]."],eV=["```mysql\ndeclare @@Questions integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of statements that clients have sent to the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Questions)]."],tV=["```mysql\ndeclare @@rand_seed1 integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used to support replication of the RAND() function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rand_seed1)]."],nV=["```mysql\ndeclare @@rand_seed2 integer\n```","_**System Variable**_\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used to support replication of the RAND() function [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rand_seed2)]."],sV=["```mysql\ndeclare @@range_alloc_block_size integer\n```","_**System Variable**_\n\ndefault: `4096`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Allocation block size for storing ranges during optimization [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_alloc_block_size)]."],oV=["```mysql\ndeclare @@range_optimizer_max_mem_size integer\n```","_**System Variable**_ (⊕ 5.7.9)\n\ndefault: `8388608`, min: `0`, max: `18446744073709551615`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Limit on range optimizer memory consumption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size)]."],aV=["```mysql\ndeclare @@rbr_exec_mode enumeration\n```","_**System Variable**_ (⊕ 5.7.1)\n\ndefault: `STRICT`, valid values:\n\n- `IDEMPOTENT`\n- `STRICT`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allows for switching the server between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rbr_exec_mode)]."],iV=["```mysql\ndeclare @@read_buffer_size integer\n```","_**System Variable**_\n\ndefault: `131072`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_buffer_size)]."],rV=["```mysql\ndeclare @@read_only boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Prevent client updates except from clients with SUPER [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_only)]."],mV=["```mysql\ndeclare @@read_rnd_buffer_size integer\n```","_**System Variable**_\n\ndefault: `262144`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_read_rnd_buffer_size)]."],lV=["```mysql\ndeclare @@regexp_stack_limit integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `8000000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Regular expression match stack size limit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_stack_limit)]."],dV=["```mysql\ndeclare @@regexp_time_limit integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `32`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Regular expression match timeout [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_regexp_time_limit)]."],cV=["```mysql\ndeclare @@relay_log filename\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The location and base name to use for relay logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log)]."],_V=["```mysql\ndeclare @@relay_log_basename filename\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `datadir + '/' + hostname + '-relay-bin'`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Complete path to relay log, including file name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_basename)]."],pV=["```mysql\ndeclare @@relay_log_index filename\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `*host_name*-relay-bin.index`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The location and name to use for the file that keeps a list of the last relay logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_index)]."],hV=["```mysql\ndeclare @@relay_log_info_file filename\n```","_**System Variable**_ (⊕ 4.1.1, ⊘ 8.0.18)\n\ndefault: `relay-log.info`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File in which the slave records information about the relay logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_info_file)]."],yV=["```mysql\ndeclare @@relay_log_info_repository string\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `TABLE`, valid values:\n\n- `FILE`\n- `TABLE`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to write the replication SQL thread's location in the relay logs to a file or a table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_info_repository)]."],vV=["```mysql\ndeclare @@relay_log_purge boolean\n```","_**System Variable**_ (⊕ 4.1.1)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Determines whether relay logs are purged [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_purge)]."],uV=["```mysql\ndeclare @@relay_log_recovery boolean\n```","_**System Variable**_ (⊕ 6.0.11)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether automatic recovery of relay log files from master at startup is enabled; must be enabled for a crash-safe slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_recovery)]."],bV=["```mysql\ndeclare @@relay_log_space_limit integer\n```","_**System Variable**_\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum space to use for all relay logs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_relay_log_space_limit)]."],fV=["```mysql\ndeclare @@report_host string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Host name or IP of the slave to be reported to the master during slave registration [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_report_host)]."],qV=["```mysql\ndeclare @@report_password string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_report_password)]."],gV=["```mysql\ndeclare @@report_port integer\n```","_**System Variable**_\n\ndefault: `[slave_port]`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Port for connecting to slave reported to the master during slave registration [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_report_port)]."],SV=["```mysql\ndeclare @@report_user string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_report_user)]."],zV=["```mysql\ndeclare @@require_row_format boolean\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For internal server use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_row_format)]."],VV=["```mysql\ndeclare @@require_secure_transport boolean\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether client connections must use secure transport [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_require_secure_transport)]."],TV=["```mysql\ndeclare @@restore_disables_events boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether RESTORE disables restored events [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_restore_disables_events)]."],EV=["```mysql\ndeclare @@restore_elevation boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable or disable RESTORE privilege elevation [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_restore_elevation)]."],AV=["```mysql\ndeclare @@restore_precheck boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether RESTORE performs privilege checking before restoring [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_restore_precheck)]."],RV=["```mysql\ndeclare @@resultset_metadata enumeration\n```","_**System Variable**_ (⊕ 8.0.3)\n\ndefault: `FULL`, valid values:\n\n- `FULL`\n- `NONE`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the server returns result set metadata [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_resultset_metadata)]."],xV=["```mysql\ndeclare @@rewriter_enabled boolean\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the example query rewrite plugin is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rewriter_enabled)]."],wV=["```mysql\ndeclare @@rewriter_verbose integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For internal use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rewriter_verbose)]."],NV=["```mysql\ndeclare @@Rewriter_number_loaded_rules integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of rewrite rules successfully loaded into memory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rewriter_number_loaded_rules)]."],CV=["```mysql\ndeclare @@Rewriter_number_reloads integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of reloads of rules table into memory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rewriter_number_reloads)]."],kV=["```mysql\ndeclare @@Rewriter_number_rewritten_queries integer\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of queries rewritten since the plugin was loaded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rewriter_number_rewritten_queries)]."],OV=["```mysql\ndeclare @@Rewriter_reload_error boolean\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether an error occurred when last loading the rewriting rules into memory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rewriter_reload_error)]."],IV=["```mysql\ndeclare @@rpl_recovery_rank integer\n```","_**System Variable**_ (⊘ 6.0.14)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Not used; removed in later versions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_recovery_rank)]."],LV=["```mysql\ndeclare @@Rpl_semi_sync_master_clients integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of semisynchronous slaves [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_clients)]."],DV=["```mysql\ndeclare @@rpl_semi_sync_master_enabled boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether semisynchronous replication is enabled on the master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_enabled)]."],MV=["```mysql\ndeclare @@Rpl_semi_sync_master_net_avg_wait_time integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The average time the master waited for a slave reply [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_net_avg_wait_time)]."],FV=["```mysql\ndeclare @@Rpl_semi_sync_master_net_wait_time integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total time the master waited for slave replies [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_net_wait_time)]."],PV=["```mysql\ndeclare @@Rpl_semi_sync_master_net_waits integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of times the master waited for slave replies [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_net_waits)]."],BV=["```mysql\ndeclare @@Rpl_semi_sync_master_no_times integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times the master turned off semisynchronous replication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_no_times)]."],UV=["```mysql\ndeclare @@Rpl_semi_sync_master_no_tx integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of commits not acknowledged successfully [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_no_tx)]."],HV=["```mysql\ndeclare @@rpl_semi_sync_master_reply_log_file_pos string\n```","_**System Variable**_ (⊕ 6.0.8, ⊗ 6.0.14)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Internal use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_reply_log_file_pos)]."],WV=["```mysql\ndeclare @@Rpl_semi_sync_master_status boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether semisynchronous replication is operational on the master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_status)]."],QV=["```mysql\ndeclare @@Rpl_semi_sync_master_timefunc_failures integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times the master failed when calling time functions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_timefunc_failures)]."],jV=["```mysql\ndeclare @@rpl_semi_sync_master_timeout integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `10000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of milliseconds to wait for slave acknowledgment [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_timeout)]."],GV=["```mysql\ndeclare @@rpl_semi_sync_master_trace_level integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `32`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The semisynchronous replication debug trace level on the master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_trace_level)]."],XV=["```mysql\ndeclare @@Rpl_semi_sync_master_tx_avg_wait_time integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The average time the master waited for each transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_tx_avg_wait_time)]."],YV=["```mysql\ndeclare @@Rpl_semi_sync_master_tx_wait_time integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total time the master waited for transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_tx_wait_time)]."],KV=["```mysql\ndeclare @@Rpl_semi_sync_master_tx_waits integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of times the master waited for transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_tx_waits)]."],ZV=["```mysql\ndeclare @@rpl_semi_sync_master_wait_for_slave_count integer\n```","_**System Variable**_ (⊕ 5.7.3)\n\ndefault: `1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many slave acknowledgments the master must receive per transaction before proceeding [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_wait_for_slave_count)]."],$V=["```mysql\ndeclare @@rpl_semi_sync_master_wait_no_slave boolean\n```","_**System Variable**_ (⊕ 6.0.14)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether master waits for timeout even with no slaves [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_wait_no_slave)]."],JV=["```mysql\ndeclare @@rpl_semi_sync_master_wait_point enumeration\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `AFTER_SYNC`, valid values:\n\n- `AFTER_SYNC`\n- `AFTER_COMMIT`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The wait point for slave transaction receipt acknowledgment [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_master_wait_point)]."],eT=["```mysql\ndeclare @@Rpl_semi_sync_master_wait_pos_backtraverse integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of times the master waited for an event with binary coordinates lower than events waited for previously [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_wait_pos_backtraverse)]."],tT=["```mysql\ndeclare @@Rpl_semi_sync_master_wait_sessions integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sessions currently waiting for slave replies [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_wait_sessions)]."],nT=["```mysql\ndeclare @@Rpl_semi_sync_master_yes_tx integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `0`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of commits acknowledged successfully [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_master_yes_tx)]."],sT=["```mysql\ndeclare @@rpl_semi_sync_slave_enabled boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether semisynchronous replication is enabled on slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_slave_enabled)]."],oT=["```mysql\ndeclare @@Rpl_semi_sync_slave_status boolean\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether semisynchronous replication is operational on slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_semi_sync_slave_status)]."],aT=["```mysql\ndeclare @@rpl_semi_sync_slave_trace_level integer\n```","_**System Variable**_ (⊕ 6.0.8)\n\ndefault: `32`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The semisynchronous replication debug trace level on the slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_semi_sync_slave_trace_level)]."],iT=["```mysql\ndeclare @@Rpl_status string\n```","_**System Variable**_ (⊘ 6.0.14)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The status of fail-safe replication (not implemented) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rpl_status)]."],rT=["```mysql\ndeclare @@rpl_read_size integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `8192`, min: `8192`, max: `4294967295`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set the minimum amount of data in bytes that is read from the binary log files and relay log files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_read_size)]."],mT=["```mysql\ndeclare @@rpl_stop_slave_timeout integer\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `31536000`, min: `2`, max: `31536000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Set the number of seconds that STOP SLAVE waits before timing out [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_rpl_stop_slave_timeout)]."],lT=["```mysql\ndeclare @@Rsa_public_key string\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","sha256_password authentication plugin RSA public key value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Rsa_public_key)]."],dT=["```mysql\ndeclare @@secondary_engine_cost_threshold numeric\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `100000.000000`, min: `0`, max: `DBL_MAX (maximum double value)`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","For future use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_secondary_engine_cost_threshold)]."],cT=["```mysql\ndeclare @@schema_definition_cache integer\n```","_**System Variable**_\n\ndefault: `256`, min: `256`, max: `524288`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the number of schema definition objects that can be kept in the dictionary object cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_schema_definition_cache)]."],_T=["```mysql\ndeclare @@Secondary_engine_execution_count integer\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For future use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Secondary_engine_execution_count)]."],pT=["```mysql\ndeclare @@secure_auth boolean\n```","_**System Variable**_ (⊕ 4.1.1, ⊘ 5.7.5, ⊗ 8.0.3)\n\ndefault: `ON`, valid values:\n\n- `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Disallow authentication for accounts that have old (pre-4.1) passwords [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_secure_auth)]."],hT=["```mysql\ndeclare @@secure_file_priv string\n```","_**System Variable**_ (⊕ 5.1.17)\n\ndefault: `platform specific`, valid values:\n\n- `empty string`\n- `dirname`\n- `NULL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Limit LOAD DATA, and SELECT ... INTO OUTFILE, and LOAD_FILE() to files in specified directory [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_secure_file_priv)]."],yT=["```mysql\ndeclare @@Select_full_join integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that perform table scans because they do not use indexes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Select_full_join)]."],vT=["```mysql\ndeclare @@Select_full_range_join integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that used a range search on a reference table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Select_full_range_join)]."],uT=["```mysql\ndeclare @@Select_range integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that used ranges on the first table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Select_range)]."],bT=["```mysql\ndeclare @@Select_range_check integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins without keys that check for key usage after each row [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Select_range_check)]."],fT=["```mysql\ndeclare @@Select_scan integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of joins that did a full scan of the first table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Select_scan)]."],qT=["```mysql\ndeclare @@server_id integer\n```","_**System Variable**_\n\ndefault: `1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Uniquely identifies the server instance in the community of replication partners. Required when binary logging is enabled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_server_id)]."],gT=["```mysql\ndeclare @@server_id_bits integer\n```","_**System Variable**_ (⊕ 5.1.47-ndb-7.1.6)\n\ndefault: `32`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_server_id_bits)]."],ST=["```mysql\ndeclare @@server_uuid string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The server's globally unique ID, automatically (re)generated at server start [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_server_uuid)]."],zT=["```mysql\ndeclare @@session_track_gtids enumeration\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `OWN_GTID`\n- `ALL_GTIDS`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables a tracker which can be configured to track different GTIDs [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_gtids)]."],VT=["```mysql\ndeclare @@session_track_schema boolean\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to track schema changes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_schema)]."],TT=["```mysql\ndeclare @@session_track_state_change boolean\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to track session state changes [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_state_change)]."],ET=["```mysql\ndeclare @@session_track_system_variables string\n```","_**System Variable**_ (⊕ 5.7.4)\n\ndefault: `time_zone, autocommit, character_set_client, character_set_results, character_set_connection`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Session variables to track changes for [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_system_variables)]."],AT=["```mysql\ndeclare @@session_track_transaction_info enumeration\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `STATE`\n- `CHARACTERISTICS`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How to perform transaction tracking [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_session_track_transaction_info)]."],RT=["```mysql\ndeclare @@sha256_password_auto_generate_rsa_keys boolean\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to autogenerate RSA key-pair files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sha256_password_auto_generate_rsa_keys)]."],xT=["```mysql\ndeclare @@sha256_password_private_key_path filename\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `private_key.pem`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SHA256 authentication plugin private key path name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sha256_password_private_key_path)]."],wT=["```mysql\ndeclare @@sha256_password_proxy_users boolean\n```","_**System Variable**_ (⊕ 5.7.7)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the sha256_password authentication plugin does proxying [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sha256_password_proxy_users)]."],NT=["```mysql\ndeclare @@sha256_password_public_key_path filename\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `public_key.pem`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SHA256 authentication plugin public key path name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sha256_password_public_key_path)]."],CT=["```mysql\ndeclare @@show_compatibility_56 boolean\n```","_**System Variable**_ (⊕ 5.7.6, ⊘ 5.7.6, ⊗ 8.0.1)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Compatibility for SHOW STATUS/VARIABLES [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_show_compatibility_56)]."],kT=["```mysql\ndeclare @@show_create_table_skip_secondary_engine boolean\n```","_**System Variable**_ (⊕ 8.0.18)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Whether to exclude the SECONDARY ENGINE clause from SHOW CREATE TABLE output [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_show_create_table_skip_secondary_engine)]."],OT=["```mysql\ndeclare @@show_create_table_verbosity boolean\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to display ROW_FORMAT in SHOW CREATE TABLE even if it has the default value [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_show_create_table_verbosity)]."],IT=["```mysql\ndeclare @@show_old_temporals boolean\n```","_**System Variable**_ (⊕ 5.7.6, ⊘ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether SHOW CREATE TABLE should indicate pre-5.6.4 temporal columns [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_show_old_temporals)]."],LT=["```mysql\ndeclare @@simplified_binlog_gtid_recovery boolean\n```","_**System Variable**_ (⊕ 5.6.21, ⊘ 5.6.23, ⊗ 5.7.6)\n\ndefault: `OFF`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Renamed to binlog_gtid_simple_recovery [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_simplified_binlog_gtid_recovery)]."],DT=["```mysql\ndeclare @@skip_external_locking boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Skip system (external) locking [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_skip_external_locking)]."],MT=["```mysql\ndeclare @@slave_load_tmpdir dirname\n```","_**System Variable**_\n\ndefault: `Value of --tmpdir`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The location where the slave should put its temporary files when replicating LOAD DATA statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_load_tmpdir)]."],FT=["```mysql\ndeclare @@slave_net_timeout integer\n```","_**System Variable**_\n\ndefault: `60`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds to wait for more data from a master/slave connection before aborting the read [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_net_timeout)]."],PT=["```mysql\ndeclare @@slave_allow_batching boolean\n```","_**System Variable**_ (⊕ 5.1.19-ndb-6.2.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Turns update batching on and off for a replication slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_allow_batching)]."],BT=["```mysql\ndeclare @@slave_checkpoint_group integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `512`, min: `32`, max: `524280`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum number of transactions processed by a multithreaded slave before a checkpoint operation is called to update progress status. Not supported by NDB Cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_checkpoint_group)]."],UT=["```mysql\ndeclare @@slave_checkpoint_period integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `300`, min: `1`, max: `4G`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Update progress status of multithreaded slave and flush relay log info to disk after this number of milliseconds. Not supported by NDB Cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_checkpoint_period)]."],HT=["```mysql\ndeclare @@slave_compressed_protocol boolean\n```","_**System Variable**_ (⊘ 8.0.18)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Use compression of master/slave protocol [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_compressed_protocol)]."],WT=["```mysql\ndeclare @@slave_exec_mode enumeration\n```","_**System Variable**_ (⊕ 6.0.5)\n\ndefault: `STRICT`, valid values:\n\n- `IDEMPOTENT`\n- `STRICT`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allows for switching the slave thread between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default, except for NDB Cluster, where IDEMPOTENT is always used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_exec_mode)]."],QT=["```mysql\ndeclare @@Slave_heartbeat_period numeric\n```","_**System Variable**_ (⊕ 6.0.4, ⊘ 5.7.6, ⊗ 8.0.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The slave's replication heartbeat interval, in seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_heartbeat_period)]."],jT=["```mysql\ndeclare @@Slave_last_heartbeat datetime\n```","_**System Variable**_ (⊕ 5.6.1, ⊘ 5.7.6, ⊗ 8.0.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Shows when the latest heartbeat signal was received, in TIMESTAMP format [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_last_heartbeat)]."],GT=["```mysql\ndeclare @@slave_max_allowed_packet integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1073741824`, min: `1024`, max: `1073741824`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_max_allowed_packet)]."],XT=["```mysql\ndeclare @@Slave_open_temp_tables integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of temporary tables that the slave SQL thread currently has open [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_open_temp_tables)]."],YT=["```mysql\ndeclare @@slave_parallel_type enumeration\n```","_**System Variable**_ (⊕ 5.7.2)\n\ndefault: `DATABASE`, valid values:\n\n- `DATABASE`\n- `LOGICAL_CLOCK`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Tells the slave to use timestamp information (LOGICAL_CLOCK) or database partioning (DATABASE) to parallelize transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_parallel_type)]."],KT=["```mysql\ndeclare @@slave_parallel_workers integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `0`, min: `0`, max: `1024`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of applier threads for executing replication transactions in parallel. A value of 0 disables slave multithreading. Not supported by MySQL Cluster [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_parallel_workers)]."],ZT=["```mysql\ndeclare @@slave_pending_jobs_size_max integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `128M`, min: `1024`, max: `16EiB`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum size of slave worker queues holding events not yet applied [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_pending_jobs_size_max)]."],$T=["```mysql\ndeclare @@slave_preserve_commit_order boolean\n```","_**System Variable**_ (⊕ 5.7.5)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Ensures that all commits by slave workers happen in the same order as on the master to maintain consistency when using parallel applier threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_preserve_commit_order)]."],JT=["```mysql\ndeclare @@Slave_received_heartbeats integer\n```","_**System Variable**_ (⊕ 6.0.4, ⊘ 5.7.6, ⊗ 8.0.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of heartbeats received by a replication slave since previous reset [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_received_heartbeats)]."],eE=["```mysql\ndeclare @@Slave_retried_transactions integer\n```","_**System Variable**_ (⊕ 5.0.4, ⊘ 5.7.6, ⊗ 8.0.1)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The total number of times since startup that the replication slave SQL thread has retried transactions [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_retried_transactions)]."],tE=["```mysql\ndeclare @@slave_rows_search_algorithms set\n```","_**System Variable**_ (⊕ 5.6.6, ⊘ 8.0.18)\n\ndefault: `INDEX_SCAN,HASH_SCAN`, valid values:\n\n- `TABLE_SCAN,INDEX_SCAN`\n- `INDEX_SCAN,HASH_SCAN`\n- `TABLE_SCAN,HASH_SCAN`\n- `TABLE_SCAN,INDEX_SCAN,HASH_SCAN`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_rows_search_algorithms)]."],nE=["```mysql\ndeclare @@Slave_rows_last_search_algorithm_used string\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Search algorithm most recently used by this slave to locate rows for row-based replication (index, table, or hash scan) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_rows_last_search_algorithm_used)]."],sE=["```mysql\ndeclare @@Slave_running string\n```","_**System Variable**_ (⊘ 5.7.6, ⊗ 8.0.1)\n\nvalid values:\n\n- `ON`\n- `OFF`\n- `CONNECTING`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The state of this server as a replication slave (slave I/O thread status) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slave_running)]."],oE=["```mysql\ndeclare @@slave_sql_verify_checksum boolean\n```","_**System Variable**_ (⊕ 5.6.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Cause slave to examine checksums when reading from relay log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_sql_verify_checksum)]."],aE=["```mysql\ndeclare @@slave_transaction_retries integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `10`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_transaction_retries)]."],iE=["```mysql\ndeclare @@slave_type_conversions set\n```","_**System Variable**_ (⊕ 6.0.14)\n\nvalid values:\n\n- `ALL_LOSSY`\n- `ALL_NON_LOSSY`\n- `ALL_SIGNED`\n- `ALL_UNSIGNED`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slave_type_conversions)]."],rE=["```mysql\ndeclare @@slow_query_log boolean\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enable|disable slow query log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_query_log)]."],mE=["```mysql\ndeclare @@Slow_launch_threads integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads that have taken more than slow_launch_time seconds to create [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slow_launch_threads)]."],lE=["```mysql\ndeclare @@slow_launch_time integer\n```","_**System Variable**_\n\ndefault: `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_launch_time)]."],dE=["```mysql\ndeclare @@Slow_queries integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of queries that have taken more than long_query_time seconds [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Slow_queries)]."],cE=["```mysql\ndeclare @@slow_query_log_file filename\n```","_**System Variable**_ (⊕ 5.1.12)\n\ndefault: `host_name-slow.log`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Name of the slow query log file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_query_log_file)]."],_E=["```mysql\ndeclare @@socket string\n```","_**System Variable**_\n\ndefault: `MySQL`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Socket file on which to listen for Unix socket or Windows named pipe connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_socket)]."],pE=["```mysql\ndeclare @@sort_buffer_size integer\n```","_**System Variable**_\n\ndefault: `262144`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Each thread that needs to do a sort allocates a buffer of this size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sort_buffer_size)]."],hE=["```mysql\ndeclare @@Sort_merge_passes integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of merge passes that the sort algorithm has had to do [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Sort_merge_passes)]."],yE=["```mysql\ndeclare @@Sort_range integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sorts that were done using ranges [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Sort_range)]."],vE=["```mysql\ndeclare @@Sort_rows integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sorted rows [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Sort_rows)]."],uE=["```mysql\ndeclare @@Sort_scan integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of sorts that were done by scanning the table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Sort_scan)]."],bE=["```mysql\ndeclare @@sporadic-binlog-dump-fail boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Option used by mysql-test for debugging and testing of replication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_sporadic-binlog-dump-fail)]."],fE=["```mysql\ndeclare @@sql-bin-update-same boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The update log is deprecated since version 5.0, is replaced by the binary log and this option does nothing anymore [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],qE=["```mysql\ndeclare @@sql-mode set\n```","_**System Variable**_\n\ndefault: `ONLY_FULL_GROUP_BY STRICT_TRANS_TABLES NO_ZERO_IN_DATE NO_ZERO_DATE ERROR_FOR_DIVISION_BY_ZERO NO_ENGINE_SUBSTITUTION`, valid values:\n\n- `ALLOW_INVALID_DATES`\n- `ANSI_QUOTES`\n- `ERROR_FOR_DIVISION_BY_ZERO`\n- `HIGH_NOT_PRECEDENCE`\n- `IGNORE_SPACE`\n- `NO_AUTO_VALUE_ON_ZERO`\n- `NO_BACKSLASH_ESCAPES`\n- `NO_DIR_IN_CREATE`\n- `NO_ENGINE_SUBSTITUTION`\n- `NO_UNSIGNED_SUBTRACTION`\n- `NO_ZERO_DATE`\n- `NO_ZERO_IN_DATE`\n- `ONLY_FULL_GROUP_BY`\n- `PAD_CHAR_TO_FULL_LENGTH`\n- `PIPES_AS_CONCAT`\n- `REAL_AS_FLOAT`\n- `STRICT_ALL_TABLES`\n- `STRICT_TRANS_TABLES`\n- `TIME_TRUNCATE_FRACTIONAL`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Set the SQL server mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_sql-mode)]."],gE=["```mysql\ndeclare @@sql_auto_is_null boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_auto_is_null)]."],SE=["```mysql\ndeclare @@sql_big_selects boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If disabled, MySQL aborts SELECT statements that are likely to take a very long time to execute [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_big_selects)]."],zE=["```mysql\ndeclare @@sql_big_tables boolean\n```","_**System Variable**_ (⊗ 5.6.1)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","This variable is deprecated, and is mapped to big_tables [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],VE=["```mysql\ndeclare @@sql_buffer_result boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Forces the result to be put into a temporary table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_buffer_result)]."],TE=["```mysql\ndeclare @@sql_log_bin boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls binary logging for the current session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_log_bin)]."],EE=["```mysql\ndeclare @@sql_log_off boolean\n```","_**System Variable**_\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Controls whether to disable logging to the general query log for this session [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_log_off)]."],AE=["```mysql\ndeclare @@sql_log_update boolean\n```","_**System Variable**_ (⊘ 5.0.0, ⊗ 6.0.14)\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable is deprecated, and is mapped to SQL_LOG_BIN [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_log_update)]."],RE=["```mysql\ndeclare @@sql_low_priority_updates boolean\n```","_**System Variable**_ (⊘ 4.1.0, ⊗ 5.6.1)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable is deprecated, and is mapped to low_priority_updates [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],xE=["```mysql\ndeclare @@sql_max_join_size integer\n```","_**System Variable**_ (⊘ 4.1.0, ⊗ 5.6.1)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable is deprecated, and is mapped to max_join_size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],wE=["```mysql\ndeclare @@sql_notes boolean\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled, warnings of Note level are recorded [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_notes)]."],NE=["```mysql\ndeclare @@sql_quote_show_create boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled, the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_quote_show_create)]."],CE=["```mysql\ndeclare @@sql_require_primary_key boolean\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Whether tables must have a primary key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_require_primary_key)]."],kE=["```mysql\ndeclare @@sql_safe_updates boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_safe_updates)]."],OE=["```mysql\ndeclare @@sql_select_limit integer\n```","_**System Variable**_\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The maximum number of rows to return from SELECT statements [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_select_limit)]."],IE=["```mysql\ndeclare @@sql_slave_skip_counter integer\n```","_**System Variable**_\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of events from the master that a slave server should skip. Not compatible with GTID replication [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_slave_skip_counter)]."],LE=["```mysql\ndeclare @@sql_warnings boolean\n```","_**System Variable**_\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable controls whether single-row INSERT statements produce an information string if warnings occur [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_warnings)]."],DE=["```mysql\ndeclare @@ssl_ca filename\n```","_**System Variable**_ (⊕ 5.1.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains list of trusted SSL Certificate Authorities [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_ca)]."],ME=["```mysql\ndeclare @@ssl_capath dirname\n```","_**System Variable**_ (⊕ 5.1.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains trusted SSL Certificate Authority certificate files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_capath)]."],FE=["```mysql\ndeclare @@ssl_cert filename\n```","_**System Variable**_ (⊕ 5.1.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 certificate [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_cert)]."],PE=["```mysql\ndeclare @@ssl_cipher string\n```","_**System Variable**_ (⊕ 5.1.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible ciphers for connection encryption [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_cipher)]."],BE=["```mysql\ndeclare @@ssl_crl filename\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains certificate revocation lists [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_crl)]."],UE=["```mysql\ndeclare @@ssl_crlpath dirname\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Directory that contains certificate revocation list files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_crlpath)]."],HE=["```mysql\ndeclare @@ssl_fips_mode enumeration\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `OFF`, valid values:\n\n- `OFF`\n- `ON`\n- `STRICT`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to enable FIPS mode on server side [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_fips_mode)]."],WE=["```mysql\ndeclare @@ssl_key filename\n```","_**System Variable**_ (⊕ 5.1.11)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","File that contains X.509 key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_ssl_key)]."],QE=["```mysql\ndeclare @@Ssl_accept_renegotiates integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of negotiates needed to establish the connection [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_accept_renegotiates)]."],jE=["```mysql\ndeclare @@Ssl_accepts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of accepted SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_accepts)]."],GE=["```mysql\ndeclare @@Ssl_callback_cache_hits integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of callback cache hits [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_callback_cache_hits)]."],XE=["```mysql\ndeclare @@Ssl_cipher string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The current SSL cipher [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_cipher)]."],YE=["```mysql\ndeclare @@Ssl_cipher_list string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The list of possible SSL ciphers [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_cipher_list)]."],KE=["```mysql\ndeclare @@Ssl_client_connects integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of SSL connection attempts to an SSL-enabled master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_client_connects)]."],ZE=["```mysql\ndeclare @@Ssl_connect_renegotiates integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of negotiates needed to establish the connection to an SSL-enabled master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_connect_renegotiates)]."],$E=["```mysql\ndeclare @@Ssl_ctx_verify_depth integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The SSL context verification depth (how many certificates in the chain are tested) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_ctx_verify_depth)]."],JE=["```mysql\ndeclare @@Ssl_ctx_verify_mode integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The SSL context verification mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_ctx_verify_mode)]."],eA=["```mysql\ndeclare @@Ssl_default_timeout integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default SSL timeout [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_default_timeout)]."],tA=["```mysql\ndeclare @@Ssl_finished_accepts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of successful SSL connections to the server [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_finished_accepts)]."],nA=["```mysql\ndeclare @@Ssl_finished_connects integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of successful slave connections to an SSL-enabled master [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_finished_connects)]."],sA=["```mysql\ndeclare @@Ssl_server_not_after integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SSL certificate last valid date [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_server_not_after)]."],oA=["```mysql\ndeclare @@Ssl_server_not_before integer\n```","_**System Variable**_ (⊕ 5.6.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","SSL certificate first valid date [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_server_not_before)]."],aA=["```mysql\ndeclare @@Ssl_session_cache_hits integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of SSL session cache hits [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_hits)]."],iA=["```mysql\ndeclare @@Ssl_session_cache_misses integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of SSL session cache misses [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_misses)]."],rA=["```mysql\ndeclare @@Ssl_session_cache_mode string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The SSL session cache mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_mode)]."],mA=["```mysql\ndeclare @@Ssl_session_cache_overflows integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of SSL session cache overflows [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_overflows)]."],lA=["```mysql\ndeclare @@Ssl_session_cache_size integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The SSL session cache size [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_size)]."],dA=["```mysql\ndeclare @@Ssl_session_cache_timeouts integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of SSL session cache timeouts [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_session_cache_timeouts)]."],cA=["```mysql\ndeclare @@Ssl_sessions_reused integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many SSL connections were reused from the cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_sessions_reused)]."],_A=["```mysql\ndeclare @@Ssl_used_session_cache_entries integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many SSL session cache entries were used [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_used_session_cache_entries)]."],pA=["```mysql\ndeclare @@Ssl_verify_depth integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The verification depth for replication SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_verify_depth)]."],hA=["```mysql\ndeclare @@Ssl_verify_mode integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The verification mode for replication SSL connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_verify_mode)]."],yA=["```mysql\ndeclare @@Ssl_version string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The SSL version number [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Ssl_version)]."],vA=["```mysql\ndeclare @@storage_engine enumeration\n```","_**System Variable**_ (⊕ 4.1.2, ⊗ 5.7.5)\n\ndefault: `MyISAM`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default storage engine [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_storage_engine)]."],uA=["```mysql\ndeclare @@stored_program_cache integer\n```","_**System Variable**_ (⊕ 5.6.5)\n\ndefault: `256`, min: `16`, max: `524288`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported",'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets size for both of these [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_stored_program_cache)].'],bA=["```mysql\ndeclare @@stored_program_definition_cache integer\n```","_**System Variable**_\n\ndefault: `256`, min: `256`, max: `524288`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the number of stored program and event definition objects that can be kept in the dictionary object cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_stored_program_definition_cache)]."],fA=["```mysql\ndeclare @@super_read_only boolean\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to ignore SUPER exceptions to read-only mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_super_read_only)]."],qA=["```mysql\ndeclare @@sync_binlog integer\n```","_**System Variable**_ (⊕ 5.0.1)\n\ndefault: `1`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Synchronously flush binary log to disk after every #th event [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sync_binlog)]."],gA=["```mysql\ndeclare @@sync_frm boolean\n```","_**System Variable**_ (⊘ 5.7.6, ⊗ 8.0.0)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Sync .frm to disk on create. Enabled by default [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sync_frm)]."],SA=["```mysql\ndeclare @@sync_master_info integer\n```","_**System Variable**_ (⊕ 6.0.11)\n\ndefault: `10000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Synchronize master.info to disk after every #th event [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sync_master_info)]."],zA=["```mysql\ndeclare @@sync_relay_log integer\n```","_**System Variable**_ (⊕ 6.0.10)\n\ndefault: `10000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Synchronize relay log to disk after every #th event [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sync_relay_log)]."],VA=["```mysql\ndeclare @@sync_relay_log_info integer\n```","_**System Variable**_ (⊕ 6.0.11)\n\ndefault: `10000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Synchronize relay.info file to disk after every #th event [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sync_relay_log_info)]."],TA=["```mysql\ndeclare @@system_time_zone string\n```","_**System Variable**_ (⊕ 4.1.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The server system time zone [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_system_time_zone)]."],EA=["```mysql\ndeclare @@tablespace_definition_cache integer\n```","_**System Variable**_\n\ndefault: `256`, min: `256`, max: `524288`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the number of tablespace definition objects that can be kept in the dictionary object cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tablespace_definition_cache)]."],AA=["```mysql\ndeclare @@table_cache integer\n```","_**System Variable**_ (⊘ 5.1.3, ⊗ 5.1.3)\n\ndefault: `64`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of open tables for all threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_cache)]."],RA=["```mysql\ndeclare @@table_encryption_privilege_check boolean\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Enables the TABLE_ENCRYPTION_ADMIN privilege check [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_encryption_privilege_check)]."],xA=["```mysql\ndeclare @@table_definition_cache integer\n```","_**System Variable**_ (⊕ 5.1.3)\n\ndefault: `256`, min: `256`, max: `524288`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of table definitions that can be stored in the definition cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache)]."],wA=["```mysql\ndeclare @@table_lock_wait_timeout integer\n```","_**System Variable**_ (⊕ 5.0.10, ⊗ 6.0.14)\n\ndefault: `50`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Currently unused [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_lock_wait_timeout)]."],NA=["```mysql\ndeclare @@Table_locks_immediate integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that a table lock was acquired immediately [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Table_locks_immediate)]."],CA=["```mysql\ndeclare @@Table_locks_waited integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of times that a table lock could not be acquired immediately and a wait was needed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Table_locks_waited)]."],kA=["```mysql\ndeclare @@table_open_cache integer\n```","_**System Variable**_ (⊕ 5.1.3)\n\ndefault: `4000`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of open tables for all threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache)]."],OA=["```mysql\ndeclare @@Table_open_cache_hits integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of hits for open tables cache lookups [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Table_open_cache_hits)]."],IA=["```mysql\ndeclare @@table_open_cache_instances integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `16`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of open tables cache instances [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache_instances)]."],LA=["```mysql\ndeclare @@Table_open_cache_misses integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of misses for open tables cache lookups [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Table_open_cache_misses)]."],DA=["```mysql\ndeclare @@Table_open_cache_overflows integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of overflows for the open tables cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Table_open_cache_overflows)]."],MA=["```mysql\ndeclare @@table_type enumeration\n```","_**System Variable**_ (⊕ 4.1.2, ⊘ 5.2.5, ⊗ 5.5.3)\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","A synonym for storage_engine [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],FA=["```mysql\ndeclare @@Tc_log_max_pages_used integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When the memory-mapped implementation of the log that is used by mysqld acts as the transaction coordinator for recovery of internal XA transactions,this variable indicates the largest number of pages used for the log since the server started [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Tc_log_max_pages_used)]."],PA=["```mysql\ndeclare @@Tc_log_page_size integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The page size used for the memory-mapped implementation of the XA recovery log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Tc_log_page_size)]."],BA=["```mysql\ndeclare @@Tc_log_page_waits integer\n```","_**System Variable**_ (⊕ 5.0.3)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For the memory-mapped implementation of the recovery log, this variable increments each time the server was not able to commit a transaction and had to wait for a free page in the log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Tc_log_page_waits)]."],UA=["```mysql\ndeclare @@temptable_max_ram integer\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `1073741824`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the maximum amount of memory that can occupied by the TempTable storage engine before data is stored on disk [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_max_ram)]."],HA=["```mysql\ndeclare @@temptable_use_mmap boolean\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines whether the TempTable storage engine allocates memory-mapped files when the temptable_max_ram threshold is reached [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_temptable_use_mmap)]."],WA=["```mysql\ndeclare @@thread_cache_size integer\n```","_**System Variable**_\n\ndefault: `-1`, min: `0`, max: `16384`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How many threads we should keep in a cache for reuse [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_cache_size)]."],QA=["```mysql\ndeclare @@thread_concurrency integer\n```","_**System Variable**_ (⊘ 5.6.1, ⊗ 5.7.2)\n\ndefault: `10`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_concurrency)]."],jA=["```mysql\ndeclare @@thread_handling enumeration\n```","_**System Variable**_ (⊕ 5.1.17)\n\ndefault: `one-thread-per-connection`, valid values:\n\n- `no-threads`\n- `one-thread-per-connection`\n- `pool-of-threads`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The thread-handling model [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_handling)]."],GA=["```mysql\ndeclare @@thread_pool_algorithm integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `0`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The thread pool algorithm [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_algorithm)]."],XA=["```mysql\ndeclare @@thread_pool_high_priority_connection integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `0`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether the current session is high priority [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_high_priority_connection)]."],YA=["```mysql\ndeclare @@thread_pool_max_active_query_threads integer\n```","_**System Variable**_ (⊕ 8.0.19)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permissible number of active query threads per group [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_max_active_query_threads)]."],KA=["```mysql\ndeclare @@thread_pool_max_unused_threads integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Maximum permissible number of unused threads [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_max_unused_threads)]."],ZA=["```mysql\ndeclare @@thread_pool_prio_kickup_timer integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `1000`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How long before a statement is moved to high-priority execution [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_prio_kickup_timer)]."],$A=["```mysql\ndeclare @@thread_pool_size integer\n```","_**System Variable**_ (⊕ 6.0.4, ⊗ 6.0.14)\n\ndefault: `16`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of thread groups in the thread pool [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_size)]."],JA=["```mysql\ndeclare @@thread_pool_stall_limit integer\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndefault: `6`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","How long before a statement is defined as stalled [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_pool_stall_limit)]."],eR=["```mysql\ndeclare @@thread_stack integer\n```","_**System Variable**_\n\ndefault: `286720`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The stack size for each thread [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_stack)]."],tR=["```mysql\ndeclare @@Threads_cached integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads in the thread cache [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Threads_cached)]."],nR=["```mysql\ndeclare @@Threads_connected integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of currently open connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Threads_connected)]."],sR=["```mysql\ndeclare @@Threads_created integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads created to handle connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Threads_created)]."],oR=["```mysql\ndeclare @@Threads_running integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of threads that are not sleeping [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Threads_running)]."],aR=["```mysql\ndeclare @@time_format string\n```","_**System Variable**_ (⊗ 8.0.3)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The TIME format (unused) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_time_format)]."],iR=["```mysql\ndeclare @@time_zone string\n```","_**System Variable**_\n\ndefault: `SYSTEM`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","The current time zone [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_time_zone)]."],rR=["```mysql\ndeclare @@timed_mutexes boolean\n```","_**System Variable**_ (⊕ 5.0.3, ⊘ 5.6.20, ⊗ 5.7.5)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Specify whether to time mutexes (only InnoDB mutexes are currently supported) [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_timed_mutexes)]."],mR=["```mysql\ndeclare @@timestamp numeric\n```","_**System Variable**_\n\ndefault: `UNIX_TIMESTAMP()`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Change the value returned by NOW(); maxmimum value corresponds to '2038-01-19 03:14:07' UTC [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_timestamp)]."],lR=["```mysql\ndeclare @@tls_ciphersuites string\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible TLSv1.3 ciphersuites for encrypted connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tls_ciphersuites)]."],dR=["```mysql\ndeclare @@tls_version string\n```","_**System Variable**_ (⊕ 5.7.10)\n\ndefault: `TLSv1,TLSv1.1,TLSv1.2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Permissible TLS protocols for encrypted connections [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tls_version)]."],cR=["```mysql\ndeclare @@tmp_table_size integer\n```","_**System Variable**_\n\ndefault: `16777216`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size)]."],_R=["```mysql\ndeclare @@tmpdir dirname\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Path for temporary files [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_tmpdir)]."],pR=["```mysql\ndeclare @@transaction_alloc_block_size integer\n```","_**System Variable**_\n\ndefault: `8192`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allocation block size for transactions to be stored in binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_alloc_block_size)]."],hR=["```mysql\ndeclare @@transaction_allow_batching boolean\n```","_**System Variable**_ (⊕ 5.1.23-ndb-6.3.7)\n\ndefault: `OFF`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Allows batching of statements within a transaction. Disable AUTOCOMMIT to use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_allow_batching)]."],yR=["```mysql\ndeclare @@transaction_prealloc_size integer\n```","_**System Variable**_\n\ndefault: `4096`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Persistent buffer for transactions to be stored in binary log [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_prealloc_size)]."],vR=["```mysql\ndeclare @@transaction_write_set_extraction enumeration\n```","_**System Variable**_ (⊕ 5.7.6)\n\ndefault: `XXHASH64`, valid values:\n\n- `OFF`\n- `MURMUR32`\n- `XXHASH64`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Defines the algorithm used to hash the writes extracted during a transaction [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_write_set_extraction)]."],uR=["```mysql\ndeclare @@tx_isolation enumeration\n```","_**System Variable**_ (⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `REPEATABLE-READ`, valid values:\n\n- `READ-UNCOMMITTED`\n- `READ-COMMITTED`\n- `REPEATABLE-READ`\n- `SERIALIZABLE`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The default transaction isolation level [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tx_isolation)]."],bR=["```mysql\ndeclare @@tx_read_only boolean\n```","_**System Variable**_ (⊕ 5.6.5, ⊘ 5.7.20, ⊗ 8.0.3)\n\ndefault: `OFF`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Default transaction access mode [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tx_read_only)]."],fR=["```mysql\ndeclare @@unique_checks boolean\n```","_**System Variable**_\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","If enabled (the default), uniqueness checks for secondary indexes in InnoDB tables are performed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_unique_checks)]."],qR=["```mysql\ndeclare @@updatable_views_with_limit boolean\n```","_**System Variable**_ (⊕ 5.0.2)\n\ndefault: `1`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_updatable_views_with_limit)]."],gR=["```mysql\ndeclare @@upgrade enumeration\n```","_**System Variable**_ (⊕ 8.0.16)\n\ndefault: `AUTO`, valid values:\n\n- `AUTO`\n- `NONE`\n- `MINIMAL`\n- `FORCE`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Control automatic upgrade at startup [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_upgrade)]."],SR=["```mysql\ndeclare @@Uptime integer\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds the server has been up [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Uptime)]."],zR=["```mysql\ndeclare @@Uptime_since_flush_status integer\n```","_**System Variable**_ (⊕ 6.0.5)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds since the most recent FLUSH STATUS [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_Uptime_since_flush_status)]."],VR=["```mysql\ndeclare @@use_secondary_engine enumeration\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `ON`, valid values:\n\n- `OFF`\n- `ON`\n- `FORCED`\n\ndynamic: yes, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","For future use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_use_secondary_engine)]."],TR=["```mysql\ndeclare @@user string\n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Run mysqld daemon as user [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_user)]."],ER=["```mysql\ndeclare @@validate_password_check_user_name boolean\n```","_**System Variable**_ (⊕ 5.7.15)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to check passwords against user name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_check_user_name)]."],AR=["```mysql\ndeclare @@validate_password_dictionary_file filename\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password dictionary file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_dictionary_file)]."],RR=["```mysql\ndeclare @@validate_password_dictionary_file_last_parsed datetime\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When the dictionary file was last parsed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_validate_password_dictionary_file_last_parsed)]."],xR=["```mysql\ndeclare @@validate_password_dictionary_file_words_count integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of words in dictionary file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_validate_password_dictionary_file_words_count)]."],wR=["```mysql\ndeclare @@validate_password_length integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `8`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required password length [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_length)]."],NR=["```mysql\ndeclare @@validate_password_mixed_case_count integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of uppercase/lowercase characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_mixed_case_count)]."],CR=["```mysql\ndeclare @@validate_password_number_count integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of digit characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_number_count)]."],kR=["```mysql\ndeclare @@validate_password_policy enumeration\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password password policy [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_policy)]."],OR=["```mysql\ndeclare @@validate_password_special_char_count integer\n```","_**System Variable**_ (⊕ 5.6.6)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of special characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password_special_char_count)]."],IR=["```mysql\ndeclare @@validate_user_plugins boolean\n```","_**System Variable**_ (⊕ 5.1.1)\n\ndefault: `ON`\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to perform additional validation of user plugins [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_user_plugins)]."],LR=["```mysql\ndeclare @@verbose \n```","_**System Variable**_\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Used with --help option for detailed help [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#option_mysqld_verbose)]."],DR=["```mysql\ndeclare @@version \n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Output version information and exit [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version)]."],MR=["```mysql\ndeclare @@version_comment string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","This variable contains the value of the --with-comment option specified when building MySQL [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_comment)]."],FR=["```mysql\ndeclare @@version_compile_machine string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The type of machine or architecture on which MySQL was built [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_compile_machine)]."],PR=["```mysql\ndeclare @@version_compile_os string\n```","_**System Variable**_\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","The type of operating system on which MySQL was built [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_compile_os)]."],BR=["```mysql\ndeclare @@version_compile_zlib string\n```","_**System Variable**_ (⊕ 8.0.11)\n\ndynamic: no, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Version of compiled-in zlib library [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_compile_zlib)]."],UR=["```mysql\ndeclare @@version_tokens_session string\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `NULL`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Client token list for Version Tokens [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_tokens_session)]."],HR=["```mysql\ndeclare @@version_tokens_session_number integer\n```","_**System Variable**_ (⊕ 5.7.8)\n\ndefault: `0`\n\ndynamic: no, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","For internal use [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_version_tokens_session_number)]."],WR=["```mysql\ndeclare @@wait_timeout integer\n```","_**System Variable**_\n\ndefault: `28800`, min: `1`, max: `2147483`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of seconds the server waits for activity on a connection before closing it [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout)]."],QR=["```mysql\ndeclare @@warning_count integer\n```","_**System Variable**_\n\ndynamic: no, scope: session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of warnings [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_warning_count)]."],jR=["```mysql\ndeclare @@warnings integer\n```","_**System Variable**_ (⊘ 4.1.0, ⊗ 5.5.3)\n\ndefault: `1`\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Deprecated; use --log-warnings instead [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#)]."],GR=["```mysql\ndeclare @@windowing_use_high_precision boolean\n```","_**System Variable**_ (⊕ 8.0.2)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, session, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) supported","Whether to compute window functions to high precision [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_windowing_use_high_precision)]."];var XR={clone_autotune_concurrency:e,clone_buffer_size:t,clone_ddl_timeout:n,clone_enable_compression:s,clone_max_concurrency:o,clone_max_data_bandwidth:a,clone_max_network_bandwidth:i,clone_ssl_ca:r,clone_ssl_cert:m,clone_ssl_key:l,clone_valid_donor_list:d,group_replication_group_name:c,group_replication_start_on_boot:_,group_replication_local_address:p,group_replication_member_weight:h,group_replication_member_expel_timeout:y,group_replication_group_seeds:v,group_replication_force_members:u,group_replication_bootstrap_group:b,group_replication_clone_threshold:f,group_replication_poll_spin_loops:q,group_replication_recovery_compression_algorithm:g,group_replication_recovery_get_public_key:S,group_replication_recovery_public_key_path:z,group_replication_recovery_retry_count:V,group_replication_recovery_reconnect_interval:T,group_replication_recovery_use_ssl:E,group_replication_recovery_ssl_ca:A,group_replication_recovery_ssl_capath:R,group_replication_recovery_ssl_cert:x,group_replication_recovery_ssl_key:w,group_replication_recovery_ssl_cipher:N,group_replication_recovery_ssl_crl:C,group_replication_recovery_ssl_crlpath:k,group_replication_recovery_ssl_verify_server_cert:O,group_replication_recovery_tls_version:I,group_replication_recovery_tls_ciphersuites:L,group_replication_recovery_complete_at:D,group_replication_recovery_zstd_compression_level:M,group_replication_communication_debug_options:F,group_replication_components_stop_timeout:P,group_replication_consistency:B,group_replication_allow_local_lower_version_join:U,group_replication_allow_local_disjoint_gtids_join:H,group_replication_auto_increment_increment:W,group_replication_compression_threshold:Q,group_replication_gtid_assignment_block_size:j,group_replication_ssl_mode:G,group_replication_single_primary_mode:X,group_replication_transaction_size_limit:Y,group_replication_unreachable_majority_timeout:K,group_replication_enforce_update_everywhere_checks:Z,group_replication_exit_state_action:$,group_replication_flow_control_mode:J,group_replication_flow_control_certifier_threshold:ee,group_replication_flow_control_applier_threshold:te,group_replication_flow_control_hold_percent:ne,group_replication_flow_control_max_commit_quota:se,group_replication_flow_control_member_quota_percent:oe,group_replication_flow_control_min_quota:ae,group_replication_flow_control_min_recovery_quota:ie,group_replication_flow_control_period:re,group_replication_flow_control_release_percent:me,group_replication_ip_whitelist:le,group_replication_communication_max_message_size:de,group_replication_message_cache_size:ce,group_replication_autorejoin_tries:_e,group_replication_tls_source:pe,group_replication_primary_member:he,mysqlx:ye,mysqlx_bind_address:ve,mysqlx_compression_algorithms:ue,mysqlx_connect_timeout:be,mysqlx_deflate_default_compression_level:fe,mysqlx_deflate_max_client_compression_level:qe,mysqlx_document_id_unique_prefix:ge,mysqlx_enable_hello_notice:Se,mysqlx_idle_worker_thread_timeout:ze,mysqlx_interactive_timeout:Ve,mysqlx_lz4_default_compression_level:Te,mysqlx_lz4_max_client_compression_level:Ee,mysqlx_max_allowed_packet:Ae,mysqlx_max_connections:Re,mysqlx_min_worker_threads:xe,mysqlx_port:we,mysqlx_port_open_timeout:Ne,mysqlx_read_timeout:Ce,mysqlx_socket:ke,mysqlx_ssl_ca:Oe,mysqlx_ssl_capath:Ie,mysqlx_ssl_cert:Le,mysqlx_ssl_cipher:De,mysqlx_ssl_crl:Me,mysqlx_ssl_crlpath:Fe,mysqlx_ssl_key:Pe,mysqlx_wait_timeout:Be,mysqlx_write_timeout:Ue,mysqlx_zstd_default_compression_level:He,mysqlx_zstd_max_client_compression_level:We,Mysqlx_aborted_clients:Qe,Mysqlx_address:je,Mysqlx_bytes_sent:Ge,Mysqlx_bytes_received:Xe,Mysqlx_bytes_sent_compressed_payload:Ye,Mysqlx_bytes_sent_uncompressed_frame:Ke,Mysqlx_bytes_received_compressed_payload:Ze,Mysqlx_bytes_received_uncompressed_frame:$e,Mysqlx_compression_algorithm:Je,Mysqlx_compression_level:et,Mysqlx_socket:tt,Mysqlx_stmt_execute_sql:nt,Mysqlx_stmt_execute_xplugin:st,Mysqlx_stmt_create_collection:ot,Mysqlx_stmt_create_collection_index:at,Mysqlx_stmt_drop_collection:it,Mysqlx_stmt_drop_collection_index:rt,Mysqlx_stmt_ensure_collection:mt,Mysqlx_stmt_execute_mysqlx:lt,Mysqlx_stmt_get_collection_options:dt,Mysqlx_stmt_modify_collection_options:ct,Mysqlx_stmt_list_objects:_t,Mysqlx_stmt_enable_notices:pt,Mysqlx_stmt_disable_notices:ht,Mysqlx_stmt_list_notices:yt,Mysqlx_stmt_list_clients:vt,Mysqlx_stmt_kill_client:ut,Mysqlx_stmt_ping:bt,Mysqlx_crud_insert:ft,Mysqlx_crud_update:qt,Mysqlx_crud_create_view:gt,Mysqlx_crud_drop_view:St,Mysqlx_crud_modify_view:zt,Mysqlx_crud_delete:Vt,Mysqlx_crud_find:Tt,Mysqlx_errors_unknown_message_type:Et,Mysqlx_expect_open:At,Mysqlx_expect_close:Rt,Mysqlx_rows_sent:xt,Mysqlx_notice_warning_sent:wt,Mysqlx_notice_global_sent:Nt,Mysqlx_notice_other_sent:Ct,Mysqlx_notified_by_group_replication:kt,Mysqlx_prep_deallocate:Ot,Mysqlx_prep_execute:It,Mysqlx_prep_prepare:Lt,Mysqlx_port:Dt,Mysqlx_ssl_cipher:Mt,Mysqlx_ssl_cipher_list:Ft,Mysqlx_ssl_verify_depth:Pt,Mysqlx_ssl_verify_mode:Bt,Mysqlx_ssl_version:Ut,Mysqlx_sessions:Ht,Mysqlx_sessions_closed:Wt,Mysqlx_sessions_fatal_error:Qt,Mysqlx_init_error:jt,Mysqlx_sessions_accepted:Gt,Mysqlx_sessions_rejected:Xt,Mysqlx_sessions_killed:Yt,Mysqlx_connections_closed:Kt,Mysqlx_connections_accepted:Zt,Mysqlx_connections_rejected:$t,Mysqlx_connection_accept_errors:Jt,Mysqlx_connection_errors:en,Mysqlx_cursor_close:tn,Mysqlx_cursor_fetch:nn,Mysqlx_cursor_open:sn,Mysqlx_worker_threads:on,Mysqlx_worker_threads_active:an,Mysqlx_ssl_active:rn,Mysqlx_ssl_ctx_verify_depth:mn,Mysqlx_ssl_ctx_verify_mode:ln,Mysqlx_ssl_finished_accepts:dn,Mysqlx_ssl_accepts:cn,Mysqlx_ssl_server_not_after:_n,Mysqlx_ssl_server_not_before:pn,Mysqlx_ssl_accept_renegotiates:hn,Mysqlx_errors_sent:yn,Aborted_clients:vn,Aborted_connects:un,Acl_cache_items_count:bn,activate_all_roles_on_login:fn,admin_address:qn,admin_port:gn,admin_ssl_ca:Sn,admin_ssl_capath:zn,admin_ssl_cert:Vn,admin_ssl_cipher:Tn,admin_ssl_crl:En,admin_ssl_crlpath:An,admin_ssl_key:Rn,admin_tls_ciphersuites:xn,admin_tls_version:wn,ansi:Nn,audit_log_buffer_size:Cn,audit_log_compression:kn,audit_log_connection_policy:On,audit_log_current_session:In,Audit_log_current_size:Ln,Audit_log_event_max_drop_size:Dn,Audit_log_events:Mn,Audit_log_events_filtered:Fn,Audit_log_events_lost:Pn,Audit_log_events_written:Bn,audit_log_encryption:Un,audit_log_exclude_accounts:Hn,audit_log_file:Wn,audit_log_filter_id:Qn,audit_log_flush:jn,audit_log_format:Gn,audit_log_include_accounts:Xn,audit_log_password_history_keep_days:Yn,audit_log_policy:Kn,audit_log_read_buffer_size:Zn,audit_log_rotate_on_size:$n,audit_log_statement_policy:Jn,audit_log_strategy:es,Audit_log_total_size:ts,Audit_log_write_waits:ns,authentication_ldap_sasl_auth_method_name:ss,authentication_ldap_sasl_bind_base_dn:os,authentication_ldap_sasl_bind_root_dn:as,authentication_ldap_sasl_bind_root_pwd:is,authentication_ldap_sasl_ca_path:rs,authentication_ldap_sasl_group_search_attr:ms,authentication_ldap_sasl_group_search_filter:ls,authentication_ldap_sasl_init_pool_size:ds,authentication_ldap_sasl_log_status:cs,authentication_ldap_sasl_max_pool_size:_s,authentication_ldap_sasl_referral:ps,authentication_ldap_sasl_server_host:hs,authentication_ldap_sasl_server_port:ys,Authentication_ldap_sasl_supported_methods:vs,authentication_ldap_sasl_tls:us,authentication_ldap_sasl_user_search_attr:bs,authentication_ldap_simple_auth_method_name:fs,authentication_ldap_simple_bind_base_dn:qs,authentication_ldap_simple_bind_root_dn:gs,authentication_ldap_simple_bind_root_pwd:Ss,authentication_ldap_simple_ca_path:zs,authentication_ldap_simple_group_search_attr:Vs,authentication_ldap_simple_group_search_filter:Ts,authentication_ldap_simple_init_pool_size:Es,authentication_ldap_simple_log_status:As,authentication_ldap_simple_max_pool_size:Rs,authentication_ldap_simple_referral:xs,authentication_ldap_simple_server_host:ws,authentication_ldap_simple_server_port:Ns,authentication_ldap_simple_tls:Cs,authentication_ldap_simple_user_search_attr:ks,authentication_windows_log_level:Os,authentication_windows_use_principal_name:Is,auto_generate_certs:Ls,auto_increment_increment:Ds,auto_increment_offset:Ms,autocommit:Fs,automatic_sp_privileges:Ps,avoid_temporal_upgrade:Bs,back_log:Us,backup_elevation:Hs,backup_history_log:Ws,backup_history_log_file:Qs,backup_progress_log:js,backup_progress_log_file:Gs,backup_wait_timeout:Xs,backupdir:Ys,basedir:Ks,big_tables:Zs,bind_address:$s,binlog_format:Js,binlog_encryption:eo,binlog_rotate_encryption_master_key_at_startup:to,Binlog_cache_disk_use:no,binlog_cache_size:so,Binlog_cache_use:oo,binlog_checksum:ao,binlog_direct_non_transactional_updates:io,binlog_error_action:ro,binlog_expire_logs_seconds:mo,binlog_group_commit_sync_delay:lo,binlog_group_commit_sync_no_delay_count:co,binlog_gtid_simple_recovery:_o,binlog_max_flush_queue_time:po,binlog_order_commits:ho,binlog_row_image:yo,binlog_row_metadata:vo,binlog_row_value_options:uo,binlog_rows_query_log_events:bo,Binlog_stmt_cache_disk_use:fo,binlog_stmt_cache_size:qo,Binlog_stmt_cache_use:go,binlog_transaction_compression:So,binlog_transaction_compression_level_zstd:zo,binlog_transaction_dependency_tracking:Vo,binlog_transaction_dependency_history_size:To,binlogging_impossible_mode:Eo,block_encryption_mode:Ao,bootstrap:Ro,bulk_insert_buffer_size:xo,Bytes_received:wo,Bytes_sent:No,caching_sha2_password_auto_generate_rsa_keys:Co,caching_sha2_password_private_key_path:ko,caching_sha2_password_public_key_path:Oo,Caching_sha2_password_rsa_public_key:Io,character_set_filesystem:Lo,character_set_server:Do,character_sets_dir:Mo,character_set:Fo,character_set_client:Po,character_set_connection:Bo,character_set_database:Uo,character_set_results:Ho,character_set_system:Wo,check_proxy_users:Qo,chroot:jo,collation_server:Go,collation_connection:Xo,collation_database:Yo,Com_admin_commands:Ko,Com_alter_db:Zo,Com_alter_db_upgrade:$o,Com_alter_event:Jo,Com_alter_function:ea,Com_alter_procedure:ta,Com_alter_resource_group:na,Com_alter_server:sa,Com_alter_table:oa,Com_alter_tablespace:aa,Com_alter_user:ia,Com_alter_user_default_role:ra,Com_analyze:ma,Com_assign_to_keycache:la,Com_backup:da,Com_backup_table:ca,Com_begin:_a,Com_binlog:pa,Com_call_procedure:ha,Com_change_db:ya,Com_change_master:va,Com_change_repl_filter:ua,Com_check:ba,Com_checksum:fa,Com_clone:qa,Com_commit:ga,Com_create_db:Sa,Com_create_event:za,Com_create_function:Va,Com_create_index:Ta,Com_create_procedure:Ea,Com_create_resource_group:Aa,Com_drop_resource_group:Ra,Com_set_resource_group:xa,Com_create_role:wa,Com_create_server:Na,Com_create_table:Ca,Com_create_trigger:ka,Com_create_udf:Oa,Com_create_user:Ia,Com_create_view:La,Com_dealloc_sql:Da,Com_delete:Ma,Com_delete_multi:Fa,Com_do:Pa,Com_drop_db:Ba,Com_drop_event:Ua,Com_drop_function:Ha,Com_drop_index:Wa,Com_drop_procedure:Qa,Com_drop_role:ja,Com_drop_server:Ga,Com_drop_table:Xa,Com_drop_trigger:Ya,Com_drop_user:Ka,Com_drop_view:Za,Com_empty_query:$a,Com_execute_sql:Ja,Com_explain_other:ei,Com_flush:ti,Com_get_diagnostics:ni,Com_grant:si,Com_grant_roles:oi,Com_group_replication_start:ai,Com_group_replication_stop:ii,Com_ha_close:ri,Com_ha_open:mi,Com_ha_read:li,Com_help:di,Com_insert:ci,Com_insert_select:_i,Com_install_component:pi,Com_install_plugin:hi,Com_kill:yi,Com_load:vi,Com_load_master_data:ui,Com_load_master_table:bi,Com_lock_tables:fi,Com_optimize:qi,Com_preload_keys:gi,Com_prepare_sql:Si,Com_purge:zi,Com_purge_before_date:Vi,Com_purge_bup_log:Ti,Com_release_savepoint:Ei,Com_rename_table:Ai,Com_rename_user:Ri,Com_repair:xi,Com_replace:wi,Com_replace_select:Ni,Com_reset:Ci,Com_resignal:ki,Com_restart:Oi,Com_restore:Ii,Com_restore_table:Li,Com_revoke:Di,Com_revoke_all:Mi,Com_revoke_roles:Fi,Com_rollback:Pi,Com_rollback_to_savepoint:Bi,Com_savepoint:Ui,Com_select:Hi,Com_set_option:Wi,Com_set_role:Qi,Com_show_authors:ji,Com_show_binlog_events:Gi,Com_show_binlogs:Xi,Com_show_charsets:Yi,Com_show_collations:Ki,Com_show_column_types:Zi,Com_show_contributors:$i,Com_show_create_db:Ji,Com_show_create_event:er,Com_show_create_func:tr,Com_show_create_proc:nr,Com_show_create_table:sr,Com_show_create_trigger:or,Com_show_create_user:ar,Com_show_databases:ir,Com_show_engine_logs:rr,Com_show_engine_mutex:mr,Com_show_engine_status:lr,Com_show_errors:dr,Com_show_events:cr,Com_show_fields:_r,Com_show_function_code:pr,Com_show_function_status:hr,Com_show_grants:yr,Com_show_innodb_status:vr,Com_show_keys:ur,Com_show_logs:br,Com_show_master_status:fr,Com_show_ndb_status:qr,Com_show_new_master:gr,Com_show_open_tables:Sr,Com_show_plugins:zr,Com_show_privileges:Vr,Com_show_procedure_code:Tr,Com_show_procedure_status:Er,Com_show_processlist:Ar,Com_show_profile:Rr,Com_show_profiles:xr,Com_show_relaylog_events:wr,Com_show_slave_hosts:Nr,Com_show_slave_status:Cr,Com_show_slave_status_nonblocking:kr,Com_show_status:Or,Com_show_storage_engines:Ir,Com_show_table_status:Lr,Com_show_tables:Dr,Com_show_triggers:Mr,Com_show_variables:Fr,Com_show_warnings:Pr,Com_shutdown:Br,Com_signal:Ur,Com_slave_start:Hr,Com_slave_stop:Wr,Com_stmt_close:Qr,Com_stmt_execute:jr,Com_stmt_fetch:Gr,Com_stmt_prepare:Xr,Com_stmt_reprepare:Yr,Com_stmt_reset:Kr,Com_stmt_send_long_data:Zr,Com_truncate:$r,Com_uninstall_component:Jr,Com_uninstall_plugin:em,Com_unlock_tables:tm,Com_update:nm,Com_update_multi:sm,Com_xa_commit:om,Com_xa_end:am,Com_xa_prepare:im,Com_xa_recover:rm,Com_xa_rollback:mm,Com_xa_start:lm,completion_type:dm,Compression:cm,Compression_algorithm:_m,Compression_level:pm,concurrent_insert:hm,Connection_control_delay_generated:ym,connection_control_failed_connections_threshold:vm,connection_control_max_connection_delay:um,connection_control_min_connection_delay:bm,connect_timeout:fm,Connection_errors_accept:qm,Connection_errors_internal:gm,Connection_errors_max_connections:Sm,Connection_errors_peer_address:zm,Connection_errors_select:Vm,Connection_errors_tcpwrap:Tm,Connections:Em,platforms:Am,core_file:Rm,Created_tmp_disk_tables:xm,Created_tmp_files:wm,Created_tmp_tables:Nm,create_admin_listener_thread:Cm,create_old_temporals:km,cte_max_recursion_depth:Om,Current_tls_ca:Im,Current_tls_capath:Lm,Current_tls_cert:Dm,Current_tls_cipher:Mm,Current_tls_ciphersuites:Fm,Current_tls_crl:Pm,Current_tls_crlpath:Bm,Current_tls_key:Um,Current_tls_version:Hm,daemon_memcached_enable_binlog:Wm,daemon_memcached_engine_lib_name:Qm,daemon_memcached_engine_lib_path:jm,daemon_memcached_option:Gm,daemon_memcached_r_batch_size:Xm,daemon_memcached_w_batch_size:Ym,daemonize:Km,datadir:Zm,date_format:$m,datetime_format:Jm,debug:el,debug_sync:tl,default_collation_for_utf8mb4:nl,default_storage_engine:sl,default_table_encryption:ol,default_authentication_plugin:al,default_password_lifetime:il,default_tmp_storage_engine:rl,default_week_format:ml,delay_key_write:ll,Delayed_errors:dl,delayed_insert_limit:cl,Delayed_insert_threads:_l,delayed_insert_timeout:pl,delayed_queue_size:hl,Delayed_writes:yl,disable_gtid_unsafe_statements:vl,disabled_storage_engines:ul,disconnect_on_expired_password:bl,div_precision_increment:fl,"dragnet.log_error_filter_rules":["```mysql\ndeclare @@dragnet.log_error_filter_rules string\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `IF prio>=INFORMATION THEN drop. IF EXISTS source_line THEN unset source_line.`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Filter rules for error logging [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_dragnet.log_error_filter_rules)]."],"dragnet.Status":["```mysql\ndeclare @@dragnet.Status string\n```","_**System Variable**_ (⊕ 8.0.12)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Result of most recent assignment to dragnet.log_error_filter_rules [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_dragnet.Status)]."],end_markers_in_json:ql,enforce_gtid_consistency:gl,engine_condition_pushdown:Sl,eq_range_index_dive_limit:zl,error_count:Vl,event_scheduler:Tl,executed_gtids_compression_period:El,expire_logs_days:Al,explicit_defaults_for_timestamp:Rl,external_user:xl,federated:wl,Firewall_access_denied:Nl,Firewall_access_granted:Cl,Firewall_cached_entries:kl,flush:Ol,Flush_commands:Il,flush_time:Ll,foreign_key_checks:Dl,ft_boolean_syntax:Ml,ft_max_word_len:Fl,ft_min_word_len:Pl,ft_query_expansion_limit:Bl,ft_stopword_file:Ul,gdb:Hl,general_log:Wl,general_log_file:Ql,generated_random_password_length:jl,group_concat_max_len:Gl,gtid_done:Xl,gtid_executed:Yl,gtid_executed_compression_period:Kl,gtid_lost:Zl,gtid_mode:$l,gtid_next:Jl,gtid_owned:ed,gtid_purged:td,Handler_commit:nd,Handler_delete:sd,Handler_discover:od,Handler_external_lock:ad,Handler_mrr_init:id,Handler_prepare:rd,Handler_read_first:md,Handler_read_key:ld,Handler_read_last:dd,Handler_read_next:cd,Handler_read_prev:_d,Handler_read_rnd:pd,Handler_read_rnd_next:hd,Handler_rollback:yd,Handler_savepoint:vd,Handler_savepoint_rollback:ud,Handler_update:bd,Handler_write:fd,have_archive:qd,have_blackhole_engine:gd,have_community_features:Sd,have_compress:zd,have_crypt:Vd,have_csv:Td,have_dynamic_loading:Ed,have_example_engine:Ad,have_federated_engine:Rd,have_geometry:xd,have_innodb:wd,have_isam:Nd,have_merge_engine:Cd,have_ndbcluster:kd,have_openssl:Od,have_partition_engine:Id,have_partitioning:Ld,have_profiling:Dd,have_query_cache:Md,have_raid:Fd,have_row_based_replication:Pd,have_rtree_keys:Bd,have_ssl:Ud,have_statement_timeout:Hd,have_symlink:Wd,help:Qd,histogram_generation_max_mem_size:jd,host_cache_size:Gd,hostname:Xd,identity:Yd,ignore_builtin_innodb:Kd,ignore_db_dirs:Zd,information_schema_stats_expiry:$d,init_file:Jd,init_connect:ec,init_slave:tc,initialize:nc,innodb:sc,innodb_adaptive_flushing:oc,innodb_adaptive_flushing_lwm:ac,innodb_adaptive_hash_index:ic,innodb_adaptive_hash_index_parts:rc,innodb_adaptive_max_sleep_delay:mc,innodb_api_bk_commit_interval:lc,innodb_api_disable_rowlock:dc,innodb_api_enable_binlog:cc,innodb_api_enable_mdl:_c,innodb_api_trx_level:pc,innodb_autoextend_increment:hc,innodb_autoinc_lock_mode:yc,Innodb_available_undo_logs:vc,innodb_background_drop_list_empty:uc,Innodb_buffer_pool_bytes_data:bc,Innodb_buffer_pool_bytes_dirty:fc,innodb_buffer_pool_chunk_size:qc,innodb_buffer_pool_debug:gc,innodb_buffer_pool_dump_at_shutdown:Sc,innodb_buffer_pool_dump_now:zc,innodb_buffer_pool_dump_pct:Vc,Innodb_buffer_pool_dump_status:Tc,innodb_buffer_pool_filename:Ec,innodb_buffer_pool_in_core_file:Ac,innodb_buffer_pool_instances:Rc,innodb_buffer_pool_load_abort:xc,innodb_buffer_pool_load_at_startup:wc,innodb_buffer_pool_load_now:Nc,Innodb_buffer_pool_load_status:Cc,Innodb_buffer_pool_pages_data:kc,Innodb_buffer_pool_pages_dirty:Oc,Innodb_buffer_pool_pages_flushed:Ic,Innodb_buffer_pool_pages_free:Lc,Innodb_buffer_pool_pages_latched:Dc,Innodb_buffer_pool_pages_misc:Mc,Innodb_buffer_pool_pages_total:Fc,Innodb_buffer_pool_read_ahead:Pc,Innodb_buffer_pool_read_ahead_evicted:Bc,Innodb_buffer_pool_read_ahead_rnd:Uc,Innodb_buffer_pool_read_ahead_seq:Hc,Innodb_buffer_pool_read_requests:Wc,Innodb_buffer_pool_reads:Qc,Innodb_buffer_pool_resize_status:jc,innodb_buffer_pool_size:Gc,Innodb_buffer_pool_wait_free:Xc,Innodb_buffer_pool_write_requests:Yc,innodb_change_buffer_max_size:Kc,innodb_change_buffering:Zc,innodb_change_buffering_debug:$c,innodb_checkpoint_disabled:Jc,innodb_checksum_algorithm:e_,innodb_checksums:t_,innodb_cmp_per_index_enabled:n_,innodb_commit_concurrency:s_,innodb_compress_debug:o_,innodb_compression_failure_threshold_pct:a_,innodb_compression_level:i_,innodb_compression_pad_pct_max:r_,innodb_concurrency_tickets:m_,innodb_data_file_path:l_,Innodb_data_fsyncs:d_,innodb_data_home_dir:c_,Innodb_data_pending_fsyncs:__,Innodb_data_pending_reads:p_,Innodb_data_pending_writes:h_,Innodb_data_read:y_,Innodb_data_reads:v_,Innodb_data_writes:u_,Innodb_data_written:b_,innodb_ddl_log_crash_reset_debug:f_,innodb_deadlock_detect:q_,innodb_dedicated_server:g_,innodb_default_row_format:S_,Innodb_dblwr_pages_written:z_,Innodb_dblwr_writes:V_,innodb_directories:T_,innodb_disable_sort_file_cache:E_,innodb_disable_resize_buffer_pool_debug:A_,innodb_doublewrite:R_,innodb_doublewrite_batch_size:x_,innodb_doublewrite_dir:w_,innodb_doublewrite_files:N_,innodb_doublewrite_pages:C_,innodb_extra_dirty_writes:k_,innodb_fast_shutdown:O_,innodb_fil_make_page_dirty_debug:I_,innodb_file_format:L_,innodb_file_format_check:D_,innodb_file_format_max:M_,innodb_file_io_threads:F_,innodb_file_per_table:P_,innodb_fill_factor:B_,innodb_flush_log_at_timeout:U_,innodb_flush_log_at_trx_commit:H_,innodb_flush_method:W_,innodb_flush_neighbors:Q_,innodb_flush_sync:j_,innodb_flushing_avg_loops:G_,innodb_force_load_corrupted:X_,innodb_force_recovery:Y_,innodb_fsync_threshold:K_,innodb_ft_aux_table:Z_,innodb_ft_cache_size:$_,innodb_ft_enable_diag_print:J_,innodb_ft_enable_stopword:ep,innodb_ft_max_token_size:tp,innodb_ft_min_token_size:np,innodb_ft_num_word_optimize:sp,innodb_ft_result_cache_limit:op,innodb_ft_server_stopword_table:ap,innodb_ft_sort_pll_degree:ip,innodb_ft_total_cache_size:rp,innodb_ft_user_stopword_table:mp,Innodb_have_atomic_builtins:lp,Innodb_have_sync_atomic:dp,Innodb_heap_enabled:cp,innodb_idle_flush_pct:_p,innodb_io_capacity:pp,innodb_io_capacity_max:hp,innodb_large_prefix:yp,innodb_limit_optimistic_insert_debug:vp,innodb_lock_wait_timeout:up,innodb_locks_unsafe_for_binlog:bp,innodb_log_arch_dir:fp,innodb_log_archive:qp,innodb_log_buffer_size:gp,innodb_log_checkpoint_fuzzy_now:Sp,innodb_log_checkpoint_now:zp,innodb_log_checksum_algorithm:Vp,innodb_log_checksums:Tp,innodb_log_compressed_pages:Ep,innodb_log_file_size:Ap,innodb_log_files_in_group:Rp,innodb_log_group_home_dir:xp,innodb_log_spin_cpu_abs_lwm:wp,innodb_log_spin_cpu_pct_hwm:Np,Innodb_log_waits:Cp,innodb_log_wait_for_flush_spin_hwm:kp,innodb_log_write_ahead_size:Op,Innodb_log_write_requests:Ip,Innodb_log_writes:Lp,innodb_log_writer_threads:Dp,innodb_lru_scan_depth:Mp,innodb_max_dirty_pages_pct:Fp,innodb_max_dirty_pages_pct_lwm:Pp,innodb_max_merged_io:Bp,innodb_max_purge_lag:Up,innodb_max_purge_lag_delay:Hp,innodb_max_undo_log_size:Wp,innodb_additional_mem_pool_size:Qp,innodb_merge_threshold_set_all_debug:jp,innodb_mirrored_log_groups:Gp,innodb_monitor_disable:Xp,innodb_monitor_enable:Yp,innodb_monitor_reset:Kp,innodb_monitor_reset_all:Zp,Innodb_num_open_files:$p,innodb_numa_interleave:Jp,innodb_old_blocks_pct:eh,innodb_old_blocks_time:th,innodb_online_alter_log_max_size:nh,innodb_open_files:sh,innodb_optimize_fulltext_only:oh,innodb_optimize_point_storage:ah,Innodb_os_log_fsyncs:ih,Innodb_os_log_pending_fsyncs:rh,Innodb_os_log_pending_writes:mh,Innodb_os_log_written:lh,innodb_page_cleaners:dh,innodb_page_size:ch,Innodb_page_size:_h,Innodb_pages_created:ph,Innodb_pages_read:hh,Innodb_pages_written:yh,innodb_parallel_read_threads:vh,innodb_print_all_deadlocks:uh,innodb_print_ddl_logs:bh,innodb_purge_batch_size:fh,innodb_purge_rseg_truncate_frequency:qh,innodb_purge_threads:gh,innodb_random_read_ahead:Sh,innodb_read_ahead_threshold:zh,innodb_read_io_threads:Vh,innodb_read_only:Th,innodb_redo_log_archive_dirs:Eh,innodb_redo_log_encrypt:Ah,innodb_replication_delay:Rh,innodb_rollback_on_timeout:xh,innodb_rollback_segments:wh,Innodb_row_lock_current_waits:Nh,Innodb_row_lock_time:Ch,Innodb_row_lock_time_avg:kh,Innodb_row_lock_time_max:Oh,Innodb_row_lock_waits:Ih,Innodb_rows_deleted:Lh,Innodb_rows_inserted:Dh,Innodb_rows_read:Mh,Innodb_rows_updated:Fh,innodb_saved_page_number_debug:Ph,innodb_scan_directories:Bh,innodb_sort_buffer_size:Uh,innodb_spin_wait_delay:Hh,innodb_spin_wait_pause_multiplier:Wh,innodb_stats_auto_recalc:Qh,innodb_stats_include_delete_marked:jh,innodb_stats_method:Gh,innodb_stats_on_metadata:Xh,innodb_stats_persistent:Yh,innodb_stats_persistent_sample_pages:Kh,innodb_stats_sample_pages:Zh,innodb_stats_transient_sample_pages:$h,innodb_status_output:Jh,innodb_status_output_locks:ey,innodb_strict_mode:ty,innodb_support_xa:ny,innodb_sync_array_size:sy,innodb_sync_spin_loops:oy,innodb_sync_debug:ay,Innodb_system_rows_deleted:iy,Innodb_system_rows_inserted:ry,Innodb_system_rows_read:my,innodb_table_locks:ly,innodb_temp_data_file_path:dy,innodb_temp_tablespaces_dir:cy,internal_tmp_mem_storage_engine:_y,innodb_tmpdir:py,innodb_thread_concurrency:hy,innodb_thread_concurrency_timer_based:yy,innodb_thread_sleep_delay:vy,Innodb_truncated_status_writes:uy,innodb_trx_purge_view_update_only_debug:by,innodb_trx_rseg_n_slots_debug:fy,innodb_undo_directory:qy,innodb_undo_log_encrypt:gy,innodb_undo_log_truncate:Sy,innodb_undo_logs:zy,innodb_undo_tablespaces:Vy,Innodb_undo_tablespaces_active:Ty,Innodb_undo_tablespaces_explicit:Ey,Innodb_undo_tablespaces_implicit:Ay,Innodb_undo_tablespaces_total:Ry,innodb_use_legacy_cardinality_algorithm:xy,innodb_use_native_aio:wy,innodb_use_sys_malloc:Ny,innodb_version:Cy,Innodb_wake_ups:ky,innodb_write_io_threads:Oy,insert_id:Iy,interactive_timeout:Ly,internal_tmp_disk_storage_engine:Dy,join_buffer_size:My,join_cache_level:Fy,keep_files_on_create:Py,Key_blocks_not_flushed:By,Key_blocks_unused:Uy,Key_blocks_used:Hy,key_buffer_size:Wy,key_cache_age_threshold:Qy,key_cache_block_size:jy,key_cache_division_limit:Gy,Key_read_requests:Xy,Key_reads:Yy,Key_write_requests:Ky,Key_writes:Zy,keyring_aws_cmk_id:$y,keyring_aws_conf_file:Jy,keyring_aws_data_file:ev,keyring_aws_region:tv,keyring_encrypted_file_data:nv,keyring_encrypted_file_password:sv,keyring_file_data:ov,keyring_hashicorp_auth_path:av,keyring_hashicorp_ca_path:iv,keyring_hashicorp_caching:rv,keyring_hashicorp_commit_auth_path:mv,keyring_hashicorp_commit_ca_path:lv,keyring_hashicorp_commit_caching:dv,keyring_hashicorp_commit_role_id:cv,keyring_hashicorp_commit_server_url:_v,keyring_hashicorp_commit_store_path:pv,keyring_hashicorp_role_id:hv,keyring_hashicorp_secret_id:yv,keyring_hashicorp_server_url:vv,keyring_hashicorp_store_path:uv,keyring_okv_conf_dir:bv,keyring_operations:fv,language:qv,large_files_support:gv,large_page_size:Sv,last_insert_id:zv,Last_query_cost:Vv,Last_query_partial_plans:Tv,lc_time_names:Ev,license:Av,local_infile:Rv,lock_order:xv,lock_order_debug_loop:wv,lock_order_debug_missing_arc:Nv,lock_order_debug_missing_key:Cv,lock_order_debug_missing_unlock:kv,lock_order_dependencies:Ov,lock_order_extra_dependencies:Iv,lock_order_output_directory:Lv,lock_order_print_txt:Dv,lock_order_trace_loop:Mv,lock_order_trace_missing_arc:Fv,lock_order_trace_missing_key:Pv,lock_order_trace_missing_unlock:Bv,lock_wait_timeout:Uv,Locked_connects:Hv,locked_in_memory:Wv,log:Qv,log_bin_trust_function_creators:jv,log_bin_trust_routine_creators:Gv,log_output:Xv,log_queries_not_using_indexes:Yv,log_slow_queries:Kv,log_backward_compatible_user_definitions:Zv,log_bin:$v,log_bin_basename:Jv,log_bin_use_v1_row_events:eu,log_builtin_as_identified_by_password:tu,log_error_filter_rules:nu,log_error_services:su,log_error_suppression_list:ou,log_error_verbosity:au,log_slave_updates:iu,log_slow_admin_statements:ru,log_slow_extra:mu,log_slow_slave_statements:lu,log_statements_unsafe_for_binlog:du,log_syslog:cu,log_syslog_facility:_u,log_syslog_include_pid:pu,log_syslog_tag:hu,log_throttle_queries_not_using_indexes:yu,log_timestamps:vu,long_query_time:uu,low_priority_updates:bu,lower_case_file_system:fu,lower_case_table_names:qu,mandatory_roles:gu,master_info_repository:Su,master_verify_checksum:zu,max_allowed_packet:Vu,max_binlog_cache_size:Tu,max_binlog_size:Eu,max_binlog_stmt_cache_size:Au,max_connect_errors:Ru,max_connections:xu,max_delayed_threads:wu,max_digest_length:Nu,max_error_count:Cu,max_execution_time:ku,Max_execution_time_exceeded:Ou,Max_execution_time_set:Iu,Max_execution_time_set_failed:Lu,max_heap_table_size:Du,max_insert_delayed_threads:Mu,max_join_size:Fu,max_length_for_sort_data:Pu,max_long_data_size:Bu,max_points_in_geometry:Uu,max_prepared_stmt_count:Hu,max_relay_log_size:Wu,max_seeks_for_key:Qu,max_sort_length:ju,max_sp_recursion_depth:Gu,max_statement_time:Xu,max_tmp_tables:Yu,Max_statement_time_exceeded:Ku,Max_statement_time_set:Zu,Max_statement_time_set_failed:$u,Max_used_connections:Ju,Max_used_connections_time:eb,max_user_connections:tb,max_write_lock_count:nb,mecab_charset:sb,mecab_rc_file:ob,memlock:ab,disabledby:ib,metadata_locks_cache_size:rb,metadata_locks_hash_instances:mb,min_examined_row_limit:lb,multi_range_count:db,myisam_data_pointer_size:cb,myisam_max_extra_sort_file_size:_b,myisam_max_sort_file_size:pb,myisam_mmap_size:hb,myisam_recover_options:yb,myisam_repair_threads:vb,myisam_sort_buffer_size:ub,myisam_stats_method:bb,myisam_use_mmap:fb,mysql_native_password_proxy_users:qb,mysql_firewall_max_query_size:gb,mysql_firewall_mode:Sb,mysql_firewall_trace:zb,Ndb_api_bytes_received_count:Vb,Ndb_api_bytes_received_count_session:Tb,Ndb_api_bytes_received_count_slave:Eb,Ndb_api_bytes_sent_count:Ab,Ndb_api_bytes_sent_count_session:Rb,Ndb_api_bytes_sent_count_slave:xb,Ndb_api_event_bytes_count:wb,Ndb_api_event_bytes_count_injector:Nb,Ndb_api_event_data_count:Cb,Ndb_api_event_data_count_injector:kb,Ndb_api_event_nondata_count:Ob,Ndb_api_event_nondata_count_injector:Ib,Ndb_api_pk_op_count:Lb,Ndb_api_pk_op_count_session:Db,Ndb_api_pk_op_count_slave:Mb,Ndb_api_pruned_scan_count:Fb,Ndb_api_pruned_scan_count_session:Pb,Ndb_api_pruned_scan_count_slave:Bb,Ndb_api_range_scan_count:Ub,Ndb_api_range_scan_count_session:Hb,Ndb_api_range_scan_count_slave:Wb,Ndb_api_read_row_count:Qb,Ndb_api_read_row_count_session:jb,Ndb_api_read_row_count_slave:Gb,Ndb_api_scan_batch_count:Xb,Ndb_api_scan_batch_count_session:Yb,Ndb_api_scan_batch_count_slave:Kb,Ndb_api_table_scan_count:Zb,Ndb_api_table_scan_count_session:$b,Ndb_api_table_scan_count_slave:Jb,Ndb_api_trans_abort_count:ef,Ndb_api_trans_abort_count_session:tf,Ndb_api_trans_abort_count_slave:nf,Ndb_api_trans_close_count:sf,Ndb_api_trans_close_count_session:of,Ndb_api_trans_close_count_slave:af,Ndb_api_trans_commit_count:rf,Ndb_api_trans_commit_count_session:mf,Ndb_api_trans_commit_count_slave:lf,Ndb_api_trans_local_read_row_count:df,Ndb_api_trans_local_read_row_count_session:cf,Ndb_api_trans_local_read_row_count_slave:_f,Ndb_api_trans_start_count:pf,Ndb_api_trans_start_count_session:hf,Ndb_api_trans_start_count_slave:yf,Ndb_api_uk_op_count:vf,Ndb_api_uk_op_count_session:uf,Ndb_api_uk_op_count_slave:bf,Ndb_api_wait_exec_complete_count:ff,Ndb_api_wait_exec_complete_count_session:qf,Ndb_api_wait_exec_complete_count_slave:gf,Ndb_api_wait_meta_request_count:Sf,Ndb_api_wait_meta_request_count_session:zf,Ndb_api_wait_meta_request_count_slave:Vf,Ndb_api_wait_nanos_count:Tf,Ndb_api_wait_nanos_count_session:Ef,Ndb_api_wait_nanos_count_slave:Af,Ndb_api_wait_scan_result_count:Rf,Ndb_api_wait_scan_result_count_session:xf,Ndb_api_wait_scan_result_count_slave:wf,ndb_autoincrement_prefetch_sz:Nf,ndb_cache_check_time:Cf,ndb_clear_apply_status:kf,Ndb_cluster_node_id:Of,Ndb_config_from_host:If,Ndb_config_from_port:Lf,Ndb_conflict_fn_epoch:Df,Ndb_conflict_fn_epoch2:Mf,Ndb_conflict_fn_epoch2_trans:Ff,Ndb_conflict_fn_epoch_trans:Pf,Ndb_conflict_fn_max:Bf,Ndb_conflict_fn_max_del_win:Uf,Ndb_conflict_fn_old:Hf,Ndb_conflict_last_conflict_epoch:Wf,Ndb_conflict_last_stable_epoch:Qf,Ndb_conflict_reflected_op_discard_count:jf,Ndb_conflict_reflected_op_prepare_count:Gf,Ndb_conflict_refresh_op_count:Xf,Ndb_conflict_trans_conflict_commit_count:Yf,Ndb_conflict_trans_detect_iter_count:Kf,Ndb_conflict_trans_reject_count:Zf,Ndb_conflict_trans_row_conflict_count:$f,Ndb_conflict_trans_row_reject_count:Jf,ndb_data_node_neighbour:eq,ndb_default_column_format:tq,ndb_deferred_constraints:nq,ndb_dbg_check_shares:sq,ndb_distribution:oq,Ndb_epoch_delete_delete_count:aq,ndb_eventbuffer_free_percent:iq,ndb_eventbuffer_max_alloc:rq,Ndb_execute_count:mq,ndb_extra_logging:lq,ndb_force_send:dq,ndb_fully_replicated:cq,ndb_index_stat_cache_entries:_q,ndb_index_stat_enable:pq,ndb_index_stat_option:hq,ndb_index_stat_update_freq:yq,ndb_join_pushdown:vq,Ndb_last_commit_epoch_server:uq,Ndb_last_commit_epoch_session:bq,ndb_log_apply_status:fq,ndb_log_bin:qq,ndb_log_binlog_index:gq,ndb_log_empty_epochs:Sq,ndb_log_empty_update:zq,ndb_log_exclusive_reads:Vq,ndb_log_orig:Tq,ndb_log_transaction_id:Eq,ndb_metadata_check:Aq,Ndb_metadata_blacklist_size:Rq,ndb_metadata_check_interval:xq,Ndb_metadata_detected_count:wq,ndb_metadata_sync:Nq,Ndb_metadata_synced_count:Cq,Ndb_number_of_data_nodes:kq,ndb_optimized_node_selection:Oq,Ndb_pruned_scan_count:Iq,Ndb_pushed_queries_defined:Lq,Ndb_pushed_queries_dropped:Dq,Ndb_pushed_queries_executed:Mq,Ndb_pushed_reads:Fq,ndb_read_backup:Pq,ndb_recv_thread_activation_threshold:Bq,ndb_recv_thread_cpu_mask:Uq,ndb_report_thresh_binlog_epoch_slip:Hq,ndb_report_thresh_binlog_mem_usage:Wq,ndb_row_checksum:Qq,Ndb_scan_count:jq,ndb_schema_dist_lock_wait_timeout:Gq,ndb_schema_dist_timeout:Xq,ndb_schema_dist_upgrade_allowed:Yq,ndb_show_foreign_key_mock_tables:Kq,ndb_slave_conflict_role:Zq,Ndb_slave_max_replicated_epoch:$q,Ndb_system_name:Jq,ndb_table_no_logging:eg,ndb_table_temporary:tg,Ndb_trans_hint_count_session:ng,ndb_use_copying_alter_table:sg,ndb_use_exact_count:og,ndb_use_transactions:ag,ndb_version:ig,ndb_version_string:rg,ndbinfo:mg,ndbinfo_database:lg,ndbinfo_max_bytes:dg,ndbinfo_max_rows:cg,ndbinfo_offline:_g,ndbinfo_show_hidden:pg,ndbinfo_table_prefix:hg,ndbinfo_version:yg,net_buffer_length:vg,net_read_timeout:ug,net_retry_count:bg,net_write_timeout:fg,ngram_token_size:qg,Not_flushed_delayed_rows:gg,offline_mode:Sg,old:zg,old_alter_table:Vg,old_passwords:Tg,Ongoing_anonymous_gtid_violating_transaction_count:Eg,Ongoing_anonymous_transaction_count:Ag,Ongoing_automatic_gtid_violating_transaction_count:Rg,open_files_limit:xg,Open_files:wg,Open_streams:Ng,Open_table_definitions:Cg,Open_tables:kg,Opened_files:Og,Opened_table_definitions:Ig,Opened_tables:Lg,optimizer_join_cache_level:Dg,optimizer_prune_level:Mg,optimizer_search_depth:Fg,optimizer_switch:Pg,optimizer_trace:Bg,optimizer_trace_features:Ug,optimizer_trace_limit:Hg,optimizer_trace_max_mem_size:Wg,optimizer_trace_offset:Qg,optimizer_use_mrr:jg,original_commit_timestamp:Gg,immediate_server_version:Xg,original_server_version:Yg,parser_max_mem_size:Kg,partial_revokes:Zg,password_history:$g,password_require_current:Jg,password_reuse_interval:eS,performance_schema:tS,Performance_schema_accounts_lost:nS,performance_schema_accounts_size:sS,Performance_schema_cond_classes_lost:oS,Performance_schema_cond_instances_lost:aS,Performance_schema_digest_lost:iS,performance_schema_digests_size:rS,performance_schema_error_size:mS,performance_schema_events_stages_history_long_size:lS,performance_schema_events_stages_history_size:dS,performance_schema_events_statements_history_long_size:cS,performance_schema_events_statements_history_size:_S,performance_schema_events_transactions_history_long_size:pS,performance_schema_events_transactions_history_size:hS,performance_schema_events_waits_history_long_size:yS,performance_schema_events_waits_history_size:vS,Performance_schema_file_classes_lost:uS,Performance_schema_file_handles_lost:bS,Performance_schema_file_instances_lost:fS,Performance_schema_hosts_lost:qS,performance_schema_hosts_size:gS,Performance_schema_index_stat_lost:SS,Performance_schema_locker_lost:zS,performance_schema_max_cond_classes:VS,performance_schema_max_cond_instances:TS,performance_schema_max_digest_length:ES,performance_schema_max_digest_sample_age:AS,performance_schema_max_file_classes:RS,performance_schema_max_file_handles:xS,performance_schema_max_file_instances:wS,performance_schema_max_index_stat:NS,performance_schema_max_memory_classes:CS,performance_schema_max_metadata_locks:kS,performance_schema_max_mutex_classes:OS,performance_schema_max_mutex_instances:IS,performance_schema_max_prepared_statements_instances:LS,performance_schema_max_program_instances:DS,performance_schema_max_rwlock_classes:MS,performance_schema_max_rwlock_instances:FS,performance_schema_max_socket_classes:PS,performance_schema_max_socket_instances:BS,performance_schema_max_sql_text_length:US,performance_schema_max_stage_classes:HS,performance_schema_max_statement_classes:WS,performance_schema_max_statement_stack:QS,performance_schema_max_table_handles:jS,performance_schema_max_table_instances:GS,performance_schema_max_table_lock_stat:XS,performance_schema_max_thread_classes:YS,performance_schema_max_thread_instances:KS,Performance_schema_memory_classes_lost:ZS,Performance_schema_metadata_lock_lost:$S,Performance_schema_mutex_classes_lost:JS,Performance_schema_mutex_instances_lost:ez,Performance_schema_nested_statement_lost:tz,Performance_schema_prepared_statements_lost:nz,Performance_schema_program_lost:sz,Performance_schema_rwlock_classes_lost:oz,Performance_schema_rwlock_instances_lost:az,Performance_schema_session_connect_attrs_longest_seen:iz,Performance_schema_session_connect_attrs_lost:rz,performance_schema_session_connect_attrs_size:mz,performance_schema_setup_actors_size:lz,performance_schema_setup_objects_size:dz,Performance_schema_socket_classes_lost:cz,Performance_schema_socket_instances_lost:_z,Performance_schema_stage_classes_lost:pz,Performance_schema_statement_classes_lost:hz,Performance_schema_table_handles_lost:yz,Performance_schema_table_instances_lost:vz,Performance_schema_table_lock_stat_lost:uz,Performance_schema_thread_classes_lost:bz,Performance_schema_thread_instances_lost:fz,Performance_schema_users_lost:qz,performance_schema_users_size:gz,persisted_globals_load:Sz,persist_only_admin_x509_subject:zz,pid_file:Vz,plugin_dir:Tz,port:Ez,preload_buffer_size:Az,prepared_stmt_count:Rz,Prepared_stmt_count:xz,print_identified_with_as_hex:wz,profiling:Nz,profiling_history_size:Cz,protocol_compression_algorithms:kz,protocol_version:Oz,proxy_user:Iz,pseudo_slave_mode:Lz,pseudo_thread_id:Dz,Qcache_free_blocks:Mz,Qcache_free_memory:Fz,Qcache_hits:Pz,Qcache_inserts:Bz,Qcache_lowmem_prunes:Uz,Qcache_not_cached:Hz,Qcache_queries_in_cache:Wz,Qcache_total_blocks:Qz,Queries:jz,query_alloc_block_size:Gz,query_cache_limit:Xz,query_cache_min_res_unit:Yz,query_cache_size:Kz,query_cache_type:Zz,query_cache_wlock_invalidate:$z,query_prealloc_size:Jz,Questions:eV,rand_seed1:tV,rand_seed2:nV,range_alloc_block_size:sV,range_optimizer_max_mem_size:oV,rbr_exec_mode:aV,read_buffer_size:iV,read_only:rV,read_rnd_buffer_size:mV,regexp_stack_limit:lV,regexp_time_limit:dV,relay_log:cV,relay_log_basename:_V,relay_log_index:pV,relay_log_info_file:hV,relay_log_info_repository:yV,relay_log_purge:vV,relay_log_recovery:uV,relay_log_space_limit:bV,report_host:fV,report_password:qV,report_port:gV,report_user:SV,require_row_format:zV,require_secure_transport:VV,restore_disables_events:TV,restore_elevation:EV,restore_precheck:AV,resultset_metadata:RV,rewriter_enabled:xV,rewriter_verbose:wV,Rewriter_number_loaded_rules:NV,Rewriter_number_reloads:CV,Rewriter_number_rewritten_queries:kV,Rewriter_reload_error:OV,rpl_recovery_rank:IV,Rpl_semi_sync_master_clients:LV,rpl_semi_sync_master_enabled:DV,Rpl_semi_sync_master_net_avg_wait_time:MV,Rpl_semi_sync_master_net_wait_time:FV,Rpl_semi_sync_master_net_waits:PV,Rpl_semi_sync_master_no_times:BV,Rpl_semi_sync_master_no_tx:UV,rpl_semi_sync_master_reply_log_file_pos:HV,Rpl_semi_sync_master_status:WV,Rpl_semi_sync_master_timefunc_failures:QV,rpl_semi_sync_master_timeout:jV,rpl_semi_sync_master_trace_level:GV,Rpl_semi_sync_master_tx_avg_wait_time:XV,Rpl_semi_sync_master_tx_wait_time:YV,Rpl_semi_sync_master_tx_waits:KV,rpl_semi_sync_master_wait_for_slave_count:ZV,rpl_semi_sync_master_wait_no_slave:$V,rpl_semi_sync_master_wait_point:JV,Rpl_semi_sync_master_wait_pos_backtraverse:eT,Rpl_semi_sync_master_wait_sessions:tT,Rpl_semi_sync_master_yes_tx:nT,rpl_semi_sync_slave_enabled:sT,Rpl_semi_sync_slave_status:oT,rpl_semi_sync_slave_trace_level:aT,Rpl_status:iT,rpl_read_size:rT,rpl_stop_slave_timeout:mT,Rsa_public_key:lT,secondary_engine_cost_threshold:dT,schema_definition_cache:cT,Secondary_engine_execution_count:_T,secure_auth:pT,secure_file_priv:hT,Select_full_join:yT,Select_full_range_join:vT,Select_range:uT,Select_range_check:bT,Select_scan:fT,server_id:qT,server_id_bits:gT,server_uuid:ST,session_track_gtids:zT,session_track_schema:VT,session_track_state_change:TT,session_track_system_variables:ET,session_track_transaction_info:AT,sha256_password_auto_generate_rsa_keys:RT,sha256_password_private_key_path:xT,sha256_password_proxy_users:wT,sha256_password_public_key_path:NT,show_compatibility_56:CT,show_create_table_skip_secondary_engine:kT,show_create_table_verbosity:OT,show_old_temporals:IT,simplified_binlog_gtid_recovery:LT,skip_external_locking:DT,slave_load_tmpdir:MT,slave_net_timeout:FT,slave_allow_batching:PT,slave_checkpoint_group:BT,slave_checkpoint_period:UT,slave_compressed_protocol:HT,slave_exec_mode:WT,Slave_heartbeat_period:QT,Slave_last_heartbeat:jT,slave_max_allowed_packet:GT,Slave_open_temp_tables:XT,slave_parallel_type:YT,slave_parallel_workers:KT,slave_pending_jobs_size_max:ZT,slave_preserve_commit_order:$T,Slave_received_heartbeats:JT,Slave_retried_transactions:eE,slave_rows_search_algorithms:tE,Slave_rows_last_search_algorithm_used:nE,Slave_running:sE,slave_sql_verify_checksum:oE,slave_transaction_retries:aE,slave_type_conversions:iE,slow_query_log:rE,Slow_launch_threads:mE,slow_launch_time:lE,Slow_queries:dE,slow_query_log_file:cE,socket:_E,sort_buffer_size:pE,Sort_merge_passes:hE,Sort_range:yE,Sort_rows:vE,Sort_scan:uE,sporadic_binlog_dump_fail:bE,sql_bin_update_same:fE,sql_mode:qE,sql_auto_is_null:gE,sql_big_selects:SE,sql_big_tables:zE,sql_buffer_result:VE,sql_log_bin:TE,sql_log_off:EE,sql_log_update:AE,sql_low_priority_updates:RE,sql_max_join_size:xE,sql_notes:wE,sql_quote_show_create:NE,sql_require_primary_key:CE,sql_safe_updates:kE,sql_select_limit:OE,sql_slave_skip_counter:IE,sql_warnings:LE,ssl_ca:DE,ssl_capath:ME,ssl_cert:FE,ssl_cipher:PE,ssl_crl:BE,ssl_crlpath:UE,ssl_fips_mode:HE,ssl_key:WE,Ssl_accept_renegotiates:QE,Ssl_accepts:jE,Ssl_callback_cache_hits:GE,Ssl_cipher:XE,Ssl_cipher_list:YE,Ssl_client_connects:KE,Ssl_connect_renegotiates:ZE,Ssl_ctx_verify_depth:$E,Ssl_ctx_verify_mode:JE,Ssl_default_timeout:eA,Ssl_finished_accepts:tA,Ssl_finished_connects:nA,Ssl_server_not_after:sA,Ssl_server_not_before:oA,Ssl_session_cache_hits:aA,Ssl_session_cache_misses:iA,Ssl_session_cache_mode:rA,Ssl_session_cache_overflows:mA,Ssl_session_cache_size:lA,Ssl_session_cache_timeouts:dA,Ssl_sessions_reused:cA,Ssl_used_session_cache_entries:_A,Ssl_verify_depth:pA,Ssl_verify_mode:hA,Ssl_version:yA,storage_engine:vA,stored_program_cache:uA,stored_program_definition_cache:bA,super_read_only:fA,sync_binlog:qA,sync_frm:gA,sync_master_info:SA,sync_relay_log:zA,sync_relay_log_info:VA,"syseventlog.facility":["```mysql\ndeclare @@syseventlog.facility string\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `daemon`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Facility for syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_syseventlog.facility)]."],"syseventlog.include_pid":["```mysql\ndeclare @@syseventlog.include_pid boolean\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to include server PID in syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_syseventlog.include_pid)]."],"syseventlog.tag":["```mysql\ndeclare @@syseventlog.tag string\n```","_**System Variable**_ (⊕ 8.0.13)\n\ndefault: `empty string`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Tag for server identifier in syslog messages [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_syseventlog.tag)]."],system_time_zone:TA,tablespace_definition_cache:EA,table_cache:AA,table_encryption_privilege_check:RA,table_definition_cache:xA,table_lock_wait_timeout:wA,Table_locks_immediate:NA,Table_locks_waited:CA,table_open_cache:kA,Table_open_cache_hits:OA,table_open_cache_instances:IA,Table_open_cache_misses:LA,Table_open_cache_overflows:DA,table_type:MA,Tc_log_max_pages_used:FA,Tc_log_page_size:PA,Tc_log_page_waits:BA,temptable_max_ram:UA,temptable_use_mmap:HA,thread_cache_size:WA,thread_concurrency:QA,thread_handling:jA,thread_pool_algorithm:GA,thread_pool_high_priority_connection:XA,thread_pool_max_active_query_threads:YA,thread_pool_max_unused_threads:KA,thread_pool_prio_kickup_timer:ZA,thread_pool_size:$A,thread_pool_stall_limit:JA,thread_stack:eR,Threads_cached:tR,Threads_connected:nR,Threads_created:sR,Threads_running:oR,time_format:aR,time_zone:iR,timed_mutexes:rR,timestamp:mR,tls_ciphersuites:lR,tls_version:dR,tmp_table_size:cR,tmpdir:_R,transaction_alloc_block_size:pR,transaction_allow_batching:hR,transaction_prealloc_size:yR,transaction_write_set_extraction:vR,tx_isolation:uR,tx_read_only:bR,unique_checks:fR,updatable_views_with_limit:qR,upgrade:gR,Uptime:SR,Uptime_since_flush_status:zR,use_secondary_engine:VR,user:TR,"validate_password.check_user_name":["```mysql\ndeclare @@validate_password.check_user_name boolean\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `ON`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Whether to check passwords against user name [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.check_user_name)]."],"validate_password.dictionary_file":["```mysql\ndeclare @@validate_password.dictionary_file filename\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password dictionary file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.dictionary_file)]."],"validate_password.dictionary_file_last_parsed":["```mysql\ndeclare @@validate_password.dictionary_file_last_parsed datetime\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","When the dictionary file was last parsed [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_validate_password.dictionary_file_last_parsed)]."],"validate_password.dictionary_file_words_count":["```mysql\ndeclare @@validate_password.dictionary_file_words_count integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndynamic: no, scope: , [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","Number of words in dictionary file [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#statvar_validate_password.dictionary_file_words_count)]."],"validate_password.length":["```mysql\ndeclare @@validate_password.length integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `8`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required password length [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.length)]."],"validate_password.mixed_case_count":["```mysql\ndeclare @@validate_password.mixed_case_count integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of uppercase/lowercase characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.mixed_case_count)]."],"validate_password.number_count":["```mysql\ndeclare @@validate_password.number_count integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of digit characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.number_count)]."],"validate_password.policy":["```mysql\ndeclare @@validate_password.policy enumeration\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `1`, valid values:\n\n- `0`\n- `1`\n- `2`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password password policy [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.policy)]."],"validate_password.special_char_count":["```mysql\ndeclare @@validate_password.special_char_count integer\n```","_**System Variable**_ (⊕ 8.0.4)\n\ndefault: `1`, min: `0`\n\ndynamic: yes, scope: global, [SET_VAR hint](https://dev.mysql.com/doc/refman/8.0/en/optimizer-hints.html#optimizer-hints-set-var) not supported","validate_password required number of special characters [[online documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_validate_password.special_char_count)]."],validate_password_check_user_name:ER,validate_password_dictionary_file:AR,validate_password_dictionary_file_last_parsed:RR,validate_password_dictionary_file_words_count:xR,validate_password_length:wR,validate_password_mixed_case_count:NR,validate_password_number_count:CR,validate_password_policy:kR,validate_password_special_char_count:OR,validate_user_plugins:IR,verbose:LR,version:DR,version_comment:MR,version_compile_machine:FR,version_compile_os:PR,version_compile_zlib:BR,version_tokens_session:UR,version_tokens_session_number:HR,wait_timeout:WR,warning_count:QR,warnings:jR,windowing_use_high_precision:GR};export{vn as Aborted_clients,un as Aborted_connects,bn as Acl_cache_items_count,Ln as Audit_log_current_size,Dn as Audit_log_event_max_drop_size,Mn as Audit_log_events,Fn as Audit_log_events_filtered,Pn as Audit_log_events_lost,Bn as Audit_log_events_written,ts as Audit_log_total_size,ns as Audit_log_write_waits,vs as Authentication_ldap_sasl_supported_methods,no as Binlog_cache_disk_use,oo as Binlog_cache_use,fo as Binlog_stmt_cache_disk_use,go as Binlog_stmt_cache_use,wo as Bytes_received,No as Bytes_sent,Io as Caching_sha2_password_rsa_public_key,Ko as Com_admin_commands,Zo as Com_alter_db,$o as Com_alter_db_upgrade,Jo as Com_alter_event,ea as Com_alter_function,ta as Com_alter_procedure,na as Com_alter_resource_group,sa as Com_alter_server,oa as Com_alter_table,aa as Com_alter_tablespace,ia as Com_alter_user,ra as Com_alter_user_default_role,ma as Com_analyze,la as Com_assign_to_keycache,da as Com_backup,ca as Com_backup_table,_a as Com_begin,pa as Com_binlog,ha as Com_call_procedure,ya as Com_change_db,va as Com_change_master,ua as Com_change_repl_filter,ba as Com_check,fa as Com_checksum,qa as Com_clone,ga as Com_commit,Sa as Com_create_db,za as Com_create_event,Va as Com_create_function,Ta as Com_create_index,Ea as Com_create_procedure,Aa as Com_create_resource_group,wa as Com_create_role,Na as Com_create_server,Ca as Com_create_table,ka as Com_create_trigger,Oa as Com_create_udf,Ia as Com_create_user,La as Com_create_view,Da as Com_dealloc_sql,Ma as Com_delete,Fa as Com_delete_multi,Pa as Com_do,Ba as Com_drop_db,Ua as Com_drop_event,Ha as Com_drop_function,Wa as Com_drop_index,Qa as Com_drop_procedure,Ra as Com_drop_resource_group,ja as Com_drop_role,Ga as Com_drop_server,Xa as Com_drop_table,Ya as Com_drop_trigger,Ka as Com_drop_user,Za as Com_drop_view,$a as Com_empty_query,Ja as Com_execute_sql,ei as Com_explain_other,ti as Com_flush,ni as Com_get_diagnostics,si as Com_grant,oi as Com_grant_roles,ai as Com_group_replication_start,ii as Com_group_replication_stop,ri as Com_ha_close,mi as Com_ha_open,li as Com_ha_read,di as Com_help,ci as Com_insert,_i as Com_insert_select,pi as Com_install_component,hi as Com_install_plugin,yi as Com_kill,vi as Com_load,ui as Com_load_master_data,bi as Com_load_master_table,fi as Com_lock_tables,qi as Com_optimize,gi as Com_preload_keys,Si as Com_prepare_sql,zi as Com_purge,Vi as Com_purge_before_date,Ti as Com_purge_bup_log,Ei as Com_release_savepoint,Ai as Com_rename_table,Ri as Com_rename_user,xi as Com_repair,wi as Com_replace,Ni as Com_replace_select,Ci as Com_reset,ki as Com_resignal,Oi as Com_restart,Ii as Com_restore,Li as Com_restore_table,Di as Com_revoke,Mi as Com_revoke_all,Fi as Com_revoke_roles,Pi as Com_rollback,Bi as Com_rollback_to_savepoint,Ui as Com_savepoint,Hi as Com_select,Wi as Com_set_option,xa as Com_set_resource_group,Qi as Com_set_role,ji as Com_show_authors,Gi as Com_show_binlog_events,Xi as Com_show_binlogs,Yi as Com_show_charsets,Ki as Com_show_collations,Zi as Com_show_column_types,$i as Com_show_contributors,Ji as Com_show_create_db,er as Com_show_create_event,tr as Com_show_create_func,nr as Com_show_create_proc,sr as Com_show_create_table,or as Com_show_create_trigger,ar as Com_show_create_user,ir as Com_show_databases,rr as Com_show_engine_logs,mr as Com_show_engine_mutex,lr as Com_show_engine_status,dr as Com_show_errors,cr as Com_show_events,_r as Com_show_fields,pr as Com_show_function_code,hr as Com_show_function_status,yr as Com_show_grants,vr as Com_show_innodb_status,ur as Com_show_keys,br as Com_show_logs,fr as Com_show_master_status,qr as Com_show_ndb_status,gr as Com_show_new_master,Sr as Com_show_open_tables,zr as Com_show_plugins,Vr as Com_show_privileges,Tr as Com_show_procedure_code,Er as Com_show_procedure_status,Ar as Com_show_processlist,Rr as Com_show_profile,xr as Com_show_profiles,wr as Com_show_relaylog_events,Nr as Com_show_slave_hosts,Cr as Com_show_slave_status,kr as Com_show_slave_status_nonblocking,Or as Com_show_status,Ir as Com_show_storage_engines,Lr as Com_show_table_status,Dr as Com_show_tables,Mr as Com_show_triggers,Fr as Com_show_variables,Pr as Com_show_warnings,Br as Com_shutdown,Ur as Com_signal,Hr as Com_slave_start,Wr as Com_slave_stop,Qr as Com_stmt_close,jr as Com_stmt_execute,Gr as Com_stmt_fetch,Xr as Com_stmt_prepare,Yr as Com_stmt_reprepare,Kr as Com_stmt_reset,Zr as Com_stmt_send_long_data,$r as Com_truncate,Jr as Com_uninstall_component,em as Com_uninstall_plugin,tm as Com_unlock_tables,nm as Com_update,sm as Com_update_multi,om as Com_xa_commit,am as Com_xa_end,im as Com_xa_prepare,rm as Com_xa_recover,mm as Com_xa_rollback,lm as Com_xa_start,cm as Compression,_m as Compression_algorithm,pm as Compression_level,ym as Connection_control_delay_generated,qm as Connection_errors_accept,gm as Connection_errors_internal,Sm as Connection_errors_max_connections,zm as Connection_errors_peer_address,Vm as Connection_errors_select,Tm as Connection_errors_tcpwrap,Em as Connections,xm as Created_tmp_disk_tables,wm as Created_tmp_files,Nm as Created_tmp_tables,Im as Current_tls_ca,Lm as Current_tls_capath,Dm as Current_tls_cert,Mm as Current_tls_cipher,Fm as Current_tls_ciphersuites,Pm as Current_tls_crl,Bm as Current_tls_crlpath,Um as Current_tls_key,Hm as Current_tls_version,dl as Delayed_errors,_l as Delayed_insert_threads,yl as Delayed_writes,Nl as Firewall_access_denied,Cl as Firewall_access_granted,kl as Firewall_cached_entries,Il as Flush_commands,nd as Handler_commit,sd as Handler_delete,od as Handler_discover,ad as Handler_external_lock,id as Handler_mrr_init,rd as Handler_prepare,md as Handler_read_first,ld as Handler_read_key,dd as Handler_read_last,cd as Handler_read_next,_d as Handler_read_prev,pd as Handler_read_rnd,hd as Handler_read_rnd_next,yd as Handler_rollback,vd as Handler_savepoint,ud as Handler_savepoint_rollback,bd as Handler_update,fd as Handler_write,vc as Innodb_available_undo_logs,bc as Innodb_buffer_pool_bytes_data,fc as Innodb_buffer_pool_bytes_dirty,Tc as Innodb_buffer_pool_dump_status,Cc as Innodb_buffer_pool_load_status,kc as Innodb_buffer_pool_pages_data,Oc as Innodb_buffer_pool_pages_dirty,Ic as Innodb_buffer_pool_pages_flushed,Lc as Innodb_buffer_pool_pages_free,Dc as Innodb_buffer_pool_pages_latched,Mc as Innodb_buffer_pool_pages_misc,Fc as Innodb_buffer_pool_pages_total,Pc as Innodb_buffer_pool_read_ahead,Bc as Innodb_buffer_pool_read_ahead_evicted,Uc as Innodb_buffer_pool_read_ahead_rnd,Hc as Innodb_buffer_pool_read_ahead_seq,Wc as Innodb_buffer_pool_read_requests,Qc as Innodb_buffer_pool_reads,jc as Innodb_buffer_pool_resize_status,Xc as Innodb_buffer_pool_wait_free,Yc as Innodb_buffer_pool_write_requests,d_ as Innodb_data_fsyncs,__ as Innodb_data_pending_fsyncs,p_ as Innodb_data_pending_reads,h_ as Innodb_data_pending_writes,y_ as Innodb_data_read,v_ as Innodb_data_reads,u_ as Innodb_data_writes,b_ as Innodb_data_written,z_ as Innodb_dblwr_pages_written,V_ as Innodb_dblwr_writes,lp as Innodb_have_atomic_builtins,dp as Innodb_have_sync_atomic,cp as Innodb_heap_enabled,Cp as Innodb_log_waits,Ip as Innodb_log_write_requests,Lp as Innodb_log_writes,$p as Innodb_num_open_files,ih as Innodb_os_log_fsyncs,rh as Innodb_os_log_pending_fsyncs,mh as Innodb_os_log_pending_writes,lh as Innodb_os_log_written,_h as Innodb_page_size,ph as Innodb_pages_created,hh as Innodb_pages_read,yh as Innodb_pages_written,Nh as Innodb_row_lock_current_waits,Ch as Innodb_row_lock_time,kh as Innodb_row_lock_time_avg,Oh as Innodb_row_lock_time_max,Ih as Innodb_row_lock_waits,Lh as Innodb_rows_deleted,Dh as Innodb_rows_inserted,Mh as Innodb_rows_read,Fh as Innodb_rows_updated,iy as Innodb_system_rows_deleted,ry as Innodb_system_rows_inserted,my as Innodb_system_rows_read,uy as Innodb_truncated_status_writes,Ty as Innodb_undo_tablespaces_active,Ey as Innodb_undo_tablespaces_explicit,Ay as Innodb_undo_tablespaces_implicit,Ry as Innodb_undo_tablespaces_total,ky as Innodb_wake_ups,By as Key_blocks_not_flushed,Uy as Key_blocks_unused,Hy as Key_blocks_used,Xy as Key_read_requests,Yy as Key_reads,Ky as Key_write_requests,Zy as Key_writes,Vv as Last_query_cost,Tv as Last_query_partial_plans,Hv as Locked_connects,Ou as Max_execution_time_exceeded,Iu as Max_execution_time_set,Lu as Max_execution_time_set_failed,Ku as Max_statement_time_exceeded,Zu as Max_statement_time_set,$u as Max_statement_time_set_failed,Ju as Max_used_connections,eb as Max_used_connections_time,Qe as Mysqlx_aborted_clients,je as Mysqlx_address,Xe as Mysqlx_bytes_received,Ze as Mysqlx_bytes_received_compressed_payload,$e as Mysqlx_bytes_received_uncompressed_frame,Ge as Mysqlx_bytes_sent,Ye as Mysqlx_bytes_sent_compressed_payload,Ke as Mysqlx_bytes_sent_uncompressed_frame,Je as Mysqlx_compression_algorithm,et as Mysqlx_compression_level,Jt as Mysqlx_connection_accept_errors,en as Mysqlx_connection_errors,Zt as Mysqlx_connections_accepted,Kt as Mysqlx_connections_closed,$t as Mysqlx_connections_rejected,gt as Mysqlx_crud_create_view,Vt as Mysqlx_crud_delete,St as Mysqlx_crud_drop_view,Tt as Mysqlx_crud_find,ft as Mysqlx_crud_insert,zt as Mysqlx_crud_modify_view,qt as Mysqlx_crud_update,tn as Mysqlx_cursor_close,nn as Mysqlx_cursor_fetch,sn as Mysqlx_cursor_open,yn as Mysqlx_errors_sent,Et as Mysqlx_errors_unknown_message_type,Rt as Mysqlx_expect_close,At as Mysqlx_expect_open,jt as Mysqlx_init_error,Nt as Mysqlx_notice_global_sent,Ct as Mysqlx_notice_other_sent,wt as Mysqlx_notice_warning_sent,kt as Mysqlx_notified_by_group_replication,Dt as Mysqlx_port,Ot as Mysqlx_prep_deallocate,It as Mysqlx_prep_execute,Lt as Mysqlx_prep_prepare,xt as Mysqlx_rows_sent,Ht as Mysqlx_sessions,Gt as Mysqlx_sessions_accepted,Wt as Mysqlx_sessions_closed,Qt as Mysqlx_sessions_fatal_error,Yt as Mysqlx_sessions_killed,Xt as Mysqlx_sessions_rejected,tt as Mysqlx_socket,hn as Mysqlx_ssl_accept_renegotiates,cn as Mysqlx_ssl_accepts,rn as Mysqlx_ssl_active,Mt as Mysqlx_ssl_cipher,Ft as Mysqlx_ssl_cipher_list,mn as Mysqlx_ssl_ctx_verify_depth,ln as Mysqlx_ssl_ctx_verify_mode,dn as Mysqlx_ssl_finished_accepts,_n as Mysqlx_ssl_server_not_after,pn as Mysqlx_ssl_server_not_before,Pt as Mysqlx_ssl_verify_depth,Bt as Mysqlx_ssl_verify_mode,Ut as Mysqlx_ssl_version,ot as Mysqlx_stmt_create_collection,at as Mysqlx_stmt_create_collection_index,ht as Mysqlx_stmt_disable_notices,it as Mysqlx_stmt_drop_collection,rt as Mysqlx_stmt_drop_collection_index,pt as Mysqlx_stmt_enable_notices,mt as Mysqlx_stmt_ensure_collection,lt as Mysqlx_stmt_execute_mysqlx,nt as Mysqlx_stmt_execute_sql,st as Mysqlx_stmt_execute_xplugin,dt as Mysqlx_stmt_get_collection_options,ut as Mysqlx_stmt_kill_client,vt as Mysqlx_stmt_list_clients,yt as Mysqlx_stmt_list_notices,_t as Mysqlx_stmt_list_objects,ct as Mysqlx_stmt_modify_collection_options,bt as Mysqlx_stmt_ping,on as Mysqlx_worker_threads,an as Mysqlx_worker_threads_active,Vb as Ndb_api_bytes_received_count,Tb as Ndb_api_bytes_received_count_session,Eb as Ndb_api_bytes_received_count_slave,Ab as Ndb_api_bytes_sent_count,Rb as Ndb_api_bytes_sent_count_session,xb as Ndb_api_bytes_sent_count_slave,wb as Ndb_api_event_bytes_count,Nb as Ndb_api_event_bytes_count_injector,Cb as Ndb_api_event_data_count,kb as Ndb_api_event_data_count_injector,Ob as Ndb_api_event_nondata_count,Ib as Ndb_api_event_nondata_count_injector,Lb as Ndb_api_pk_op_count,Db as Ndb_api_pk_op_count_session,Mb as Ndb_api_pk_op_count_slave,Fb as Ndb_api_pruned_scan_count,Pb as Ndb_api_pruned_scan_count_session,Bb as Ndb_api_pruned_scan_count_slave,Ub as Ndb_api_range_scan_count,Hb as Ndb_api_range_scan_count_session,Wb as Ndb_api_range_scan_count_slave,Qb as Ndb_api_read_row_count,jb as Ndb_api_read_row_count_session,Gb as Ndb_api_read_row_count_slave,Xb as Ndb_api_scan_batch_count,Yb as Ndb_api_scan_batch_count_session,Kb as Ndb_api_scan_batch_count_slave,Zb as Ndb_api_table_scan_count,$b as Ndb_api_table_scan_count_session,Jb as Ndb_api_table_scan_count_slave,ef as Ndb_api_trans_abort_count,tf as Ndb_api_trans_abort_count_session,nf as Ndb_api_trans_abort_count_slave,sf as Ndb_api_trans_close_count,of as Ndb_api_trans_close_count_session,af as Ndb_api_trans_close_count_slave,rf as Ndb_api_trans_commit_count,mf as Ndb_api_trans_commit_count_session,lf as Ndb_api_trans_commit_count_slave,df as Ndb_api_trans_local_read_row_count,cf as Ndb_api_trans_local_read_row_count_session,_f as Ndb_api_trans_local_read_row_count_slave,pf as Ndb_api_trans_start_count,hf as Ndb_api_trans_start_count_session,yf as Ndb_api_trans_start_count_slave,vf as Ndb_api_uk_op_count,uf as Ndb_api_uk_op_count_session,bf as Ndb_api_uk_op_count_slave,ff as Ndb_api_wait_exec_complete_count,qf as Ndb_api_wait_exec_complete_count_session,gf as Ndb_api_wait_exec_complete_count_slave,Sf as Ndb_api_wait_meta_request_count,zf as Ndb_api_wait_meta_request_count_session,Vf as Ndb_api_wait_meta_request_count_slave,Tf as Ndb_api_wait_nanos_count,Ef as Ndb_api_wait_nanos_count_session,Af as Ndb_api_wait_nanos_count_slave,Rf as Ndb_api_wait_scan_result_count,xf as Ndb_api_wait_scan_result_count_session,wf as Ndb_api_wait_scan_result_count_slave,Of as Ndb_cluster_node_id,If as Ndb_config_from_host,Lf as Ndb_config_from_port,Df as Ndb_conflict_fn_epoch,Mf as Ndb_conflict_fn_epoch2,Ff as Ndb_conflict_fn_epoch2_trans,Pf as Ndb_conflict_fn_epoch_trans,Bf as Ndb_conflict_fn_max,Uf as Ndb_conflict_fn_max_del_win,Hf as Ndb_conflict_fn_old,Wf as Ndb_conflict_last_conflict_epoch,Qf as Ndb_conflict_last_stable_epoch,jf as Ndb_conflict_reflected_op_discard_count,Gf as Ndb_conflict_reflected_op_prepare_count,Xf as Ndb_conflict_refresh_op_count,Yf as Ndb_conflict_trans_conflict_commit_count,Kf as Ndb_conflict_trans_detect_iter_count,Zf as Ndb_conflict_trans_reject_count,$f as Ndb_conflict_trans_row_conflict_count,Jf as Ndb_conflict_trans_row_reject_count,aq as Ndb_epoch_delete_delete_count,mq as Ndb_execute_count,uq as Ndb_last_commit_epoch_server,bq as Ndb_last_commit_epoch_session,Rq as Ndb_metadata_blacklist_size,wq as Ndb_metadata_detected_count,Cq as Ndb_metadata_synced_count,kq as Ndb_number_of_data_nodes,Iq as Ndb_pruned_scan_count,Lq as Ndb_pushed_queries_defined,Dq as Ndb_pushed_queries_dropped,Mq as Ndb_pushed_queries_executed,Fq as Ndb_pushed_reads,jq as Ndb_scan_count,$q as Ndb_slave_max_replicated_epoch,Jq as Ndb_system_name,ng as Ndb_trans_hint_count_session,gg as Not_flushed_delayed_rows,Eg as Ongoing_anonymous_gtid_violating_transaction_count,Ag as Ongoing_anonymous_transaction_count,Rg as Ongoing_automatic_gtid_violating_transaction_count,wg as Open_files,Ng as Open_streams,Cg as Open_table_definitions,kg as Open_tables,Og as Opened_files,Ig as Opened_table_definitions,Lg as Opened_tables,nS as Performance_schema_accounts_lost,oS as Performance_schema_cond_classes_lost,aS as Performance_schema_cond_instances_lost,iS as Performance_schema_digest_lost,uS as Performance_schema_file_classes_lost,bS as Performance_schema_file_handles_lost,fS as Performance_schema_file_instances_lost,qS as Performance_schema_hosts_lost,SS as Performance_schema_index_stat_lost,zS as Performance_schema_locker_lost,ZS as Performance_schema_memory_classes_lost,$S as Performance_schema_metadata_lock_lost,JS as Performance_schema_mutex_classes_lost,ez as Performance_schema_mutex_instances_lost,tz as Performance_schema_nested_statement_lost,nz as Performance_schema_prepared_statements_lost,sz as Performance_schema_program_lost,oz as Performance_schema_rwlock_classes_lost,az as Performance_schema_rwlock_instances_lost,iz as Performance_schema_session_connect_attrs_longest_seen,rz as Performance_schema_session_connect_attrs_lost,cz as Performance_schema_socket_classes_lost,_z as Performance_schema_socket_instances_lost,pz as Performance_schema_stage_classes_lost,hz as Performance_schema_statement_classes_lost,yz as Performance_schema_table_handles_lost,vz as Performance_schema_table_instances_lost,uz as Performance_schema_table_lock_stat_lost,bz as Performance_schema_thread_classes_lost,fz as Performance_schema_thread_instances_lost,qz as Performance_schema_users_lost,xz as Prepared_stmt_count,Mz as Qcache_free_blocks,Fz as Qcache_free_memory,Pz as Qcache_hits,Bz as Qcache_inserts,Uz as Qcache_lowmem_prunes,Hz as Qcache_not_cached,Wz as Qcache_queries_in_cache,Qz as Qcache_total_blocks,jz as Queries,eV as Questions,NV as Rewriter_number_loaded_rules,CV as Rewriter_number_reloads,kV as Rewriter_number_rewritten_queries,OV as Rewriter_reload_error,LV as Rpl_semi_sync_master_clients,MV as Rpl_semi_sync_master_net_avg_wait_time,FV as Rpl_semi_sync_master_net_wait_time,PV as Rpl_semi_sync_master_net_waits,BV as Rpl_semi_sync_master_no_times,UV as Rpl_semi_sync_master_no_tx,WV as Rpl_semi_sync_master_status,QV as Rpl_semi_sync_master_timefunc_failures,XV as Rpl_semi_sync_master_tx_avg_wait_time,YV as Rpl_semi_sync_master_tx_wait_time,KV as Rpl_semi_sync_master_tx_waits,eT as Rpl_semi_sync_master_wait_pos_backtraverse,tT as Rpl_semi_sync_master_wait_sessions,nT as Rpl_semi_sync_master_yes_tx,oT as Rpl_semi_sync_slave_status,iT as Rpl_status,lT as Rsa_public_key,_T as Secondary_engine_execution_count,yT as Select_full_join,vT as Select_full_range_join,uT as Select_range,bT as Select_range_check,fT as Select_scan,QT as Slave_heartbeat_period,jT as Slave_last_heartbeat,XT as Slave_open_temp_tables,JT as Slave_received_heartbeats,eE as Slave_retried_transactions,nE as Slave_rows_last_search_algorithm_used,sE as Slave_running,mE as Slow_launch_threads,dE as Slow_queries,hE as Sort_merge_passes,yE as Sort_range,vE as Sort_rows,uE as Sort_scan,QE as Ssl_accept_renegotiates,jE as Ssl_accepts,GE as Ssl_callback_cache_hits,XE as Ssl_cipher,YE as Ssl_cipher_list,KE as Ssl_client_connects,ZE as Ssl_connect_renegotiates,$E as Ssl_ctx_verify_depth,JE as Ssl_ctx_verify_mode,eA as Ssl_default_timeout,tA as Ssl_finished_accepts,nA as Ssl_finished_connects,sA as Ssl_server_not_after,oA as Ssl_server_not_before,aA as Ssl_session_cache_hits,iA as Ssl_session_cache_misses,rA as Ssl_session_cache_mode,mA as Ssl_session_cache_overflows,lA as Ssl_session_cache_size,dA as Ssl_session_cache_timeouts,cA as Ssl_sessions_reused,_A as Ssl_used_session_cache_entries,pA as Ssl_verify_depth,hA as Ssl_verify_mode,yA as Ssl_version,NA as Table_locks_immediate,CA as Table_locks_waited,OA as Table_open_cache_hits,LA as Table_open_cache_misses,DA as Table_open_cache_overflows,FA as Tc_log_max_pages_used,PA as Tc_log_page_size,BA as Tc_log_page_waits,tR as Threads_cached,nR as Threads_connected,sR as Threads_created,oR as Threads_running,SR as Uptime,zR as Uptime_since_flush_status,fn as activate_all_roles_on_login,qn as admin_address,gn as admin_port,Sn as admin_ssl_ca,zn as admin_ssl_capath,Vn as admin_ssl_cert,Tn as admin_ssl_cipher,En as admin_ssl_crl,An as admin_ssl_crlpath,Rn as admin_ssl_key,xn as admin_tls_ciphersuites,wn as admin_tls_version,Nn as ansi,Cn as audit_log_buffer_size,kn as audit_log_compression,On as audit_log_connection_policy,In as audit_log_current_session,Un as audit_log_encryption,Hn as audit_log_exclude_accounts,Wn as audit_log_file,Qn as audit_log_filter_id,jn as audit_log_flush,Gn as audit_log_format,Xn as audit_log_include_accounts,Yn as audit_log_password_history_keep_days,Kn as audit_log_policy,Zn as audit_log_read_buffer_size,$n as audit_log_rotate_on_size,Jn as audit_log_statement_policy,es as audit_log_strategy,ss as authentication_ldap_sasl_auth_method_name,os as authentication_ldap_sasl_bind_base_dn,as as authentication_ldap_sasl_bind_root_dn,is as authentication_ldap_sasl_bind_root_pwd,rs as authentication_ldap_sasl_ca_path,ms as authentication_ldap_sasl_group_search_attr,ls as authentication_ldap_sasl_group_search_filter,ds as authentication_ldap_sasl_init_pool_size,cs as authentication_ldap_sasl_log_status,_s as authentication_ldap_sasl_max_pool_size,ps as authentication_ldap_sasl_referral,hs as authentication_ldap_sasl_server_host,ys as authentication_ldap_sasl_server_port,us as authentication_ldap_sasl_tls,bs as authentication_ldap_sasl_user_search_attr,fs as authentication_ldap_simple_auth_method_name,qs as authentication_ldap_simple_bind_base_dn,gs as authentication_ldap_simple_bind_root_dn,Ss as authentication_ldap_simple_bind_root_pwd,zs as authentication_ldap_simple_ca_path,Vs as authentication_ldap_simple_group_search_attr,Ts as authentication_ldap_simple_group_search_filter,Es as authentication_ldap_simple_init_pool_size,As as authentication_ldap_simple_log_status,Rs as authentication_ldap_simple_max_pool_size,xs as authentication_ldap_simple_referral,ws as authentication_ldap_simple_server_host,Ns as authentication_ldap_simple_server_port,Cs as authentication_ldap_simple_tls,ks as authentication_ldap_simple_user_search_attr,Os as authentication_windows_log_level,Is as authentication_windows_use_principal_name,Ls as auto_generate_certs,Ds as auto_increment_increment,Ms as auto_increment_offset,Fs as autocommit,Ps as automatic_sp_privileges,Bs as avoid_temporal_upgrade,Us as back_log,Hs as backup_elevation,Ws as backup_history_log,Qs as backup_history_log_file,js as backup_progress_log,Gs as backup_progress_log_file,Xs as backup_wait_timeout,Ys as backupdir,Ks as basedir,Zs as big_tables,$s as bind_address,so as binlog_cache_size,ao as binlog_checksum,io as binlog_direct_non_transactional_updates,eo as binlog_encryption,ro as binlog_error_action,mo as binlog_expire_logs_seconds,Js as binlog_format,lo as binlog_group_commit_sync_delay,co as binlog_group_commit_sync_no_delay_count,_o as binlog_gtid_simple_recovery,po as binlog_max_flush_queue_time,ho as binlog_order_commits,to as binlog_rotate_encryption_master_key_at_startup,yo as binlog_row_image,vo as binlog_row_metadata,uo as binlog_row_value_options,bo as binlog_rows_query_log_events,qo as binlog_stmt_cache_size,So as binlog_transaction_compression,zo as binlog_transaction_compression_level_zstd,To as binlog_transaction_dependency_history_size,Vo as binlog_transaction_dependency_tracking,Eo as binlogging_impossible_mode,Ao as block_encryption_mode,Ro as bootstrap,xo as bulk_insert_buffer_size,Co as caching_sha2_password_auto_generate_rsa_keys,ko as caching_sha2_password_private_key_path,Oo as caching_sha2_password_public_key_path,Fo as character_set,Po as character_set_client,Bo as character_set_connection,Uo as character_set_database,Lo as character_set_filesystem,Ho as character_set_results,Do as character_set_server,Wo as character_set_system,Mo as character_sets_dir,Qo as check_proxy_users,jo as chroot,e as clone_autotune_concurrency,t as clone_buffer_size,n as clone_ddl_timeout,s as clone_enable_compression,o as clone_max_concurrency,a as clone_max_data_bandwidth,i as clone_max_network_bandwidth,r as clone_ssl_ca,m as clone_ssl_cert,l as clone_ssl_key,d as clone_valid_donor_list,Xo as collation_connection,Yo as collation_database,Go as collation_server,dm as completion_type,hm as concurrent_insert,fm as connect_timeout,vm as connection_control_failed_connections_threshold,um as connection_control_max_connection_delay,bm as connection_control_min_connection_delay,Rm as core_file,Cm as create_admin_listener_thread,km as create_old_temporals,Om as cte_max_recursion_depth,Wm as daemon_memcached_enable_binlog,Qm as daemon_memcached_engine_lib_name,jm as daemon_memcached_engine_lib_path,Gm as daemon_memcached_option,Xm as daemon_memcached_r_batch_size,Ym as daemon_memcached_w_batch_size,Km as daemonize,Zm as datadir,$m as date_format,Jm as datetime_format,el as debug,tl as debug_sync,XR as default,al as default_authentication_plugin,nl as default_collation_for_utf8mb4,il as default_password_lifetime,sl as default_storage_engine,ol as default_table_encryption,rl as default_tmp_storage_engine,ml as default_week_format,ll as delay_key_write,cl as delayed_insert_limit,pl as delayed_insert_timeout,hl as delayed_queue_size,vl as disable_gtid_unsafe_statements,ul as disabled_storage_engines,ib as disabledby,bl as disconnect_on_expired_password,fl as div_precision_increment,ql as end_markers_in_json,gl as enforce_gtid_consistency,Sl as engine_condition_pushdown,zl as eq_range_index_dive_limit,Vl as error_count,Tl as event_scheduler,El as executed_gtids_compression_period,Al as expire_logs_days,Rl as explicit_defaults_for_timestamp,xl as external_user,wl as federated,Ol as flush,Ll as flush_time,Dl as foreign_key_checks,Ml as ft_boolean_syntax,Fl as ft_max_word_len,Pl as ft_min_word_len,Bl as ft_query_expansion_limit,Ul as ft_stopword_file,Hl as gdb,Wl as general_log,Ql as general_log_file,jl as generated_random_password_length,Gl as group_concat_max_len,H as group_replication_allow_local_disjoint_gtids_join,U as group_replication_allow_local_lower_version_join,W as group_replication_auto_increment_increment,_e as group_replication_autorejoin_tries,b as group_replication_bootstrap_group,f as group_replication_clone_threshold,F as group_replication_communication_debug_options,de as group_replication_communication_max_message_size,P as group_replication_components_stop_timeout,Q as group_replication_compression_threshold,B as group_replication_consistency,Z as group_replication_enforce_update_everywhere_checks,$ as group_replication_exit_state_action,te as group_replication_flow_control_applier_threshold,ee as group_replication_flow_control_certifier_threshold,ne as group_replication_flow_control_hold_percent,se as group_replication_flow_control_max_commit_quota,oe as group_replication_flow_control_member_quota_percent,ae as group_replication_flow_control_min_quota,ie as group_replication_flow_control_min_recovery_quota,J as group_replication_flow_control_mode,re as group_replication_flow_control_period,me as group_replication_flow_control_release_percent,u as group_replication_force_members,c as group_replication_group_name,v as group_replication_group_seeds,j as group_replication_gtid_assignment_block_size,le as group_replication_ip_whitelist,p as group_replication_local_address,y as group_replication_member_expel_timeout,h as group_replication_member_weight,ce as group_replication_message_cache_size,q as group_replication_poll_spin_loops,he as group_replication_primary_member,D as group_replication_recovery_complete_at,g as group_replication_recovery_compression_algorithm,S as group_replication_recovery_get_public_key,z as group_replication_recovery_public_key_path,T as group_replication_recovery_reconnect_interval,V as group_replication_recovery_retry_count,A as group_replication_recovery_ssl_ca,R as group_replication_recovery_ssl_capath,x as group_replication_recovery_ssl_cert,N as group_replication_recovery_ssl_cipher,C as group_replication_recovery_ssl_crl,k as group_replication_recovery_ssl_crlpath,w as group_replication_recovery_ssl_key,O as group_replication_recovery_ssl_verify_server_cert,L as group_replication_recovery_tls_ciphersuites,I as group_replication_recovery_tls_version,E as group_replication_recovery_use_ssl,M as group_replication_recovery_zstd_compression_level,X as group_replication_single_primary_mode,G as group_replication_ssl_mode,_ as group_replication_start_on_boot,pe as group_replication_tls_source,Y as group_replication_transaction_size_limit,K as group_replication_unreachable_majority_timeout,Xl as gtid_done,Yl as gtid_executed,Kl as gtid_executed_compression_period,Zl as gtid_lost,$l as gtid_mode,Jl as gtid_next,ed as gtid_owned,td as gtid_purged,qd as have_archive,gd as have_blackhole_engine,Sd as have_community_features,zd as have_compress,Vd as have_crypt,Td as have_csv,Ed as have_dynamic_loading,Ad as have_example_engine,Rd as have_federated_engine,xd as have_geometry,wd as have_innodb,Nd as have_isam,Cd as have_merge_engine,kd as have_ndbcluster,Od as have_openssl,Id as have_partition_engine,Ld as have_partitioning,Dd as have_profiling,Md as have_query_cache,Fd as have_raid,Pd as have_row_based_replication,Bd as have_rtree_keys,Ud as have_ssl,Hd as have_statement_timeout,Wd as have_symlink,Qd as help,jd as histogram_generation_max_mem_size,Gd as host_cache_size,Xd as hostname,Yd as identity,Kd as ignore_builtin_innodb,Zd as ignore_db_dirs,Xg as immediate_server_version,$d as information_schema_stats_expiry,ec as init_connect,Jd as init_file,tc as init_slave,nc as initialize,sc as innodb,oc as innodb_adaptive_flushing,ac as innodb_adaptive_flushing_lwm,ic as innodb_adaptive_hash_index,rc as innodb_adaptive_hash_index_parts,mc as innodb_adaptive_max_sleep_delay,Qp as innodb_additional_mem_pool_size,lc as innodb_api_bk_commit_interval,dc as innodb_api_disable_rowlock,cc as innodb_api_enable_binlog,_c as innodb_api_enable_mdl,pc as innodb_api_trx_level,hc as innodb_autoextend_increment,yc as innodb_autoinc_lock_mode,uc as innodb_background_drop_list_empty,qc as innodb_buffer_pool_chunk_size,gc as innodb_buffer_pool_debug,Sc as innodb_buffer_pool_dump_at_shutdown,zc as innodb_buffer_pool_dump_now,Vc as innodb_buffer_pool_dump_pct,Ec as innodb_buffer_pool_filename,Ac as innodb_buffer_pool_in_core_file,Rc as innodb_buffer_pool_instances,xc as innodb_buffer_pool_load_abort,wc as innodb_buffer_pool_load_at_startup,Nc as innodb_buffer_pool_load_now,Gc as innodb_buffer_pool_size,Kc as innodb_change_buffer_max_size,Zc as innodb_change_buffering,$c as innodb_change_buffering_debug,Jc as innodb_checkpoint_disabled,e_ as innodb_checksum_algorithm,t_ as innodb_checksums,n_ as innodb_cmp_per_index_enabled,s_ as innodb_commit_concurrency,o_ as innodb_compress_debug,a_ as innodb_compression_failure_threshold_pct,i_ as innodb_compression_level,r_ as innodb_compression_pad_pct_max,m_ as innodb_concurrency_tickets,l_ as innodb_data_file_path,c_ as innodb_data_home_dir,f_ as innodb_ddl_log_crash_reset_debug,q_ as innodb_deadlock_detect,g_ as innodb_dedicated_server,S_ as innodb_default_row_format,T_ as innodb_directories,A_ as innodb_disable_resize_buffer_pool_debug,E_ as innodb_disable_sort_file_cache,R_ as innodb_doublewrite,x_ as innodb_doublewrite_batch_size,w_ as innodb_doublewrite_dir,N_ as innodb_doublewrite_files,C_ as innodb_doublewrite_pages,k_ as innodb_extra_dirty_writes,O_ as innodb_fast_shutdown,I_ as innodb_fil_make_page_dirty_debug,L_ as innodb_file_format,D_ as innodb_file_format_check,M_ as innodb_file_format_max,F_ as innodb_file_io_threads,P_ as innodb_file_per_table,B_ as innodb_fill_factor,U_ as innodb_flush_log_at_timeout,H_ as innodb_flush_log_at_trx_commit,W_ as innodb_flush_method,Q_ as innodb_flush_neighbors,j_ as innodb_flush_sync,G_ as innodb_flushing_avg_loops,X_ as innodb_force_load_corrupted,Y_ as innodb_force_recovery,K_ as innodb_fsync_threshold,Z_ as innodb_ft_aux_table,$_ as innodb_ft_cache_size,J_ as innodb_ft_enable_diag_print,ep as innodb_ft_enable_stopword,tp as innodb_ft_max_token_size,np as innodb_ft_min_token_size,sp as innodb_ft_num_word_optimize,op as innodb_ft_result_cache_limit,ap as innodb_ft_server_stopword_table,ip as innodb_ft_sort_pll_degree,rp as innodb_ft_total_cache_size,mp as innodb_ft_user_stopword_table,_p as innodb_idle_flush_pct,pp as innodb_io_capacity,hp as innodb_io_capacity_max,yp as innodb_large_prefix,vp as innodb_limit_optimistic_insert_debug,up as innodb_lock_wait_timeout,bp as innodb_locks_unsafe_for_binlog,fp as innodb_log_arch_dir,qp as innodb_log_archive,gp as innodb_log_buffer_size,Sp as innodb_log_checkpoint_fuzzy_now,zp as innodb_log_checkpoint_now,Vp as innodb_log_checksum_algorithm,Tp as innodb_log_checksums,Ep as innodb_log_compressed_pages,Ap as innodb_log_file_size,Rp as innodb_log_files_in_group,xp as innodb_log_group_home_dir,wp as innodb_log_spin_cpu_abs_lwm,Np as innodb_log_spin_cpu_pct_hwm,kp as innodb_log_wait_for_flush_spin_hwm,Op as innodb_log_write_ahead_size,Dp as innodb_log_writer_threads,Mp as innodb_lru_scan_depth,Fp as innodb_max_dirty_pages_pct,Pp as innodb_max_dirty_pages_pct_lwm,Bp as innodb_max_merged_io,Up as innodb_max_purge_lag,Hp as innodb_max_purge_lag_delay,Wp as innodb_max_undo_log_size,jp as innodb_merge_threshold_set_all_debug,Gp as innodb_mirrored_log_groups,Xp as innodb_monitor_disable,Yp as innodb_monitor_enable,Kp as innodb_monitor_reset,Zp as innodb_monitor_reset_all,Jp as innodb_numa_interleave,eh as innodb_old_blocks_pct,th as innodb_old_blocks_time,nh as innodb_online_alter_log_max_size,sh as innodb_open_files,oh as innodb_optimize_fulltext_only,ah as innodb_optimize_point_storage,dh as innodb_page_cleaners,ch as innodb_page_size,vh as innodb_parallel_read_threads,uh as innodb_print_all_deadlocks,bh as innodb_print_ddl_logs,fh as innodb_purge_batch_size,qh as innodb_purge_rseg_truncate_frequency,gh as innodb_purge_threads,Sh as innodb_random_read_ahead,zh as innodb_read_ahead_threshold,Vh as innodb_read_io_threads,Th as innodb_read_only,Eh as innodb_redo_log_archive_dirs,Ah as innodb_redo_log_encrypt,Rh as innodb_replication_delay,xh as innodb_rollback_on_timeout,wh as innodb_rollback_segments,Ph as innodb_saved_page_number_debug,Bh as innodb_scan_directories,Uh as innodb_sort_buffer_size,Hh as innodb_spin_wait_delay,Wh as innodb_spin_wait_pause_multiplier,Qh as innodb_stats_auto_recalc,jh as innodb_stats_include_delete_marked,Gh as innodb_stats_method,Xh as innodb_stats_on_metadata,Yh as innodb_stats_persistent,Kh as innodb_stats_persistent_sample_pages,Zh as innodb_stats_sample_pages,$h as innodb_stats_transient_sample_pages,Jh as innodb_status_output,ey as innodb_status_output_locks,ty as innodb_strict_mode,ny as innodb_support_xa,sy as innodb_sync_array_size,ay as innodb_sync_debug,oy as innodb_sync_spin_loops,ly as innodb_table_locks,dy as innodb_temp_data_file_path,cy as innodb_temp_tablespaces_dir,hy as innodb_thread_concurrency,yy as innodb_thread_concurrency_timer_based,vy as innodb_thread_sleep_delay,py as innodb_tmpdir,by as innodb_trx_purge_view_update_only_debug,fy as innodb_trx_rseg_n_slots_debug,qy as innodb_undo_directory,gy as innodb_undo_log_encrypt,Sy as innodb_undo_log_truncate,zy as innodb_undo_logs,Vy as innodb_undo_tablespaces,xy as innodb_use_legacy_cardinality_algorithm,wy as innodb_use_native_aio,Ny as innodb_use_sys_malloc,Cy as innodb_version,Oy as innodb_write_io_threads,Iy as insert_id,Ly as interactive_timeout,Dy as internal_tmp_disk_storage_engine,_y as internal_tmp_mem_storage_engine,My as join_buffer_size,Fy as join_cache_level,Py as keep_files_on_create,Wy as key_buffer_size,Qy as key_cache_age_threshold,jy as key_cache_block_size,Gy as key_cache_division_limit,$y as keyring_aws_cmk_id,Jy as keyring_aws_conf_file,ev as keyring_aws_data_file,tv as keyring_aws_region,nv as keyring_encrypted_file_data,sv as keyring_encrypted_file_password,ov as keyring_file_data,av as keyring_hashicorp_auth_path,iv as keyring_hashicorp_ca_path,rv as keyring_hashicorp_caching,mv as keyring_hashicorp_commit_auth_path,lv as keyring_hashicorp_commit_ca_path,dv as keyring_hashicorp_commit_caching,cv as keyring_hashicorp_commit_role_id,_v as keyring_hashicorp_commit_server_url,pv as keyring_hashicorp_commit_store_path,hv as keyring_hashicorp_role_id,yv as keyring_hashicorp_secret_id,vv as keyring_hashicorp_server_url,uv as keyring_hashicorp_store_path,bv as keyring_okv_conf_dir,fv as keyring_operations,qv as language,gv as large_files_support,Sv as large_page_size,zv as last_insert_id,Ev as lc_time_names,Av as license,Rv as local_infile,xv as lock_order,wv as lock_order_debug_loop,Nv as lock_order_debug_missing_arc,Cv as lock_order_debug_missing_key,kv as lock_order_debug_missing_unlock,Ov as lock_order_dependencies,Iv as lock_order_extra_dependencies,Lv as lock_order_output_directory,Dv as lock_order_print_txt,Mv as lock_order_trace_loop,Fv as lock_order_trace_missing_arc,Pv as lock_order_trace_missing_key,Bv as lock_order_trace_missing_unlock,Uv as lock_wait_timeout,Wv as locked_in_memory,Qv as log,Zv as log_backward_compatible_user_definitions,$v as log_bin,Jv as log_bin_basename,jv as log_bin_trust_function_creators,Gv as log_bin_trust_routine_creators,eu as log_bin_use_v1_row_events,tu as log_builtin_as_identified_by_password,nu as log_error_filter_rules,su as log_error_services,ou as log_error_suppression_list,au as log_error_verbosity,Xv as log_output,Yv as log_queries_not_using_indexes,iu as log_slave_updates,ru as log_slow_admin_statements,mu as log_slow_extra,Kv as log_slow_queries,lu as log_slow_slave_statements,du as log_statements_unsafe_for_binlog,cu as log_syslog,_u as log_syslog_facility,pu as log_syslog_include_pid,hu as log_syslog_tag,yu as log_throttle_queries_not_using_indexes,vu as log_timestamps,uu as long_query_time,bu as low_priority_updates,fu as lower_case_file_system,qu as lower_case_table_names,gu as mandatory_roles,Su as master_info_repository,zu as master_verify_checksum,Vu as max_allowed_packet,Tu as max_binlog_cache_size,Eu as max_binlog_size,Au as max_binlog_stmt_cache_size,Ru as max_connect_errors,xu as max_connections,wu as max_delayed_threads,Nu as max_digest_length,Cu as max_error_count,ku as max_execution_time,Du as max_heap_table_size,Mu as max_insert_delayed_threads,Fu as max_join_size,Pu as max_length_for_sort_data,Bu as max_long_data_size,Uu as max_points_in_geometry,Hu as max_prepared_stmt_count,Wu as max_relay_log_size,Qu as max_seeks_for_key,ju as max_sort_length,Gu as max_sp_recursion_depth,Xu as max_statement_time,Yu as max_tmp_tables,tb as max_user_connections,nb as max_write_lock_count,sb as mecab_charset,ob as mecab_rc_file,ab as memlock,rb as metadata_locks_cache_size,mb as metadata_locks_hash_instances,lb as min_examined_row_limit,db as multi_range_count,cb as myisam_data_pointer_size,_b as myisam_max_extra_sort_file_size,pb as myisam_max_sort_file_size,hb as myisam_mmap_size,yb as myisam_recover_options,vb as myisam_repair_threads,ub as myisam_sort_buffer_size,bb as myisam_stats_method,fb as myisam_use_mmap,gb as mysql_firewall_max_query_size,Sb as mysql_firewall_mode,zb as mysql_firewall_trace,qb as mysql_native_password_proxy_users,ye as mysqlx,ve as mysqlx_bind_address,ue as mysqlx_compression_algorithms,be as mysqlx_connect_timeout,fe as mysqlx_deflate_default_compression_level,qe as mysqlx_deflate_max_client_compression_level,ge as mysqlx_document_id_unique_prefix,Se as mysqlx_enable_hello_notice,ze as mysqlx_idle_worker_thread_timeout,Ve as mysqlx_interactive_timeout,Te as mysqlx_lz4_default_compression_level,Ee as mysqlx_lz4_max_client_compression_level,Ae as mysqlx_max_allowed_packet,Re as mysqlx_max_connections,xe as mysqlx_min_worker_threads,we as mysqlx_port,Ne as mysqlx_port_open_timeout,Ce as mysqlx_read_timeout,ke as mysqlx_socket,Oe as mysqlx_ssl_ca,Ie as mysqlx_ssl_capath,Le as mysqlx_ssl_cert,De as mysqlx_ssl_cipher,Me as mysqlx_ssl_crl,Fe as mysqlx_ssl_crlpath,Pe as mysqlx_ssl_key,Be as mysqlx_wait_timeout,Ue as mysqlx_write_timeout,He as mysqlx_zstd_default_compression_level,We as mysqlx_zstd_max_client_compression_level,Nf as ndb_autoincrement_prefetch_sz,Cf as ndb_cache_check_time,kf as ndb_clear_apply_status,eq as ndb_data_node_neighbour,sq as ndb_dbg_check_shares,tq as ndb_default_column_format,nq as ndb_deferred_constraints,oq as ndb_distribution,iq as ndb_eventbuffer_free_percent,rq as ndb_eventbuffer_max_alloc,lq as ndb_extra_logging,dq as ndb_force_send,cq as ndb_fully_replicated,_q as ndb_index_stat_cache_entries,pq as ndb_index_stat_enable,hq as ndb_index_stat_option,yq as ndb_index_stat_update_freq,vq as ndb_join_pushdown,fq as ndb_log_apply_status,qq as ndb_log_bin,gq as ndb_log_binlog_index,Sq as ndb_log_empty_epochs,zq as ndb_log_empty_update,Vq as ndb_log_exclusive_reads,Tq as ndb_log_orig,Eq as ndb_log_transaction_id,Aq as ndb_metadata_check,xq as ndb_metadata_check_interval,Nq as ndb_metadata_sync,Oq as ndb_optimized_node_selection,Pq as ndb_read_backup,Bq as ndb_recv_thread_activation_threshold,Uq as ndb_recv_thread_cpu_mask,Hq as ndb_report_thresh_binlog_epoch_slip,Wq as ndb_report_thresh_binlog_mem_usage,Qq as ndb_row_checksum,Gq as ndb_schema_dist_lock_wait_timeout,Xq as ndb_schema_dist_timeout,Yq as ndb_schema_dist_upgrade_allowed,Kq as ndb_show_foreign_key_mock_tables,Zq as ndb_slave_conflict_role,eg as ndb_table_no_logging,tg as ndb_table_temporary,sg as ndb_use_copying_alter_table,og as ndb_use_exact_count,ag as ndb_use_transactions,ig as ndb_version,rg as ndb_version_string,mg as ndbinfo,lg as ndbinfo_database,dg as ndbinfo_max_bytes,cg as ndbinfo_max_rows,_g as ndbinfo_offline,pg as ndbinfo_show_hidden,hg as ndbinfo_table_prefix,yg as ndbinfo_version,vg as net_buffer_length,ug as net_read_timeout,bg as net_retry_count,fg as net_write_timeout,qg as ngram_token_size,Sg as offline_mode,zg as old,Vg as old_alter_table,Tg as old_passwords,xg as open_files_limit,Dg as optimizer_join_cache_level,Mg as optimizer_prune_level,Fg as optimizer_search_depth,Pg as optimizer_switch,Bg as optimizer_trace,Ug as optimizer_trace_features,Hg as optimizer_trace_limit,Wg as optimizer_trace_max_mem_size,Qg as optimizer_trace_offset,jg as optimizer_use_mrr,Gg as original_commit_timestamp,Yg as original_server_version,Kg as parser_max_mem_size,Zg as partial_revokes,$g as password_history,Jg as password_require_current,eS as password_reuse_interval,tS as performance_schema,sS as performance_schema_accounts_size,rS as performance_schema_digests_size,mS as performance_schema_error_size,lS as performance_schema_events_stages_history_long_size,dS as performance_schema_events_stages_history_size,cS as performance_schema_events_statements_history_long_size,_S as performance_schema_events_statements_history_size,pS as performance_schema_events_transactions_history_long_size,hS as performance_schema_events_transactions_history_size,yS as performance_schema_events_waits_history_long_size,vS as performance_schema_events_waits_history_size,gS as performance_schema_hosts_size,VS as performance_schema_max_cond_classes,TS as performance_schema_max_cond_instances,ES as performance_schema_max_digest_length,AS as performance_schema_max_digest_sample_age,RS as performance_schema_max_file_classes,xS as performance_schema_max_file_handles,wS as performance_schema_max_file_instances,NS as performance_schema_max_index_stat,CS as performance_schema_max_memory_classes,kS as performance_schema_max_metadata_locks,OS as performance_schema_max_mutex_classes,IS as performance_schema_max_mutex_instances,LS as performance_schema_max_prepared_statements_instances,DS as performance_schema_max_program_instances,MS as performance_schema_max_rwlock_classes,FS as performance_schema_max_rwlock_instances,PS as performance_schema_max_socket_classes,BS as performance_schema_max_socket_instances,US as performance_schema_max_sql_text_length,HS as performance_schema_max_stage_classes,WS as performance_schema_max_statement_classes,QS as performance_schema_max_statement_stack,jS as performance_schema_max_table_handles,GS as performance_schema_max_table_instances,XS as performance_schema_max_table_lock_stat,YS as performance_schema_max_thread_classes,KS as performance_schema_max_thread_instances,mz as performance_schema_session_connect_attrs_size,lz as performance_schema_setup_actors_size,dz as performance_schema_setup_objects_size,gz as performance_schema_users_size,zz as persist_only_admin_x509_subject,Sz as persisted_globals_load,Vz as pid_file,Am as platforms,Tz as plugin_dir,Ez as port,Az as preload_buffer_size,Rz as prepared_stmt_count,wz as print_identified_with_as_hex,Nz as profiling,Cz as profiling_history_size,kz as protocol_compression_algorithms,Oz as protocol_version,Iz as proxy_user,Lz as pseudo_slave_mode,Dz as pseudo_thread_id,Gz as query_alloc_block_size,Xz as query_cache_limit,Yz as query_cache_min_res_unit,Kz as query_cache_size,Zz as query_cache_type,$z as query_cache_wlock_invalidate,Jz as query_prealloc_size,tV as rand_seed1,nV as rand_seed2,sV as range_alloc_block_size,oV as range_optimizer_max_mem_size,aV as rbr_exec_mode,iV as read_buffer_size,rV as read_only,mV as read_rnd_buffer_size,lV as regexp_stack_limit,dV as regexp_time_limit,cV as relay_log,_V as relay_log_basename,pV as relay_log_index,hV as relay_log_info_file,yV as relay_log_info_repository,vV as relay_log_purge,uV as relay_log_recovery,bV as relay_log_space_limit,fV as report_host,qV as report_password,gV as report_port,SV as report_user,zV as require_row_format,VV as require_secure_transport,TV as restore_disables_events,EV as restore_elevation,AV as restore_precheck,RV as resultset_metadata,xV as rewriter_enabled,wV as rewriter_verbose,rT as rpl_read_size,IV as rpl_recovery_rank,DV as rpl_semi_sync_master_enabled,HV as rpl_semi_sync_master_reply_log_file_pos,jV as rpl_semi_sync_master_timeout,GV as rpl_semi_sync_master_trace_level,ZV as rpl_semi_sync_master_wait_for_slave_count,$V as rpl_semi_sync_master_wait_no_slave,JV as rpl_semi_sync_master_wait_point,sT as rpl_semi_sync_slave_enabled,aT as rpl_semi_sync_slave_trace_level,mT as rpl_stop_slave_timeout,cT as schema_definition_cache,dT as secondary_engine_cost_threshold,pT as secure_auth,hT as secure_file_priv,qT as server_id,gT as server_id_bits,ST as server_uuid,zT as session_track_gtids,VT as session_track_schema,TT as session_track_state_change,ET as session_track_system_variables,AT as session_track_transaction_info,RT as sha256_password_auto_generate_rsa_keys,xT as sha256_password_private_key_path,wT as sha256_password_proxy_users,NT as sha256_password_public_key_path,CT as show_compatibility_56,kT as show_create_table_skip_secondary_engine,OT as show_create_table_verbosity,IT as show_old_temporals,LT as simplified_binlog_gtid_recovery,DT as skip_external_locking,PT as slave_allow_batching,BT as slave_checkpoint_group,UT as slave_checkpoint_period,HT as slave_compressed_protocol,WT as slave_exec_mode,MT as slave_load_tmpdir,GT as slave_max_allowed_packet,FT as slave_net_timeout,YT as slave_parallel_type,KT as slave_parallel_workers,ZT as slave_pending_jobs_size_max,$T as slave_preserve_commit_order,tE as slave_rows_search_algorithms,oE as slave_sql_verify_checksum,aE as slave_transaction_retries,iE as slave_type_conversions,lE as slow_launch_time,rE as slow_query_log,cE as slow_query_log_file,_E as socket,pE as sort_buffer_size,bE as sporadic_binlog_dump_fail,gE as sql_auto_is_null,SE as sql_big_selects,zE as sql_big_tables,fE as sql_bin_update_same,VE as sql_buffer_result,TE as sql_log_bin,EE as sql_log_off,AE as sql_log_update,RE as sql_low_priority_updates,xE as sql_max_join_size,qE as sql_mode,wE as sql_notes,NE as sql_quote_show_create,CE as sql_require_primary_key,kE as sql_safe_updates,OE as sql_select_limit,IE as sql_slave_skip_counter,LE as sql_warnings,DE as ssl_ca,ME as ssl_capath,FE as ssl_cert,PE as ssl_cipher,BE as ssl_crl,UE as ssl_crlpath,HE as ssl_fips_mode,WE as ssl_key,vA as storage_engine,uA as stored_program_cache,bA as stored_program_definition_cache,fA as super_read_only,qA as sync_binlog,gA as sync_frm,SA as sync_master_info,zA as sync_relay_log,VA as sync_relay_log_info,TA as system_time_zone,AA as table_cache,xA as table_definition_cache,RA as table_encryption_privilege_check,wA as table_lock_wait_timeout,kA as table_open_cache,IA as table_open_cache_instances,MA as table_type,EA as tablespace_definition_cache,UA as temptable_max_ram,HA as temptable_use_mmap,WA as thread_cache_size,QA as thread_concurrency,jA as thread_handling,GA as thread_pool_algorithm,XA as thread_pool_high_priority_connection,YA as thread_pool_max_active_query_threads,KA as thread_pool_max_unused_threads,ZA as thread_pool_prio_kickup_timer,$A as thread_pool_size,JA as thread_pool_stall_limit,eR as thread_stack,aR as time_format,iR as time_zone,rR as timed_mutexes,mR as timestamp,lR as tls_ciphersuites,dR as tls_version,cR as tmp_table_size,_R as tmpdir,pR as transaction_alloc_block_size,hR as transaction_allow_batching,yR as transaction_prealloc_size,vR as transaction_write_set_extraction,uR as tx_isolation,bR as tx_read_only,fR as unique_checks,qR as updatable_views_with_limit,gR as upgrade,VR as use_secondary_engine,TR as user,ER as validate_password_check_user_name,AR as validate_password_dictionary_file,RR as validate_password_dictionary_file_last_parsed,xR as validate_password_dictionary_file_words_count,wR as validate_password_length,NR as validate_password_mixed_case_count,CR as validate_password_number_count,kR as validate_password_policy,OR as validate_password_special_char_count,IR as validate_user_plugins,LR as verbose,DR as version,MR as version_comment,FR as version_compile_machine,PR as version_compile_os,BR as version_compile_zlib,UR as version_tokens_session,HR as version_tokens_session_number,WR as wait_timeout,QR as warning_count,jR as warnings,GR as windowing_use_high_precision};
