---
title: MRS Core REST APIs
---

This book provides examples of using the MySQL REST Service queries and other operations against tables and views after you have REST-enabled them.

__Chapter Overview__

- [About MRS RESTful Web Services](#about-mrs-restful-web-services)
- [Get Schema Metadata](#get-schema-metadata)
- [Get Object Metadata](#get-object-metadata)
- [Get Object Data](#get-object-data)
- [Insert Table Row](#insert-table-row)
- [Delete Using Filter](#delete-using-filter)
- [Authenticate a REST User](#authenticate-a-rest-user)
- [FilterObject Grammar](#filterobject-grammar)
- [Examples: FilterObject Specifications](#filterobject-grammar-examples)

---

Please also see

- __[MySQL REST Service - Developer's Guide](index.html)__ - This book explains how to install and configure the MySQL REST Service (MRS) as well as how to access the data through REST calls.
- __[MySQL REST Service - Quickstart Guide](quickstart.html)__ - This book provides a hands-on approach to learning how to use the MySQL REST service.
- __[MySQL REST Service - SDK Reference](sdk.html)__ - This book explains how to work with the MRS Software Development Kit and discusses the Client APIs.
- __[MySQL REST Service - SQL Reference](sql.html)__ - This book discusses the MySQL REST Service SQL Extension.

---

!include sections/restApi/About.md

!include sections/restApi/Queries.md

!include sections/restApi/FilterGrammar.md

!include sections/restApi/FilterGrammarExamples.md

!include sections/restApi/Authentication.md

Copyright (c) 2022, 2025, Oracle and/or its affiliates.
